/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindSettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindUsagesOptions
implements Cloneable {
    @NotNull
    public SearchScope searchScope;
    public boolean isSearchForTextOccurrences;
    public boolean isUsages;
    public SearchRequestCollector fastTrack;

    public FindUsagesOptions(@NotNull Project project) {
        if (project == null) {
            FindUsagesOptions.$$$reportNull$$$0(0);
        }
        this(project, null);
    }

    public FindUsagesOptions(@NotNull Project project, @Nullable DataContext dataContext) {
        if (project == null) {
            FindUsagesOptions.$$$reportNull$$$0(1);
        }
        this(FindUsagesOptions.findScopeByName(project, dataContext, FindSettings.getInstance().getDefaultScopeName()));
    }

    public FindUsagesOptions(@NotNull SearchScope searchScope) {
        if (searchScope == null) {
            FindUsagesOptions.$$$reportNull$$$0(2);
        }
        this.isSearchForTextOccurrences = true;
        this.searchScope = searchScope;
    }

    @NotNull
    private static SearchScope findScopeByName(@NotNull Project project, @Nullable DataContext dataContext, @Nullable String scopeName) {
        if (project == null) {
            FindUsagesOptions.$$$reportNull$$$0(3);
        }
        List<SearchScope> predefined = PredefinedSearchScopeProvider.getInstance().getPredefinedScopes(project, dataContext, true, false, false, false, false);
        for (SearchScope scope : predefined) {
            if (!scope.getDisplayName().equals(scopeName)) continue;
            SearchScope searchScope = scope;
            if (searchScope == null) {
                FindUsagesOptions.$$$reportNull$$$0(4);
            }
            return searchScope;
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getProjectScope((Project)project);
        if (globalSearchScope == null) {
            FindUsagesOptions.$$$reportNull$$$0(5);
        }
        return globalSearchScope;
    }

    public FindUsagesOptions clone() {
        try {
            return (FindUsagesOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FindUsagesOptions that = (FindUsagesOptions)o;
        if (this.isSearchForTextOccurrences != that.isSearchForTextOccurrences) {
            return false;
        }
        if (this.isUsages != that.isUsages) {
            return false;
        }
        return this.searchScope.equals(that.searchScope);
    }

    public int hashCode() {
        int result2 = this.searchScope.hashCode();
        result2 = 31 * result2 + (this.isSearchForTextOccurrences ? 1 : 0);
        result2 = 31 * result2 + (this.isUsages ? 1 : 0);
        return result2;
    }

    @NonNls
    public String toString() {
        return this.getClass().getSimpleName() + "{searchScope=" + this.searchScope + ", isSearchForTextOccurrences=" + this.isSearchForTextOccurrences + ", isUsages=" + this.isUsages + '}';
    }

    @NotNull
    public String generateUsagesString() {
        return "Usages";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/findUsages/FindUsagesOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/findUsages/FindUsagesOptions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findScopeByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findScopeByName";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

