/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.navigationToolbar.NavBarModel;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.navigationToolbar.NavBarPresentation;
import com.intellij.ide.navigationToolbar.ui.NavBarUI;
import com.intellij.ide.util.treeView.TreeAnchorizer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavBarItem
extends SimpleColoredComponent
implements DataProvider,
Disposable {
    private final String myText;
    private final SimpleTextAttributes myAttributes;
    private final int myIndex;
    private final Icon myIcon;
    private final NavBarPanel myPanel;
    private final Object myObject;
    private final boolean isPopupElement;
    private final NavBarUI myUI;

    public NavBarItem(NavBarPanel panel2, Object object, int idx, Disposable parent) {
        this(panel2, object, idx, parent, false);
    }

    public NavBarItem(NavBarPanel panel2, Object object, int idx, Disposable parent, boolean inPopup) {
        this.myPanel = panel2;
        this.myUI = panel2.getNavBarUI();
        this.myObject = object == null ? null : TreeAnchorizer.getService().createAnchor(object);
        this.myIndex = idx;
        boolean bl = this.isPopupElement = idx == -1;
        if (object != null) {
            NavBarPresentation presentation = this.myPanel.getPresentation();
            this.myText = presentation.getPresentableText(object, inPopup);
            this.myIcon = presentation.getIcon(object);
            this.myAttributes = presentation.getTextAttributes(object, false);
        } else {
            this.myText = "Sample";
            this.myIcon = PlatformIcons.FOLDER_ICON;
            this.myAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }
        Disposer.register((Disposable)(parent == null ? panel2 : parent), (Disposable)this);
        this.setOpaque(false);
        this.setIpad(this.myUI.getElementIpad(this.isPopupElement));
        if (!this.isPopupElement) {
            this.setMyBorder(null);
            this.setBorder(null);
            this.setPaintFocusBorder(false);
            this.setIconOpaque(false);
            if (this.myPanel.allowNavItemsFocus()) {
                this.setFocusTraversalKeysEnabled(false);
                this.setFocusable(true);
                this.addKeyListener(new KeyHandler());
                this.addFocusListener(new FocusHandler());
            }
        } else {
            this.setIconOpaque(true);
            this.setFocusBorderAroundIcon(true);
        }
        this.update();
    }

    public NavBarItem(NavBarPanel panel2, Object object, Disposable parent, boolean inPopup) {
        this(panel2, object, -1, parent, inPopup);
    }

    public Object getObject() {
        return this.myObject == null ? null : TreeAnchorizer.getService().retrieveElement(this.myObject);
    }

    public SimpleTextAttributes getAttributes() {
        return this.myAttributes;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            NavBarItem.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Font getFont() {
        return this.myUI == null ? super.getFont() : this.myUI.getElementFont(this);
    }

    void update() {
        this.clear();
        this.setIcon(this.myIcon);
        boolean focused = this.isFocusedOrPopupElement();
        boolean selected2 = this.isSelected();
        this.setBackground(this.myUI.getBackground(selected2, focused));
        Color fg = this.myUI.getForeground(selected2, focused, this.isInactive());
        if (fg == null) {
            fg = this.myAttributes.getFgColor();
        }
        Color bg = this.getBackground();
        this.append(this.myText, new SimpleTextAttributes(bg, fg, this.myAttributes.getWaveColor(), this.myAttributes.getStyle()));
    }

    public boolean isInactive() {
        NavBarModel model = this.myPanel.getModel();
        return model.getSelectedIndex() < this.myIndex && model.getSelectedIndex() != -1 && !this.myPanel.isUpdating();
    }

    public boolean isPopupElement() {
        return this.isPopupElement;
    }

    protected void doPaint(Graphics2D g) {
        if (this.isPopupElement) {
            super.doPaint(g);
        } else {
            this.myUI.doPaintNavBarItem(g, this, this.myPanel);
        }
    }

    public int doPaintText(Graphics2D g, int offset) {
        return super.doPaintText(g, offset, false);
    }

    public boolean isLastElement() {
        return this.myIndex == this.myPanel.getModel().size() - 1;
    }

    public boolean isFirstElement() {
        return this.myIndex == 0;
    }

    public void setOpaque(boolean isOpaque) {
        super.setOpaque(false);
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        Dimension offsets2 = this.myUI.getOffsets(this);
        int width = size.width + offsets2.width;
        if (!this.needPaintIcon() && this.myIcon != null) {
            width -= this.myIcon.getIconWidth();
        }
        return new Dimension(width, size.height + offsets2.height);
    }

    @DirtyUI
    public boolean needPaintIcon() {
        if (Registry.is((String)"navBar.show.icons") || this.isPopupElement || this.isLastElement()) {
            return true;
        }
        Object object = this.getObject();
        return object instanceof PsiElement && ((PsiElement)object).getContainingFile() != null;
    }

    @NotNull
    public Dimension getMinimumSize() {
        Dimension dimension = this.getPreferredSize();
        if (dimension == null) {
            NavBarItem.$$$reportNull$$$0(1);
        }
        return dimension;
    }

    private boolean isFocusedOrPopupElement() {
        return this.isFocused() || this.isPopupElement;
    }

    public boolean isFocused() {
        if (this.myPanel.allowNavItemsFocus()) {
            return UIUtil.isFocusAncestor((Component)this.myPanel) && !this.myPanel.isNodePopupActive();
        }
        return this.myPanel.hasFocus() && !this.myPanel.isNodePopupActive();
    }

    public boolean isSelected() {
        NavBarModel model = this.myPanel.getModel();
        return this.isPopupElement ? this.myPanel.isSelectedInPopup(this.getObject()) : model.getSelectedIndex() == this.myIndex;
    }

    protected boolean shouldDrawBackground() {
        return this.isSelected() && this.isFocusedOrPopupElement();
    }

    public void dispose() {
    }

    public boolean isNextSelected() {
        return this.myIndex == this.myPanel.getModel().getSelectedIndex() - 1;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            NavBarItem.$$$reportNull$$$0(2);
        }
        return this.myPanel.getDataImpl(dataId, (JComponent)((Object)this), () -> JBIterable.of((Object)this.getObject()));
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleNavBarItem();
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/navigationToolbar/NavBarItem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinimumSize";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/navigationToolbar/NavBarItem";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            NavBarItem.this.myPanel.fireNavBarItemFocusGained(e);
        }

        @Override
        public void focusLost(FocusEvent e) {
            NavBarItem.this.myPanel.fireNavBarItemFocusLost(e);
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 9 && e.getSource() instanceof NavBarItem) {
                e.consume();
                this.jumpToNextComponent(!e.isShiftDown());
            }
        }

        void jumpToNextComponent(boolean next) {
            NavBarItem focusBase = null;
            List<NavBarItem> items = NavBarItem.this.myPanel.getItems();
            if (items.size() > 0) {
                focusBase = next ? items.get(items.size() - 1) : items.get(0);
            }
            if (focusBase != null) {
                if (next) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent((Component)((Object)focusBase));
                } else {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent((Component)((Object)focusBase));
                }
            }
        }
    }

    protected class AccessibleNavBarItem
    extends SimpleColoredComponent.AccessibleSimpleColoredComponent
    implements AccessibleAction {
        protected AccessibleNavBarItem() {
            super((SimpleColoredComponent)NavBarItem.this);
        }

        public AccessibleRole getAccessibleRole() {
            if (!NavBarItem.this.isPopupElement()) {
                return AccessibleRole.PUSH_BUTTON;
            }
            return super.getAccessibleRole();
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public int getAccessibleActionCount() {
            return !NavBarItem.this.isPopupElement() ? 1 : 0;
        }

        @Override
        public String getAccessibleActionDescription(int i) {
            if (i == 0 && !NavBarItem.this.isPopupElement()) {
                return UIManager.getString("AbstractButton.clickText");
            }
            return null;
        }

        @Override
        public boolean doAccessibleAction(int i) {
            if (i == 0 && !NavBarItem.this.isPopupElement()) {
                NavBarItem.this.myPanel.getModel().setSelectedIndex(NavBarItem.this.myIndex);
            }
            return false;
        }
    }
}

