/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.CommonBundle;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginHeaderPanel;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerColumnInfo;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PluginManagerMain {
    private static final String TEXT_SUFFIX = "</body></html>";
    private static final String HTML_PREFIX = "<a href=\"";
    private static final String HTML_SUFFIX = "</a>";

    private static String getTextPrefix() {
        int fontSize = JBUIScale.scale((int)12);
        int m1 = JBUIScale.scale((int)2);
        int m2 = JBUIScale.scale((int)5);
        return String.format("<html><head>    <style type=\"text/css\">        p {            font-family: Arial,serif; font-size: %dpt; margin: %dpx %dpx        }    </style></head><body style=\"font-family: Arial,serif; font-size: %dpt; margin: %dpx %dpx;\">", fontSize, m1, m1, fontSize, m2, m2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public static boolean downloadPlugins(List<PluginNode> plugins2, List<PluginId> allPlugins, Runnable onSuccess2, @Nullable Runnable cleanup) throws IOException {
        return PluginManagerMain.downloadPlugins(plugins2, ContainerUtil.map(allPlugins, p -> new PluginNode((PluginId)p, p.getIdString(), "-1")), onSuccess2, new PluginEnabler.HEADLESS(), cleanup);
    }

    public static boolean downloadPlugins(List<PluginNode> plugins2, List<? extends IdeaPluginDescriptor> allPlugins, Runnable onSuccess2, PluginEnabler pluginEnabler, @Nullable Runnable cleanup) throws IOException {
        return PluginManagerMain.downloadPlugins(plugins2, allPlugins, false, onSuccess2, pluginEnabler, cleanup);
    }

    public static boolean downloadPlugins(final List<PluginNode> plugins2, final List<? extends IdeaPluginDescriptor> allPlugins, final boolean allowInstallWithoutRestart, final Runnable onSuccess2, final PluginEnabler pluginEnabler, final @Nullable Runnable cleanup) throws IOException {
        final boolean[] result2 = new boolean[1];
        try {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, IdeBundle.message((String)"progress.download.plugins", (Object[])new Object[0]), true, PluginManagerUISettings.getInstance()){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        if (PluginInstaller.prepareToInstall(plugins2, allPlugins, allowInstallWithoutRestart, pluginEnabler, onSuccess2, indicator)) {
                            result2[0] = true;
                        }
                    }
                    finally {
                        if (cleanup != null) {
                            ApplicationManager.getApplication().invokeLater(cleanup);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/plugins/PluginManagerMain$1", "run"));
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
        return result2[0];
    }

    public static void pluginInfoUpdate(IdeaPluginDescriptor plugin, @Nullable String filter2, @NotNull JEditorPane descriptionTextArea, @NotNull PluginHeaderPanel header) {
        String changeNotes;
        if (descriptionTextArea == null) {
            PluginManagerMain.$$$reportNull$$$0(0);
        }
        if (header == null) {
            PluginManagerMain.$$$reportNull$$$0(1);
        }
        if (plugin == null) {
            PluginManagerMain.setTextValue(null, filter2, descriptionTextArea);
            header.getPanel().setVisible(false);
            return;
        }
        StringBuilder sb = new StringBuilder();
        header.setPlugin(plugin);
        String description = plugin.getDescription();
        if (!StringUtil.isEmptyOrSpaces((String)description)) {
            sb.append(description);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(changeNotes = plugin.getChangeNotes()))) {
            sb.append("<h4>Change Notes</h4>");
            sb.append(changeNotes);
        }
        if (!plugin.isBundled()) {
            String size;
            String pluginDescriptorUrl;
            String vendor = plugin.getVendor();
            String vendorEmail = plugin.getVendorEmail();
            String vendorUrl = plugin.getVendorUrl();
            if (!(StringUtil.isEmptyOrSpaces((String)vendor) && StringUtil.isEmptyOrSpaces((String)vendorEmail) && StringUtil.isEmptyOrSpaces((String)vendorUrl))) {
                sb.append("<h4>Vendor</h4>");
                if (!StringUtil.isEmptyOrSpaces((String)vendor)) {
                    sb.append(vendor);
                }
                if (!StringUtil.isEmptyOrSpaces((String)vendorUrl)) {
                    sb.append("<br>").append(PluginManagerMain.composeHref(vendorUrl));
                }
                if (!StringUtil.isEmptyOrSpaces((String)vendorEmail)) {
                    sb.append("<br>").append(HTML_PREFIX).append("mailto:").append(vendorEmail).append("\">").append(vendorEmail).append(HTML_SUFFIX);
                }
            }
            if (!StringUtil.isEmptyOrSpaces((String)(pluginDescriptorUrl = plugin.getUrl()))) {
                sb.append("<h4>Plugin homepage</h4>").append(PluginManagerMain.composeHref(pluginDescriptorUrl));
            }
            String string = size = plugin instanceof PluginNode ? ((PluginNode)plugin).getSize() : null;
            if (!StringUtil.isEmptyOrSpaces((String)size)) {
                sb.append("<h4>Size</h4>").append(PluginManagerColumnInfo.getFormattedSize(size));
            }
        }
        PluginManagerMain.setTextValue(sb, filter2, descriptionTextArea);
    }

    private static void setTextValue(@Nullable StringBuilder text2, @Nullable String filter2, JEditorPane pane2) {
        if (text2 != null) {
            text2.insert(0, PluginManagerMain.getTextPrefix());
            text2.append(TEXT_SUFFIX);
            pane2.setText(SearchUtil.markup(text2.toString(), filter2).trim());
            pane2.setCaretPosition(0);
        } else {
            pane2.setText(PluginManagerMain.getTextPrefix() + TEXT_SUFFIX);
        }
    }

    private static String composeHref(String vendorUrl) {
        return HTML_PREFIX + vendorUrl + "\">" + vendorUrl + HTML_SUFFIX;
    }

    public static boolean isAccepted(@Nullable String filter2, @NotNull Set<String> search2, @NotNull IdeaPluginDescriptor descriptor2) {
        if (search2 == null) {
            PluginManagerMain.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            PluginManagerMain.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)filter2)) {
            return true;
        }
        if (StringUtil.containsIgnoreCase((String)descriptor2.getName(), (String)filter2) || PluginManagerMain.isAccepted(search2, filter2, descriptor2.getName())) {
            return true;
        }
        if (PluginManagerMain.isAccepted(search2, filter2, descriptor2.getDescription())) {
            return true;
        }
        String category = descriptor2.getCategory();
        return category != null && (StringUtil.containsIgnoreCase((String)category, (String)filter2) || PluginManagerMain.isAccepted(search2, filter2, category));
    }

    public static boolean isAccepted(@NotNull Set<String> search2, @NotNull String filter2, @Nullable String description) {
        if (search2 == null) {
            PluginManagerMain.$$$reportNull$$$0(4);
        }
        if (filter2 == null) {
            PluginManagerMain.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty((String)description)) {
            return false;
        }
        if (filter2.length() <= 2) {
            return false;
        }
        Set words = SearchableOptionsRegistrar.getInstance().getProcessedWords(description);
        if (words.contains(filter2)) {
            return true;
        }
        if (search2.isEmpty()) {
            return false;
        }
        HashSet<String> descriptionSet = new HashSet<String>(search2);
        descriptionSet.removeAll(words);
        return descriptionSet.isEmpty();
    }

    public static boolean suggestToEnableInstalledDependantPlugins(PluginEnabler pluginEnabler, List<PluginNode> list2) {
        HashSet<PluginNode> disabled = new HashSet<PluginNode>();
        HashSet<IdeaPluginDescriptor> disabledDependants = new HashSet<IdeaPluginDescriptor>();
        for (PluginNode node : list2) {
            List<PluginId> depends;
            PluginId pluginId = node.getPluginId();
            if (pluginEnabler.isDisabled(pluginId)) {
                disabled.add(node);
            }
            if ((depends = node.getDepends()) == null) continue;
            Set optionalDeps = ContainerUtil.set((Object[])node.getOptionalDependentPluginIds());
            for (PluginId dependantId : depends) {
                IdeaPluginDescriptor pluginDescriptor2;
                if (optionalDeps.contains(dependantId) || (pluginDescriptor2 = PluginManagerCore.getPlugin(dependantId)) == null || !pluginEnabler.isDisabled(dependantId)) continue;
                disabledDependants.add(pluginDescriptor2);
            }
        }
        if (!disabled.isEmpty() || !disabledDependants.isEmpty()) {
            int result2;
            String message = "";
            if (disabled.size() == 1) {
                message = message + "Updated plugin '" + ((IdeaPluginDescriptor)disabled.iterator().next()).getName() + "' is disabled.";
            } else if (!disabled.isEmpty()) {
                message = message + "Updated plugins " + StringUtil.join(disabled, pluginDescriptor -> pluginDescriptor.getName(), (String)", ") + " are disabled.";
            }
            if (!disabledDependants.isEmpty()) {
                message = message + "<br>";
                message = message + "Updated plugin" + (list2.size() > 1 ? "s depend " : " depends ") + "on disabled";
                message = disabledDependants.size() == 1 ? message + " plugin '" + ((IdeaPluginDescriptor)disabledDependants.iterator().next()).getName() + "'." : message + " plugins " + StringUtil.join(disabledDependants, pluginDescriptor -> pluginDescriptor.getName(), (String)", ") + ".";
            }
            message = message + " Disabled plugins " + (disabled.isEmpty() ? "and plugins which depend on disabled " : "") + "won't be activated after restart.";
            if (!disabled.isEmpty() && !disabledDependants.isEmpty()) {
                result2 = Messages.showYesNoCancelDialog((String)XmlStringUtil.wrapInHtml((CharSequence)message), (String)IdeBundle.message((String)"dialog.title.dependent.plugins.found", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.enable.all", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.enable.updated.plugin.0", (Object[])new Object[]{disabled.size()}), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
                if (result2 == 2) {
                    return false;
                }
            } else {
                message = message + "<br>Would you like to enable ";
                message = !disabled.isEmpty() ? message + "updated plugin" + (disabled.size() > 1 ? "s" : "") : message + "plugin " + StringUtil.pluralize((String)"dependency", (int)disabledDependants.size());
                result2 = Messages.showYesNoDialog((String)XmlStringUtil.wrapInHtml((CharSequence)(message = message + "?")), (String)IdeBundle.message((String)"dialog.title.dependent.plugins.found", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                if (result2 == 1) {
                    return false;
                }
            }
            if (result2 == 0) {
                disabled.addAll(disabledDependants);
                pluginEnabler.enablePlugins(disabled);
            } else if (result2 == 1 && !disabled.isEmpty()) {
                pluginEnabler.enablePlugins(disabled);
            }
            return true;
        }
        return false;
    }

    public static void notifyPluginsUpdated(@Nullable Project project) {
        final ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        String title = IdeBundle.message((String)"updates.plugins.ready.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        String action2 = IdeBundle.message((String)"ide.restart.required.notification", (Object[])new Object[]{IdeBundle.message((String)(app.isRestartCapable() ? "ide.restart.action" : "ide.shutdown.action"), (Object[])new Object[0])});
        Notification notification = UpdateChecker.getNotificationGroup().createNotification(title, "", NotificationType.INFORMATION, null);
        notification.addAction((AnAction)new NotificationAction(action2){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    2.$$$reportNull$$$0(1);
                }
                notification.expire();
                app.restart(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/plugins/PluginManagerMain$2";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        notification.notify(project);
    }

    public static boolean checkThirdPartyPluginsAllowed(Iterable<? extends IdeaPluginDescriptor> descriptors) {
        UpdateSettings updateSettings = UpdateSettings.getInstance();
        if (updateSettings.isThirdPartyPluginsAllowed()) {
            return true;
        }
        PluginManager pluginManager = PluginManager.getInstance();
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptors) {
            String noText;
            String yesText;
            if (pluginManager.isDevelopedByJetBrains((PluginDescriptor)ideaPluginDescriptor)) continue;
            String title = IdeBundle.message((String)"third.party.plugins.privacy.note.title", (Object[])new Object[0]);
            String message = IdeBundle.message((String)"third.party.plugins.privacy.note.message", (Object[])new Object[0]);
            if (Messages.showYesNoDialog((String)message, (String)title, (String)(yesText = IdeBundle.message((String)"third.party.plugins.privacy.note.yes", (Object[])new Object[0])), (String)(noText = IdeBundle.message((String)"third.party.plugins.privacy.note.no", (Object[])new Object[0])), (Icon)Messages.getWarningIcon()) == 0) {
                updateSettings.setThirdPartyPluginsAllowed(true);
                return true;
            }
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionTextArea";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "search";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/plugins/PluginManagerMain";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "pluginInfoUpdate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isAccepted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface PluginEnabler {
        public void enablePlugins(Set<? extends IdeaPluginDescriptor> var1);

        public void disablePlugins(Set<? extends IdeaPluginDescriptor> var1);

        public boolean isDisabled(@NotNull PluginId var1);

        public static class HEADLESS
        implements PluginEnabler {
            @Override
            public void enablePlugins(Set<? extends IdeaPluginDescriptor> disabled) {
                PluginManager.getInstance().enablePlugins(disabled, true);
            }

            @Override
            public void disablePlugins(Set<? extends IdeaPluginDescriptor> disabled) {
                for (IdeaPluginDescriptor ideaPluginDescriptor : disabled) {
                    PluginManagerCore.disablePlugin(ideaPluginDescriptor.getPluginId());
                }
            }

            @Override
            public boolean isDisabled(@NotNull PluginId pluginId) {
                if (pluginId == null) {
                    HEADLESS.$$$reportNull$$$0(0);
                }
                return PluginManagerCore.isDisabled(pluginId);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId", "com/intellij/ide/plugins/PluginManagerMain$PluginEnabler$HEADLESS", "isDisabled"));
            }
        }
    }

    public static class MyHyperlinkListener
    implements HyperlinkListener {
        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane2 = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane2.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    URL url = e.getURL();
                    if (url != null) {
                        BrowserUtil.browse((URL)url);
                    }
                }
            }
        }
    }
}

