/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginRepositoryRequests;
import com.intellij.ide.plugins.PluginsMetaLoader;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RepositoryHelper {
    private static final Logger LOG = Logger.getInstance(RepositoryHelper.class);
    private static final String PLUGIN_LIST_FILE = "availables.xml";
    private static final String MARKETPLACE_PLUGIN_ID = "com.intellij.marketplace";
    private static final String ULTIMATE_MODULE = "com.intellij.modules.ultimate";

    @NotNull
    public static List<String> getPluginHosts() {
        ArrayList<String> hosts = new ArrayList<String>(UpdateSettings.getInstance().getPluginHosts());
        ContainerUtil.addIfNotNull(hosts, (Object)ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl());
        hosts.add(null);
        ArrayList<String> arrayList = hosts;
        if (arrayList == null) {
            RepositoryHelper.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPluginsFromAllRepositories(@Nullable ProgressIndicator indicator) {
        ArrayList<IdeaPluginDescriptor> result2 = new ArrayList<IdeaPluginDescriptor>();
        HashSet<PluginId> addedPluginIds = new HashSet<PluginId>();
        for (String host : RepositoryHelper.getPluginHosts()) {
            try {
                List<IdeaPluginDescriptor> plugins2 = RepositoryHelper.loadPlugins(host, indicator);
                for (IdeaPluginDescriptor plugin : plugins2) {
                    if (!addedPluginIds.add(plugin.getPluginId())) continue;
                    result2.add(plugin);
                }
            }
            catch (IOException e) {
                LOG.info("Couldn't load plugins from " + (host == null ? "main repository" : host) + ": " + e);
                LOG.debug((Throwable)e);
            }
        }
        ArrayList<IdeaPluginDescriptor> arrayList = result2;
        if (arrayList == null) {
            RepositoryHelper.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable ProgressIndicator indicator) throws IOException {
        return RepositoryHelper.loadPlugins(null, indicator);
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable String repositoryUrl, @Nullable ProgressIndicator indicator) throws IOException {
        return RepositoryHelper.loadPlugins(repositoryUrl, null, indicator);
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable String repositoryUrl, @Nullable BuildNumber build2, @Nullable ProgressIndicator indicator) throws IOException {
        File pluginListFile;
        Url url;
        if (repositoryUrl == null) {
            String base = ApplicationInfoImpl.getShadowInstance().getPluginsListUrl();
            url = Urls.newFromEncoded((String)base).addParameters(Collections.singletonMap("uuid", PermanentInstallationID.get()));
            pluginListFile = new File(PathManager.getPluginsPath(), PLUGIN_LIST_FILE);
        } else {
            url = Urls.newFromEncoded((String)repositoryUrl);
            pluginListFile = null;
        }
        if (!"file".equals(url.getScheme())) {
            url = url.addParameters(Collections.singletonMap("build", build2 != null ? build2.asString() : PluginRepositoryRequests.getBuildForPluginRepositoryRequests()));
        }
        if (indicator != null) {
            indicator.setText2(IdeBundle.message((String)"progress.connecting.to.plugin.manager", (Object[])new Object[]{url.getAuthority()}));
        }
        List descriptors = (List)PluginsMetaLoader.readOrUpdateFile(pluginListFile, url.toExternalForm(), indicator, IdeBundle.message((String)"progress.downloading.list.of.plugins", (Object[])new Object[]{url.getAuthority()}), reader -> PluginsMetaLoader.parsePluginList(reader));
        return RepositoryHelper.process(descriptors, repositoryUrl, build2);
    }

    @Nullable
    public static List<IdeaPluginDescriptor> loadCachedPlugins() throws IOException {
        File file2 = new File(PathManager.getPluginsPath(), PLUGIN_LIST_FILE);
        return file2.length() > 0L ? RepositoryHelper.process(RepositoryHelper.loadPluginList(file2), null, null) : null;
    }

    private static List<PluginNode> loadPluginList(File file2) throws IOException {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file2)), StandardCharsets.UTF_8);){
            List<PluginNode> list2 = PluginsMetaLoader.parsePluginList(reader);
            return list2;
        }
    }

    @NotNull
    private static List<IdeaPluginDescriptor> process(@NotNull List<PluginNode> list2, @Nullable String repositoryUrl, @Nullable BuildNumber build2) {
        if (list2 == null) {
            RepositoryHelper.$$$reportNull$$$0(2);
        }
        LinkedHashMap<PluginId, PluginNode> result2 = new LinkedHashMap<PluginId, PluginNode>(list2.size());
        if (build2 == null) {
            build2 = PluginManagerCore.getBuildNumber();
        }
        boolean isCommunityIDE = !RepositoryHelper.ideContainsUltimateModule();
        boolean isVendorNotJetBrains = !ApplicationInfoImpl.getShadowInstance().isVendorJetBrains();
        boolean isPaidPluginsRequireMarketplacePlugin = isCommunityIDE || isVendorNotJetBrains;
        for (PluginNode node : list2) {
            IdeaPluginDescriptor previous;
            PluginId pluginId = node.getPluginId();
            if (pluginId == null || repositoryUrl != null && node.getDownloadUrl() == null) {
                LOG.debug("Malformed plugin record (id:" + pluginId + " repository:" + repositoryUrl + ")");
                continue;
            }
            if (PluginManagerCore.isBrokenPlugin(node) || PluginManagerCore.isIncompatible(node, build2)) {
                LOG.debug("An incompatible plugin (id:" + pluginId + " repository:" + repositoryUrl + ")");
                continue;
            }
            if (repositoryUrl != null) {
                node.setRepositoryName(repositoryUrl);
            }
            if (node.getName() == null) {
                String url = node.getDownloadUrl();
                node.setName(FileUtilRt.getNameWithoutExtension((String)url.substring(url.lastIndexOf(47) + 1)));
            }
            if ((previous = (IdeaPluginDescriptor)result2.get(pluginId)) == null || VersionComparatorUtil.compare((String)node.getVersion(), (String)previous.getVersion()) > 0) {
                result2.put(pluginId, node);
            }
            if (!isPaidPluginsRequireMarketplacePlugin || node.getProductCode() == null) continue;
            node.addDepends(MARKETPLACE_PLUGIN_ID);
        }
        return new ArrayList<IdeaPluginDescriptor>(result2.values());
    }

    private static boolean ideContainsUltimateModule() {
        IdeaPluginDescriptor corePlugin = PluginManagerCore.getPlugin(PluginId.getId((String)"com.intellij"));
        IdeaPluginDescriptorImpl corePluginImpl = corePlugin instanceof IdeaPluginDescriptorImpl ? (IdeaPluginDescriptorImpl)corePlugin : null;
        return corePluginImpl != null && corePluginImpl.getModules().contains(PluginId.getId((String)ULTIMATE_MODULE));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/RepositoryHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginHosts";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPluginsFromAllRepositories";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/RepositoryHelper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

