/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.settings;

import com.intellij.DynamicBundle;
import com.intellij.application.options.colors.ColorAndFontDescription;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.OptionsPanelImpl;
import com.intellij.diff.util.TextDiffTypeFactory;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DiffColorDescriptionPanel
extends JPanel
implements OptionsPanelImpl.ColorDescriptionPanel {
    private final EventDispatcher<OptionsPanelImpl.ColorDescriptionPanel.Listener> myDispatcher;
    private JPanel myPanel;
    private ColorPanel myBackgroundColorPanel;
    private ColorPanel myIgnoredColorPanel;
    private ColorPanel myStripeMarkColorPanel;
    private JBCheckBox myInheritIgnoredCheckBox;
    @NotNull
    private final ColorAndFontOptions myOptions;

    DiffColorDescriptionPanel(@NotNull ColorAndFontOptions options) {
        if (options == null) {
            DiffColorDescriptionPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myDispatcher = EventDispatcher.create(OptionsPanelImpl.ColorDescriptionPanel.Listener.class);
        this.myOptions = options;
        this.add((Component)this.myPanel, "Center");
        this.myBackgroundColorPanel.addActionListener(this::onSettingsChanged);
        this.myIgnoredColorPanel.addActionListener(this::onSettingsChanged);
        this.myStripeMarkColorPanel.addActionListener(this::onSettingsChanged);
        this.myInheritIgnoredCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiffColorDescriptionPanel.this.myIgnoredColorPanel.setEnabled(!DiffColorDescriptionPanel.this.myInheritIgnoredCheckBox.isSelected());
                if (DiffColorDescriptionPanel.this.myInheritIgnoredCheckBox.isSelected()) {
                    DiffColorDescriptionPanel.this.myIgnoredColorPanel.setSelectedColor(null);
                } else {
                    Color background = (Color)ObjectUtils.notNull((Object)DiffColorDescriptionPanel.this.myBackgroundColorPanel.getSelectedColor(), (Object)JBColor.WHITE);
                    Color gutterBackground = DiffColorDescriptionPanel.this.myOptions.getSelectedScheme().getDefaultBackground();
                    DiffColorDescriptionPanel.this.myIgnoredColorPanel.setSelectedColor(TextDiffTypeFactory.getMiddleColor(background, gutterBackground));
                }
                DiffColorDescriptionPanel.this.onSettingsChanged(e);
            }
        });
    }

    @Override
    @NotNull
    public JComponent getPanel() {
        DiffColorDescriptionPanel diffColorDescriptionPanel = this;
        if (diffColorDescriptionPanel == null) {
            DiffColorDescriptionPanel.$$$reportNull$$$0(1);
        }
        return diffColorDescriptionPanel;
    }

    private void onSettingsChanged(@NotNull ActionEvent e) {
        if (e == null) {
            DiffColorDescriptionPanel.$$$reportNull$$$0(2);
        }
        ((OptionsPanelImpl.ColorDescriptionPanel.Listener)this.myDispatcher.getMulticaster()).onSettingsChanged(e);
    }

    @Override
    public void resetDefault() {
        this.myBackgroundColorPanel.setEnabled(false);
        this.myIgnoredColorPanel.setEnabled(false);
        this.myStripeMarkColorPanel.setEnabled(false);
        this.myInheritIgnoredCheckBox.setEnabled(false);
        this.myInheritIgnoredCheckBox.setSelected(false);
    }

    @Override
    public void reset(@NotNull EditorSchemeAttributeDescriptor attrDescription) {
        if (attrDescription == null) {
            DiffColorDescriptionPanel.$$$reportNull$$$0(3);
        }
        if (!(attrDescription instanceof ColorAndFontDescription)) {
            return;
        }
        ColorAndFontDescription description = (ColorAndFontDescription)attrDescription;
        Color backgroundColor = DiffColorDescriptionPanel.getBackgroundColor(description);
        Color ignoredColor = DiffColorDescriptionPanel.getIgnoredColor(description);
        Color stripeMarkColor = DiffColorDescriptionPanel.getStripeMarkColor(description);
        boolean inheritIgnored = ignoredColor == null;
        this.myBackgroundColorPanel.setEnabled(true);
        this.myIgnoredColorPanel.setEnabled(!inheritIgnored);
        this.myStripeMarkColorPanel.setEnabled(true);
        this.myInheritIgnoredCheckBox.setEnabled(true);
        this.myBackgroundColorPanel.setSelectedColor(backgroundColor);
        this.myIgnoredColorPanel.setSelectedColor(ignoredColor);
        this.myStripeMarkColorPanel.setSelectedColor(stripeMarkColor);
        this.myInheritIgnoredCheckBox.setSelected(inheritIgnored);
    }

    @Override
    public void apply(@NotNull EditorSchemeAttributeDescriptor attrDescription, EditorColorsScheme scheme) {
        if (attrDescription == null) {
            DiffColorDescriptionPanel.$$$reportNull$$$0(4);
        }
        if (!(attrDescription instanceof ColorAndFontDescription)) {
            return;
        }
        ColorAndFontDescription description = (ColorAndFontDescription)attrDescription;
        description.setBackgroundChecked(true);
        description.setForegroundChecked(true);
        description.setErrorStripeChecked(true);
        this.setBackgroundColor(description);
        this.setIgnoredColor(description);
        this.setStripeMarkColor(description);
        description.apply(scheme);
    }

    @Override
    public void addListener(@NotNull OptionsPanelImpl.ColorDescriptionPanel.Listener listener2) {
        if (listener2 == null) {
            DiffColorDescriptionPanel.$$$reportNull$$$0(5);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Nullable
    private static Color getBackgroundColor(@NotNull TextAttributes attributes) {
        if (attributes == null) {
            DiffColorDescriptionPanel.$$$reportNull$$$0(6);
        }
        return attributes.getBackgroundColor();
    }

    @Nullable
    private static Color getIgnoredColor(@NotNull TextAttributes attributes) {
        if (attributes == null) {
            DiffColorDescriptionPanel.$$$reportNull$$$0(7);
        }
        return attributes.getForegroundColor();
    }

    @Nullable
    private static Color getStripeMarkColor(@NotNull TextAttributes attributes) {
        if (attributes == null) {
            DiffColorDescriptionPanel.$$$reportNull$$$0(8);
        }
        return attributes.getErrorStripeColor();
    }

    private void setBackgroundColor(@NotNull TextAttributes attributes) {
        if (attributes == null) {
            DiffColorDescriptionPanel.$$$reportNull$$$0(9);
        }
        attributes.setBackgroundColor(this.myBackgroundColorPanel.getSelectedColor());
    }

    private void setIgnoredColor(@NotNull TextAttributes attributes) {
        if (attributes == null) {
            DiffColorDescriptionPanel.$$$reportNull$$$0(10);
        }
        attributes.setForegroundColor(this.myInheritIgnoredCheckBox.isSelected() ? null : this.myIgnoredColorPanel.getSelectedColor());
    }

    private void setStripeMarkColor(@NotNull TextAttributes attributes) {
        if (attributes == null) {
            DiffColorDescriptionPanel.$$$reportNull$$$0(11);
        }
        attributes.setErrorStripeColor(this.myStripeMarkColorPanel.getSelectedColor());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        ColorPanel colorPanel;
        ColorPanel colorPanel2;
        ColorPanel colorPanel3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 10, 10, 10), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DiffBundle", DiffColorDescriptionPanel.class).getString("merge.color.options.background.color.label"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBackgroundColorPanel = colorPanel3 = new ColorPanel();
        jPanel.add((Component)colorPanel3, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/ApplicationBundle", DiffColorDescriptionPanel.class).getString("checkbox.color.error.stripe.mark"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myStripeMarkColorPanel = colorPanel2 = new ColorPanel();
        jPanel.add((Component)colorPanel2, new GridConstraints(2, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/DiffBundle", DiffColorDescriptionPanel.class).getString("merge.color.options.ignored.color.label"));
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIgnoredColorPanel = colorPanel = new ColorPanel();
        jPanel.add((Component)colorPanel, new GridConstraints(1, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myInheritIgnoredCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/DiffBundle", DiffColorDescriptionPanel.class).getString("option.inherit.ignored.color"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/settings/DiffColorDescriptionPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrDescription";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/settings/DiffColorDescriptionPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onSettingsChanged";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBackgroundColor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoredColor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getStripeMarkColor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setBackgroundColor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoredColor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setStripeMarkColor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

