/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.WriteThread;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.impl.DummyProject;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectCloseHandler;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectLoadHelper;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.VetoableProjectManagerListener;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.DefaultProject;
import com.intellij.openapi.project.impl.ExcludeRootsCache;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.project.impl.TooManyProjectLeakedException;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.serviceContainer.ContainerUtilKt;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.IdeUICustomization;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UnsafeWeakList;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ref.GCUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class ProjectManagerImpl
extends ProjectManagerEx
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ProjectManagerImpl.class);
    private static final Key<List<ProjectManagerListener>> LISTENERS_IN_PROJECT_KEY = Key.create((String)"LISTENERS_IN_PROJECT_KEY");
    private static final ExtensionPointName<ProjectCloseHandler> CLOSE_HANDLER_EP = new ExtensionPointName("com.intellij.projectCloseHandler");
    private Project @NotNull [] myOpenProjects = new Project[0];
    private final Map<String, Project> myOpenProjectByHash = ContainerUtil.newConcurrentMap();
    private final Object lock = new Object();
    private final List<ProjectManagerListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final DefaultProject myDefaultProject = new DefaultProject();
    private final ExcludeRootsCache myExcludeRootsCache;
    public static int TEST_PROJECTS_CREATED;
    private static final boolean LOG_PROJECT_LEAKAGE_IN_TESTS;
    private static final int MAX_LEAKY_PROJECTS = 5;
    private static final long LEAK_CHECK_INTERVAL;
    private static long CHECK_START;
    private final Map<Project, String> myProjects = new WeakHashMap<Project, String>();

    @NotNull
    private static List<ProjectManagerListener> getListeners(@NotNull Project project) {
        List array;
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(0);
        }
        if ((array = (List)project.getUserData(LISTENERS_IN_PROJECT_KEY)) == null) {
            List<ProjectManagerListener> list2 = Collections.emptyList();
            if (list2 == null) {
                ProjectManagerImpl.$$$reportNull$$$0(1);
            }
            return list2;
        }
        List list3 = array;
        if (list3 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(2);
        }
        return list3;
    }

    public ProjectManagerImpl() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (ProjectManagerListener listener2 : ProjectManagerImpl.this.getAllListeners(project)) {
                    try {
                        listener2.projectOpened(project);
                    }
                    catch (Exception e) {
                        ProjectManagerImpl.handleListenerError(e, listener2);
                    }
                }
            }

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (ProjectManagerListener listener2 : ProjectManagerImpl.this.getAllListeners(project)) {
                    try {
                        listener2.projectClosed(project);
                    }
                    catch (Exception e) {
                        ProjectManagerImpl.handleListenerError(e, listener2);
                    }
                }
            }

            public void projectClosing(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                for (ProjectManagerListener listener2 : ProjectManagerImpl.this.getAllListeners(project)) {
                    try {
                        listener2.projectClosing(project);
                    }
                    catch (Exception e) {
                        ProjectManagerImpl.handleListenerError(e, listener2);
                    }
                }
            }

            public void projectClosingBeforeSave(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(3);
                }
                for (ProjectManagerListener listener2 : ProjectManagerImpl.this.getAllListeners(project)) {
                    try {
                        listener2.projectClosingBeforeSave(project);
                    }
                    catch (Exception e) {
                        ProjectManagerImpl.handleListenerError(e, listener2);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/openapi/project/impl/ProjectManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosed";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosing";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosingBeforeSave";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myExcludeRootsCache = new ExcludeRootsCache(connection);
    }

    @NotNull
    private static ProjectManagerListener getPublisher() {
        ProjectManagerListener projectManagerListener2 = (ProjectManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC);
        if (projectManagerListener2 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(3);
        }
        return projectManagerListener2;
    }

    private static void handleListenerError(@NotNull Throwable e, @NotNull ProjectManagerListener listener2) {
        if (e == null) {
            ProjectManagerImpl.$$$reportNull$$$0(4);
        }
        if (listener2 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(5);
        }
        if (e instanceof ProcessCanceledException) {
            throw (ProcessCanceledException)e;
        }
        LOG.error("From the listener " + listener2 + " (" + listener2.getClass() + ")", e);
    }

    public void dispose() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Disposer.dispose((Disposable)this.myDefaultProject);
    }

    @Override
    @Nullable
    public Project newProject(@Nullable String projectName, @NotNull String filePath, boolean useDefaultProjectSettings, boolean isDummy) {
        if (filePath == null) {
            ProjectManagerImpl.$$$reportNull$$$0(6);
        }
        return this.newProject(Paths.get(ProjectManagerImpl.toCanonicalName(filePath), new String[0]), projectName, OpenProjectTask.newProject(useDefaultProjectSettings));
    }

    @Override
    @Nullable
    public Project newProject(@NotNull Path projectFile, @Nullable String projectName, @NotNull OpenProjectTask options) {
        if (projectFile == null) {
            ProjectManagerImpl.$$$reportNull$$$0(7);
        }
        if (options == null) {
            ProjectManagerImpl.$$$reportNull$$$0(8);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ++TEST_PROJECTS_CREATED;
            this.checkProjectLeaksInTests();
        }
        if (Files.isRegularFile(projectFile, new LinkOption[0])) {
            try {
                FileUtil.delete((Path)projectFile);
            }
            catch (IOException iOException) {}
        } else {
            try (DirectoryStream<Path> directoryStream2 = Files.newDirectoryStream(projectFile.resolve(".idea"));){
                for (Path file2 : directoryStream2) {
                    FileUtil.delete((Path)file2);
                }
            }
            catch (IOException directoryStream2) {
                // empty catch block
            }
        }
        ProjectImpl project = ProjectManagerImpl.doCreateProject(projectName, projectFile);
        try {
            Project template = options.useDefaultProjectAsTemplate ? this.getDefaultProject() : null;
            ProjectManagerImpl.initProject(projectFile, project, options.isRefreshVfsNeeded, template, ProgressManager.getInstance().getProgressIndicator());
            if (LOG_PROJECT_LEAKAGE_IN_TESTS) {
                this.myProjects.put(project, null);
            }
            return project;
        }
        catch (Throwable t) {
            LOG.warn(t);
            try {
                Messages.showErrorDialog((String)ProjectManagerImpl.message(t), (String)ProjectBundle.message((String)"project.load.default.error", (Object[])new Object[0]));
            }
            catch (NoClassDefFoundError e) {
                LOG.info((Throwable)e);
            }
            return null;
        }
    }

    @NonNls
    @NotNull
    private static String message(@NotNull Throwable e) {
        String message;
        if (e == null) {
            ProjectManagerImpl.$$$reportNull$$$0(9);
        }
        if ((message = e.getMessage()) != null) {
            String string = message;
            if (string == null) {
                ProjectManagerImpl.$$$reportNull$$$0(10);
            }
            return string;
        }
        message = e.getLocalizedMessage();
        if (message != null) {
            String string = message;
            if (string == null) {
                ProjectManagerImpl.$$$reportNull$$$0(11);
            }
            return string;
        }
        message = e.toString();
        Throwable cause = e.getCause();
        if (cause != null) {
            String causeMessage = ProjectManagerImpl.message(cause);
            String string = message + " (cause: " + causeMessage + ")";
            if (string == null) {
                ProjectManagerImpl.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = message;
        if (string == null) {
            ProjectManagerImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    private void checkProjectLeaksInTests() {
        if (!LOG_PROJECT_LEAKAGE_IN_TESTS || this.getLeakedProjectsCount() < 5) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - CHECK_START < LEAK_CHECK_INTERVAL) {
            return;
        }
        for (int i = 0; i < 3 && this.getLeakedProjectsCount() >= 5; ++i) {
            GCUtil.tryGcSoftlyReachableObjects();
        }
        CHECK_START = currentTime;
        if (this.getLeakedProjectsCount() >= 5) {
            System.gc();
            Collection<Project> copy2 = this.getLeakedProjects();
            this.myProjects.clear();
            if (ContainerUtil.collect(copy2.iterator()).size() >= 5) {
                throw new TooManyProjectLeakedException(copy2);
            }
        }
    }

    private Collection<Project> getLeakedProjects() {
        this.myProjects.remove(DummyProject.getInstance());
        return (Collection)this.myProjects.keySet().stream().filter(p -> p.isDisposed() && !((ProjectImpl)p).isTemporarilyDisposed()).collect(Collectors.toCollection(UnsafeWeakList::new));
    }

    private int getLeakedProjectsCount() {
        this.myProjects.remove(DummyProject.getInstance());
        return (int)this.myProjects.keySet().stream().filter(project -> project.isDisposed() && !((ProjectImpl)project).isTemporarilyDisposed()).count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void initProject(@NotNull Path file2, @NotNull ProjectImpl project, boolean isRefreshVfsNeeded, @Nullable Project template, @Nullable ProgressIndicator indicator) {
        if (file2 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(14);
        }
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(15);
        }
        LOG.assertTrue(!project.isDefault());
        if (indicator != null) {
            indicator.setIndeterminate(false);
            indicator.setText(ProjectBundle.message((String)"project.loading.components", (Object[])new Object[0]));
        }
        Activity activity = StartUpMeasurer.startMainActivity((String)"project before loaded callbacks");
        ((ProjectLifecycleListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).beforeProjectLoaded((Project)project);
        activity.end();
        boolean succeed = false;
        try {
            ProjectLoadHelper.registerComponents(project);
            project.getStateStore().setPath(file2, isRefreshVfsNeeded, template);
            project.init(indicator);
            succeed = true;
        }
        finally {
            if (!succeed) {
                WriteThread.submit(() -> WriteAction.run(() -> Disposer.dispose((Disposable)project)));
            }
        }
    }

    @NotNull
    @ApiStatus.Internal
    public static ProjectImpl doCreateProject(@Nullable String projectName, @NotNull Path filePath) {
        if (filePath == null) {
            ProjectManagerImpl.$$$reportNull$$$0(16);
        }
        Activity activity = StartUpMeasurer.startMainActivity((String)"project instantiation");
        ProjectImpl project = new ProjectImpl(filePath, projectName);
        activity.end();
        ProjectImpl projectImpl = project;
        if (projectImpl == null) {
            ProjectManagerImpl.$$$reportNull$$$0(17);
        }
        return projectImpl;
    }

    @Override
    @NotNull
    public Project loadProject(@NotNull Path file2, @Nullable String projectName) {
        if (file2 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(18);
        }
        Project project = ProjectManagerImpl.loadProject(file2, projectName, null);
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(19);
        }
        return project;
    }

    public static Project loadProject(@NotNull Path file2, @Nullable String projectName, @Nullable Consumer<Project> beforeInit) {
        if (file2 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(20);
        }
        ProjectImpl project = ProjectManagerImpl.doCreateProject(projectName, file2);
        if (beforeInit != null) {
            beforeInit.accept(project);
        }
        ProjectManagerImpl.initProject(file2, project, true, null, ProgressManager.getInstance().getProgressIndicator());
        return project;
    }

    @NotNull
    private static String toCanonicalName(@NotNull String filePath) {
        String string;
        if (filePath == null) {
            ProjectManagerImpl.$$$reportNull$$$0(21);
        }
        try {
            string = FileUtil.resolveShortWindowsName((String)filePath);
        }
        catch (IOException iOException) {
            String string2 = filePath;
            if (string2 == null) {
                ProjectManagerImpl.$$$reportNull$$$0(23);
            }
            return string2;
        }
        if (string == null) {
            ProjectManagerImpl.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Override
    public boolean isDefaultProjectInitialized() {
        return this.myDefaultProject.isCached();
    }

    @NotNull
    public Project getDefaultProject() {
        LOG.assertTrue(!ApplicationManager.getApplication().isDisposed(), (Object)"Default project has been already disposed!");
        LOG.assertTrue(!this.myDefaultProject.getMessageBus().isDisposed());
        LOG.assertTrue(this.myDefaultProject.isCached());
        DefaultProject defaultProject = this.myDefaultProject;
        if (defaultProject == null) {
            ProjectManagerImpl.$$$reportNull$$$0(24);
        }
        return defaultProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Project @NotNull [] getOpenProjects() {
        Object object = this.lock;
        // MONITORENTER : object
        // MONITOREXIT : object
        if (this.myOpenProjects != null) return this.myOpenProjects;
        ProjectManagerImpl.$$$reportNull$$$0(25);
        return this.myOpenProjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProjectOpened(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(26);
        }
        Object object = this.lock;
        synchronized (object) {
            return ArrayUtil.contains((Object)project, (Object[])this.myOpenProjects);
        }
    }

    @Override
    public boolean openProject(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(27);
        }
        if (ProjectManagerImpl.isLight(project)) {
            ((ProjectImpl)project).setTemporarilyDisposed(false);
            boolean isInitialized = StartupManagerEx.getInstanceEx(project).startupActivityPassed();
            if (isInitialized) {
                this.addToOpened(project);
                return true;
            }
        }
        for (Project p : this.getOpenProjects()) {
            if (!ProjectUtil.isSameProject(project.getProjectFilePath(), p)) continue;
            GuiUtils.invokeLaterIfNeeded(() -> ProjectUtil.focusProjectWindow(p, false), (ModalityState)ModalityState.NON_MODAL);
            return false;
        }
        if (!this.addToOpened(project)) {
            return false;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && ApplicationManager.getApplication().isDispatchThread()) {
            LOG.warn("Consider to load project under progress");
        }
        try {
            ProjectManagerImpl.doLoadProject(project, ProgressManager.getInstance().getProgressIndicator());
        }
        catch (ProcessCanceledException e) {
            ApplicationManager.getApplication().invokeAndWait(() -> this.closeProject(project, false, true, false));
            ProjectManagerImpl.notifyProjectOpenFailed();
            return false;
        }
        return true;
    }

    private static void doLoadProject(@NotNull Project project, @Nullable ProgressIndicator indicator) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(28);
        }
        Activity waitEdtActivity = StartUpMeasurer.startMainActivity((String)"placing calling projectOpened on event queue");
        if (indicator != null) {
            indicator.setText(ApplicationManager.getApplication().isInternal() ? "Waiting on event queue..." : ProjectBundle.message((String)"project.preparing.workspace", (Object[])new Object[0]));
            indicator.setIndeterminate(true);
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            waitEdtActivity.end();
            if (indicator != null && ApplicationManager.getApplication().isInternal()) {
                indicator.setText("Running project opened tasks...");
            }
            ProjectManagerImpl.fireProjectOpened(project);
        });
        ((StartupManagerImpl)StartupManager.getInstance((Project)project)).projectOpened(indicator);
        GuiUtils.invokeLaterIfNeeded(() -> {
            LoadingState phase = DumbService.isDumb((Project)project) ? LoadingState.PROJECT_OPENED : LoadingState.INDEXING_FINISHED;
            StartUpMeasurer.compareAndSetCurrentState((LoadingState)LoadingState.COMPONENTS_LOADED, (LoadingState)phase);
        }, (ModalityState)ModalityState.NON_MODAL, (Condition)project.getDisposed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addToOpened(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(29);
        }
        assert (!project.isDisposed()) : "Must not open already disposed project";
        Object object = this.lock;
        synchronized (object) {
            if (this.isProjectOpened(project)) {
                return false;
            }
            this.myOpenProjects = (Project[])ArrayUtil.append((Object[])this.myOpenProjects, (Object)project);
        }
        this.updateTheOnlyProjectField();
        this.myOpenProjectByHash.put(project.getLocationHash(), project);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTheOnlyProjectField() {
        boolean isDefaultInitialized = this.isDefaultProjectInitialized();
        Object object = this.lock;
        synchronized (object) {
            ProjectCoreUtil.theProject = this.myOpenProjects.length == 1 && !isDefaultInitialized ? this.myOpenProjects[0] : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromOpened(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(30);
        }
        Object object = this.lock;
        synchronized (object) {
            this.myOpenProjects = (Project[])ArrayUtil.remove((Object[])this.myOpenProjects, (Object)project);
            this.myOpenProjectByHash.values().remove(project);
        }
    }

    @Override
    @Nullable
    public Project findOpenProjectByHash(@Nullable String locationHash) {
        return this.myOpenProjectByHash.get(locationHash);
    }

    public Project loadAndOpenProject(@NotNull String originalFilePath) {
        if (originalFilePath == null) {
            ProjectManagerImpl.$$$reportNull$$$0(31);
        }
        return this.loadAndOpenProject(Paths.get(FileUtilRt.toSystemIndependentName((String)ProjectManagerImpl.toCanonicalName(originalFilePath)), new String[0]));
    }

    @Nullable
    public Project loadAndOpenProject(final @NotNull Path file2) {
        ProjectImpl project;
        ConversionResult conversionResult;
        if (file2 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(32);
        }
        try {
            conversionResult = ConversionService.getInstance().convert(file2);
        }
        catch (CannotConvertException e) {
            conversionResult = null;
            LOG.info((Throwable)e);
            ProjectManagerImpl.showCannotConvertMessage(e, null);
        }
        if (conversionResult == null || conversionResult.openingIsCanceled()) {
            project = null;
        } else {
            project = ProjectManagerImpl.doCreateProject(null, file2);
            final ConversionResult finalConversionResult = conversionResult;
            ProgressManager.getInstance().run((Task)new Task.Modal(project, IdeUICustomization.getInstance().projectMessage("progress.title.loading.project", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    try {
                        ProjectManagerImpl.initProject(file2, project, true, null, indicator);
                    }
                    catch (ProcessCanceledException e) {
                        return;
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                        return;
                    }
                    if (!finalConversionResult.conversionNotNeeded()) {
                        StartupManager.getInstance((Project)project).registerPostStartupActivity(() -> finalConversionResult.postStartupActivity(project));
                    }
                    ProjectManagerImpl.this.openProject(project);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/project/impl/ProjectManagerImpl$2", "run"));
                }
            });
        }
        if (project == null) {
            WelcomeFrame.showIfNoProjectOpened();
            return null;
        }
        if (!project.isOpen()) {
            WelcomeFrame.showIfNoProjectOpened();
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (!project.isDisposed()) {
                    Disposer.dispose((Disposable)project);
                }
            });
        }
        return project;
    }

    public static void showCannotConvertMessage(@NotNull CannotConvertException e, @Nullable Component component2) {
        if (e == null) {
            ProjectManagerImpl.$$$reportNull$$$0(33);
        }
        AppUIUtil.invokeOnEdt(() -> Messages.showErrorDialog((Component)component2, (String)IdeBundle.message((String)"error.cannot.convert.project", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"title.cannot.convert.project", (Object[])new Object[0])));
    }

    private static void notifyProjectOpenFailed() {
        Application app = ApplicationManager.getApplication();
        ((AppLifecycleListener)app.getMessageBus().syncPublisher(AppLifecycleListener.TOPIC)).projectOpenFailed();
        if (!app.isUnitTestMode()) {
            WelcomeFrame.showIfNoProjectOpened();
        }
    }

    @Override
    public void openTestProject(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(34);
        }
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.openProject(project);
        UIUtil.dispatchAllInvocationEvents();
    }

    public void reloadProject(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(35);
        }
        StoreReloadManager.getInstance().reloadProject(project);
    }

    public final boolean closeProject(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(36);
        }
        return this.closeProject(project, true, false, true);
    }

    public final boolean forceCloseProject(@NotNull Project project, boolean dispose2) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(37);
        }
        return this.closeProject(project, false, dispose2, false);
    }

    @Override
    public boolean forceCloseProject(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(38);
        }
        return this.closeProject(project, false, true, false);
    }

    @Override
    public boolean closeAndDisposeAllProjects(boolean checkCanClose) {
        for (Project project : this.getOpenProjects()) {
            if (this.closeProject(project, true, true, checkCanClose)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeProject(@NotNull Project project, boolean saveProject, boolean dispose2, boolean checkCanClose) {
        Application app;
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(39);
        }
        if ((app = ApplicationManager.getApplication()).isWriteAccessAllowed()) {
            throw new IllegalStateException("Must not call closeProject() from under write action because fireProjectClosing() listeners must have a chance to do something useful");
        }
        app.assertIsWriteThread();
        if (ProjectManagerImpl.isLight(project)) {
            ProjectImpl projectImpl = (ProjectImpl)project;
            if (!projectImpl.isTemporarilyDisposed()) {
                projectImpl.disposeEarlyDisposable();
                projectImpl.setTemporarilyDisposed(true);
                this.removeFromOpened(project);
                this.updateTheOnlyProjectField();
                return true;
            }
            projectImpl.setTemporarilyDisposed(false);
        } else if (!this.isProjectOpened(project)) {
            if (dispose2) {
                if (project instanceof ProjectImpl) {
                    ProjectImpl projectImpl = (ProjectImpl)project;
                    projectImpl.stopServicePreloading();
                    projectImpl.disposeEarlyDisposable();
                }
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (project instanceof ProjectImpl) {
                        ((ProjectImpl)project).startDispose();
                    }
                    Disposer.dispose((Disposable)project);
                });
            }
            return true;
        }
        if (checkCanClose && !this.canClose(project)) {
            return false;
        }
        ShutDownTracker shutDownTracker = ShutDownTracker.getInstance();
        shutDownTracker.registerStopperThread(Thread.currentThread());
        try {
            if (project instanceof ProjectImpl) {
                ((ProjectImpl)project).stopServicePreloading();
            }
            ProjectManagerImpl.getPublisher().projectClosingBeforeSave(project);
            if (saveProject) {
                FileDocumentManager.getInstance().saveAllDocuments();
                SaveAndSyncHandler.getInstance().saveSettingsUnderModalProgress((ComponentManager)project);
            }
            if (checkCanClose && !ProjectManagerImpl.ensureCouldCloseIfUnableToSave(project)) {
                boolean bl = false;
                return bl;
            }
            ProjectManagerImpl.fireProjectClosing(project);
            if (project instanceof ProjectImpl) {
                ((ProjectImpl)project).disposeEarlyDisposable();
            }
            app.runWriteAction(() -> {
                if (dispose2 && project instanceof ProjectImpl) {
                    ((ProjectImpl)project).startDispose();
                }
                this.removeFromOpened(project);
                ProjectManagerImpl.fireProjectClosed(project);
                ZipHandler.clearFileAccessorCache();
                LaterInvocator.purgeExpiredItems();
                if (dispose2) {
                    Disposer.dispose((Disposable)project);
                }
            });
        }
        finally {
            shutDownTracker.unregisterStopperThread(Thread.currentThread());
        }
        return true;
    }

    public static boolean isLight(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(40);
        }
        return project instanceof ProjectImpl && ((ProjectImpl)project).isLight();
    }

    @Override
    public boolean closeAndDispose(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(41);
        }
        return this.closeProject(project, true, true, true);
    }

    private static void fireProjectClosing(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(42);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: fireProjectClosing()");
        }
        ProjectManagerImpl.getPublisher().projectClosing(project);
    }

    public void addProjectManagerListener(@NotNull ProjectManagerListener listener2) {
        if (listener2 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(43);
        }
        this.myListeners.add(listener2);
    }

    public void addProjectManagerListener(@NotNull VetoableProjectManagerListener listener2) {
        if (listener2 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(44);
        }
        this.myListeners.add((ProjectManagerListener)listener2);
    }

    public void addProjectManagerListener(@NotNull ProjectManagerListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(45);
        }
        if (parentDisposable == null) {
            ProjectManagerImpl.$$$reportNull$$$0(46);
        }
        this.addProjectManagerListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.removeProjectManagerListener(listener2));
    }

    public void removeProjectManagerListener(@NotNull ProjectManagerListener listener2) {
        if (listener2 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(47);
        }
        boolean removed = this.myListeners.remove(listener2);
        LOG.assertTrue(removed);
    }

    public void removeProjectManagerListener(@NotNull VetoableProjectManagerListener listener2) {
        if (listener2 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(48);
        }
        boolean removed = this.myListeners.remove(listener2);
        LOG.assertTrue(removed);
    }

    public void addProjectManagerListener(@NotNull Project project, @NotNull ProjectManagerListener listener2) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(49);
        }
        if (listener2 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(50);
        }
        if (project.isDefault()) {
            return;
        }
        List listeners = (List)project.getUserData(LISTENERS_IN_PROJECT_KEY);
        if (listeners == null) {
            listeners = (List)((UserDataHolderEx)project).putUserDataIfAbsent(LISTENERS_IN_PROJECT_KEY, (Object)ContainerUtil.createLockFreeCopyOnWriteList());
        }
        listeners.add(listener2);
    }

    public void removeProjectManagerListener(@NotNull Project project, @NotNull ProjectManagerListener listener2) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(51);
        }
        if (listener2 == null) {
            ProjectManagerImpl.$$$reportNull$$$0(52);
        }
        if (project.isDefault()) {
            return;
        }
        List listeners = (List)project.getUserData(LISTENERS_IN_PROJECT_KEY);
        LOG.assertTrue(listeners != null);
        boolean removed = listeners.remove(listener2);
        LOG.assertTrue(removed);
    }

    private static void fireProjectOpened(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(53);
        }
        LOG.debug("projectOpened");
        LifecycleUsageTriggerCollector.onProjectOpened(project);
        Activity activity = StartUpMeasurer.startMainActivity((String)"project opened callbacks");
        ProjectManagerImpl.getPublisher().projectOpened(project);
        ContainerUtilKt.processProjectComponents((PicoContainer)project.getPicoContainer(), (component2, pluginDescriptor) -> StartupManagerImpl.runActivity(() -> {
            Activity componentActivity = StartUpMeasurer.startActivity((String)component2.getClass().getName(), (ActivityCategory)ActivityCategory.PROJECT_OPEN_HANDLER, (String)pluginDescriptor.getPluginId().getIdString());
            component2.projectOpened();
            componentActivity.end();
        }));
        activity.end();
        ProjectImpl.ourClassesAreLoaded = true;
    }

    private static void fireProjectClosed(@NotNull Project project) {
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(54);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("projectClosed");
        }
        LifecycleUsageTriggerCollector.onProjectClosed(project);
        ProjectManagerImpl.getPublisher().projectClosed(project);
        List components = project.getComponentInstancesOfType(ProjectComponent.class, false);
        for (int i = components.size() - 1; i >= 0; --i) {
            ProjectComponent component2 = (ProjectComponent)components.get(i);
            try {
                component2.projectClosed();
                continue;
            }
            catch (Throwable e) {
                LOG.error(component2.toString(), e);
            }
        }
    }

    @Override
    public boolean canClose(@NotNull Project project) {
        ProjectCloseHandler handler2;
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(55);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: canClose()");
        }
        Iterator<Object> iterator2 = CLOSE_HANDLER_EP.getIterable().iterator();
        while (iterator2.hasNext() && (handler2 = (ProjectCloseHandler)iterator2.next()) != null) {
            try {
                if (handler2.canClose(project)) continue;
                LOG.debug("close canceled by " + handler2);
                return false;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        for (ProjectManagerListener listener2 : this.getAllListeners(project)) {
            try {
                boolean canClose = listener2 instanceof VetoableProjectManagerListener ? ((VetoableProjectManagerListener)listener2).canClose(project) : listener2.canCloseProject(project);
                if (canClose) continue;
                LOG.debug("close canceled by " + listener2);
                return false;
            }
            catch (Throwable e) {
                ProjectManagerImpl.handleListenerError(e, listener2);
            }
        }
        return true;
    }

    @NotNull
    private List<ProjectManagerListener> getAllListeners(@NotNull Project project) {
        List<ProjectManagerListener> projectLevelListeners;
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(56);
        }
        if ((projectLevelListeners = ProjectManagerImpl.getListeners(project)).isEmpty()) {
            List<ProjectManagerListener> list2 = this.myListeners;
            if (list2 == null) {
                ProjectManagerImpl.$$$reportNull$$$0(57);
            }
            return list2;
        }
        if (this.myListeners.isEmpty()) {
            List<ProjectManagerListener> list3 = projectLevelListeners;
            if (list3 == null) {
                ProjectManagerImpl.$$$reportNull$$$0(58);
            }
            return list3;
        }
        ArrayList<ProjectManagerListener> result2 = new ArrayList<ProjectManagerListener>(projectLevelListeners.size() + this.myListeners.size());
        result2.addAll(projectLevelListeners);
        result2.addAll(this.myListeners);
        ArrayList<ProjectManagerListener> arrayList = result2;
        if (arrayList == null) {
            ProjectManagerImpl.$$$reportNull$$$0(59);
        }
        return arrayList;
    }

    private static boolean ensureCouldCloseIfUnableToSave(@NotNull Project project) {
        NotificationsManager notificationManager2;
        if (project == null) {
            ProjectManagerImpl.$$$reportNull$$$0(60);
        }
        if ((notificationManager2 = (NotificationsManager)ApplicationManager.getApplication().getServiceIfCreated(NotificationsManager.class)) == null) {
            return true;
        }
        UnableToSaveProjectNotification[] notifications = (UnableToSaveProjectNotification[])notificationManager2.getNotificationsOfType(UnableToSaveProjectNotification.class, project);
        if (notifications.length == 0) {
            return true;
        }
        StringBuilder message = new StringBuilder();
        message.append(String.format("%s was unable to save some project files,\nare you sure you want to close this project anyway?", ApplicationNamesInfo.getInstance().getProductName()));
        message.append("\n\nRead-only files:\n");
        int count = 0;
        List files2 = notifications[0].myFiles;
        for (VirtualFile file2 : files2) {
            if (count == 10) {
                message.append('\n').append("and ").append(files2.size() - count).append(" more").append('\n');
                continue;
            }
            message.append(file2.getPath()).append('\n');
            ++count;
        }
        return Messages.showYesNoDialog((Project)project, (String)message.toString(), (String)IdeUICustomization.getInstance().projectMessage("dialog.title.unsaved.project", new Object[0]), (Icon)Messages.getWarningIcon()) == 0;
    }

    @Override
    public String @NotNull [] getAllExcludedUrls() {
        String[] stringArray = this.myExcludeRootsCache.getExcludedUrls();
        if (stringArray == null) {
            ProjectManagerImpl.$$$reportNull$$$0(61);
        }
        return stringArray;
    }

    static {
        LOG_PROJECT_LEAKAGE_IN_TESTS = Boolean.parseBoolean(System.getProperty("idea.log.leaked.projects.in.tests", "true"));
        LEAK_CHECK_INTERVAL = TimeUnit.MINUTES.toMillis(30L);
        CHECK_START = System.currentTimeMillis();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 57: 
            case 58: 
            case 59: 
            case 61: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 57: 
            case 58: 
            case 59: 
            case 61: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 57: 
            case 58: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/project/impl/ProjectManagerImpl";
                break;
            }
            case 4: 
            case 9: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 14: 
            case 18: 
            case 20: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFilePath";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/project/impl/ProjectManagerImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getListeners";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublisher";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "message";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateProject";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "loadProject";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "toCanonicalName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProject";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenProjects";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllListeners";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllExcludedUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getListeners";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 57: 
            case 58: 
            case 59: 
            case 61: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleListenerError";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "newProject";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "message";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "initProject";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doCreateProject";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "loadProject";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "toCanonicalName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isProjectOpened";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "openProject";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doLoadProject";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addToOpened";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "removeFromOpened";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "loadAndOpenProject";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "showCannotConvertMessage";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "openTestProject";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "reloadProject";
                break;
            }
            case 36: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "closeProject";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "forceCloseProject";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isLight";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "closeAndDispose";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "fireProjectClosing";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "addProjectManagerListener";
                break;
            }
            case 47: 
            case 48: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "removeProjectManagerListener";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "fireProjectOpened";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "fireProjectClosed";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "canClose";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getAllListeners";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "ensureCouldCloseIfUnableToSave";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 57: 
            case 58: 
            case 59: 
            case 61: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class UnableToSaveProjectNotification
    extends Notification {
        private Project myProject;
        private List<VirtualFile> myFiles;

        public void setFiles(@NotNull List<VirtualFile> files2) {
            if (files2 == null) {
                UnableToSaveProjectNotification.$$$reportNull$$$0(0);
            }
            this.myFiles = files2;
        }

        public UnableToSaveProjectNotification(@NotNull Project project, @NotNull List<VirtualFile> readOnlyFiles) {
            if (project == null) {
                UnableToSaveProjectNotification.$$$reportNull$$$0(1);
            }
            if (readOnlyFiles == null) {
                UnableToSaveProjectNotification.$$$reportNull$$$0(2);
            }
            super(IdeBundle.message((String)"notification.group.project.settings", (Object[])new Object[0]), IdeUICustomization.getInstance().projectMessage("notification.title.cannot.save.project", new Object[0]), IdeBundle.message((String)"notification.content.unable.to.save.project.files", (Object[])new Object[0]), NotificationType.ERROR, (notification, event) -> {
                UnableToSaveProjectNotification unableToSaveProjectNotification = (UnableToSaveProjectNotification)notification;
                Project _project = unableToSaveProjectNotification.myProject;
                notification.expire();
                if (_project != null && !_project.isDisposed()) {
                    _project.save();
                }
            });
            this.myProject = project;
            this.myFiles = readOnlyFiles;
        }

        public void expire() {
            this.myProject = null;
            super.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "readOnlyFiles";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/project/impl/ProjectManagerImpl$UnableToSaveProjectNotification";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setFiles";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

