/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePointerCapableFileSystem;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.impl.FilePointerPartNode;
import com.intellij.openapi.vfs.impl.IdentityVirtualFilePointer;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.impl.VirtualFilePointerContainerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VirtualFilePointerManagerImpl
extends VirtualFilePointerManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(VirtualFilePointerManagerImpl.class);
    private static final Comparator<String> URL_COMPARATOR = SystemInfo.isFileSystemCaseSensitive ? String::compareTo : String::compareToIgnoreCase;
    static final boolean IS_UNDER_UNIT_TEST = ApplicationManager.getApplication().isUnitTestMode();
    private static final VirtualFilePointerListener NULL_LISTENER = new VirtualFilePointerListener(){

        public int hashCode() {
            return 4;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }
    };
    private final Map<VirtualFileSystem, Map<VirtualFilePointerListener, FilePointerPartNode>> myRoots = ContainerUtil.newIdentityTroveMap();
    private final Set<VirtualFilePointerContainerImpl> myContainers = ContainerUtil.newIdentityTroveSet();
    private int myPointerSetModCount;
    private final Map<String, IdentityVirtualFilePointer> myUrlToIdentity = new THashMap();

    public void dispose() {
        this.assertAllPointersDisposed();
    }

    private static VirtualFilePointer @NotNull [] toPointers(@NotNull Collection<? extends FilePointerPartNode> nodes) {
        if (nodes == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(0);
        }
        if (nodes.isEmpty()) {
            if (VirtualFilePointer.EMPTY_ARRAY == null) {
                VirtualFilePointerManagerImpl.$$$reportNull$$$0(1);
            }
            return VirtualFilePointer.EMPTY_ARRAY;
        }
        ArrayList list2 = new ArrayList(nodes.size());
        for (FilePointerPartNode filePointerPartNode : nodes) {
            filePointerPartNode.addAllPointersTo(list2);
        }
        VirtualFilePointer[] virtualFilePointerArray = list2.toArray(VirtualFilePointer.EMPTY_ARRAY);
        if (virtualFilePointerArray == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(2);
        }
        return virtualFilePointerArray;
    }

    @NotNull
    synchronized List<VirtualFilePointer> getPointersUnder(@NotNull VirtualFile parent, @NotNull String childName) {
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(3);
        }
        if (childName == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(4);
        }
        assert (!StringUtil.isEmptyOrSpaces((String)childName));
        MultiMap nodes = MultiMap.create();
        this.addRelevantPointers(parent, VirtualFilePointerManagerImpl.toNameId(childName), (MultiMap<VirtualFilePointerListener, FilePointerPartNode>)nodes, true, parent.getFileSystem());
        ArrayList<VirtualFilePointer> pointers2 = new ArrayList<VirtualFilePointer>();
        for (FilePointerPartNode node : nodes.values()) {
            node.addAllPointersTo(pointers2);
        }
        ArrayList<VirtualFilePointer> arrayList = pointers2;
        if (arrayList == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private void addRelevantPointers(VirtualFile parent, int childNameId, @NotNull MultiMap<VirtualFilePointerListener, FilePointerPartNode> out, boolean addSubdirectoryPointers, @NotNull VirtualFileSystem fs) {
        if (out == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(6);
        }
        if (fs == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(7);
        }
        if (childNameId <= 0) {
            throw new IllegalArgumentException("invalid argument childNameId: " + childNameId);
        }
        Map<VirtualFilePointerListener, FilePointerPartNode> myPointers = this.myRoots.get(fs);
        if (myPointers != null) {
            for (Map.Entry<VirtualFilePointerListener, FilePointerPartNode> entry : myPointers.entrySet()) {
                FilePointerPartNode root = entry.getValue();
                VirtualFilePointerListener listener2 = entry.getKey();
                List outNodes = (List)out.getModifiable((Object)listener2);
                root.addRelevantPointersFrom(parent, childNameId, outNodes, addSubdirectoryPointers, fs);
            }
        }
        if (fs instanceof LocalFileSystem) {
            for (Map.Entry<Object, Object> entry : this.myRoots.entrySet()) {
                VirtualFileSystem rootFS = (VirtualFileSystem)entry.getKey();
                if (!(rootFS instanceof ArchiveFileSystem)) continue;
                this.addRelevantPointers(parent, childNameId, out, addSubdirectoryPointers, rootFS);
            }
        }
    }

    @NotNull
    public VirtualFilePointer create(@NotNull String url, @NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        if (url == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(8);
        }
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(9);
        }
        return this.create(null, url, parent, listener2, false);
    }

    @NotNull
    public VirtualFilePointer create(@NotNull VirtualFile file2, @NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        if (file2 == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(10);
        }
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(11);
        }
        return this.create(file2, null, parent, listener2, false);
    }

    @NotNull
    private VirtualFilePointer create(@Nullable(value="null means the pointer will be created from the (not null) url") @Nullable(value="null means the pointer will be created from the (not null) url") VirtualFile file2, @Nullable(value="null means url has to be computed from the (not-null) file path") @Nullable(value="null means url has to be computed from the (not-null) file path") String url, @NotNull Disposable parentDisposable, @Nullable VirtualFilePointerListener listener2, boolean recursive) {
        String path;
        VirtualFileSystem fileSystem;
        String protocol;
        if (parentDisposable == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            int protocolEnd = url.indexOf("://");
            if (protocolEnd == -1) {
                protocol = null;
                fileSystem = null;
                path = url;
            } else {
                protocol = url.substring(0, protocolEnd);
                fileSystem = VirtualFileManager.getInstance().getFileSystem(protocol);
                path = url.substring(protocolEnd + "://".length());
            }
            if (fileSystem == null) {
                return new LightFilePointer(url);
            }
        } else {
            fileSystem = file2.getFileSystem();
            protocol = fileSystem.getProtocol();
            path = null;
            url = null;
        }
        if (fileSystem instanceof TempFileSystem && listener2 == null) {
            VirtualFile found = file2 == null ? VirtualFileManager.getInstance().findFileByUrl(url) : file2;
            return found == null ? new LightFilePointer(url) : new LightFilePointer(found);
        }
        if (!(fileSystem instanceof VirtualFilePointerCapableFileSystem)) {
            VirtualFile found;
            VirtualFile virtualFile = found = file2 == null ? VirtualFileManager.getInstance().findFileByUrl(url) : file2;
            if (url == null) {
                url = file2.getUrl();
            }
            return this.getOrCreateIdentity(url, found, recursive, parentDisposable);
        }
        if (file2 == null) {
            String cleanPath = VirtualFilePointerManagerImpl.cleanupPath(path);
            if (cleanPath != path) {
                url = VirtualFileManager.constructUrl((String)protocol, (String)(cleanPath + (fileSystem instanceof ArchiveFileSystem ? "!/" : "")));
                path = cleanPath;
            }
            if (url.contains("..")) {
                file2 = VirtualFileManager.getInstance().findFileByUrl(url);
                if (file2 != null) {
                    url = file2.getUrl();
                    path = file2.getPath();
                } else {
                    path = FileUtil.toCanonicalPath((String)path);
                    url = VirtualFileManager.constructUrl((String)protocol, (String)(path + (fileSystem instanceof ArchiveFileSystem ? "!/" : "")));
                }
            }
            if (file2 == null && StringUtil.isEmptyOrSpaces((String)path)) {
                return this.getOrCreateIdentity(url, VirtualFileManager.getInstance().findFileByUrl(url), recursive, parentDisposable);
            }
        }
        return this.getOrCreate(file2, path, url, recursive, parentDisposable, listener2, (NewVirtualFileSystem)fileSystem);
    }

    @NotNull
    private synchronized IdentityVirtualFilePointer getOrCreateIdentity(final @NotNull String url, final @Nullable VirtualFile found, boolean recursive, @NotNull Disposable parentDisposable) {
        IdentityVirtualFilePointer pointer;
        if (url == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(13);
        }
        if (parentDisposable == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(14);
        }
        if ((pointer = this.myUrlToIdentity.get(url)) == null) {
            pointer = new IdentityVirtualFilePointer(found, url){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void dispose() {
                    VirtualFilePointerManagerImpl virtualFilePointerManagerImpl = VirtualFilePointerManagerImpl.this;
                    synchronized (virtualFilePointerManagerImpl) {
                        super.dispose();
                        VirtualFilePointerManagerImpl.this.myUrlToIdentity.remove(url);
                    }
                }

                @Override
                public String toString() {
                    return "identity: url='" + url + "'; file=" + found;
                }
            };
            this.myUrlToIdentity.put(url, pointer);
            DelegatingDisposable.registerDisposable(parentDisposable, pointer);
        }
        pointer.incrementUsageCount(1);
        pointer.recursive = recursive;
        IdentityVirtualFilePointer identityVirtualFilePointer = pointer;
        if (identityVirtualFilePointer == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(15);
        }
        return identityVirtualFilePointer;
    }

    @NotNull
    private static String cleanupPath(@NotNull String path) {
        int slash;
        if (path == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(16);
        }
        path = FileUtilRt.toSystemIndependentName((String)path);
        path = VirtualFilePointerManagerImpl.trimTrailingSeparators(path);
        int i = 0;
        while (i < path.length() && (slash = path.indexOf(47, i)) != -1 && slash != path.length() - 1) {
            char next = path.charAt(slash + 1);
            if (next == '/' && (i != 0 || !SystemInfo.isWindows) || next == '.' && (slash == path.length() - 2 || path.charAt(slash + 2) == '/')) {
                return VirtualFilePointerManagerImpl.cleanupTail(path, slash);
            }
            i = slash + 1;
        }
        String string = path;
        if (string == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private static String cleanupTail(@NotNull String path, int slashIndex) {
        if (path == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(18);
        }
        StringBuilder s = new StringBuilder(path.length());
        s.append(path, 0, slashIndex);
        for (int i = slashIndex; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/') {
                char nextc;
                char c2 = nextc = i == path.length() - 1 ? (char)'\u0000' : path.charAt(i + 1);
                if (nextc == '.') {
                    if (i == path.length() - 2) break;
                    char nextNextc = path.charAt(i + 2);
                    if (nextNextc == '/') {
                        ++i;
                        continue;
                    }
                } else if (nextc == '/') continue;
            }
            s.append(c);
        }
        String string = s.toString();
        if (string == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private static String trimTrailingSeparators(@NotNull String path) {
        if (path == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(20);
        }
        path = StringUtil.trimEnd((String)path, (String)"!/");
        String string = path = StringUtil.trimTrailing((String)path, (char)'/');
        if (string == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    private synchronized VirtualFilePointerImpl getOrCreate(VirtualFile file2, String path, String url, boolean recursive, @NotNull Disposable parentDisposable, @Nullable VirtualFilePointerListener listener2, @NotNull NewVirtualFileSystem fs) {
        if (parentDisposable == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(22);
        }
        if (fs == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(23);
        }
        VirtualFilePointerListener nl = (VirtualFilePointerListener)ObjectUtils.notNull((Object)listener2, (Object)NULL_LISTENER);
        Map myPointers = this.myRoots.computeIfAbsent((VirtualFileSystem)fs, __ -> new THashMap());
        FilePointerPartNode root = myPointers.computeIfAbsent(nl, __ -> FilePointerPartNode.createFakeRoot());
        FilePointerPartNode node = file2 == null ? FilePointerPartNode.findOrCreateNodeByPath(root, path, fs) : root.findOrCreateNodeByFile(file2, fs);
        VirtualFilePointerImpl pointer = node.getAnyPointer();
        if (pointer == null) {
            pointer = new VirtualFilePointerImpl();
            Pair fileAndUrl = Pair.create((Object)file2, (Object)(file2 == null ? url : file2.getUrl()));
            node.associate((Object)pointer, (Pair<VirtualFile, String>)fileAndUrl);
            FilePointerPartNode n = node;
            while (n != null) {
                ++n.pointersUnder;
                n = n.parent;
            }
        }
        pointer.incrementUsageCount(1);
        pointer.recursive = recursive;
        root.checkConsistency();
        DelegatingDisposable.registerDisposable(parentDisposable, pointer);
        ++this.myPointerSetModCount;
        VirtualFilePointerImpl virtualFilePointerImpl = pointer;
        if (virtualFilePointerImpl == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(24);
        }
        return virtualFilePointerImpl;
    }

    @NotNull
    public VirtualFilePointer duplicate(@NotNull VirtualFilePointer pointer, @NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        VirtualFile file2;
        if (pointer == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(25);
        }
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(26);
        }
        VirtualFilePointer virtualFilePointer = (file2 = pointer.getFile()) == null ? this.create(pointer.getUrl(), parent, listener2) : this.create(file2, parent, listener2);
        if (virtualFilePointer == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(27);
        }
        return virtualFilePointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void assertAllPointersDisposed() {
        ArrayList<VirtualFilePointer> leaked = new ArrayList<VirtualFilePointer>(this.dumpAllPointers());
        Collections.sort(leaked, Comparator.comparing(VirtualFilePointer::getUrl));
        for (VirtualFilePointer pointer : leaked) {
            try {
                ((VirtualFilePointerImpl)pointer).throwDisposalError("Not disposed pointer: " + pointer);
            }
            finally {
                ((VirtualFilePointerImpl)pointer).dispose();
            }
        }
        Set<VirtualFilePointerContainerImpl> set = this.myContainers;
        synchronized (set) {
            if (!this.myContainers.isEmpty()) {
                VirtualFilePointerContainerImpl container2 = this.myContainers.iterator().next();
                container2.throwDisposalError("Not disposed container");
            }
        }
    }

    @NotNull
    public VirtualFilePointerContainer createContainer(@NotNull Disposable parent) {
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(28);
        }
        VirtualFilePointerContainer virtualFilePointerContainer = this.createContainer(parent, null);
        if (virtualFilePointerContainer == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(29);
        }
        return virtualFilePointerContainer;
    }

    @NotNull
    public synchronized VirtualFilePointerContainer createContainer(@NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(30);
        }
        return this.registerContainer(parent, new VirtualFilePointerContainerImpl(this, parent, listener2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private VirtualFilePointerContainer registerContainer(@NotNull Disposable parent, final @NotNull VirtualFilePointerContainerImpl container2) {
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(31);
        }
        if (container2 == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(32);
        }
        Set<VirtualFilePointerContainerImpl> set = this.myContainers;
        synchronized (set) {
            this.myContainers.add(container2);
        }
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                boolean removed;
                Disposer.dispose((Disposable)container2);
                Set set = VirtualFilePointerManagerImpl.this.myContainers;
                synchronized (set) {
                    removed = VirtualFilePointerManagerImpl.this.myContainers.remove((Object)container2);
                }
                if (!IS_UNDER_UNIT_TEST) assert (removed);
            }

            public String toString() {
                return "Disposing container " + (Object)((Object)container2);
            }
        });
        VirtualFilePointerContainerImpl virtualFilePointerContainerImpl = container2;
        if (virtualFilePointerContainerImpl == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(33);
        }
        return virtualFilePointerContainerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public AsyncFileListener.ChangeApplier prepareChange(final @NotNull List<? extends VFileEvent> events) {
        ArrayList<EventDescriptor> eventList;
        long startModCount;
        if (events == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(34);
        }
        long start2 = System.currentTimeMillis();
        final MultiMap toFireEvents = MultiMap.create();
        final MultiMap toUpdateUrl = MultiMap.create();
        ArrayList allPointersToFire = new ArrayList();
        VirtualFilePointerManagerImpl virtualFilePointerManagerImpl = this;
        synchronized (virtualFilePointerManagerImpl) {
            startModCount = this.myPointerSetModCount;
            for (VFileEvent vFileEvent : events) {
                VFilePropertyChangeEvent change;
                VirtualFile eventFile;
                ProgressManager.checkCanceled();
                VirtualFileSystem fs = vFileEvent.getFileSystem();
                if (!(fs instanceof VirtualFilePointerCapableFileSystem)) continue;
                if (vFileEvent instanceof VFileDeleteEvent) {
                    VFileDeleteEvent deleteEvent = (VFileDeleteEvent)vFileEvent;
                    VirtualFile file2 = deleteEvent.getFile();
                    this.addRelevantPointers(file2.getParent(), ((VirtualFileSystemEntry)file2).getNameId(), (MultiMap<VirtualFilePointerListener, FilePointerPartNode>)toFireEvents, true, fs);
                    continue;
                }
                if (vFileEvent instanceof VFileCreateEvent) {
                    boolean fireSubdirectoryPointers;
                    VFileCreateEvent createEvent = (VFileCreateEvent)vFileEvent;
                    if (createEvent.isDirectory()) {
                        fireSubdirectoryPointers = !createEvent.isEmptyDirectory();
                    } else {
                        String createdFileName = createEvent.getChildName();
                        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension(FileUtilRt.getExtension((String)createdFileName));
                        fireSubdirectoryPointers = fileType instanceof ArchiveFileType;
                    }
                    this.addRelevantPointers(createEvent.getParent(), createEvent.getChildNameId(), (MultiMap<VirtualFilePointerListener, FilePointerPartNode>)toFireEvents, fireSubdirectoryPointers, fs);
                    toUpdateUrl.putAllValues(toFireEvents);
                    continue;
                }
                if (vFileEvent instanceof VFileCopyEvent) {
                    VFileCopyEvent copyEvent = (VFileCopyEvent)vFileEvent;
                    this.addRelevantPointers(copyEvent.getNewParent(), VirtualFilePointerManagerImpl.toNameId(copyEvent.getNewChildName()), (MultiMap<VirtualFilePointerListener, FilePointerPartNode>)toFireEvents, true, fs);
                    continue;
                }
                if (vFileEvent instanceof VFileMoveEvent) {
                    VFileMoveEvent moveEvent = (VFileMoveEvent)vFileEvent;
                    eventFile = moveEvent.getFile();
                    int newNameId = ((VirtualFileSystemEntry)eventFile).getNameId();
                    this.addRelevantPointers(moveEvent.getNewParent(), newNameId, (MultiMap<VirtualFilePointerListener, FilePointerPartNode>)toFireEvents, true, fs);
                    MultiMap nodes = MultiMap.create();
                    this.addRelevantPointers(eventFile.getParent(), newNameId, (MultiMap<VirtualFilePointerListener, FilePointerPartNode>)nodes, true, fs);
                    toFireEvents.putAllValues(nodes);
                    VirtualFilePointerManagerImpl.collectNodes((MultiMap<VirtualFilePointerListener, FilePointerPartNode>)nodes, (MultiMap<VirtualFilePointerListener, FilePointerPartNode>)toUpdateUrl);
                    continue;
                }
                if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !"name".equals((change = (VFilePropertyChangeEvent)vFileEvent).getPropertyName()) || Comparing.equal((Object)change.getOldValue(), (Object)change.getNewValue())) continue;
                eventFile = change.getFile();
                VirtualFile parent = eventFile.getParent();
                int newNameId = VirtualFilePointerManagerImpl.toNameId(change.getNewValue().toString());
                this.addRelevantPointers(parent, newNameId, (MultiMap<VirtualFilePointerListener, FilePointerPartNode>)toFireEvents, true, fs);
                MultiMap nodes = MultiMap.create();
                this.addRelevantPointers(parent, ((VirtualFileSystemEntry)eventFile).getNameId(), (MultiMap<VirtualFilePointerListener, FilePointerPartNode>)nodes, true, fs);
                VirtualFilePointerManagerImpl.collectNodes((MultiMap<VirtualFilePointerListener, FilePointerPartNode>)nodes, (MultiMap<VirtualFilePointerListener, FilePointerPartNode>)toUpdateUrl);
            }
            eventList = new ArrayList<EventDescriptor>();
            for (Map.Entry entry : toFireEvents.entrySet()) {
                Collection values2;
                Object[] toFirePointers;
                VirtualFilePointerListener listener2 = (VirtualFilePointerListener)entry.getKey();
                if (listener2 == NULL_LISTENER || (toFirePointers = VirtualFilePointerManagerImpl.toPointers(values2 = (Collection)entry.getValue())).length == 0) continue;
                eventList.add(new EventDescriptor(listener2, (VirtualFilePointer[])toFirePointers));
                ContainerUtil.addAll(allPointersToFire, (Object[])toFirePointers);
            }
        }
        final long prepareElapsedMs = System.currentTimeMillis() - start2;
        final VirtualFilePointer[] virtualFilePointerArray = allPointersToFire.isEmpty() ? VirtualFilePointer.EMPTY_ARRAY : allPointersToFire.toArray(VirtualFilePointer.EMPTY_ARRAY);
        return new AsyncFileListener.ChangeApplier(){
            private AsyncFileListener.ChangeApplier delegate;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void beforeVfsChange() {
                VirtualFilePointerManagerImpl virtualFilePointerManagerImpl = VirtualFilePointerManagerImpl.this;
                synchronized (virtualFilePointerManagerImpl) {
                    if (startModCount != (long)VirtualFilePointerManagerImpl.this.myPointerSetModCount) {
                        this.delegate = VirtualFilePointerManagerImpl.this.prepareChange(events);
                    } else {
                        VirtualFilePointerManagerImpl.this.incModificationCount();
                    }
                }
                if (this.delegate != null) {
                    this.delegate.beforeVfsChange();
                    return;
                }
                for (EventDescriptor descriptor2 : eventList) {
                    descriptor2.fireBefore();
                }
                if (virtualFilePointerArray.length != 0) {
                    ((VirtualFilePointerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFilePointerListener.TOPIC)).beforeValidityChanged(virtualFilePointerArray);
                }
                VirtualFilePointerManagerImpl.this.assertConsistency();
            }

            public void afterVfsChange() {
                if (this.delegate != null) {
                    this.delegate.afterVfsChange();
                    return;
                }
                VirtualFilePointerManagerImpl.this.after((MultiMap<VirtualFilePointerListener, FilePointerPartNode>)toFireEvents, (MultiMap<VirtualFilePointerListener, FilePointerPartNode>)toUpdateUrl, eventList, virtualFilePointerArray, prepareElapsedMs, events.size());
            }
        };
    }

    private static int toNameId(@NotNull String name) {
        if (name == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(35);
        }
        return FileNameCache.storeName(name);
    }

    private static void collectNodes(@NotNull MultiMap<VirtualFilePointerListener, FilePointerPartNode> nodes, @NotNull MultiMap<VirtualFilePointerListener, FilePointerPartNode> toUpdateUrl) {
        if (nodes == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(36);
        }
        if (toUpdateUrl == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(37);
        }
        for (Map.Entry entry : nodes.entrySet()) {
            VirtualFilePointerListener listener2 = (VirtualFilePointerListener)entry.getKey();
            Collection values2 = (Collection)entry.getValue();
            for (FilePointerPartNode node : values2) {
                VirtualFile file2;
                VirtualFilePointerImpl pointer = node.getAnyPointer();
                if (pointer == null || (file2 = pointer.getFile()) == null) continue;
                toUpdateUrl.putValue((Object)listener2, (Object)node);
            }
        }
    }

    synchronized void assertConsistency() {
        if (IS_UNDER_UNIT_TEST && !ApplicationInfoImpl.isInStressTest()) {
            for (Map<VirtualFilePointerListener, FilePointerPartNode> myPointers : this.myRoots.values()) {
                for (FilePointerPartNode root : myPointers.values()) {
                    root.checkConsistency();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void after(@NotNull MultiMap<VirtualFilePointerListener, FilePointerPartNode> toFireEvents, @NotNull MultiMap<VirtualFilePointerListener, FilePointerPartNode> toUpdateUrls, @NotNull List<? extends EventDescriptor> eventList, VirtualFilePointer @NotNull [] allPointers, long prepareElapsedMs, int n) {
        if (toFireEvents == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(38);
        }
        if (toUpdateUrls == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(39);
        }
        if (eventList == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(40);
        }
        if (allPointers == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(41);
        }
        long start2 = System.currentTimeMillis();
        ApplicationManager.getApplication().assertIsWriteThread();
        this.incModificationCount();
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        VirtualFilePointerManagerImpl virtualFilePointerManagerImpl = this;
        synchronized (virtualFilePointerManagerImpl) {
            for (FilePointerPartNode node : toUpdateUrls.values()) {
                VirtualFileSystem fs;
                Pair<VirtualFile, String> pairBefore = node.myFileAndUrl;
                if (pairBefore == null) continue;
                String urlBefore = (String)pairBefore.second;
                Pair<VirtualFile, String> after2 = node.update();
                assert (after2 != null) : "can't invalidate inside modification";
                String urlAfter = (String)after2.second;
                VirtualFile fileAfter = (VirtualFile)after2.first;
                if (URL_COMPARATOR.compare(urlBefore, urlAfter) == 0 && node.urlEndsWithName(urlAfter, fileAfter) || !((fs = virtualFileManager.getFileSystem(VirtualFileManager.extractProtocol((String)urlAfter))) instanceof NewVirtualFileSystem)) continue;
                SmartList myPointers2 = new SmartList();
                node.addAllPointersTo((Collection<? super VirtualFilePointerImpl>)myPointers2);
                int useCount = node.useCount;
                FilePointerPartNode root = node.remove();
                String path = VirtualFilePointerManagerImpl.trimTrailingSeparators(VfsUtilCore.urlToPath((String)urlAfter));
                FilePointerPartNode newNode = fileAfter == null ? FilePointerPartNode.findOrCreateNodeByPath(root, path, (NewVirtualFileSystem)fs) : root.findOrCreateNodeByFile(fileAfter, (NewVirtualFileSystem)fs);
                newNode.addAllPointersTo((Collection<? super VirtualFilePointerImpl>)myPointers2);
                int pointersDelta = myPointers2.size() - newNode.pointersUnder;
                Object newMyPointers = myPointers2.size() == 1 ? myPointers2.get(0) : myPointers2.toArray(new VirtualFilePointerImpl[0]);
                newNode.associate(newMyPointers, after2);
                newNode.incrementUsageCount(useCount);
                FilePointerPartNode n2 = newNode;
                while (n2 != null) {
                    n2.pointersUnder += pointersDelta;
                    n2 = n2.parent;
                }
            }
        }
        for (FilePointerPartNode filePointerPartNode : toFireEvents.values()) {
            filePointerPartNode.update();
        }
        for (EventDescriptor eventDescriptor : eventList) {
            eventDescriptor.fireAfter();
        }
        if (allPointers.length != 0) {
            ((VirtualFilePointerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFilePointerListener.TOPIC)).validityChanged(allPointers);
        }
        this.assertConsistency();
        long afterElapsedMs = System.currentTimeMillis() - start2;
        if (afterElapsedMs > 1000L || prepareElapsedMs > 1000L) {
            void eventsSize;
            int totalPointers;
            VirtualFilePointerManagerImpl virtualFilePointerManagerImpl2 = this;
            synchronized (virtualFilePointerManagerImpl2) {
                totalPointers = this.myRoots.values().stream().flatMapToInt(myPointers -> myPointers.values().stream().mapToInt(root -> root.pointersUnder)).sum();
            }
            LOG.warn("VirtualFilePointerManagerImpl.prepareChange(" + (int)eventsSize + " events): " + prepareElapsedMs + "ms. after(toFireEvents: " + toFireEvents.size() + ", toUpdateUrl: " + toUpdateUrls + ", eventList: " + eventList + "): " + afterElapsedMs + "ms. total pointers: " + totalPointers);
        }
    }

    synchronized boolean decrementUsageCount(@NotNull VirtualFilePointerImpl pointer) {
        boolean shouldKill;
        if (pointer == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(42);
        }
        boolean bl = shouldKill = pointer.incrementUsageCount(-1) == 0;
        if (shouldKill) {
            this.removeNodeFrom(pointer);
        }
        return shouldKill;
    }

    private void removeNodeFrom(@NotNull VirtualFilePointerImpl pointer) {
        boolean rootNodeEmpty;
        if (pointer == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(43);
        }
        FilePointerPartNode root = pointer.myNode.remove();
        boolean bl = rootNodeEmpty = root.children.length == 0;
        if (rootNodeEmpty) {
            for (Map<VirtualFilePointerListener, FilePointerPartNode> myPointers : this.myRoots.values()) {
                myPointers.values().remove(root);
            }
        }
        pointer.myNode = null;
        this.assertConsistency();
        ++this.myPointerSetModCount;
    }

    public long getModificationCount() {
        return super.getModificationCount() + (long)PersistentFS.getInstance().getStructureModificationCount();
    }

    @NotNull
    public VirtualFilePointer createDirectoryPointer(@NotNull String url, boolean recursively, @NotNull Disposable parent, @NotNull VirtualFilePointerListener listener2) {
        if (url == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(44);
        }
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(45);
        }
        if (listener2 == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(46);
        }
        return this.create(null, url, parent, listener2, true);
    }

    synchronized int numberOfPointers() {
        int number = 0;
        for (Map<VirtualFilePointerListener, FilePointerPartNode> myPointers : this.myRoots.values()) {
            for (FilePointerPartNode root : myPointers.values()) {
                number += root.numberOfPointersUnder();
            }
        }
        return number;
    }

    synchronized int numberOfListeners() {
        return this.myRoots.values().stream().flatMap(myPointers -> myPointers.keySet().stream()).collect(Collectors.toSet()).size();
    }

    synchronized int numberOfCachedUrlToIdentity() {
        return this.myUrlToIdentity.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shelveAllPointersIn(@NotNull Runnable runnable2) {
        LinkedHashMap<VirtualFileSystem, Map<VirtualFilePointerListener, FilePointerPartNode>> shelvedPointers;
        if (runnable2 == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(47);
        }
        VirtualFilePointerManagerImpl virtualFilePointerManagerImpl = this;
        synchronized (virtualFilePointerManagerImpl) {
            shelvedPointers = new LinkedHashMap<VirtualFileSystem, Map<VirtualFilePointerListener, FilePointerPartNode>>(this.myRoots);
            this.myRoots.clear();
        }
        try {
            runnable2.run();
        }
        finally {
            virtualFilePointerManagerImpl = this;
            synchronized (virtualFilePointerManagerImpl) {
                this.myRoots.clear();
                this.myRoots.putAll(shelvedPointers);
            }
        }
    }

    @NotNull
    synchronized Collection<VirtualFilePointer> dumpAllPointers() {
        THashSet result2 = new THashSet();
        for (Map<VirtualFilePointerListener, FilePointerPartNode> myPointers : this.myRoots.values()) {
            for (FilePointerPartNode node : myPointers.values()) {
                VirtualFilePointerManagerImpl.dumpPointersRecursivelyTo(node, (Collection<? super VirtualFilePointer>)result2);
            }
        }
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(48);
        }
        return tHashSet;
    }

    private static void dumpPointersRecursivelyTo(@NotNull FilePointerPartNode node, @NotNull Collection<? super VirtualFilePointer> result2) {
        if (node == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(49);
        }
        if (result2 == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(50);
        }
        node.addAllPointersTo(result2);
        for (FilePointerPartNode child2 : node.children) {
            VirtualFilePointerManagerImpl.dumpPointersRecursivelyTo(child2, result2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 33: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 33: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 33: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 7: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 8: 
            case 13: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 25: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toUpdateUrl";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFireEvents";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toUpdateUrls";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventList";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allPointers";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toPointers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointersUnder";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateIdentity";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanupPath";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanupTail";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "trimTrailingSeparators";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "duplicate";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createContainer";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "registerContainer";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpAllPointers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toPointers";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 33: 
            case 48: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPointersUnder";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addRelevantPointers";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateIdentity";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "cleanupPath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "cleanupTail";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "trimTrailingSeparators";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "duplicate";
                break;
            }
            case 28: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createContainer";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "registerContainer";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "prepareChange";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "toNameId";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "collectNodes";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "after";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "decrementUsageCount";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "removeNodeFrom";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createDirectoryPointer";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "shelveAllPointersIn";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "dumpPointersRecursivelyTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 33: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DelegatingDisposable
    implements Disposable {
        private static final ConcurrentMap<Disposable, DelegatingDisposable> ourInstances = ConcurrentCollectionFactory.createMap(ContainerUtil.identityStrategy());
        private final TObjectIntHashMap<VirtualFilePointerImpl> myCounts;
        private final Disposable myParent;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DelegatingDisposable(@NotNull Disposable parent, @NotNull VirtualFilePointerImpl firstPointer) {
            if (parent == null) {
                DelegatingDisposable.$$$reportNull$$$0(0);
            }
            if (firstPointer == null) {
                DelegatingDisposable.$$$reportNull$$$0(1);
            }
            this.myCounts = new TObjectIntHashMap(ContainerUtil.identityStrategy());
            this.myParent = parent;
            DelegatingDisposable delegatingDisposable = this;
            synchronized (delegatingDisposable) {
                this.myCounts.put((Object)firstPointer, 1);
            }
        }

        private static void registerDisposable(@NotNull Disposable parentDisposable, @NotNull VirtualFilePointerImpl pointer) {
            DelegatingDisposable newDisposable;
            DelegatingDisposable result2;
            if (parentDisposable == null) {
                DelegatingDisposable.$$$reportNull$$$0(2);
            }
            if (pointer == null) {
                DelegatingDisposable.$$$reportNull$$$0(3);
            }
            if ((result2 = (DelegatingDisposable)ourInstances.get(parentDisposable)) == null && (result2 = (DelegatingDisposable)ConcurrencyUtil.cacheOrGet(ourInstances, (Object)parentDisposable, (Object)(newDisposable = new DelegatingDisposable(parentDisposable, pointer)))) == newDisposable) {
                Disposer.register((Disposable)parentDisposable, (Disposable)result2);
                return;
            }
            result2.increment(pointer);
        }

        synchronized void increment(@NotNull VirtualFilePointerImpl pointer) {
            if (pointer == null) {
                DelegatingDisposable.$$$reportNull$$$0(4);
            }
            if (!this.myCounts.increment((Object)pointer)) {
                this.myCounts.put((Object)pointer, 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            ourInstances.remove(this.myParent);
            DelegatingDisposable delegatingDisposable = this;
            synchronized (delegatingDisposable) {
                this.myCounts.forEachEntry((pointer, disposeCount) -> {
                    boolean isDisposed;
                    boolean bl = isDisposed = !(pointer instanceof IdentityVirtualFilePointer) && pointer.myNode == null;
                    if (isDisposed) {
                        pointer.throwDisposalError("Already disposed:\n" + pointer.getStackTrace());
                    }
                    int after2 = pointer.incrementUsageCount(-(disposeCount - 1));
                    LOG.assertTrue(after2 > 0, (Object)after2);
                    pointer.dispose();
                    return true;
                });
                this.myCounts.clear();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstPointer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pointer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$DelegatingDisposable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerDisposable";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "increment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class EventDescriptor {
        @NotNull
        private final VirtualFilePointerListener myListener;
        private final VirtualFilePointer @NotNull [] myPointers;

        private EventDescriptor(@NotNull VirtualFilePointerListener listener2, VirtualFilePointer @NotNull [] pointers2) {
            if (listener2 == null) {
                EventDescriptor.$$$reportNull$$$0(0);
            }
            if (pointers2 == null) {
                EventDescriptor.$$$reportNull$$$0(1);
            }
            this.myListener = listener2;
            this.myPointers = pointers2;
            if (pointers2.length == 0) {
                throw new IllegalArgumentException();
            }
        }

        private void fireBefore() {
            this.myListener.beforeValidityChanged(this.myPointers);
        }

        private void fireAfter() {
            this.myListener.validityChanged(this.myPointers);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "listener";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pointers";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$EventDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class MyAsyncFileListener
    implements AsyncFileListener {
        MyAsyncFileListener() {
        }

        public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                MyAsyncFileListener.$$$reportNull$$$0(0);
            }
            return ((VirtualFilePointerManagerImpl)VirtualFilePointerManager.getInstance()).prepareChange(events);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$MyAsyncFileListener", "prepareChange"));
        }
    }
}

