/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.FileContextProvider;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelperRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceResolver;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileTargetContext;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileReferenceSet {
    private static final Logger LOG = Logger.getInstance(FileReferenceSet.class);
    private static final FileType[] EMPTY_FILE_TYPES = new FileType[0];
    public static final CustomizableReferenceProvider.CustomizationKey<Function<PsiFile, Collection<PsiFileSystemItem>>> DEFAULT_PATH_EVALUATOR_OPTION = new CustomizableReferenceProvider.CustomizationKey(AnalysisBundle.message((String)"default.path.evaluator.option", (Object[])new Object[0]));
    public static final Function<PsiFile, Collection<PsiFileSystemItem>> ABSOLUTE_TOP_LEVEL = new AbsoluteTopLevelEvaluator();
    public static final Condition<PsiFileSystemItem> FILE_FILTER = item -> item instanceof PsiFile;
    public static final Condition<PsiFileSystemItem> DIRECTORY_FILTER = item -> item instanceof PsiDirectory;
    protected FileReference[] myReferences;
    private PsiElement myElement;
    private final int myStartInElement;
    private final boolean myCaseSensitive;
    private final String myPathStringNonTrimmed;
    private final String myPathString;
    private volatile Collection<PsiFileSystemItem> myDefaultContexts;
    private final boolean myEndingSlashNotAllowed;
    private boolean myEmptyPathAllowed;
    @Nullable
    private Map<CustomizableReferenceProvider.CustomizationKey, Object> myOptions;
    private FileType @Nullable [] mySuitableFileTypes;

    public FileReferenceSet(@NotNull String str, @NotNull PsiElement element2, int startInElement, PsiReferenceProvider provider, boolean caseSensitive, boolean endingSlashNotAllowed, FileType @Nullable [] suitableFileTypes) {
        if (str == null) {
            FileReferenceSet.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            FileReferenceSet.$$$reportNull$$$0(1);
        }
        this(str, element2, startInElement, provider, caseSensitive, endingSlashNotAllowed, suitableFileTypes, true);
    }

    public FileReferenceSet(@NotNull String str, @NotNull PsiElement element2, int startInElement, PsiReferenceProvider provider, boolean caseSensitive, boolean endingSlashNotAllowed, FileType @Nullable [] suitableFileTypes, boolean init2) {
        if (str == null) {
            FileReferenceSet.$$$reportNull$$$0(2);
        }
        if (element2 == null) {
            FileReferenceSet.$$$reportNull$$$0(3);
        }
        this.myElement = element2;
        this.myStartInElement = startInElement;
        this.myCaseSensitive = caseSensitive;
        this.myPathStringNonTrimmed = str;
        this.myPathString = str.trim();
        this.myEndingSlashNotAllowed = endingSlashNotAllowed;
        this.myEmptyPathAllowed = !endingSlashNotAllowed;
        this.myOptions = provider instanceof CustomizableReferenceProvider ? ((CustomizableReferenceProvider)provider).getOptions() : null;
        this.mySuitableFileTypes = suitableFileTypes;
        if (init2) {
            this.reparse();
        }
    }

    protected String getNewAbsolutePath(PsiFileSystemItem root, String relativePath) {
        return this.absoluteUrlNeedsStartSlash() ? "/" + relativePath : relativePath;
    }

    public String getSeparatorString() {
        return "/";
    }

    protected int findSeparatorLength(@NotNull CharSequence sequence, int atOffset) {
        if (sequence == null) {
            FileReferenceSet.$$$reportNull$$$0(4);
        }
        return StringUtil.startsWith((CharSequence)sequence, (int)atOffset, (CharSequence)this.getSeparatorString()) ? this.getSeparatorString().length() : 0;
    }

    protected int findSeparatorOffset(@NotNull CharSequence sequence, int startingFrom) {
        if (sequence == null) {
            FileReferenceSet.$$$reportNull$$$0(5);
        }
        return StringUtil.indexOf((CharSequence)sequence, (CharSequence)this.getSeparatorString(), (int)startingFrom);
    }

    @Deprecated
    protected Collection<PsiFileSystemItem> getExtraContexts() {
        return Collections.emptyList();
    }

    public static FileReferenceSet createSet(@NotNull PsiElement element2, final boolean soft, boolean endingSlashNotAllowed, final boolean urlEncoded) {
        if (element2 == null) {
            FileReferenceSet.$$$reportNull$$$0(6);
        }
        TextRange range2 = ElementManipulators.getValueTextRange((PsiElement)element2);
        int offset = range2.getStartOffset();
        String text2 = range2.substring(element2.getText());
        for (FileReferenceHelper helper : FileReferenceHelperRegistrar.getHelpers()) {
            text2 = helper.trimUrl(text2);
        }
        return new FileReferenceSet(text2, element2, offset, null, true, endingSlashNotAllowed){

            @Override
            protected boolean isUrlEncoded() {
                return urlEncoded;
            }

            @Override
            protected boolean isSoft() {
                return soft;
            }
        };
    }

    public FileReferenceSet(String str, @NotNull PsiElement element2, int startInElement, @Nullable PsiReferenceProvider provider, boolean isCaseSensitive) {
        if (element2 == null) {
            FileReferenceSet.$$$reportNull$$$0(7);
        }
        this(str, element2, startInElement, provider, isCaseSensitive, true);
    }

    public FileReferenceSet(@NotNull String str, @NotNull PsiElement element2, int startInElement, PsiReferenceProvider provider, boolean isCaseSensitive, boolean endingSlashNotAllowed) {
        if (str == null) {
            FileReferenceSet.$$$reportNull$$$0(8);
        }
        if (element2 == null) {
            FileReferenceSet.$$$reportNull$$$0(9);
        }
        this(str, element2, startInElement, provider, isCaseSensitive, endingSlashNotAllowed, null);
    }

    public FileReferenceSet(@NotNull PsiElement element2) {
        if (element2 == null) {
            FileReferenceSet.$$$reportNull$$$0(10);
        }
        this.myElement = element2;
        TextRange range2 = ElementManipulators.getValueTextRange((PsiElement)element2);
        this.myStartInElement = range2.getStartOffset();
        this.myPathStringNonTrimmed = range2.substring(element2.getText());
        this.myPathString = this.myPathStringNonTrimmed.trim();
        this.myEndingSlashNotAllowed = true;
        this.myCaseSensitive = false;
        this.reparse();
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            FileReferenceSet.$$$reportNull$$$0(11);
        }
        return psiElement;
    }

    void setElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            FileReferenceSet.$$$reportNull$$$0(12);
        }
        this.myElement = element2;
    }

    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    public boolean isEndingSlashNotAllowed() {
        return this.myEndingSlashNotAllowed;
    }

    public int getStartInElement() {
        return this.myStartInElement;
    }

    @Nullable
    public FileReference createFileReference(TextRange range2, int index, String text2) {
        return new FileReference(this, range2, index, text2);
    }

    protected void reparse() {
        List<FileReference> referencesList = this.reparse(this.myPathStringNonTrimmed, this.myStartInElement);
        this.myReferences = referencesList.toArray(FileReference.EMPTY);
    }

    protected List<FileReference> reparse(String str, int startInElement) {
        TextRange r;
        FileReference reference2;
        int sepLen;
        int i;
        CharSequence decoded;
        TextRange valueRange;
        LiteralTextEscaper escaper;
        int wsHead = 0;
        int wsTail = 0;
        if (this.myElement instanceof PsiLanguageInjectionHost && !StringUtil.startsWith((CharSequence)this.myElement.getText(), (int)startInElement, (CharSequence)str)) {
            escaper = ((PsiLanguageInjectionHost)this.myElement).createLiteralTextEscaper();
            valueRange = ElementManipulators.getValueTextRange((PsiElement)this.myElement);
            StringBuilder sb = new StringBuilder();
            escaper.decode(valueRange, sb);
            decoded = sb;
            wsHead += Math.max(0, startInElement - valueRange.getStartOffset());
        } else {
            escaper = null;
            decoded = str;
            valueRange = TextRange.from((int)startInElement, (int)decoded.length());
        }
        ArrayList<FileReference> referencesList = new ArrayList<FileReference>();
        for (i = wsHead; i < decoded.length() && Character.isWhitespace(decoded.charAt(i)); ++i) {
            ++wsHead;
        }
        for (i = decoded.length() - 1; i >= 0 && Character.isWhitespace(decoded.charAt(i)); --i) {
            ++wsTail;
        }
        int index = 0;
        int curSep = this.findSeparatorOffset(decoded, wsHead);
        int n = sepLen = curSep >= wsHead ? this.findSeparatorLength(decoded, curSep) : 0;
        if (curSep >= 0 && decoded.length() == wsHead + sepLen + wsTail && (reference2 = this.createFileReference(r = TextRange.create((int)startInElement, (int)(FileReferenceSet.offset(curSep + Math.max(0, sepLen - 1), (LiteralTextEscaper<? extends PsiLanguageInjectionHost>)escaper, valueRange) + 1)), index++, decoded.subSequence(curSep, curSep + sepLen).toString())) != null) {
            referencesList.add(reference2);
        }
        curSep = curSep == wsHead ? curSep + sepLen : wsHead;
        sepLen = 0;
        while (curSep >= 0) {
            FileReference reference3;
            int refEnd;
            int nextSep = this.findSeparatorOffset(decoded, curSep + sepLen);
            int start2 = curSep + sepLen;
            int endTrimmed = nextSep > 0 ? nextSep : Math.max(start2, decoded.length() - wsTail);
            String refText = index == 0 && nextSep < 0 && !StringUtil.contains((CharSequence)decoded, (CharSequence)str) ? str : decoded.subSequence(start2, endTrimmed).toString();
            int refStart = FileReferenceSet.offset(start2, (LiteralTextEscaper<? extends PsiLanguageInjectionHost>)escaper, valueRange);
            if (refStart > (refEnd = FileReferenceSet.offset(endTrimmed, (LiteralTextEscaper<? extends PsiLanguageInjectionHost>)escaper, valueRange)) || refStart < 0) {
                LOG.error("Invalid range: (" + refText + ", " + refEnd + "), escaper=" + escaper + "\ntext=" + refText + ", start=" + startInElement);
            }
            if ((reference3 = this.createFileReference(new TextRange(refStart, refEnd), index++, refText)) != null) {
                referencesList.add(reference3);
            }
            sepLen = (curSep = nextSep) > 0 ? this.findSeparatorLength(decoded, curSep) : 0;
        }
        return referencesList;
    }

    private static int offset(int offset, LiteralTextEscaper<? extends PsiLanguageInjectionHost> escaper, TextRange valueRange) {
        return escaper == null ? offset + valueRange.getStartOffset() : escaper.getOffsetInHost(offset, valueRange);
    }

    public FileReference getReference(int index) {
        return this.myReferences[index];
    }

    public FileReference @NotNull [] getAllReferences() {
        if (this.myReferences == null) {
            FileReferenceSet.$$$reportNull$$$0(13);
        }
        return this.myReferences;
    }

    protected boolean isSoft() {
        return false;
    }

    protected boolean isUrlEncoded() {
        return false;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getDefaultContexts() {
        Collection<PsiFileSystemItem> result2 = this.myDefaultContexts;
        if (result2 == null) {
            this.myDefaultContexts = result2 = this.computeDefaultContexts();
        }
        Collection<PsiFileSystemItem> collection = result2;
        if (collection == null) {
            FileReferenceSet.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        PsiFile file2 = this.getContainingFile();
        if (file2 == null) {
            List<PsiFileSystemItem> list2 = Collections.emptyList();
            if (list2 == null) {
                FileReferenceSet.$$$reportNull$$$0(15);
            }
            return list2;
        }
        Collection<PsiFileSystemItem> contexts = this.getCustomizationContexts(file2);
        if (contexts != null) {
            Collection<PsiFileSystemItem> collection = contexts;
            if (collection == null) {
                FileReferenceSet.$$$reportNull$$$0(16);
            }
            return collection;
        }
        if (this.isAbsolutePathReference()) {
            return FileReferenceSet.getAbsoluteTopLevelDirLocations(file2);
        }
        return this.getContextByFile(file2);
    }

    @Nullable
    protected PsiFile getContainingFile() {
        PsiFile cf = this.myElement.getContainingFile();
        PsiFile file2 = InjectedLanguageManager.getInstance((Project)cf.getProject()).getTopLevelFile((PsiElement)cf);
        if (file2 != null) {
            return file2.getOriginalFile();
        }
        LOG.error("Invalid element: " + this.myElement);
        return null;
    }

    @NotNull
    private Collection<PsiFileSystemItem> getContextByFile(@NotNull PsiFile file2) {
        Collection<PsiFileSystemItem> folders;
        PsiElement context;
        if (file2 == null) {
            FileReferenceSet.$$$reportNull$$$0(17);
        }
        if ((context = file2.getContext()) != null) {
            file2 = context.getContainingFile();
        }
        if ((folders = this.getIncludingFileContexts(file2)) != null) {
            Collection<PsiFileSystemItem> collection = folders;
            if (collection == null) {
                FileReferenceSet.$$$reportNull$$$0(18);
            }
            return collection;
        }
        Collection<PsiFileSystemItem> collection = this.getContextByFileSystemItem((PsiFileSystemItem)file2.getOriginalFile());
        if (collection == null) {
            FileReferenceSet.$$$reportNull$$$0(19);
        }
        return collection;
    }

    @NotNull
    protected Collection<PsiFileSystemItem> getContextByFileSystemItem(@NotNull PsiFileSystemItem file2) {
        VirtualFile virtualFile;
        if (file2 == null) {
            FileReferenceSet.$$$reportNull$$$0(20);
        }
        if ((virtualFile = file2.getVirtualFile()) != null) {
            FileReferenceHelper[] helpers = FileReferenceHelperRegistrar.getHelpers();
            ArrayList<PsiFileSystemItem> list2 = new ArrayList<PsiFileSystemItem>();
            Project project = file2.getProject();
            boolean hasRealContexts = false;
            for (FileReferenceHelper helper : helpers) {
                if (!helper.isMine(project, virtualFile) || !list2.isEmpty() && helper.isFallback()) continue;
                Collection<PsiFileSystemItem> contexts = helper.getContexts(project, virtualFile);
                for (PsiFileSystemItem context : contexts) {
                    list2.add(context);
                    hasRealContexts |= !(context instanceof FileReferenceResolver);
                }
            }
            if (!list2.isEmpty()) {
                if (!hasRealContexts) {
                    list2.addAll(this.getParentDirectoryContext());
                }
                ArrayList<PsiFileSystemItem> arrayList = list2;
                if (arrayList == null) {
                    FileReferenceSet.$$$reportNull$$$0(21);
                }
                return arrayList;
            }
            Collection<PsiFileSystemItem> collection = this.getParentDirectoryContext();
            if (collection == null) {
                FileReferenceSet.$$$reportNull$$$0(22);
            }
            return collection;
        }
        List<PsiFileSystemItem> list3 = Collections.emptyList();
        if (list3 == null) {
            FileReferenceSet.$$$reportNull$$$0(23);
        }
        return list3;
    }

    @Nullable
    private Collection<PsiFileSystemItem> getIncludingFileContexts(@NotNull PsiFile file2) {
        FileContextProvider contextProvider;
        if (file2 == null) {
            FileReferenceSet.$$$reportNull$$$0(24);
        }
        if (this.useIncludingFileAsContext() && (contextProvider = FileContextProvider.getProvider((PsiFile)file2)) != null) {
            Collection folders = contextProvider.getContextFolders(file2);
            if (!folders.isEmpty()) {
                return folders;
            }
            PsiFile contextFile = contextProvider.getContextFile(file2);
            if (contextFile != null && contextFile.getParent() != null) {
                return Collections.singletonList(contextFile.getParent());
            }
        }
        return null;
    }

    @NotNull
    protected Collection<PsiFileSystemItem> getParentDirectoryContext() {
        PsiFile file2 = this.getContainingFile();
        VirtualFile virtualFile = file2 == null ? null : file2.getOriginalFile().getVirtualFile();
        VirtualFile parent = virtualFile == null ? null : virtualFile.getParent();
        PsiDirectory directory = parent == null ? null : file2.getManager().findDirectory(parent);
        Collection<Object> collection = directory != null ? Collections.singleton(directory) : Collections.emptyList();
        if (collection == null) {
            FileReferenceSet.$$$reportNull$$$0(25);
        }
        return collection;
    }

    public Collection<FileTargetContext> getTargetContexts() {
        PsiFile file2 = this.getContainingFile();
        if (file2 == null) {
            return Collections.emptyList();
        }
        Collection<FileTargetContext> customizationContexts = this.getTargetCustomizationContexts(file2);
        Collection<FileTargetContext> targetContexts = customizationContexts != null ? customizationContexts : this.getTargetContextByFile(file2);
        return FileReferenceSet.filterLocalFsContexts(targetContexts);
    }

    private static Collection<FileTargetContext> filterLocalFsContexts(Collection<FileTargetContext> contexts) {
        return ContainerUtil.filter(contexts, c -> {
            VirtualFile file2 = c.getFileSystemItem().getVirtualFile();
            return file2 != null && c.getFileSystemItem().isDirectory() && file2.isInLocalFileSystem();
        });
    }

    @Nullable
    private Collection<PsiFileSystemItem> getCustomizationContexts(PsiFile file2) {
        Collection roots;
        Function<PsiFile, Collection<PsiFileSystemItem>> value2;
        if (this.myOptions != null && (value2 = DEFAULT_PATH_EVALUATOR_OPTION.getValue(this.myOptions)) != null && (roots = (Collection)value2.fun((Object)file2)) != null) {
            for (PsiFileSystemItem root : roots) {
                if (root != null) continue;
                LOG.error("Default path evaluator " + value2 + " produced a null root for " + file2);
            }
            return roots;
        }
        return null;
    }

    @Nullable
    private Collection<FileTargetContext> getTargetCustomizationContexts(@NotNull PsiFile file2) {
        Function<PsiFile, Collection<PsiFileSystemItem>> value2;
        if (file2 == null) {
            FileReferenceSet.$$$reportNull$$$0(26);
        }
        if (this.myOptions != null && (value2 = DEFAULT_PATH_EVALUATOR_OPTION.getValue(this.myOptions)) != null) {
            Collection items;
            Collection<FileTargetContext> roots = value2 instanceof TargetContextEvaluator ? ((TargetContextEvaluator)value2).getTargetContexts(file2) : ((items = (Collection)value2.fun((Object)file2)) != null ? FileTargetContext.toTargetContexts(items) : Collections.emptyList());
            return roots;
        }
        return null;
    }

    @NotNull
    private Collection<FileTargetContext> getTargetContextByFile(@NotNull PsiFile file2) {
        PsiDirectory parent;
        boolean absolutePathReference;
        if (file2 == null) {
            FileReferenceSet.$$$reportNull$$$0(27);
        }
        if (!(absolutePathReference = this.isAbsolutePathReference())) {
            Collection<PsiFileSystemItem> folders;
            PsiElement context = file2.getContext();
            if (context != null) {
                file2 = context.getContainingFile();
            }
            if ((folders = this.getIncludingFileContexts(file2)) != null) {
                Collection<FileTargetContext> collection = FileTargetContext.toTargetContexts(folders);
                if (collection == null) {
                    FileReferenceSet.$$$reportNull$$$0(28);
                }
                return collection;
            }
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((parent = file2.getParent()) == null ? file2 : parent));
        if (absolutePathReference && module == null) {
            List<FileTargetContext> list2 = Collections.emptyList();
            if (list2 == null) {
                FileReferenceSet.$$$reportNull$$$0(29);
            }
            return list2;
        }
        PsiFile originalFile = file2.getOriginalFile();
        VirtualFile virtualFile = originalFile.getVirtualFile();
        if (virtualFile == null) {
            List<FileTargetContext> list3 = Collections.emptyList();
            if (list3 == null) {
                FileReferenceSet.$$$reportNull$$$0(30);
            }
            return list3;
        }
        LinkedHashSet<FileTargetContext> list4 = new LinkedHashSet<FileTargetContext>();
        Project project = originalFile.getProject();
        boolean hasRealContexts = false;
        FileReferenceHelper[] helpers = FileReferenceHelperRegistrar.getHelpers();
        for (FileReferenceHelper helper : helpers) {
            if (!helper.isMine(project, virtualFile) || !list4.isEmpty() && helper.isFallback()) continue;
            Collection<FileTargetContext> contexts = helper.getTargetContexts(project, virtualFile, absolutePathReference);
            for (FileTargetContext context : contexts) {
                list4.add(context);
                hasRealContexts |= !(context.getFileSystemItem() instanceof FileReferenceResolver);
            }
        }
        if (!list4.isEmpty()) {
            if (!hasRealContexts) {
                for (PsiFileSystemItem item : this.getParentDirectoryContext()) {
                    list4.add(new FileTargetContext(item));
                }
            }
            LinkedHashSet<FileTargetContext> linkedHashSet = list4;
            if (linkedHashSet == null) {
                FileReferenceSet.$$$reportNull$$$0(31);
            }
            return linkedHashSet;
        }
        Collection<FileTargetContext> collection = FileTargetContext.toTargetContexts(this.getParentDirectoryContext());
        if (collection == null) {
            FileReferenceSet.$$$reportNull$$$0(32);
        }
        return collection;
    }

    public String getPathString() {
        return this.myPathString;
    }

    public boolean isAbsolutePathReference() {
        return this.myPathString.startsWith(this.getSeparatorString());
    }

    protected boolean useIncludingFileAsContext() {
        return true;
    }

    @Nullable
    public PsiFileSystemItem resolve() {
        FileReference lastReference = this.getLastReference();
        return lastReference == null ? null : lastReference.resolve();
    }

    @Nullable
    public FileReference getLastReference() {
        return this.myReferences == null || this.myReferences.length == 0 ? null : this.myReferences[this.myReferences.length - 1];
    }

    @NotNull
    public static Collection<PsiFileSystemItem> getAbsoluteTopLevelDirLocations(@NotNull PsiFile file2) {
        VirtualFile virtualFile;
        if (file2 == null) {
            FileReferenceSet.$$$reportNull$$$0(33);
        }
        if ((virtualFile = file2.getVirtualFile()) == null) {
            List<PsiFileSystemItem> list2 = Collections.emptyList();
            if (list2 == null) {
                FileReferenceSet.$$$reportNull$$$0(34);
            }
            return list2;
        }
        PsiDirectory parent = file2.getParent();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)(parent == null ? file2 : parent));
        if (module == null) {
            List<PsiFileSystemItem> list3 = Collections.emptyList();
            if (list3 == null) {
                FileReferenceSet.$$$reportNull$$$0(35);
            }
            return list3;
        }
        LinkedHashSet<PsiFileSystemItem> result2 = new LinkedHashSet<PsiFileSystemItem>();
        Project project = file2.getProject();
        for (FileReferenceHelper helper : FileReferenceHelperRegistrar.getHelpers()) {
            if (!helper.isMine(project, virtualFile) || helper.isFallback() && !result2.isEmpty()) continue;
            Collection<PsiFileSystemItem> roots = helper.getRoots(module);
            for (PsiFileSystemItem root : roots) {
                if (root != null) continue;
                LOG.error("Helper " + helper + " produced a null root for " + file2);
            }
            result2.addAll(roots);
        }
        return new ArrayList<PsiFileSystemItem>(result2);
    }

    @NotNull
    private static Collection<FileTargetContext> getTargetAbsoluteTopLevelContexts(@NotNull PsiFile file2) {
        VirtualFile virtualFile;
        if (file2 == null) {
            FileReferenceSet.$$$reportNull$$$0(36);
        }
        if ((virtualFile = file2.getVirtualFile()) == null) {
            List<FileTargetContext> list2 = Collections.emptyList();
            if (list2 == null) {
                FileReferenceSet.$$$reportNull$$$0(37);
            }
            return list2;
        }
        PsiDirectory parent = file2.getParent();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)(parent == null ? file2 : parent));
        if (module == null) {
            List<FileTargetContext> list3 = Collections.emptyList();
            if (list3 == null) {
                FileReferenceSet.$$$reportNull$$$0(38);
            }
            return list3;
        }
        LinkedHashSet<FileTargetContext> result2 = new LinkedHashSet<FileTargetContext>();
        Project project = file2.getProject();
        for (FileReferenceHelper helper : FileReferenceHelperRegistrar.getHelpers()) {
            if (!helper.isMine(project, virtualFile) || helper.isFallback() && !result2.isEmpty()) continue;
            Collection<FileTargetContext> roots = helper.getTargetContexts(project, virtualFile, true);
            result2.addAll(roots);
        }
        return new ArrayList<FileTargetContext>(result2);
    }

    @NotNull
    protected Collection<PsiFileSystemItem> toFileSystemItems(VirtualFile ... files2) {
        Collection<PsiFileSystemItem> collection = this.toFileSystemItems(Arrays.asList(files2));
        if (collection == null) {
            FileReferenceSet.$$$reportNull$$$0(39);
        }
        return collection;
    }

    @NotNull
    protected Collection<PsiFileSystemItem> toFileSystemItems(@NotNull Collection<? extends VirtualFile> files2) {
        if (files2 == null) {
            FileReferenceSet.$$$reportNull$$$0(40);
        }
        PsiManager manager = this.getElement().getManager();
        List list2 = ContainerUtil.mapNotNull(files2, (Function)((NullableFunction)file2 -> file2 != null && file2.isValid() ? manager.findDirectory(file2) : null));
        if (list2 == null) {
            FileReferenceSet.$$$reportNull$$$0(41);
        }
        return list2;
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return Conditions.alwaysTrue();
    }

    public <Option> void addCustomization(CustomizableReferenceProvider.CustomizationKey<Option> key, Option value2) {
        if (this.myOptions == null) {
            this.myOptions = new HashMap<CustomizableReferenceProvider.CustomizationKey, Object>(5);
        }
        this.myOptions.put(key, value2);
    }

    public boolean couldBeConvertedTo(boolean relative) {
        return true;
    }

    public boolean absoluteUrlNeedsStartSlash() {
        return true;
    }

    public FileType @NotNull [] getSuitableFileTypes() {
        FileType[] fileTypeArray = this.mySuitableFileTypes == null ? EMPTY_FILE_TYPES : this.mySuitableFileTypes;
        if (fileTypeArray == null) {
            FileReferenceSet.$$$reportNull$$$0(42);
        }
        return fileTypeArray;
    }

    public boolean isEmptyPathAllowed() {
        return this.myEmptyPathAllowed;
    }

    public void setEmptyPathAllowed(boolean emptyPathAllowed) {
        this.myEmptyPathAllowed = emptyPathAllowed;
    }

    public boolean supportsExtendedCompletion() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet";
                break;
            }
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 27: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllReferences";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultContexts";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultContexts";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextByFile";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextByFileSystemItem";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentDirectoryContext";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetContextByFile";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsoluteTopLevelDirLocations";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetAbsoluteTopLevelContexts";
                break;
            }
            case 39: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "toFileSystemItems";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableFileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findSeparatorLength";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findSeparatorOffset";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createSet";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setElement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getContextByFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getContextByFileSystemItem";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getIncludingFileContexts";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTargetCustomizationContexts";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTargetContextByFile";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getAbsoluteTopLevelDirLocations";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getTargetAbsoluteTopLevelContexts";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "toFileSystemItems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AbsoluteTopLevelEvaluator
    implements Function<PsiFile, Collection<PsiFileSystemItem>>,
    TargetContextEvaluator {
        private AbsoluteTopLevelEvaluator() {
        }

        @Override
        @NotNull
        public Collection<FileTargetContext> getTargetContexts(@NotNull PsiFile file2) {
            if (file2 == null) {
                AbsoluteTopLevelEvaluator.$$$reportNull$$$0(0);
            }
            Collection collection = FileReferenceSet.getTargetAbsoluteTopLevelContexts(file2);
            if (collection == null) {
                AbsoluteTopLevelEvaluator.$$$reportNull$$$0(1);
            }
            return collection;
        }

        public Collection<PsiFileSystemItem> fun(PsiFile file2) {
            return FileReferenceSet.getAbsoluteTopLevelDirLocations(file2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet$AbsoluteTopLevelEvaluator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet$AbsoluteTopLevelEvaluator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetContexts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getTargetContexts";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface TargetContextEvaluator {
        @NotNull
        public Collection<FileTargetContext> getTargetContexts(@NotNull PsiFile var1);
    }
}

