/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.webSocket;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Disposer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientListener;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.ClientManagerKt;
import org.jetbrains.io.jsonRpc.ExceptionHandler;
import org.jetbrains.io.jsonRpc.MessageServer;
import org.jetbrains.io.webSocket.MessageChannelHandler;
import org.jetbrains.io.webSocket.WebSocketClient;

public abstract class WebSocketHandshakeHandler
extends HttpRequestHandler
implements ClientListener,
ExceptionHandler {
    private static final Logger LOG = Logger.getInstance(WebSocketHandshakeHandler.class);
    private final AtomicNotNullLazyValue<ClientManager> clientManager = new AtomicNotNullLazyValue<ClientManager>(){

        @NotNull
        protected ClientManager compute() {
            ClientManager result2 = new ClientManager(WebSocketHandshakeHandler.this, WebSocketHandshakeHandler.this, null);
            Disposable serverDisposable = BuiltInServerManager.getInstance().getServerDisposable();
            assert (serverDisposable != null);
            Disposer.register((Disposable)serverDisposable, (Disposable)result2);
            WebSocketHandshakeHandler.this.serverCreated(result2);
            ClientManager clientManager = result2;
            if (clientManager == null) {
                1.$$$reportNull$$$0(0);
            }
            return clientManager;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/webSocket/WebSocketHandshakeHandler$1", "compute"));
        }
    };

    public boolean isSupported(@NotNull FullHttpRequest request2) {
        if (request2 == null) {
            WebSocketHandshakeHandler.$$$reportNull$$$0(0);
        }
        return request2.method() == HttpMethod.GET && "WebSocket".equalsIgnoreCase(request2.headers().getAsString((CharSequence)HttpHeaderNames.UPGRADE)) && request2.uri().length() > 2;
    }

    protected void serverCreated(@NotNull ClientManager server) {
        if (server == null) {
            WebSocketHandshakeHandler.$$$reportNull$$$0(1);
        }
    }

    @Override
    public void exceptionCaught(@NotNull Throwable e) {
        if (e == null) {
            WebSocketHandshakeHandler.$$$reportNull$$$0(2);
        }
        NettyUtil.log((Throwable)e, (Logger)LOG);
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request2, @NotNull ChannelHandlerContext context) {
        if (urlDecoder == null) {
            WebSocketHandshakeHandler.$$$reportNull$$$0(3);
        }
        if (request2 == null) {
            WebSocketHandshakeHandler.$$$reportNull$$$0(4);
        }
        if (context == null) {
            WebSocketHandshakeHandler.$$$reportNull$$$0(5);
        }
        this.handleWebSocketRequest(context, request2, urlDecoder);
        return true;
    }

    private void handleWebSocketRequest(final @NotNull ChannelHandlerContext context, @NotNull FullHttpRequest request2, final @NotNull QueryStringDecoder uriDecoder) {
        WebSocketServerHandshakerFactory factory;
        WebSocketServerHandshaker handshaker;
        if (context == null) {
            WebSocketHandshakeHandler.$$$reportNull$$$0(6);
        }
        if (request2 == null) {
            WebSocketHandshakeHandler.$$$reportNull$$$0(7);
        }
        if (uriDecoder == null) {
            WebSocketHandshakeHandler.$$$reportNull$$$0(8);
        }
        if ((handshaker = (factory = new WebSocketServerHandshakerFactory("ws://" + request2.headers().getAsString((CharSequence)HttpHeaderNames.HOST) + uriDecoder.path(), null, false, 0x6400000)).newHandshaker((HttpRequest)request2)) == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)context.channel());
            return;
        }
        if (!context.channel().isOpen()) {
            return;
        }
        final WebSocketClient client = new WebSocketClient(context.channel(), handshaker);
        context.channel().attr(ClientManagerKt.getCLIENT()).set((Object)client);
        handshaker.handshake(context.channel(), request2).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future2) {
                if (future2.isSuccess()) {
                    ClientManager clientManager = (ClientManager)WebSocketHandshakeHandler.this.clientManager.getValue();
                    clientManager.addClient(client);
                    MessageChannelHandler messageChannelHandler = new MessageChannelHandler(clientManager, WebSocketHandshakeHandler.this.getMessageServer());
                    BuiltInServer.replaceDefaultHandler((ChannelHandlerContext)context, (ChannelHandler)messageChannelHandler);
                    ChannelHandlerContext messageChannelHandlerContext = context.pipeline().context((ChannelHandler)messageChannelHandler);
                    context.pipeline().addBefore(messageChannelHandlerContext.name(), "webSocketFrameAggregator", (ChannelHandler)new WebSocketFrameAggregator(0x6400000));
                    messageChannelHandlerContext.channel().attr(ClientManagerKt.getCLIENT()).set((Object)client);
                    WebSocketHandshakeHandler.this.connected(client, uriDecoder.parameters());
                }
            }
        });
    }

    @NotNull
    protected abstract MessageServer getMessageServer();

    @Override
    public void connected(@NotNull Client client, @Nullable Map<String, List<String>> parameters) {
        if (client == null) {
            WebSocketHandshakeHandler.$$$reportNull$$$0(9);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlDecoder";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uriDecoder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/io/webSocket/WebSocketHandshakeHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "serverCreated";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "exceptionCaught";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "handleWebSocketRequest";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "connected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

