/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.compress;

import com.intellij.spellchecker.compress.Alphabet;
import com.intellij.spellchecker.compress.Encoder;
import com.intellij.spellchecker.compress.UnitBitSet;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.dictionary.Loader;
import com.intellij.spellchecker.engine.Transformation;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompressedDictionary
implements Dictionary {
    private final Alphabet alphabet;
    private int wordsCount;
    private byte[][] words;
    private int[] lengths;
    private final Encoder encoder;
    private final String name;
    private TIntObjectHashMap<SortedSet<byte[]>> rawData;
    private static final Comparator<byte[]> COMPARATOR = (o1, o2) -> CompressedDictionary.compareArrays(o1, o2);

    private CompressedDictionary(@NotNull Alphabet alphabet, @NotNull Encoder encoder, @NotNull String name) {
        if (alphabet == null) {
            CompressedDictionary.$$$reportNull$$$0(0);
        }
        if (encoder == null) {
            CompressedDictionary.$$$reportNull$$$0(1);
        }
        if (name == null) {
            CompressedDictionary.$$$reportNull$$$0(2);
        }
        this.rawData = new TIntObjectHashMap();
        this.alphabet = alphabet;
        this.encoder = encoder;
        this.name = name;
    }

    private void addToDictionary(byte @NotNull [] word) {
        SortedSet<byte[]> set;
        if (word == null) {
            CompressedDictionary.$$$reportNull$$$0(3);
        }
        if ((set = (SortedSet<byte[]>)this.rawData.get(word.length)) == null) {
            set = CompressedDictionary.createSet();
            this.rawData.put(word.length, set);
        }
        set.add(word);
        ++this.wordsCount;
    }

    private void pack() {
        this.lengths = new int[this.rawData.size()];
        this.words = new byte[this.rawData.size()][];
        this.rawData.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<SortedSet<byte[]>>(){
            int row = 0;

            public boolean execute(int length, SortedSet<byte[]> value) {
                ((CompressedDictionary)CompressedDictionary.this).lengths[this.row] = length;
                ((CompressedDictionary)CompressedDictionary.this).words[this.row] = new byte[value.size() * length];
                int k = 0;
                byte[] wordBytes = CompressedDictionary.this.words[this.row];
                for (byte[] bytes : value) {
                    assert (bytes.length == length);
                    System.arraycopy(bytes, 0, wordBytes, k, bytes.length);
                    k += bytes.length;
                }
                ++this.row;
                return true;
            }
        });
        this.rawData = null;
    }

    @NotNull
    private static SortedSet<byte[]> createSet() {
        return new TreeSet<byte[]>(COMPARATOR);
    }

    public void getWords(char first, int minLength, int maxLength, @NotNull Collection<? super String> result) {
        if (result == null) {
            CompressedDictionary.$$$reportNull$$$0(4);
        }
        this.getWords(first, minLength, maxLength, (Consumer<? super String>)((Consumer)result::add));
    }

    public void getWords(char first, int minLength, int maxLength, @NotNull Consumer<? super String> consumer) {
        int index;
        if (consumer == null) {
            CompressedDictionary.$$$reportNull$$$0(5);
        }
        if ((index = this.alphabet.getIndex(first, false)) == -1) {
            return;
        }
        int i = 0;
        for (byte[] data : this.words) {
            int length = this.lengths[i];
            if (length < minLength || length > maxLength) continue;
            for (int x = 0; x < data.length; x += length) {
                if (this.encoder.getFirstLetterIndex(data[x]) != index) continue;
                String decoded = this.encoder.decode(data, x, x + length);
                consumer.consume((Object)decoded);
            }
            ++i;
        }
    }

    @Override
    public void consumeSuggestions(@NotNull String word, @NotNull Consumer<String> consumer) {
        if (word == null) {
            CompressedDictionary.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            CompressedDictionary.$$$reportNull$$$0(7);
        }
        this.getWords(word.charAt(0), 0, Integer.MAX_VALUE, consumer);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            CompressedDictionary.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @Nullable
    public Boolean contains(@NotNull String word) {
        UnitBitSet bs;
        if (word == null) {
            CompressedDictionary.$$$reportNull$$$0(9);
        }
        if ((bs = this.encoder.encode(word, false)) == Encoder.WORD_OF_ENTIRELY_UNKNOWN_LETTERS) {
            return null;
        }
        if (bs == null) {
            return false;
        }
        byte[] compressed = bs.pack();
        int index = ArrayUtil.indexOf((int[])this.lengths, (int)compressed.length);
        return index != -1 && CompressedDictionary.contains(compressed, this.words[index]);
    }

    @Override
    @NotNull
    public Set<String> getWords() {
        THashSet words = new THashSet();
        for (int i = 0; i <= this.alphabet.getLastIndexUsed(); ++i) {
            char letter = this.alphabet.getLetter(i);
            this.getWords(letter, 0, Integer.MAX_VALUE, (Collection<? super String>)words);
        }
        THashSet tHashSet = words;
        if (tHashSet == null) {
            CompressedDictionary.$$$reportNull$$$0(10);
        }
        return tHashSet;
    }

    public String toString() {
        return "CompressedDictionary{wordsCount=" + this.wordsCount + ", name='" + this.name + '\'' + '}';
    }

    @NotNull
    public static CompressedDictionary create(@NotNull Loader loader, @NotNull Transformation transform) {
        if (loader == null) {
            CompressedDictionary.$$$reportNull$$$0(11);
        }
        if (transform == null) {
            CompressedDictionary.$$$reportNull$$$0(12);
        }
        Alphabet alphabet = new Alphabet();
        Encoder encoder = new Encoder(alphabet);
        CompressedDictionary dictionary = new CompressedDictionary(alphabet, encoder, loader.getName());
        ArrayList bss = new ArrayList();
        loader.load((Consumer<String>)((Consumer)s -> {
            String transformed = transform.transform((String)s);
            if (transformed != null) {
                UnitBitSet bs = encoder.encode(transformed, true);
                if (bs == null) {
                    return;
                }
                bss.add(bs);
            }
        }));
        for (UnitBitSet bs : bss) {
            byte[] compressed = bs.pack();
            dictionary.addToDictionary(compressed);
        }
        dictionary.pack();
        CompressedDictionary compressedDictionary = dictionary;
        if (compressedDictionary == null) {
            CompressedDictionary.$$$reportNull$$$0(13);
        }
        return compressedDictionary;
    }

    public static int compareArrays(byte @NotNull [] array1, byte @NotNull [] array2) {
        if (array1 == null) {
            CompressedDictionary.$$$reportNull$$$0(14);
        }
        if (array2 == null) {
            CompressedDictionary.$$$reportNull$$$0(15);
        }
        return CompressedDictionary.compareArrays(array1, 0, array1.length, array2);
    }

    private static int compareArrays(byte @NotNull [] array1, int start1, int length1, byte @NotNull [] array2) {
        if (array1 == null) {
            CompressedDictionary.$$$reportNull$$$0(16);
        }
        if (array2 == null) {
            CompressedDictionary.$$$reportNull$$$0(17);
        }
        if (length1 != array2.length) {
            return length1 < array2.length ? -1 : 1;
        }
        for (int i = 0; i < length1; ++i) {
            int d = array1[i + start1] - array2[i];
            if (d < 0) {
                return -1;
            }
            if (d <= 0) continue;
            return 1;
        }
        return 0;
    }

    public static boolean contains(byte @NotNull [] goal, byte @NotNull [] data) {
        if (goal == null) {
            CompressedDictionary.$$$reportNull$$$0(18);
        }
        if (data == null) {
            CompressedDictionary.$$$reportNull$$$0(19);
        }
        return CompressedDictionary.binarySearchNew(goal, 0, data.length / goal.length, data) >= 0;
    }

    public static int binarySearchNew(byte @NotNull [] goal, int fromIndex, int toIndex, byte @NotNull [] data) {
        if (goal == null) {
            CompressedDictionary.$$$reportNull$$$0(20);
        }
        if (data == null) {
            CompressedDictionary.$$$reportNull$$$0(21);
        }
        int unitLength = goal.length;
        return ObjectUtils.binarySearch((int)fromIndex, (int)toIndex, mid -> CompressedDictionary.compareArrays(data, mid * unitLength, unitLength, goal));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alphabet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/compress/CompressedDictionary";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array1";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array2";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goal";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/compress/CompressedDictionary";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getWords";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addToDictionary";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getWords";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "consumeSuggestions";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                break;
            }
            case 9: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "compareArrays";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "binarySearchNew";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

