/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serviceContainer;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.StartupAbortedException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionInstantiationException;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.serviceContainer.ComponentManagerImpl;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u001c\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\n\u001a\u0004\u0018\u00010\u000b\"\u0019\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0011"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "createPluginExceptionIfNeeded", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "error", "", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "handleComponentError", "", "t", "componentClassName", "", "intellij.platform.serviceContainer"})
public final class ComponentManagerImplKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    private static final RuntimeException createPluginExceptionIfNeeded(Throwable error, PluginId pluginId) {
        RuntimeException runtimeException;
        Throwable throwable = error;
        if (throwable instanceof PluginException || throwable instanceof ExtensionInstantiationException) {
            Throwable throwable2 = error;
            if (throwable2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.RuntimeException /* = java.lang.RuntimeException */");
            }
            runtimeException = (RuntimeException)throwable2;
        } else {
            runtimeException = (RuntimeException)new PluginException(error, pluginId);
        }
        return runtimeException;
    }

    public static final void handleComponentError(@NotNull Throwable t, @Nullable String componentClassName, @Nullable PluginId pluginId) {
        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
        if (t instanceof StartupAbortedException) {
            throw t;
        }
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isUnitTestMode()) {
            throw t;
        }
        PluginId effectivePluginId = pluginId;
        if ((effectivePluginId == null || Intrinsics.areEqual((Object)PluginManagerCore.CORE_ID, (Object)effectivePluginId)) && componentClassName != null) {
            effectivePluginId = PluginManagerCore.getPluginByClassName((String)componentClassName);
        }
        if ((effectivePluginId == null || Intrinsics.areEqual((Object)PluginManagerCore.CORE_ID, (Object)effectivePluginId)) && t instanceof ExtensionInstantiationException) {
            effectivePluginId = ((ExtensionInstantiationException)t).getExtensionOwnerId();
        }
        if (effectivePluginId != null && Intrinsics.areEqual((Object)PluginManagerCore.CORE_ID, (Object)effectivePluginId) ^ true) {
            throw (Throwable)new StartupAbortedException("Fatal error initializing plugin " + effectivePluginId.getIdString(), (Throwable)new PluginException(t, effectivePluginId));
        }
        throw (Throwable)new StartupAbortedException("Fatal error initializing '" + componentClassName + '\'', t);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ComponentManagerImpl.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ RuntimeException access$createPluginExceptionIfNeeded(Throwable error, PluginId pluginId) {
        return ComponentManagerImplKt.createPluginExceptionIfNeeded(error, pluginId);
    }
}

