/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssPsiColorAdjustmentUtils {
    @Nullable
    public static Color adjustColor(@NotNull Color color, @NotNull CssTerm term) {
        CssFunction function;
        if (color == null) {
            CssPsiColorAdjustmentUtils.$$$reportNull$$$0(0);
        }
        if (term == null) {
            CssPsiColorAdjustmentUtils.$$$reportNull$$$0(1);
        }
        if ((function = (CssFunction)PsiTreeUtil.getChildOfType((PsiElement)term, CssFunction.class)) == null) {
            return null;
        }
        CssTermList termList = function.getValue();
        if (termList == null) {
            return null;
        }
        CssTerm[] terms = termList.getTerms();
        String functionName = function.getName();
        switch (functionName = StringUtil.toLowerCase((String)functionName)) {
            case "red": 
            case "green": 
            case "blue": 
            case "a": 
            case "alpha": {
                return CssPsiColorAdjustmentUtils.adjustRedGreenBlueAlpha(functionName, color, terms);
            }
            case "hue": 
            case "h": {
                return CssPsiColorAdjustmentUtils.adjustHue(color, terms);
            }
            case "saturation": 
            case "s": 
            case "lightness": 
            case "l": {
                return CssPsiColorAdjustmentUtils.adjustSaturationLightness(functionName, color, terms);
            }
            case "whiteness": 
            case "w": 
            case "blackness": 
            case "b": {
                return CssPsiColorAdjustmentUtils.adjustWhitenessBlackness(functionName, color, terms);
            }
            case "tint": 
            case "shade": {
                return CssPsiColorAdjustmentUtils.adjustTintShade(functionName, color, terms);
            }
            case "blend": {
                return CssPsiColorAdjustmentUtils.adjustBlend(color, terms);
            }
        }
        return null;
    }

    @Contract(value="_, _, null -> null")
    @Nullable
    private static Color adjustRedGreenBlueAlpha(@NotNull String functionName, @NotNull Color color, CssTerm @Nullable [] terms) {
        int value;
        if (functionName == null) {
            CssPsiColorAdjustmentUtils.$$$reportNull$$$0(2);
        }
        if (color == null) {
            CssPsiColorAdjustmentUtils.$$$reportNull$$$0(3);
        }
        if (terms == null || terms.length != 1) {
            return null;
        }
        String text = terms[0].getText().trim();
        if (StringUtil.endsWithChar((CharSequence)text, (char)'%')) {
            double percentageValue = CssPsiColorUtil.getPercentageValueWithSign(text);
            if (Double.isNaN(percentageValue)) {
                return null;
            }
            value = (int)Math.round(255.0 * percentageValue);
        } else {
            value = StringUtil.parseInt((String)text, (int)Integer.MIN_VALUE);
            if (value == Integer.MIN_VALUE) {
                return null;
            }
        }
        switch (functionName) {
            case "red": {
                if (StringUtil.startsWithChar((CharSequence)text, (char)'+') || StringUtil.startsWithChar((CharSequence)text, (char)'-')) {
                    value += color.getRed();
                }
                return CssPsiColorUtil.createColor(value, color.getGreen(), color.getBlue(), color.getAlpha());
            }
            case "green": {
                if (StringUtil.startsWithChar((CharSequence)text, (char)'+') || StringUtil.startsWithChar((CharSequence)text, (char)'-')) {
                    value += color.getGreen();
                }
                return CssPsiColorUtil.createColor(color.getRed(), value, color.getBlue(), color.getAlpha());
            }
            case "blue": {
                if (StringUtil.startsWithChar((CharSequence)text, (char)'+') || StringUtil.startsWithChar((CharSequence)text, (char)'-')) {
                    value += color.getBlue();
                }
                return CssPsiColorUtil.createColor(color.getRed(), color.getGreen(), value, color.getAlpha());
            }
            case "a": 
            case "alpha": {
                if (StringUtil.startsWithChar((CharSequence)text, (char)'+') || StringUtil.startsWithChar((CharSequence)text, (char)'-')) {
                    value += color.getAlpha();
                }
                return CssPsiColorUtil.createColor(color.getRed(), color.getGreen(), color.getBlue(), value);
            }
        }
        return null;
    }

    @Contract(value="_, null -> null")
    @Nullable
    private static Color adjustHue(@NotNull Color color, CssTerm @Nullable [] terms) {
        if (color == null) {
            CssPsiColorAdjustmentUtils.$$$reportNull$$$0(4);
        }
        if (terms == null || terms.length != 1) {
            return null;
        }
        String text = terms[0].getText().trim();
        double value = CssPsiColorUtil.getHueValue(text);
        if (value == -1.0) {
            return null;
        }
        double[] hsl = CssPsiColorUtil.getHslByRgb(color.getRed(), color.getGreen(), color.getBlue());
        if (StringUtil.startsWithChar((CharSequence)text, (char)'+') || StringUtil.startsWithChar((CharSequence)text, (char)'-')) {
            value += hsl[0];
            value = 360.0 * value % 360.0 / 360.0;
        }
        double[] rgb = CssPsiColorUtil.getRgbByHsl(value, hsl[1], hsl[2]);
        return CssPsiColorUtil.createColor(rgb[0], rgb[1], rgb[2], color.getAlpha());
    }

    @Contract(value="_, _, null -> null")
    @Nullable
    private static Color adjustSaturationLightness(@NotNull String functionName, @NotNull Color color, CssTerm @Nullable [] terms) {
        if (functionName == null) {
            CssPsiColorAdjustmentUtils.$$$reportNull$$$0(5);
        }
        if (color == null) {
            CssPsiColorAdjustmentUtils.$$$reportNull$$$0(6);
        }
        if (terms == null || terms.length != 1) {
            return null;
        }
        String text = terms[0].getText().trim();
        double value = CssPsiColorUtil.getPercentageValueWithSign(text);
        if (Double.isNaN(value)) {
            return null;
        }
        double[] hsl = CssPsiColorUtil.getHslByRgb(color.getRed(), color.getGreen(), color.getBlue());
        switch (functionName) {
            case "saturation": 
            case "s": {
                if (StringUtil.startsWithChar((CharSequence)text, (char)'+') || StringUtil.startsWithChar((CharSequence)text, (char)'-')) {
                    value = Math.min(Math.max(value + hsl[1], 0.0), 1.0);
                }
                double[] rgb = CssPsiColorUtil.getRgbByHsl(hsl[0], value, hsl[2]);
                return CssPsiColorUtil.createColor(rgb[0], rgb[1], rgb[2], color.getAlpha());
            }
            case "lightness": 
            case "l": {
                if (StringUtil.startsWithChar((CharSequence)text, (char)'+') || StringUtil.startsWithChar((CharSequence)text, (char)'-')) {
                    value = Math.min(Math.max(value + hsl[2], 0.0), 1.0);
                }
                double[] rgb = CssPsiColorUtil.getRgbByHsl(hsl[0], hsl[1], value);
                return CssPsiColorUtil.createColor(rgb[0], rgb[1], rgb[2], color.getAlpha());
            }
        }
        return null;
    }

    @Contract(value="_, _, null -> null")
    @Nullable
    private static Color adjustWhitenessBlackness(@NotNull String functionName, @NotNull Color color, CssTerm @Nullable [] terms) {
        if (functionName == null) {
            CssPsiColorAdjustmentUtils.$$$reportNull$$$0(7);
        }
        if (color == null) {
            CssPsiColorAdjustmentUtils.$$$reportNull$$$0(8);
        }
        if (terms == null || terms.length != 1) {
            return null;
        }
        String text = terms[0].getText().trim();
        double value = CssPsiColorUtil.getPercentageValueWithSign(text);
        if (Double.isNaN(value)) {
            return null;
        }
        double[] hwb = CssPsiColorUtil.getHwbByRgb(color.getRed(), color.getGreen(), color.getBlue());
        switch (functionName) {
            case "whiteness": 
            case "w": {
                if (StringUtil.startsWithChar((CharSequence)text, (char)'+') || StringUtil.startsWithChar((CharSequence)text, (char)'-')) {
                    value = Math.min(Math.max(value + hwb[1], 0.0), 1.0);
                }
                double[] rgb = CssPsiColorUtil.getRgbByHwb(hwb[0], value, hwb[2]);
                return CssPsiColorUtil.createColor(rgb[0], rgb[1], rgb[2], color.getAlpha());
            }
            case "blackness": 
            case "b": {
                if (StringUtil.startsWithChar((CharSequence)text, (char)'+') || StringUtil.startsWithChar((CharSequence)text, (char)'-')) {
                    value = Math.min(Math.max(value + hwb[2], 0.0), 1.0);
                }
                double[] rgb = CssPsiColorUtil.getRgbByHwb(hwb[0], hwb[1], value);
                return CssPsiColorUtil.createColor(rgb[0], rgb[1], rgb[2], color.getAlpha());
            }
        }
        return null;
    }

    @Contract(value="_, _, null -> null")
    @Nullable
    private static Color adjustTintShade(@NotNull String functionName, @NotNull Color color, CssTerm @Nullable [] terms) {
        if (functionName == null) {
            CssPsiColorAdjustmentUtils.$$$reportNull$$$0(9);
        }
        if (color == null) {
            CssPsiColorAdjustmentUtils.$$$reportNull$$$0(10);
        }
        if (terms == null || terms.length != 1) {
            return null;
        }
        if (!functionName.equals("tint") && !functionName.equals("shade")) {
            return null;
        }
        String text = terms[0].getText().trim();
        double value = CssPsiColorUtil.getPercentageValue(text);
        if (value == -1.0) {
            return null;
        }
        return ColorUtil.toAlpha((Color)CssPsiColorAdjustmentUtils.blendColorsInRgb(color, functionName.equals("tint") ? Color.WHITE : Color.BLACK, value), (int)color.getAlpha());
    }

    @Contract(value="_, null -> null")
    @Nullable
    private static Color adjustBlend(@NotNull Color color, CssTerm @Nullable [] terms) {
        if (color == null) {
            CssPsiColorAdjustmentUtils.$$$reportNull$$$0(11);
        }
        if (terms == null || terms.length != 2 && terms.length != 3) {
            return null;
        }
        String text = terms[1].getText().trim();
        double value = CssPsiColorUtil.getPercentageValue(text);
        if (value == -1.0) {
            return null;
        }
        String colorSpace = "rgb";
        if (!(terms.length != 3 || (colorSpace = StringUtil.toLowerCase((String)terms[2].getText())).equals("rgb") || colorSpace.equals("hsl") || colorSpace.equals("hwb"))) {
            return null;
        }
        Color mix = CssPsiColorUtil.getColorInClassicCss((PsiElement)terms[0]);
        if (mix == null) {
            return null;
        }
        switch (colorSpace) {
            case "rgb": {
                return ColorUtil.toAlpha((Color)CssPsiColorAdjustmentUtils.blendColorsInRgb(color, mix, value), (int)color.getAlpha());
            }
            case "hsl": {
                return ColorUtil.toAlpha((Color)CssPsiColorAdjustmentUtils.blendColorsInHsl(color, mix, value), (int)color.getAlpha());
            }
            case "hwb": {
                return ColorUtil.toAlpha((Color)CssPsiColorAdjustmentUtils.blendColorsInHwb(color, mix, value), (int)color.getAlpha());
            }
        }
        return null;
    }

    @NotNull
    private static Color blendColorsInRgb(@NotNull Color base, @NotNull Color mix, double value) {
        if (base == null) {
            CssPsiColorAdjustmentUtils.$$$reportNull$$$0(12);
        }
        if (mix == null) {
            CssPsiColorAdjustmentUtils.$$$reportNull$$$0(13);
        }
        int red = CssPsiColorAdjustmentUtils.blendRgb(base.getRed(), mix.getRed(), value);
        int green = CssPsiColorAdjustmentUtils.blendRgb(base.getGreen(), mix.getGreen(), value);
        int blue = CssPsiColorAdjustmentUtils.blendRgb(base.getBlue(), mix.getBlue(), value);
        Color color = CssPsiColorUtil.createColor(red, green, blue);
        if (color == null) {
            CssPsiColorAdjustmentUtils.$$$reportNull$$$0(14);
        }
        return color;
    }

    @NotNull
    private static Color blendColorsInHsl(@NotNull Color base, @NotNull Color mix, double value) {
        if (base == null) {
            CssPsiColorAdjustmentUtils.$$$reportNull$$$0(15);
        }
        if (mix == null) {
            CssPsiColorAdjustmentUtils.$$$reportNull$$$0(16);
        }
        double[] baseHsl = CssPsiColorUtil.getHslByRgb(base.getRed(), base.getGreen(), base.getBlue());
        double[] mixHsl = CssPsiColorUtil.getHslByRgb(mix.getRed(), mix.getGreen(), mix.getBlue());
        double h = CssPsiColorAdjustmentUtils.blend(baseHsl[0], mixHsl[0], value);
        double s = CssPsiColorAdjustmentUtils.blend(baseHsl[1], mixHsl[1], value);
        double l = CssPsiColorAdjustmentUtils.blend(baseHsl[2], mixHsl[2], value);
        double[] rgb = CssPsiColorUtil.getRgbByHsl(h, s, l);
        Color color = CssPsiColorUtil.createColor(rgb[0], rgb[1], rgb[2]);
        if (color == null) {
            CssPsiColorAdjustmentUtils.$$$reportNull$$$0(17);
        }
        return color;
    }

    @NotNull
    private static Color blendColorsInHwb(@NotNull Color base, @NotNull Color mix, double value) {
        if (base == null) {
            CssPsiColorAdjustmentUtils.$$$reportNull$$$0(18);
        }
        if (mix == null) {
            CssPsiColorAdjustmentUtils.$$$reportNull$$$0(19);
        }
        double[] baseHwb = CssPsiColorUtil.getHwbByRgb(base.getRed(), base.getGreen(), base.getBlue());
        double[] mixHwb = CssPsiColorUtil.getHwbByRgb(mix.getRed(), mix.getGreen(), mix.getBlue());
        double h = CssPsiColorAdjustmentUtils.blend(baseHwb[0], mixHwb[0], value);
        double w = CssPsiColorAdjustmentUtils.blend(baseHwb[1], mixHwb[1], value);
        double b = CssPsiColorAdjustmentUtils.blend(baseHwb[2], mixHwb[2], value);
        double[] rgb = CssPsiColorUtil.getRgbByHwb(h, w, b);
        Color color = CssPsiColorUtil.createColor(rgb[0], rgb[1], rgb[2]);
        if (color == null) {
            CssPsiColorAdjustmentUtils.$$$reportNull$$$0(20);
        }
        return color;
    }

    private static double blend(double base, double mix, double value) {
        return (1.0 - value) * base + value * mix;
    }

    private static int blendRgb(int base, int mix, double value) {
        return (int)Math.round((1.0 - value) * (double)base + value * (double)mix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 17: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 17: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "term";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mix";
                break;
            }
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/CssPsiColorAdjustmentUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/CssPsiColorAdjustmentUtils";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "blendColorsInRgb";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "blendColorsInHsl";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "blendColorsInHwb";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adjustColor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "adjustRedGreenBlueAlpha";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "adjustHue";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "adjustSaturationLightness";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "adjustWhitenessBlackness";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "adjustTintShade";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "adjustBlend";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "blendColorsInRgb";
                break;
            }
            case 14: 
            case 17: 
            case 20: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "blendColorsInHsl";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "blendColorsInHwb";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 17: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

