/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.index;

import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.util.CssHighlighterLexer;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorFactory2;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CssSupportedFileTypesProvider {
    public static final ExtensionPointName<CssSupportedFileTypesProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.css.supportedFileTypesProvider");

    @Nullable
    public static CssSupportedFileTypesProvider findProvider(@NotNull Language language) {
        if (language == null) {
            CssSupportedFileTypesProvider.$$$reportNull$$$0(0);
        }
        return (CssSupportedFileTypesProvider)ContainerUtil.find((Iterable)EP_NAME.getExtensionList(), provider -> provider.getLanguage().equals(language));
    }

    @NotNull
    public abstract LanguageFileType getSupportedFileType();

    @NotNull
    public abstract Language getLanguage();

    @NotNull
    public abstract Lexer getIndexingLexer();

    @NotNull
    public abstract Class<? extends CssCodeStyleSettings> getCustomCodeStyleSettingsClass();

    public static boolean isSupportedFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            CssSupportedFileTypesProvider.$$$reportNull$$$0(1);
        }
        for (CssSupportedFileTypesProvider extension : EP_NAME.getExtensionList()) {
            if (extension.getSupportedFileType() != fileType) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/index/CssSupportedFileTypesProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupportedFileType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Css
    extends CssSupportedFileTypesProvider {
        @Override
        @NotNull
        public LanguageFileType getSupportedFileType() {
            LanguageFileType languageFileType = CssFileType.INSTANCE;
            if (languageFileType == null) {
                Css.$$$reportNull$$$0(0);
            }
            return languageFileType;
        }

        @Override
        @NotNull
        public Language getLanguage() {
            CSSLanguage cSSLanguage = CSSLanguage.INSTANCE;
            if (cSSLanguage == null) {
                Css.$$$reportNull$$$0(1);
            }
            return cSSLanguage;
        }

        @Override
        @NotNull
        public Lexer getIndexingLexer() {
            return new CssHighlighterLexer(CssElementDescriptorFactory2.getInstance().getValueIdentifiers());
        }

        @NotNull
        public Class<CssCodeStyleSettings> getCustomCodeStyleSettingsClass() {
            return CssCodeStyleSettings.class;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/psi/css/index/CssSupportedFileTypesProvider$Css";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSupportedFileType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguage";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

