/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions.createproject;

import com.intellij.DynamicBundle;
import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.createproject.BaseStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.ChooseRemotePathStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.ChooseServerStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.ChooseWebPathStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.CreateProjectModel;
import com.jetbrains.plugins.webDeployment.actions.createproject.FileChooserStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.PublishOptionsStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.SpecifyLocalPathStep;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.WebServerConfigForm;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsDeployable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddServerStep
extends BaseStep {
    public static final Object ID = AddServerStep.class;
    private JTextField myNameField;
    private WebServerConfigForm myConfigForm;
    private JPanel myContentPane;
    private JCheckBox myDontCheckHttpCheckBox;
    private JLabel myMessageLabel;
    private HoverHyperlinkLabel myFixLink;
    private WebServerConfig myItem;

    public AddServerStep(CreateProjectModel model) {
        super(AddServerStep.getTitle(model.scenario), model);
        this.$$$setupUI$$$();
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                AddServerStep.this.myItem.setName(AddServerStep.this.myNameField.getText());
                AddServerStep.this.fireStateChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/webDeployment/actions/createproject/AddServerStep$1", "textChanged"));
            }
        });
        this.myConfigForm.setNewMessageLabel(this.myMessageLabel);
        this.myConfigForm.setNewFixLink(this.myFixLink);
        this.myConfigForm.addListener(new WebServerConfigForm.Listener(){

            @Override
            public void changed(SettingsDeployable effective) {
                AddServerStep.this.fireStateChanged();
            }
        }, (Disposable)this);
        this.myMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
    }

    @Nullable
    private String validate() {
        if (this.myItem == null) {
            return null;
        }
        if (StringUtil.isEmpty((String)this.myItem.getName())) {
            return WDBundle.message("server.name.empty", new Object[0]);
        }
        return this.myConfigForm.getCurrentWarning();
    }

    @NotNull
    public Object getStepId() {
        Object object = ID;
        if (object == null) {
            AddServerStep.$$$reportNull$$$0(0);
        }
        return object;
    }

    public Object getNextStepId() {
        return this.myModel.scenario == CreateProjectModel.Scenario.LocalServer ? ChooseWebPathStep.ID : ChooseRemotePathStep.ID;
    }

    public Object getPreviousStepId() {
        if (!this.myModel.getServersForCurrentScenario().isEmpty()) {
            return ChooseServerStep.ID;
        }
        if (this.myModel.scenario == CreateProjectModel.Scenario.LocalServer) {
            return FileChooserStep.ID_LOCAL_SERVER;
        }
        return this.myModel.isDefaultConfigUsed() ? SpecifyLocalPathStep.ID : PublishOptionsStep.ID;
    }

    public boolean isComplete() {
        if (this.myModel.scenario == CreateProjectModel.Scenario.NoServer) {
            return true;
        }
        return this.validate() == null;
    }

    public void commit(AbstractWizardStepEx.CommitType commitType) throws CommitStepException {
        if (commitType != AbstractWizardStepEx.CommitType.Prev) {
            SettingsDeployable newServer = this.myConfigForm.getCurrentState();
            ChooseServerStep.checkConnection(newServer, this.myContentPane, !this.myDontCheckHttpCheckBox.isSelected());
            newServer.setCredentials(newServer.getCredentials(), newServer.isPassMemoryOnly(), true, false);
            GroupedServersConfigManager.getInstance(null).addServer(newServer.computeWebServerConfig());
            this.myModel.setServer(newServer.computeWebServerConfig());
        }
        this.myItem = null;
    }

    @Override
    public JComponent getInnerComponent() {
        return this.myContentPane;
    }

    private void createUIComponents() {
        this.myFixLink = new HoverHyperlinkLabel(WDBundle.message("revalidate", new Object[0]));
        WebServerConfig server = new WebServerConfig();
        server.initializeNewCreatedServer(true);
        server.getFileTransferConfig().setPort(server.getAccessType().getDefaultPort());
        SettingsDeployable item = SettingsDeployable.create(server, false, null);
        this.myConfigForm = new WebServerConfigForm(item, null);
        this.myFixLink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    AddServerStep.this.fireStateChanged();
                }
            }
        });
    }

    @Override
    public void doInit() {
        this.myItem = new WebServerConfig(WebServerConfig.getNextId());
        this.myItem.initializeNewCreatedServer(true);
        this.myItem.getFileTransferConfig().setPort(this.myItem.getAccessType().getDefaultPort());
        this.myNameField.setText(null);
        this.myConfigForm.updateAccessTypes(this.myModel.scenario.accessTypes);
        this.myConfigForm.setItem(SettingsDeployable.create(this.myItem, false, null));
        String forbiddenChildPath = null;
        if (CreateProjectModel.Scenario.MountedServer == this.myModel.scenario) {
            forbiddenChildPath = this.myModel.localPath;
        }
        this.myConfigForm.setForbiddenChildPath(forbiddenChildPath);
        this.setTitle(AddServerStep.getTitle(this.myModel.scenario));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    private static String getTitle(CreateProjectModel.Scenario scenario) {
        return WDBundle.message(scenario == CreateProjectModel.Scenario.LocalServer ? "create.web.project.add.local.server.step.title" : "create.web.project.add.remote.server.step.title", new Object[0]);
    }

    public String getHelpId() {
        return this.myModel.scenario == CreateProjectModel.Scenario.LocalServer ? "reference.dialogs.new.project.from.existing.files.add.local.server" : "reference.dialogs.new.project.from.existing.files.add.remote.server";
    }

    @Override
    @Nls
    @NotNull
    protected String getSummaryText() {
        String string = WDBundle.message("create.web.project.add.server.step.summary", new Object[0]);
        if (string == null) {
            AddServerStep.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void dispose() {
        this.myConfigForm.disposeUIResources();
        super.dispose();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JCheckBox jCheckBox;
        JTextField jTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel2);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/WDBundle", AddServerStep.class).getString("add.server.step.server.name.label"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        WebServerConfigForm webServerConfigForm = this.myConfigForm;
        JComponent jComponent = webServerConfigForm.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDontCheckHttpCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/WDBundle", AddServerStep.class).getString("do.not.check.http"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myMessageLabel = jLabel = new JLabel();
        jLabel.setText("------");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        HoverHyperlinkLabel hoverHyperlinkLabel = this.myFixLink;
        hoverHyperlinkLabel.setText("-----");
        jPanel3.add((Component)hoverHyperlinkLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 1, null, new Dimension(5, -1), null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/plugins/webDeployment/actions/createproject/AddServerStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSummaryText";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

