/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.DynamicBundle;
import com.intellij.application.Topics;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.credentialStore.PasswordSafeSettings;
import com.intellij.credentialStore.PasswordSafeSettingsListener;
import com.intellij.credentialStore.ProviderType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.AuthType;
import com.intellij.remote.PresentableId;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.ssh.config.unified.SshCredentialsVerifier;
import com.intellij.ssh.interaction.ConnectionOwnerFactory;
import com.intellij.ssh.ui.unified.SshConfigComboBox;
import com.intellij.ssh.ui.unified.SshConfigConfigurable;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.HideableTitledPanel;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.UriUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.SftpUtil;
import com.jetbrains.plugins.webDeployment.statistic.ServerSettingsUsageTriggerCollector;
import com.jetbrains.plugins.webDeployment.ui.AdvancedOptionsForm;
import com.jetbrains.plugins.webDeployment.ui.BrowseMountedFolderActionListener;
import com.jetbrains.plugins.webDeployment.ui.ServerBrowserDialog;
import com.jetbrains.plugins.webDeployment.ui.auth.AuthHelper;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsDeployable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.io.File;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.TimeoutException;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebServerConfigForm
implements UnnamedConfigurable,
Iconable {
    private static final Logger LOG = Logger.getInstance(WebServerConfigForm.class);
    private static final long VALIDATE_TIMEOUT = 200L;
    @NonNls
    private static final String LOCALHOST_URL = "http://localhost";
    private JPanel myContentPane;
    private JTextField myHostField;
    private JTextField myPortField;
    private JTextField myUsernameField;
    private JPasswordField myPasswordField;
    private JCheckBox mySavePasswordCheckBox;
    private MultiLineLabel myMessageLabel;
    private JButton myTestConnectionButton;
    private JCheckBox myAnonymousCheckBox;
    @NonNls
    private TextFieldWithBrowseButton myUrlField;
    private JLabel myPasswordLabel;
    private JComboBox<AccessType> myAccessTypeCombo;
    private JLabel myHostLabel;
    private JLabel myRootFolderLabel;
    private TextFieldWithBrowseButton.NoPathCompletion myRootFolderField;
    private JButton myAutodetectButton;
    private TextFieldWithBrowseButton myMountedFolderField;
    private JLabel myMountedFolderLabel;
    private JLabel myPortLabel;
    private JLabel myUsernameLabel;
    private JLabel myAccessTypeLabel;
    private HoverHyperlinkLabel myFixLink;
    private JLabel myAccessTypeDescriptionLabel;
    private JBCheckBox myProjectLevelCheckBox;
    private JPanel myUploadPanel;
    private AdvancedOptionsForm myAdvancedOptionsForm;
    private HideableTitledPanel myAdvancedSettingsPanel;
    private JPanel mySftpsSpacer;
    private JLabel mySshConfigLabel;
    private SshConfigComboBox mySshConfigComboBox;
    private JPanel mySshPanel;
    private boolean mySlowValidationTimedOut;
    private JLabel myNewMessageLabel;
    private HoverHyperlinkLabel myNewFixLink;
    private SettingsDeployable myItem;
    @Nullable
    private final Project myProject;
    private final EventDispatcher<Listener> myEventDispatcher = EventDispatcher.create(Listener.class);
    private final EventDispatcher<AccessTypeChangeListener> myAccessTypeEventDispatcher = EventDispatcher.create(AccessTypeChangeListener.class);
    private AccessType myPreviousAccessType;
    private String myForbiddenChildPath;
    private String myPreviousHostValue;
    private boolean myMuted;
    private final Disposable myDisposable = Disposer.newDisposable((String)this.getClass().getName());

    public WebServerConfigForm(SettingsDeployable item, @Nullable Project project) {
        LOG.assertTrue(project != null || item == null || !item.isProjectLevel(), (Object)"Project-level server needs project");
        this.myItem = item;
        this.myProject = project;
        this.$$$setupUI$$$();
        this.mySshConfigLabel.setLabelFor((Component)this.mySshConfigComboBox);
        this.mySshConfigComboBox.setDataListener(() -> this.updateUi());
        this.myMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myProjectLevelCheckBox.setVisible(project != null && !project.isDefault() && !this.myItem.isInGroup());
        this.updateAccessTypes(new AccessType[0]);
        this.myAccessTypeCombo.addActionListener(e -> {
            AccessType newAccessType = this.getSelectedAccessType();
            if (newAccessType == this.myPreviousAccessType) {
                return;
            }
            this.updateOnAccessTypeChange();
            this.myPreviousAccessType = newAccessType;
            ((AccessTypeChangeListener)this.myAccessTypeEventDispatcher.getMulticaster()).changed();
        });
        this.myAccessTypeCombo.setRenderer((ListCellRenderer<AccessType>)SimpleListCellRenderer.create((label, value, index) -> {
            if (value != null) {
                label.setText(value.getTitle());
                label.setIcon(value.getIcon());
            }
        }));
        this.myAnonymousCheckBox.addActionListener(e -> this.updateOnAnonymousChange());
        UserActivityWatcher watcher = new UserActivityWatcher();
        watcher.register((Component)this.myContentPane);
        watcher.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                WebServerConfigForm.this.fireChanged();
            }
        });
        this.myTestConnectionButton.addActionListener(e -> {
            String title = WDBundle.message("test.connection", this.getCurrentState().getAccessType().getTitle());
            this.testConnection(title, false, project);
        });
        this.myRootFolderLabel.setLabelFor(this.myRootFolderField.getTextField());
        this.myRootFolderField.addActionListener(e -> {
            WebServerConfig.RemotePath path;
            SettingsDeployable server = this.getCurrentState();
            if (!AuthHelper.ensureAuthSpecified(project, server, false, ConnectionOwnerFactory.createConnectionOwner((Component)this.myContentPane))) {
                return;
            }
            String title = WDBundle.message("choose.root.path", server.getName(), server.getHost());
            WebServerConfig.RemotePath initialPath = new WebServerConfig.RemotePath(this.myRootFolderField.getText());
            @Nullable Project project1 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myRootFolderField));
            ServerBrowserDialog d = project1 != null ? new ServerBrowserDialog(project1, (Deployable)server, title, true, FileTransferConfig.Origin.ForceRoot, initialPath) : new ServerBrowserDialog((Component)this.myRootFolderField, (Deployable)server, title, true, FileTransferConfig.Origin.ForceRoot, initialPath);
            d.show();
            this.updateAuth(server);
            if (d.isOK() && (path = d.getPath()) != null) {
                this.myRootFolderField.setText(path.path);
            }
        });
        this.myAutodetectButton.addActionListener(e -> {
            String homePath = this.testConnection(WDBundle.message("autodetect.root.path", new Object[0]), true, project);
            if (homePath != null) {
                this.myRootFolderField.setText(homePath);
            }
            ServerSettingsUsageTriggerCollector.logAutodetect();
        });
        this.myUrlField.addActionListener(e -> {
            String text = this.myUrlField.getText();
            if (PublishUtils.validateUrl(text) == null) {
                BrowserUtil.browse((String)text);
            }
        });
        this.myUrlField.getButton().setText(WDBundle.message("server.form.browse", new Object[0]));
        this.myMountedFolderField.addBrowseFolderListener((TextBrowseFolderListener)new BrowseMountedFolderActionListener(new FileChooserDescriptor(false, true, false, true, false, false), null){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.onFileChosen(chosenFile);
                WebServerConfigForm.this.mySlowValidationTimedOut = false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm$2", "onFileChosen"));
            }
        });
        this.myHostField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                String url = StringUtil.trimStart((String)StringUtil.notNullize((String)WebServerConfigForm.this.myUrlField.getText()), (String)"http://");
                String newHost = WebServerConfigForm.this.myHostField.getText();
                if (!WebServerConfigForm.this.myMuted && Comparing.equal((String)url, (String)WebServerConfigForm.this.myPreviousHostValue)) {
                    String urlFieldContent = newHost.startsWith("http://") || newHost.startsWith("https://") ? newHost : "http://" + newHost;
                    WebServerConfigForm.this.myUrlField.setText(urlFieldContent);
                }
                WebServerConfigForm.this.myPreviousHostValue = newHost;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm$3", "textChanged"));
            }
        });
        this.getFixLink().addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                        ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                        WebServerConfigForm.this.updateWarning(true);
                    }, WDBundle.message("validating.server", new Object[0]), false, null, (JComponent)WebServerConfigForm.this.myContentPane);
                }
            }
        });
        boolean passwordSafeSaves = WebServerConfigForm.showSaveCheckboxed();
        this.mySavePasswordCheckBox.setVisible(passwordSafeSaves);
        if (!passwordSafeSaves) {
            this.myItem.updateCredentialsFromPasswordSafe();
        }
        this.myProjectLevelCheckBox.addActionListener(event -> ServerSettingsUsageTriggerCollector.logProjectIDELevelCheckBoxClick());
        Topics.subscribe((Topic)PasswordSafeSettings.TOPIC, (Disposable)this.myDisposable, (Object)new PasswordSafeSettingsListener(){

            public void typeChanged(@NotNull ProviderType oldValue, @NotNull ProviderType newValue) {
                if (oldValue == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (newValue == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (oldValue == newValue) {
                    return;
                }
                AccessType type = WebServerConfigForm.this.getSelectedAccessType();
                boolean word = newValue == ProviderType.KEYCHAIN && (type == AccessType.FTP || type == AccessType.FTPS);
                WebServerConfigForm.this.mySavePasswordCheckBox.setVisible(word);
                if (!word) {
                    WebServerConfigForm.this.mySavePasswordCheckBox.setSelected(false);
                }
            }

            public void credentialStoreCleared() {
                WebServerConfigForm.this.myUsernameField.setText(null);
                WebServerConfigForm.this.myPasswordField.setText(null);
                WebServerConfigForm.this.mySavePasswordCheckBox.setSelected(false);
                WebServerConfigForm.this.myItem.updateCredentialsFromPasswordSafe();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "oldValue";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "newValue";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm$5";
                objectArray[2] = "typeChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean showSaveCheckboxed() {
        return !PasswordSafe.getInstance().isMemoryOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAuth(@NotNull SettingsDeployable server) {
        if (server == null) {
            WebServerConfigForm.$$$reportNull$$$0(0);
        }
        if (server.getAccessType() == AccessType.SFTP) {
            return;
        }
        this.myMuted = true;
        try {
            String password;
            Credentials credentials = server.getCredentials();
            String string = password = credentials == null ? null : credentials.getPasswordAsString();
            if (server.getAccessType().isProtocolBased()) {
                this.myPasswordField.setText(password);
            }
            String username = credentials == null ? null : credentials.getUserName();
            this.myUsernameField.setText(username);
        }
        finally {
            this.myMuted = false;
        }
    }

    public void fireChanged() {
        if (!this.myMuted) {
            SettingsDeployable effective = this.updateUi();
            ((Listener)this.myEventDispatcher.getMulticaster()).changed(effective);
        }
    }

    public void updateAccessTypes(AccessType ... accessTypes) {
        EnumComboBoxModel comboModel;
        if (accessTypes.length == 0) {
            comboModel = new EnumComboBoxModel(AccessType.class);
        } else {
            ArrayList<AccessType> list = new ArrayList<AccessType>();
            for (AccessType accessType : AccessType.values()) {
                if (!ArrayUtil.contains((Object)((Object)accessType), (Object[])accessTypes)) continue;
                list.add(accessType);
            }
            comboModel = new CollectionComboBoxModel(list, list.get(0));
        }
        this.myAccessTypeCombo.setVisible(comboModel.getSize() > 1);
        this.myAccessTypeLabel.setVisible(comboModel.getSize() > 1);
        this.myAccessTypeCombo.setModel((ComboBoxModel<AccessType>)comboModel);
        this.updateOnAccessTypeChange();
    }

    public void setItem(SettingsDeployable item) {
        this.myItem = item;
        this.reset();
    }

    @Nullable
    private String testConnection(String title, boolean detectHomePath, Project project) {
        SettingsDeployable serverConfig = this.getCurrentState();
        if (!AuthHelper.ensureAuthSpecified(project, serverConfig, false, ConnectionOwnerFactory.createConnectionOwner((Component)this.myContentPane))) {
            return null;
        }
        try {
            String homePath = PublishUtils.testConnection(serverConfig, this.myContentPane, title, false);
            if (!detectHomePath) {
                Messages.showInfoMessage((Component)this.myContentPane, (String)WDBundle.message("connection.to.successful", serverConfig.getHost()), (String)title);
            }
            if (!serverConfig.isAnonymous()) {
                Credentials credentials = serverConfig.getCredentials();
                String password = credentials == null ? null : credentials.getPasswordAsString();
                boolean isStorePassword = !serverConfig.isPassMemoryOnly();
                this.myUsernameField.setText(credentials == null ? null : credentials.getUserName());
                if (serverConfig.getAccessType() != AccessType.SFTP) {
                    this.myPasswordField.setText(password);
                    this.mySavePasswordCheckBox.setSelected(isStorePassword);
                }
            }
            return homePath;
        }
        catch (FileSystemException e) {
            LOG.warn((Throwable)e);
            Messages.showErrorDialog((Component)this.myContentPane, (String)WDBundle.message("connection.to.failed", serverConfig.getHost(), StringUtil.capitalize((String)PublishUtils.getMessage(e, false))), (String)title);
            return null;
        }
        catch (ProcessCanceledException e) {
            return null;
        }
    }

    @NotNull
    private AccessType getSelectedAccessType() {
        AccessType accessType = (AccessType)((Object)this.myAccessTypeCombo.getSelectedItem());
        if (accessType == null) {
            WebServerConfigForm.$$$reportNull$$$0(1);
        }
        return accessType;
    }

    private void updateOnAnonymousChange() {
        boolean isAnonymous = this.myAnonymousCheckBox.isSelected();
        this.myUsernameField.setEnabled(!isAnonymous);
        this.myPasswordField.setEnabled(!isAnonymous);
        this.mySavePasswordCheckBox.setEnabled(!isAnonymous);
        if (isAnonymous) {
            this.myUsernameField.setText("anonymous");
            this.myPasswordField.setText(null);
            this.mySavePasswordCheckBox.setSelected(false);
        } else {
            this.myUsernameField.setText(null);
        }
    }

    private void updateOnAccessTypeChange() {
        String url;
        boolean ftpSftp;
        AccessType accessType = this.getSelectedAccessType();
        boolean ftpS = accessType == AccessType.FTP || accessType == AccessType.FTPS;
        boolean sftp = accessType == AccessType.SFTP;
        boolean bl = ftpSftp = ftpS || sftp;
        if ((accessType == AccessType.MOUNT || accessType == AccessType.LOCAL) && (StringUtil.isEmptyOrSpaces((String)(url = this.myUrlField.getText())) || "http://".equalsIgnoreCase(url))) {
            this.myUrlField.setText(LOCALHOST_URL);
        }
        this.myUploadPanel.setVisible(ftpSftp || accessType == AccessType.MOUNT);
        this.mySshPanel.setVisible(sftp);
        this.myTestConnectionButton.setVisible(ftpSftp);
        this.myHostLabel.setVisible(ftpS);
        this.myHostField.setVisible(ftpS);
        this.myPortLabel.setVisible(ftpS);
        this.myPortField.setVisible(ftpS);
        this.myRootFolderLabel.setVisible(ftpSftp);
        this.myRootFolderField.setVisible(ftpSftp);
        this.myAutodetectButton.setVisible(ftpSftp);
        this.myUsernameLabel.setVisible(ftpS);
        this.myUsernameField.setVisible(ftpS);
        this.myAnonymousCheckBox.setVisible(ftpS);
        this.myPasswordLabel.setVisible(ftpS);
        this.myPasswordField.setVisible(ftpS);
        this.mySavePasswordCheckBox.setVisible(ftpS && WebServerConfigForm.showSaveCheckboxed());
        this.myAdvancedSettingsPanel.setVisible(ftpSftp);
        this.mySftpsSpacer.setVisible(ftpSftp);
        this.myMountedFolderLabel.setVisible(!ftpSftp);
        this.myMountedFolderField.setVisible(!ftpSftp);
        if (ftpS) {
            this.myPortField.setText(String.valueOf(accessType.getDefaultPort()));
            if (StringUtil.isEmpty((String)this.myRootFolderField.getText()) || this.myPreviousAccessType != null && this.myPreviousAccessType.getDefaultRootFolder().equals(this.myRootFolderField.getText())) {
                this.myRootFolderField.setText(accessType.getDefaultRootFolder());
            }
        }
        if (sftp) {
            this.mySshConfigComboBox.reload();
        } else {
            this.mySshConfigComboBox.select(null);
        }
        this.myAccessTypeDescriptionLabel.setText(accessType.getDescription());
        this.myAdvancedOptionsForm.updateOnAccessTypeChange(accessType);
    }

    public JComponent createComponent() {
        return this.myContentPane;
    }

    public boolean isModified() {
        if (!Comparing.equal((String)this.myItem.getUrl(), (String)this.myUrlField.getText()) || this.myItem.isProjectLevel() != this.myProjectLevelCheckBox.isSelected()) {
            return true;
        }
        if (this.myItem.getAccessType() != this.myAccessTypeCombo.getSelectedItem()) {
            return true;
        }
        if (this.myItem.getAccessType() != AccessType.SFTP) {
            if (!Comparing.strEqual((String)this.myItem.getHost(), (String)this.getHost()) || !Comparing.strEqual((String)this.myItem.getLiteralPort(), (String)this.myPortField.getText()) || this.myItem.isAnonymous() != this.myAnonymousCheckBox.isSelected()) {
                return true;
            }
            if (!(this.myItem.isAnonymous() || this.myItem.getAccessType() != AccessType.FTP && this.myItem.getAccessType() != AccessType.FTPS)) {
                String password;
                String username;
                Credentials credentials = this.myItem.getCredentials();
                if (!Comparing.strEqual((String)(credentials == null ? null : credentials.getUserName()), (String)(username = StringUtil.notNullize((String)this.myUsernameField.getText()).trim()))) {
                    return true;
                }
                if (!Comparing.strEqual((String)(credentials == null ? null : credentials.getPasswordAsString()), (String)(password = new String(this.myPasswordField.getPassword())))) {
                    return true;
                }
                boolean isFormPassSaved = this.mySavePasswordCheckBox.isSelected();
                if (this.myItem.isPassMemoryOnly() == isFormPassSaved) {
                    return true;
                }
            }
        } else if (!Objects.equals(this.myItem.getSshPresentableId(), this.mySshConfigComboBox.getSelectedPresentableId())) {
            return true;
        }
        if (this.myAdvancedOptionsForm.isModified(this.myItem)) {
            return true;
        }
        if (!Comparing.equal((String)StringUtil.notNullize((String)this.myItem.getRootFolder()), (String)this.myRootFolderField.getText())) {
            return true;
        }
        return !Comparing.equal((String)StringUtil.notNullize((String)this.myItem.getMountedFolder()), (String)StringUtil.notNullize((String)this.getMountedFolder()));
    }

    public void apply() {
        this.applyTo(this.myItem, true);
    }

    @Nullable
    private String getHost() {
        String host = this.myHostField.getText();
        if (host != null) {
            host = UriUtil.trimTrailingSlashes((String)host);
        }
        return host;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void applyTo(@NotNull SettingsDeployable serverConfig, boolean isApplyCredentials) {
        if (serverConfig == null) {
            WebServerConfigForm.$$$reportNull$$$0(2);
        }
        serverConfig.setUrl(this.myUrlField.getText());
        if (this.myProjectLevelCheckBox.isVisible()) {
            serverConfig.setIsProjectLevel(this.myProjectLevelCheckBox.isSelected());
        }
        AccessType accessType = this.getSelectedAccessType();
        serverConfig.setAccessType(accessType);
        if (accessType == AccessType.SFTP) {
            @Nullable Pair selected = this.mySshConfigComboBox.getSelectedUiDataAndPresentableId();
            if (selected != null) {
                serverConfig.setSshUiData((PresentableId)selected.getSecond(), (SshUiData)selected.getFirst());
            } else {
                serverConfig.setSshUiData(null, null);
            }
            this.myAdvancedOptionsForm.apply(serverConfig);
            serverConfig.setRootFolder(this.myRootFolderField.getText());
            serverConfig.setMountedFolder(null);
        } else if (accessType.isProtocolBased()) {
            serverConfig.setHost(this.getHost());
            serverConfig.setLiteralPort(this.myPortField.getText());
            if (this.myAnonymousCheckBox.isSelected()) {
                serverConfig.setAnonymous(true);
                serverConfig.setCredentials(null, false, isApplyCredentials, false);
            } else {
                boolean memoryOnly;
                serverConfig.setAnonymous(false);
                char[] password = this.myPasswordField.getPassword();
                boolean bl = memoryOnly = !this.mySavePasswordCheckBox.isSelected();
                if (memoryOnly && password.length == 0) {
                    password = null;
                }
                String userName = StringUtil.nullize((String)this.myUsernameField.getText());
                Credentials credentials = new Credentials(userName, password);
                serverConfig.setCredentials(credentials, memoryOnly, isApplyCredentials, false);
            }
            this.myAdvancedOptionsForm.apply(serverConfig);
            serverConfig.setRootFolder(this.myRootFolderField.getText());
            serverConfig.setMountedFolder(null);
        } else {
            serverConfig.eraseCredentialsFromPasswordSafe();
            serverConfig.setHost(null);
            serverConfig.setPort(0);
            serverConfig.setAnonymous(false);
            serverConfig.setRootFolder(new FileTransferConfig().getRootFolder());
            serverConfig.setAuthType(AuthType.PASSWORD);
            serverConfig.setAdvancedOptions(new AdvancedOptionsConfig());
            if (accessType == AccessType.MOUNT) {
                serverConfig.setMountedFolder(this.getMountedFolder());
            } else {
                serverConfig.setMountedFolder(null);
            }
        }
    }

    public String getMountedFolder() {
        String s = this.myMountedFolderField.getText();
        if (StringUtil.isEmpty((String)s)) {
            return s;
        }
        return new File(s).getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.myMuted = true;
        try {
            this.myAccessTypeCombo.setSelectedItem((Object)this.myItem.getAccessType());
            this.updateOnAccessTypeChange();
            this.myUrlField.setText(this.myItem.getUrl());
            this.myProjectLevelCheckBox.setSelected(this.myItem.isProjectLevel());
            this.myRootFolderField.setText(this.myItem.getRootFolder());
            if (this.myItem.getAccessType() == AccessType.SFTP) {
                this.mySshConfigComboBox.reload(this.myItem.getSshPresentableId(), this.myItem.isProjectLevel() ? SshConfigConfigurable.Visibility.Project : SshConfigConfigurable.Visibility.App);
            }
            if (this.myItem.getSshPresentableId() != null) {
                this.myHostField.setText(null);
                this.myPreviousHostValue = this.myHostField.getText();
                this.myPortField.setText(null);
                this.myAnonymousCheckBox.setSelected(false);
                this.myUsernameField.setText(null);
                this.myPasswordField.setText(null);
                this.mySavePasswordCheckBox.setSelected(false);
            } else {
                this.myHostField.setText(this.myItem.getHost());
                this.myPreviousHostValue = this.myHostField.getText();
                this.myPortField.setText(this.myItem.getLiteralPort());
                this.myAnonymousCheckBox.setSelected(this.myItem.isAnonymous());
                this.updateOnAnonymousChange();
                if (!this.myItem.isAnonymous()) {
                    this.myItem.updateCredentialsFromPasswordSafe();
                    Credentials credentials = this.myItem.getCredentials();
                    String userName = credentials == null ? "" : credentials.getUserName();
                    this.myUsernameField.setText(userName);
                    String password = credentials == null ? "" : credentials.getPasswordAsString();
                    this.myPasswordField.setText(password);
                    boolean isStorePassword = !this.myItem.isPassMemoryOnly();
                    this.mySavePasswordCheckBox.setSelected(isStorePassword);
                }
            }
            this.myAdvancedOptionsForm.reset(this.myItem);
            this.myMountedFolderField.setText(this.myItem.getMountedFolder());
            this.myAdvancedSettingsPanel.setOn(!WebServerConfigForm.isDefaultAdvancedSettings(this.myItem));
            this.mySlowValidationTimedOut = false;
            this.updateUi();
        }
        finally {
            this.myMuted = false;
        }
    }

    private static boolean isDefaultAdvancedSettings(@NotNull SettingsDeployable item) {
        AccessType type;
        if (item == null) {
            WebServerConfigForm.$$$reportNull$$$0(3);
        }
        if ((type = item.getAccessType()) != AccessType.FTP && type != AccessType.FTPS && type != AccessType.SFTP) {
            return true;
        }
        WebServerConfig config = new WebServerConfig();
        config.initializeNewCreatedServer(false);
        if (type == AccessType.FTPS && item.isFtpsExplicit() != config.getFileTransferConfig().isFtpsExplicit()) {
            return false;
        }
        AdvancedOptionsConfig options = item.getAdvancedOptions();
        AdvancedOptionsConfig defaultOptions = config.getFileTransferConfig().getAdvancedOptions();
        if (options.getMaxConnections() != defaultOptions.getMaxConnections()) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)options.getControlEncoding(), (CharSequence)defaultOptions.getControlEncoding())) {
            return false;
        }
        if (options.getKeepAliveTimeout() != defaultOptions.getKeepAliveTimeout()) {
            return false;
        }
        if (type == AccessType.FTP || type == AccessType.FTPS) {
            if (options.isPassiveMode() != defaultOptions.isPassiveMode()) {
                return false;
            }
            if (options.isShowHiddenFiles() != defaultOptions.isShowHiddenFiles()) {
                return false;
            }
            if (options.getAccurateTimestamps() != defaultOptions.getAccurateTimestamps()) {
                return false;
            }
            if (options.isCompatibilityMode() != defaultOptions.isCompatibilityMode()) {
                return false;
            }
            if (options.isForceListCommand() != defaultOptions.isForceListCommand()) {
                return false;
            }
            if (options.getKeepAliveFtpCommand() != options.getKeepAliveFtpCommand()) {
                return false;
            }
        }
        if (type == AccessType.FTPS) {
            if (options.getDataChannelProtectionLevel() != defaultOptions.getDataChannelProtectionLevel()) {
                return false;
            }
            if (options.isShareSslContext() != defaultOptions.isShareSslContext()) {
                return false;
            }
        }
        return type != AccessType.SFTP || options.isMuteSftpMessages() == defaultOptions.isMuteSftpMessages();
    }

    public JComponent getPreferredFocusedComponent() {
        JComponent[] fields;
        for (JComponent field : fields = new JComponent[]{this.myHostField, this.myPortField, this.myRootFolderField, this.myUsernameField, this.myPasswordField, this.myMountedFolderField, this.myUrlField}) {
            String text;
            String string = text = field instanceof TextFieldWithBrowseButton ? ((TextFieldWithBrowseButton)field).getText() : ((JTextField)field).getText();
            if (field == this.myUrlField && "http://".equals(text)) {
                text = null;
            }
            if (!field.isEnabled() || !field.isVisible() || !StringUtil.isEmpty((String)text)) continue;
            return field instanceof TextFieldWithBrowseButton ? ((TextFieldWithBrowseButton)field).getTextField() : field;
        }
        for (JComponent field : fields) {
            if (!field.isVisible()) continue;
            return field;
        }
        return fields[0];
    }

    @NotNull
    private SettingsDeployable updateUi() {
        SettingsDeployable serverConfig = this.updateWarning(false);
        if (serverConfig == null) {
            serverConfig = this.getCurrentState();
        }
        boolean canConnect = serverConfig.validateFastInternal(false) == null;
        this.myTestConnectionButton.setEnabled(canConnect);
        this.myAutodetectButton.setEnabled(canConnect);
        this.myRootFolderField.getButton().setEnabled(canConnect);
        SettingsDeployable settingsDeployable = serverConfig;
        if (settingsDeployable == null) {
            WebServerConfigForm.$$$reportNull$$$0(4);
        }
        return settingsDeployable;
    }

    public void setForbiddenChildPath(String forbiddenChildPath) {
        this.myForbiddenChildPath = forbiddenChildPath;
    }

    @Nullable
    private SettingsDeployable updateWarning(boolean forceSlow) {
        if (!forceSlow && this.mySlowValidationTimedOut) {
            return null;
        }
        String errorMessage = null;
        if (!this.myAnonymousCheckBox.isSelected() && StringUtil.isEmpty((String)this.myUsernameField.getText()) && this.getSelectedAccessType().isProtocolBased() && this.getSelectedAccessType() != AccessType.SFTP) {
            errorMessage = WDBundle.message("username.is.empty", new Object[0]);
        }
        if (errorMessage == null) {
            errorMessage = this.myAdvancedOptionsForm.getErrorMessage();
        }
        SettingsDeployable currentState = null;
        if (errorMessage == null) {
            File path;
            File mountedFolder;
            currentState = this.getCurrentState();
            try {
                errorMessage = currentState.validateSlow(forceSlow ? -1L : 200L);
                this.mySlowValidationTimedOut = false;
            }
            catch (TimeoutException e) {
                errorMessage = WDBundle.message("validation.took.more.than.expected", new Object[0]);
                boolean bl = this.mySlowValidationTimedOut = !forceSlow;
            }
            if (StringUtil.isEmpty((String)errorMessage) && !StringUtil.isEmpty((String)this.myForbiddenChildPath) && VfsUtilCore.isAncestor((File)(mountedFolder = new File(this.getMountedFolder())), (File)(path = new File(this.myForbiddenChildPath)), (boolean)false)) {
                errorMessage = WDBundle.message("path.is.under.mounted.folder", mountedFolder);
            }
            if (StringUtil.isEmpty((String)errorMessage)) {
                try {
                    errorMessage = WebServerConfigForm.getNonBlockingWarnings(currentState, forceSlow ? -1L : 200L);
                }
                catch (TimeoutException e) {
                    errorMessage = WDBundle.message("validation.took.more.than.expected", new Object[0]);
                    this.mySlowValidationTimedOut = !forceSlow;
                }
            }
        }
        String finalErrorMessage = errorMessage;
        Runnable updateRunnable = () -> {
            if (finalErrorMessage != null) {
                this.getMessageLabel().setText(WDBundle.message("server.form.html.0.html", finalErrorMessage));
                this.getMessageLabel().setVisible(true);
                this.getFixLink().setVisible(this.mySlowValidationTimedOut);
            } else {
                this.getMessageLabel().setText(null);
                this.getMessageLabel().setVisible(false);
                this.getFixLink().setVisible(false);
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            updateRunnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(updateRunnable, ModalityState.stateForComponent((Component)this.myContentPane));
        }
        return currentState;
    }

    private static String getNonBlockingWarnings(@NotNull SettingsDeployable currentState, long msTimeout) throws TimeoutException {
        String warning;
        if (currentState == null) {
            WebServerConfigForm.$$$reportNull$$$0(5);
        }
        if ((warning = currentState.getNonBlockingWarnings()) != null) {
            return warning;
        }
        if (currentState.getAccessType() == AccessType.SFTP && !StringUtil.isEmpty((String)currentState.getPrivateKeyFile())) {
            boolean needsKeyPassphrase;
            OneTimeString password;
            Credentials credentials = currentState.getCredentials();
            OneTimeString oneTimeString = password = credentials == null ? null : credentials.getPassword();
            if (StringUtil.isEmpty((CharSequence)password) && (needsKeyPassphrase = ((Boolean)SshCredentialsVerifier.runWithTimeout((long)msTimeout, () -> Ssh.isPassphraseMayBeRequired((String)currentState.getPrivateKeyFile(), (SshBackendLibrary)SftpUtil.getSshBackendLibraryForWebDeployment()))).booleanValue())) {
                return WDBundle.message("server.form.provided.private.key.requires.a.passphrase", new Object[0]);
            }
        }
        return null;
    }

    @Nullable
    public String getCurrentWarning() {
        return this.getMessageLabel().getText();
    }

    public Icon getIcon(int flags) {
        Icon icon = this.getSelectedAccessType().getIcon();
        if (this.getCurrentWarning() != null) {
            icon = new LayeredIcon(new Icon[]{icon, AllIcons.General.WarningDecorator});
        }
        return icon;
    }

    public void addListener(Listener listener, Disposable parentDisposable) {
        this.myEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    @NotNull
    public SettingsDeployable getCurrentState() {
        SettingsDeployable currentState = this.myItem.clone();
        currentState.setAccessType(this.myItem.getAccessType());
        this.applyTo(currentState, false);
        SettingsDeployable settingsDeployable = currentState;
        if (settingsDeployable == null) {
            WebServerConfigForm.$$$reportNull$$$0(6);
        }
        return settingsDeployable;
    }

    private void createUIComponents() {
        this.mySshConfigComboBox = new SshConfigComboBox(this.myProject, this.myDisposable, this.myProject == null || this.myProject.isDefault() ? SshConfigConfigurable.Visibility.App : SshConfigConfigurable.Visibility.Project);
        this.mySshConfigComboBox.reload();
        this.myFixLink = new HoverHyperlinkLabel(WDBundle.message("revalidate", new Object[0]));
        this.myUrlField = new TextFieldWithBrowseButton.NoPathCompletion(){

            @NotNull
            protected Icon getDefaultIcon() {
                Icon icon = AllIcons.Toolwindows.WebToolWindow;
                if (icon == null) {
                    6.$$$reportNull$$$0(0);
                }
                return icon;
            }

            @NotNull
            protected Icon getHoveredIcon() {
                Icon icon = AllIcons.Toolwindows.WebToolWindow;
                if (icon == null) {
                    6.$$$reportNull$$$0(1);
                }
                return icon;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDefaultIcon";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHoveredIcon";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        this.myAccessTypeDescriptionLabel = ComponentPanelBuilder.createCommentComponent((String)"", (boolean)true);
        this.myAdvancedOptionsForm = new AdvancedOptionsForm();
        this.myAdvancedSettingsPanel = new HideableTitledPanel(WDBundle.message("server.form.advanced", new Object[0]), false, this.myAdvancedOptionsForm.getContentPane(), false);
    }

    private JLabel getMessageLabel() {
        return this.myNewMessageLabel == null ? this.myMessageLabel : this.myNewMessageLabel;
    }

    private HoverHyperlinkLabel getFixLink() {
        return this.myNewFixLink == null ? this.myFixLink : this.myNewFixLink;
    }

    public void setNewMessageLabel(@NotNull JLabel messageLabel) {
        if (messageLabel == null) {
            WebServerConfigForm.$$$reportNull$$$0(7);
        }
        this.myNewMessageLabel = messageLabel;
        this.myMessageLabel.setVisible(false);
    }

    public void setNewFixLink(@NotNull HoverHyperlinkLabel fixLink) {
        if (fixLink == null) {
            WebServerConfigForm.$$$reportNull$$$0(8);
        }
        this.myNewFixLink = fixLink;
        this.myFixLink.setVisible(false);
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        MultiLineLabel multiLineLabel;
        JLabel jLabel;
        JPanel jPanel;
        JButton jButton;
        JPanel jPanel2;
        JTextField jTextField;
        JTextField jTextField2;
        JLabel jLabel2;
        JButton jButton2;
        TextFieldWithBrowseButton.NoPathCompletion noPathCompletion;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel3;
        JLabel jLabel4;
        JCheckBox jCheckBox;
        JPasswordField jPasswordField;
        JLabel jLabel5;
        JCheckBox jCheckBox2;
        JTextField jTextField3;
        JLabel jLabel6;
        JLabel jLabel7;
        JPanel jPanel3;
        JLabel jLabel8;
        JBCheckBox jBCheckBox;
        JPanel jPanel4;
        this.createUIComponents();
        this.myContentPane = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(8, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(7, 0, 1, 4, 0, 2, 1, 6, null, null, null));
        this.myProjectLevelCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/WDBundle", WebServerConfigForm.class).getString("visible.only.for.this.project"));
        jPanel4.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myAccessTypeCombo = jComboBox;
        jPanel4.add(jComboBox, new GridConstraints(1, 1, 1, 3, 8, 0, 2, 0, new Dimension(200, -1), null, null));
        this.myAccessTypeLabel = jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, DynamicBundle.getBundle((String)"messages/WDBundle", WebServerConfigForm.class).getString("server.type.label"));
        jPanel4.add((Component)jLabel8, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel9 = this.myAccessTypeDescriptionLabel;
        ((Component)jLabel9).setForeground(SystemColor.textInactiveText);
        jLabel9.setText("---");
        jPanel4.add((Component)jLabel9, new GridConstraints(2, 1, 1, 3, 8, 0, 3, 3, null, null, null, 1));
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, DynamicBundle.getBundle((String)"messages/WDBundle", WebServerConfigForm.class).getString("server.web.path.label"));
        jPanel4.add((Component)jLabel10, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.myUrlField;
        textFieldWithBrowseButton2.setText("");
        jPanel4.add((Component)textFieldWithBrowseButton2, new GridConstraints(4, 1, 1, 3, 0, 1, 7, 0, null, new Dimension(150, -1), null));
        this.myUploadPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(8, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(3, 0, 1, 4, 0, 3, 3, 3, null, null, null, 0, true));
        this.myHostLabel = jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, DynamicBundle.getBundle((String)"messages/WDBundle", WebServerConfigForm.class).getString("server.h_ost"));
        jPanel3.add((Component)jLabel7, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUsernameLabel = jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, DynamicBundle.getBundle((String)"messages/WDBundle", WebServerConfigForm.class).getString("user.name.label"));
        jPanel3.add((Component)jLabel6, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUsernameField = jTextField3 = new JTextField();
        jPanel3.add((Component)jTextField3, new GridConstraints(3, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(200, -1), null));
        this.myAnonymousCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/WDBundle", WebServerConfigForm.class).getString("server.form.anonymous.checkbox"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(3, 2, 1, 1, 8, 0, 3, 0, null, new Dimension(122, 22), null));
        this.myPasswordLabel = jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/WDBundle", WebServerConfigForm.class).getString("password.label"));
        jPanel3.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordField = jPasswordField = new JPasswordField();
        jPanel3.add((Component)jPasswordField, new GridConstraints(4, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(200, 22), null));
        this.mySavePasswordCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/WDBundle", WebServerConfigForm.class).getString("server.save.password"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(4, 2, 1, 2, 8, 0, 3, 0, null, new Dimension(122, 22), null));
        this.myRootFolderLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/WDBundle", WebServerConfigForm.class).getString("server.root.path.label"));
        jPanel3.add((Component)jLabel4, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMountedFolderLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/WDBundle", WebServerConfigForm.class).getString("server.folder.label"));
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMountedFolderField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 3, 0, 1, 7, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(7, 1, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myRootFolderField = noPathCompletion = new TextFieldWithBrowseButton.NoPathCompletion();
        jPanel5.add((Component)noPathCompletion, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myAutodetectButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, DynamicBundle.getBundle((String)"messages/WDBundle", WebServerConfigForm.class).getString("server.autodetect.button"));
        jButton2.setToolTipText(ResourceBundle.getBundle("messages/WDBundle").getString("server.autodetect.button.tooltip"));
        jPanel5.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(2, 1, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myPortLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/WDBundle", WebServerConfigForm.class).getString("server.port.label"));
        jPanel6.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPortField = jTextField2 = new JTextField();
        jTextField2.setText("");
        jPanel6.add((Component)jTextField2, new GridConstraints(0, 3, 1, 1, 8, 0, 2, 0, null, new Dimension(70, 22), null));
        this.myHostField = jTextField = new JTextField();
        jPanel6.add((Component)jTextField, new GridConstraints(0, 0, 1, 2, 0, 1, 7, 0, new Dimension(100, -1), null, null));
        this.mySftpsSpacer = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(6, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(3, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myTestConnectionButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/WDBundle", WebServerConfigForm.class).getString("server.test.connection.button"));
        jPanel3.add((Component)jButton, new GridConstraints(5, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.mySshPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        SshConfigComboBox sshConfigComboBox = this.mySshConfigComboBox;
        jPanel.add((Component)sshConfigComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.mySshConfigLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/WDBundle", WebServerConfigForm.class).getString("server.ssh.config.label"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel7, new GridConstraints(5, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        HoverHyperlinkLabel hoverHyperlinkLabel = this.myFixLink;
        hoverHyperlinkLabel.setText("---");
        hoverHyperlinkLabel.setToolTipText(ResourceBundle.getBundle("messages/WDBundle").getString("server.revalidation.tooltip"));
        jPanel7.add((Component)hoverHyperlinkLabel, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 3, null, null, null));
        this.myMessageLabel = multiLineLabel = new MultiLineLabel();
        multiLineLabel.setText("------");
        jPanel7.add((Component)multiLineLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel7.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        HideableTitledPanel hideableTitledPanel = this.myAdvancedSettingsPanel;
        jPanel4.add((Component)hideableTitledPanel, new GridConstraints(6, 0, 1, 4, 1, 1, 3, 3, null, null, null));
        jLabel8.setLabelFor(jComboBox);
        jLabel10.setLabelFor((Component)textFieldWithBrowseButton2);
        jLabel7.setLabelFor(jTextField);
        jLabel6.setLabelFor(jTextField3);
        jLabel5.setLabelFor(jPasswordField);
        jLabel3.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel2.setLabelFor(jTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverConfig";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentState";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageLabel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixLink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedAccessType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "updateUi";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateAuth";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultAdvancedSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNonBlockingWarnings";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setNewMessageLabel";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setNewFixLink";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface AccessTypeChangeListener
    extends EventListener {
        public void changed();
    }

    public static interface Listener
    extends EventListener {
        public void changed(SettingsDeployable var1);
    }
}

