/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import java.security.SecureRandom;
import org.jetbrains.annotations.NotNull;

public class RandomStringGenerator {
    @NotNull
    private final SecureRandom myRandom;
    @NotNull
    private final String myAlphabet;

    @NotNull
    public static RandomStringGenerator fromDefaultAlphabet() {
        return new RandomStringGenerator("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
    }

    @NotNull
    public static RandomStringGenerator fromUpperCaseShuffledAlphabet() {
        return new RandomStringGenerator("5J0PKMFIOGVCURZDABN3QSTE786194XWLY2H");
    }

    @NotNull
    public static RandomStringGenerator fromLowerCaseAlphabet() {
        return new RandomStringGenerator("0123456789abcdefghijklmnopqrstuvwxyz");
    }

    public RandomStringGenerator(@NotNull String alphabet) {
        if (alphabet == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myRandom = new SecureRandom();
        this.myAlphabet = alphabet;
        this.myRandom.nextInt();
    }

    @NotNull
    public String generateRandomString(int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(this.myAlphabet.charAt(this.myRandom.nextInt(this.myAlphabet.length())));
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }
}

