/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.util.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;

public class RegExpUtil {
    public static boolean CLR = false;
    @NotNull
    public static final String SPECIAL_CHARS = ".[](){}$^+-|!?\\";

    private static String escape(char c) {
        StringBuilder b = new StringBuilder();
        if (SPECIAL_CHARS.indexOf(c) != -1) {
            b.append('\\').append(c);
        } else if (Character.isLetterOrDigit(c)) {
            b.append(c);
        } else {
            b.append("\\u").append(Strings.toHexLowCase(c, 4));
        }
        return b.toString();
    }

    private static boolean onlyUpperCase(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (Character.isLetter(c) && Character.isUpperCase(c) || c == '*' && i == pattern.length() - 1) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String patternToJavaRegExp(@NotNull String pattern, boolean caseSensitive, boolean withCamelHumps) {
        String string;
        if (pattern == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        boolean isCLR = CLR;
        StringBuilder builder = new StringBuilder();
        boolean onlyUpperCase = RegExpUtil.onlyUpperCase(pattern);
        boolean asterisk = false;
        boolean lastIsUpperCase = false;
        int humpCount = 0;
        for (int i = 0; i < pattern.length(); ++i) {
            lastIsUpperCase = false;
            char c = pattern.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                asterisk = false;
                if (caseSensitive) {
                    builder.append(c);
                    continue;
                }
                if (!withCamelHumps) {
                    builder.append('[');
                    char cLo = Character.toLowerCase(c);
                    char cUp = Character.toUpperCase(c);
                    if (cLo != cUp) {
                        builder.append(cLo);
                        builder.append('|');
                        builder.append(cUp);
                    } else {
                        builder.append(c);
                    }
                    builder.append(']');
                    continue;
                }
                if (Character.isUpperCase(c)) {
                    if (!onlyUpperCase) {
                        builder.append('(');
                    }
                    if (i > 0) {
                        if (isCLR) {
                            builder.append("[a-zA-Z0-9\\.\\$_]*");
                        } else {
                            builder.append("[a-zA-Z0-9\\$_]*");
                        }
                    }
                    builder.append(c);
                    if (!onlyUpperCase) {
                        builder.append('|');
                        builder.append(Character.toLowerCase(c));
                        builder.append(')');
                    }
                    lastIsUpperCase = true;
                    if (humpCount++ <= 10) continue;
                    builder.append(".*");
                    string = builder.toString();
                    if (string == null) throw new IllegalStateException("Method must not return null");
                    return string;
                } else {
                    if (Character.isLowerCase(c)) {
                        builder.append('[');
                        builder.append(c);
                        builder.append('|');
                        builder.append(Character.toUpperCase(c));
                        builder.append(']');
                        continue;
                    }
                    builder.append(c);
                    continue;
                }
            }
            if (c == '*') {
                if (asterisk) continue;
                asterisk = true;
                builder.append(".*");
                continue;
            }
            asterisk = false;
            builder.append(RegExpUtil.escape(c));
        }
        if ((pattern.endsWith(" ") || asterisk) && lastIsUpperCase) {
            builder.append("[a-z0-9]*");
        }
        if ((string = builder.toString()) != null) return string;
        throw new IllegalStateException("Method must not return null");
    }

    public static Matcher compileMatcher(@NotNull String rawRegexp) throws PatternSyntaxException {
        if (rawRegexp == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return Pattern.compile(rawRegexp, 32).matcher("");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Matcher compileMatcherForFind(@NotNull String pattern, boolean caseSensitive, boolean withCamelHumps) {
        Matcher matcher;
        if (pattern == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (pattern.startsWith("=")) {
            int flags = (caseSensitive ? 0 : 66) | 0x20;
            matcher = Pattern.compile(pattern.substring(1), flags).matcher("");
            if (matcher == null) throw new IllegalStateException("Method must not return null");
            return matcher;
        }
        matcher = RegExpUtil.compileMatcher(RegExpUtil.patternToJavaRegExp(Strings.trim(pattern, '*'), caseSensitive, withCamelHumps));
        if (matcher != null) return matcher;
        throw new IllegalStateException("Method must not return null");
    }

    @NotNull
    public static Matcher compileDefaultMatcherForFind(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        Matcher matcher = RegExpUtil.compileMatcherForFind(pattern, false, true);
        if (matcher == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return matcher;
    }

    @NotNull
    public static Matcher compileCaseSensitiveMatcher(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        Matcher matcher = RegExpUtil.compileMatcher(RegExpUtil.patternToJavaRegExp(pattern, true, false));
        if (matcher == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return matcher;
    }

    @NotNull
    public static Matcher compileCamelHumpsMatcher(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        Matcher matcher = RegExpUtil.compileMatcher(RegExpUtil.patternToJavaRegExp(pattern, false, true));
        if (matcher == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return matcher;
    }
}

