/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util.http;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Protocol {
    HTTP("http"),
    HTTPS("https"),
    RELATIVE("//");

    @NotNull
    public final String name;

    private Protocol(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.name = name;
    }

    @Nullable
    public static Protocol parse(@NotNull String protocolStr) {
        if (protocolStr == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        for (Protocol p : Protocol.values()) {
            if (!p.name.equals(protocolStr)) continue;
            return p;
        }
        return null;
    }
}

