/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action;

import com.intellij.docker.action.DockerActionUtils;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.view.DockerServiceViewContributor;
import com.intellij.docker.view.details.DockerDetailsTab;
import com.intellij.docker.view.details.EditorTextFieldTab;
import com.intellij.docker.view.details.ITabManager;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.util.ApplicationActionUtils;
import com.intellij.ui.content.Content;
import com.intellij.util.concurrency.EdtExecutorService;
import java.util.concurrent.Executor;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectDockerAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            InspectDockerAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        boolean nodeWithDetails = ApplicationActionUtils.getDeploymentTarget((AnActionEvent)e) instanceof DockerServiceViewContributor.DetailsProvidingNode;
        DockerApplicationRuntime runtime = (DockerApplicationRuntime)((Object)ApplicationActionUtils.getApplicationRuntime((AnActionEvent)e, DockerApplicationRuntime.class));
        if (DockerActionUtils.isImageRuntime(runtime)) {
            presentation.setEnabledAndVisible(nodeWithDetails);
            presentation.setDescription(DockerBundle.messagePointer("InspectDockerAction.description.image", new Object[0]));
        } else if (DockerActionUtils.isContainerRuntime(runtime)) {
            presentation.setEnabledAndVisible(nodeWithDetails);
            presentation.setDescription(DockerBundle.messagePointer("InspectDockerAction.description.container", new Object[0]));
        } else {
            presentation.setEnabledAndVisible(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DockerActionUtils.LoggingActionHelper helper;
        if (e == null) {
            InspectDockerAction.$$$reportNull$$$0(1);
        }
        if ((helper = DockerActionUtils.getLoggingActionHelper(e)) == null) {
            return;
        }
        helper.applicationRuntime.promiseInspectJson().thenApplyAsync(json -> {
            ShowAsJsonConsumer consumer = new ShowAsJsonConsumer(helper.project, helper.node, InspectDockerAction.getTabTitle());
            return consumer.showAsJsonEditor((String)json);
        }, (Executor)EdtExecutorService.getInstance());
    }

    @Nls
    private static String getTabTitle() {
        return DockerBundle.message("InspectDockerAction.tab.title", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/docker/action/InspectDockerAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class ShowAsJsonConsumer {
        private final Project myProject;
        private final DockerServiceViewContributor.DetailsProvidingNode myNode;
        private final String myTabTitle;

        ShowAsJsonConsumer(@NotNull Project project, @NotNull DockerServiceViewContributor.DetailsProvidingNode node, @NotNull String tabTitle) {
            if (project == null) {
                ShowAsJsonConsumer.$$$reportNull$$$0(0);
            }
            if (node == null) {
                ShowAsJsonConsumer.$$$reportNull$$$0(1);
            }
            if (tabTitle == null) {
                ShowAsJsonConsumer.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myNode = node;
            this.myTabTitle = tabTitle;
        }

        @Nullable
        DockerDetailsTab showAsJsonEditor(String preparedText) {
            if (this.myProject.isDisposed()) {
                return null;
            }
            ITabManager tabManager = this.myNode.getDetailsTabs();
            if (tabManager == null) {
                return null;
            }
            EditorTextFieldTab tab = (EditorTextFieldTab)tabManager.findTab((Function1<? super DockerDetailsTab, Boolean>)((Function1)this::isMatchingTab));
            if (tab != null) {
                tab.replaceEditorText(preparedText);
            } else {
                tab = new EditorTextFieldTab(tabManager, this.myTabTitle, ShowAsJsonConsumer.findEditorLanguage(), preparedText);
                tabManager.addTab(tab);
                Content content = tab.createContent();
                tabManager.getContentManager().setSelectedContent(content, true);
            }
            return tab;
        }

        private boolean isMatchingTab(DockerDetailsTab tab) {
            return tab instanceof EditorTextFieldTab && ((EditorTextFieldTab)tab).getTitle().equals(this.myTabTitle);
        }

        @NotNull
        private static Language findEditorLanguage() {
            Language result = Language.findLanguageByID((String)"JSON");
            Object object = result != null ? result : PlainTextLanguage.INSTANCE;
            if (object == null) {
                ShowAsJsonConsumer.$$$reportNull$$$0(3);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tabTitle";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/action/InspectDockerAction$ShowAsJsonConsumer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/action/InspectDockerAction$ShowAsJsonConsumer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findEditorLanguage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

