/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.debug;

import com.intellij.docker.debug.DockerBeforeRunTask;
import com.intellij.docker.debug.DockerBeforeRunTaskLauncherBase;
import com.intellij.docker.debug.DockerBeforeRunTaskUI;
import com.intellij.docker.debug.DockerRunConfigurationUtils;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remoteDebug.RemoteServerRequest;
import com.intellij.docker.remoteDebug.RemoteServerRequestAdapterFactory;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.remoteServer.util.CloudNotifier;
import icons.DockerIcons;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerBeforeRunTaskProvider
extends BeforeRunTaskProvider<DockerBeforeRunTask> {
    static final Key<DockerBeforeRunTask> ID = Key.create((String)DockerBeforeRunTask.class.getName());
    private final CloudNotifier myNotifier;
    private final Project myProject;

    public static DockerBeforeRunTaskProvider getInstance(@NotNull Project project) {
        if (project == null) {
            DockerBeforeRunTaskProvider.$$$reportNull$$$0(0);
        }
        return (DockerBeforeRunTaskProvider)BeforeRunTaskProvider.getProvider((Project)project, ID);
    }

    public DockerBeforeRunTaskProvider(@NotNull Project project) {
        if (project == null) {
            DockerBeforeRunTaskProvider.$$$reportNull$$$0(1);
        }
        this.myNotifier = new CloudNotifier(NotificationGroup.createIdWithTitle((String)"Docker Before Run Task", (String)DockerBundle.message("DockerBeforeRunTaskProvider.notifier", new Object[0])));
        this.myProject = project;
    }

    public Key<DockerBeforeRunTask> getId() {
        return ID;
    }

    public String getName() {
        return DockerBundle.message("DockerBeforeRunTaskProvider.name", new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return DockerIcons.Docker;
    }

    @Nullable
    public Icon getTaskIcon(DockerBeforeRunTask task) {
        return Optional.ofNullable(task).map(DockerBeforeRunTask::getDockerRunConfig).map(DockerRunConfigurationUtils::getRunConfigurationIcon).orElse(null);
    }

    public String getDescription(DockerBeforeRunTask task) {
        String dockerConfigName = Optional.ofNullable(task).map(DockerBeforeRunTask::getDockerRunConfig).map(RunConfigurationBase::getName).orElse(null);
        if (dockerConfigName != null) {
            return DockerBundle.message("DockerBeforeRunTaskProvider.description", dockerConfigName);
        }
        return super.getDescription((BeforeRunTask)task);
    }

    @Nullable
    public DockerBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            DockerBeforeRunTaskProvider.$$$reportNull$$$0(2);
        }
        if (this.myProject.isDefault()) {
            return null;
        }
        RemoteServerRequestAdapterFactory factory = RemoteServerRequestAdapterFactory.findAdapterFactory(runConfiguration);
        if (factory == null) {
            return null;
        }
        RemoteServerRequest adapter = factory.createAdapter();
        if (adapter == null) {
            return null;
        }
        return new DockerBeforeRunTask(this.myProject, adapter);
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull DockerBeforeRunTask task) {
        DockerBeforeRunTask.TargetRunConfig targetRunConfig;
        if (context == null) {
            DockerBeforeRunTaskProvider.$$$reportNull$$$0(3);
        }
        if (configuration == null) {
            DockerBeforeRunTaskProvider.$$$reportNull$$$0(4);
        }
        if (env == null) {
            DockerBeforeRunTaskProvider.$$$reportNull$$$0(5);
        }
        if (task == null) {
            DockerBeforeRunTaskProvider.$$$reportNull$$$0(6);
        }
        if ((targetRunConfig = task.getTargetRunConfig()) == null) {
            return false;
        }
        DockerBeforeRunTaskLauncherBase launcher = targetRunConfig.createLauncher(env, task);
        CompletableFuture<String> promise = new CompletableFuture<String>();
        try {
            launcher.startAsBeforeRunStep(promise);
            String dockerOk = promise.get(2L, TimeUnit.MINUTES);
            return "true".equalsIgnoreCase(dockerOk);
        }
        catch (InterruptedException | TimeoutException e) {
            this.myNotifier.showMessage("Unable to locate started container", MessageType.ERROR);
            return false;
        }
        catch (RuntimeConfigurationException e) {
            this.myNotifier.showMessage("Configuration error: " + e.getMessage(), MessageType.ERROR);
            return false;
        }
        catch (ExecutionException e) {
            this.myNotifier.showMessage("Launch error: " + e.getMessage(), MessageType.ERROR);
            return false;
        }
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean configureTask(@NotNull RunConfiguration configuration, @NotNull DockerBeforeRunTask task) {
        RemoteServerRequestAdapterFactory factory;
        if (configuration == null) {
            DockerBeforeRunTaskProvider.$$$reportNull$$$0(7);
        }
        if (task == null) {
            DockerBeforeRunTaskProvider.$$$reportNull$$$0(8);
        }
        if ((factory = RemoteServerRequestAdapterFactory.findAdapterFactory(configuration)) == null) {
            return false;
        }
        factory.bind(task.getRequest(), configuration);
        DockerBeforeRunTaskUI editor = new DockerBeforeRunTaskUI(configuration.getProject(), factory, task);
        editor.resetFrom();
        JPanel ui = editor.createUI();
        DialogBuilder builder = new DialogBuilder(this.myProject);
        builder.setTitle(DockerBundle.message("DockerBeforeRunTaskProvider.Dialog.title", new Object[0]));
        builder.setDimensionServiceKey("#DockerBeforeRunTaskProvider");
        builder.addOkAction();
        builder.addCancelAction();
        builder.setCenterPanel((JComponent)ui);
        builder.setPreferredFocusComponent((JComponent)ui);
        if (builder.show() == 0) {
            editor.applyTo(task);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/debug/DockerBeforeRunTaskProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createTask";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "executeTask";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "configureTask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

