/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.filter.FilterPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilterModel<Filter> {
    @NotNull
    protected final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final Collection<Runnable> mySetFilterListeners;
    @Nullable
    protected Filter myFilter;

    FilterModel(@NotNull MainVcsLogUiProperties uiProperties) {
        if (uiProperties == null) {
            FilterModel.$$$reportNull$$$0(0);
        }
        this.mySetFilterListeners = new ArrayList<Runnable>();
        this.myUiProperties = uiProperties;
    }

    public void setFilter(@Nullable Filter filter) {
        this.myFilter = filter;
        this.saveFilterToProperties(filter);
        this.notifyFiltersChanged();
    }

    protected void notifyFiltersChanged() {
        for (Runnable listener2 : this.mySetFilterListeners) {
            listener2.run();
        }
    }

    @Nullable
    Filter getFilter() {
        if (this.myFilter == null) {
            this.myFilter = this.getFilterFromProperties();
        }
        return this.myFilter;
    }

    protected abstract void saveFilterToProperties(@Nullable Filter var1);

    @Nullable
    protected abstract Filter getFilterFromProperties();

    void addSetFilterListener(@NotNull Runnable runnable) {
        if (runnable == null) {
            FilterModel.$$$reportNull$$$0(1);
        }
        this.mySetFilterListeners.add(runnable);
    }

    protected static void triggerFilterSet(@NotNull String name) {
        if (name == null) {
            FilterModel.$$$reportNull$$$0(2);
        }
        VcsLogUsageTriggerCollector.triggerUsage(VcsLogUsageTriggerCollector.VcsLogEvent.FILTER_SET, false, data -> data.addData("filter_name", name));
    }

    protected static <FilterObject, F> void triggerFilterSet(@Nullable FilterObject filter, @NotNull Function<FilterObject, F> getter, @NotNull String name) {
        Object newFilter;
        if (getter == null) {
            FilterModel.$$$reportNull$$$0(3);
        }
        if (name == null) {
            FilterModel.$$$reportNull$$$0(4);
        }
        Object v0 = newFilter = filter == null ? null : getter.apply(filter);
        if (newFilter != null) {
            FilterModel.triggerFilterSet(name);
        }
    }

    protected static <FilterObject, F> boolean filterDiffers(@Nullable FilterObject filter, @NotNull Function<FilterObject, F> getter, @Nullable FilterObject currentFilter) {
        if (getter == null) {
            FilterModel.$$$reportNull$$$0(5);
        }
        Object oldFilter = currentFilter == null ? null : getter.apply(currentFilter);
        Object newFilter = filter == null ? null : getter.apply(filter);
        return !ObjectUtils.equals(oldFilter, newFilter);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/ui/filter/FilterModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addSetFilterListener";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerFilterSet";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "filterDiffers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class PairFilterModel<Filter1 extends VcsLogFilter, Filter2 extends VcsLogFilter>
    extends FilterModel<FilterPair<Filter1, Filter2>> {
        @NotNull
        private final VcsLogFilterCollection.FilterKey<? extends Filter1> myFilterKey1;
        @NotNull
        private final VcsLogFilterCollection.FilterKey<? extends Filter2> myFilterKey2;

        PairFilterModel(@NotNull VcsLogFilterCollection.FilterKey<? extends Filter1> filterKey1, @NotNull VcsLogFilterCollection.FilterKey<? extends Filter2> filterKey2, @NotNull MainVcsLogUiProperties uiProperties, @Nullable VcsLogFilterCollection filters) {
            if (filterKey1 == null) {
                PairFilterModel.$$$reportNull$$$0(0);
            }
            if (filterKey2 == null) {
                PairFilterModel.$$$reportNull$$$0(1);
            }
            if (uiProperties == null) {
                PairFilterModel.$$$reportNull$$$0(2);
            }
            super(uiProperties);
            this.myFilterKey1 = filterKey1;
            this.myFilterKey2 = filterKey2;
            if (filters != null) {
                VcsLogFilter filter1 = filters.get(this.myFilterKey1);
                VcsLogFilter filter2 = filters.get(this.myFilterKey2);
                FilterPair<VcsLogFilter, VcsLogFilter> filter = filter1 == null && filter2 == null ? null : new FilterPair<VcsLogFilter, VcsLogFilter>(filter1, filter2);
                this.saveFilterToProperties(filter);
            }
        }

        @Override
        public void setFilter(@Nullable FilterPair<Filter1, Filter2> filter) {
            if (filter != null && filter.isEmpty()) {
                filter = null;
            }
            boolean anyFiltersDiffers = false;
            if (PairFilterModel.filterDiffers(filter, FilterPair::getFilter1, this.myFilter)) {
                PairFilterModel.triggerFilterSet(filter, FilterPair::getFilter1, this.myFilterKey1.getName());
                anyFiltersDiffers = true;
            }
            if (PairFilterModel.filterDiffers(filter, FilterPair::getFilter2, this.myFilter)) {
                PairFilterModel.triggerFilterSet(filter, FilterPair::getFilter2, this.myFilterKey2.getName());
                anyFiltersDiffers = true;
            }
            if (anyFiltersDiffers) {
                super.setFilter(filter);
            }
        }

        public void updateFilterFromProperties() {
            this.setFilter((FilterPair<Filter1, Filter2>)this.getFilterFromProperties());
        }

        @Override
        protected void saveFilterToProperties(@Nullable FilterPair<Filter1, Filter2> filter) {
            if (filter == null || filter.getFilter1() == null) {
                this.myUiProperties.saveFilterValues(this.myFilterKey1.getName(), null);
            } else {
                this.myUiProperties.saveFilterValues(this.myFilterKey1.getName(), this.getFilter1Values(filter.getFilter1()));
            }
            if (filter == null || filter.getFilter2() == null) {
                this.myUiProperties.saveFilterValues(this.myFilterKey2.getName(), null);
            } else {
                this.myUiProperties.saveFilterValues(this.myFilterKey2.getName(), this.getFilter2Values(filter.getFilter2()));
            }
        }

        @Override
        @Nullable
        protected FilterPair<Filter1, Filter2> getFilterFromProperties() {
            List<String> values1 = this.myUiProperties.getFilterValues(this.myFilterKey1.getName());
            Object filter1 = null;
            if (values1 != null) {
                filter1 = this.createFilter1(values1);
            }
            List<String> values2 = this.myUiProperties.getFilterValues(this.myFilterKey2.getName());
            Object filter2 = null;
            if (values2 != null) {
                filter2 = this.createFilter2(values2);
            }
            if (filter1 == null && filter2 == null) {
                return null;
            }
            return new FilterPair<Object, Object>(filter1, filter2);
        }

        @Nullable
        public Filter1 getFilter1() {
            FilterPair filterPair = (FilterPair)this.getFilter();
            if (filterPair == null) {
                return null;
            }
            return (Filter1)filterPair.getFilter1();
        }

        @Nullable
        public Filter2 getFilter2() {
            FilterPair filterPair = (FilterPair)this.getFilter();
            if (filterPair == null) {
                return null;
            }
            return (Filter2)filterPair.getFilter2();
        }

        @NotNull
        protected abstract List<String> getFilter1Values(@NotNull Filter1 var1);

        @NotNull
        protected abstract List<String> getFilter2Values(@NotNull Filter2 var1);

        @Nullable
        protected abstract Filter1 createFilter1(@NotNull List<String> var1);

        @Nullable
        protected abstract Filter2 createFilter2(@NotNull List<String> var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filterKey1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filterKey2";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "uiProperties";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/ui/filter/FilterModel$PairFilterModel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class SingleFilterModel<Filter extends VcsLogFilter>
    extends FilterModel<Filter> {
        @NotNull
        private final VcsLogFilterCollection.FilterKey<? extends Filter> myFilterKey;

        SingleFilterModel(@NotNull VcsLogFilterCollection.FilterKey<? extends Filter> filterKey, @NotNull MainVcsLogUiProperties uiProperties, @Nullable VcsLogFilterCollection filters) {
            if (filterKey == null) {
                SingleFilterModel.$$$reportNull$$$0(0);
            }
            if (uiProperties == null) {
                SingleFilterModel.$$$reportNull$$$0(1);
            }
            super(uiProperties);
            this.myFilterKey = filterKey;
            if (filters != null) {
                this.saveFilterToProperties((Filter)filters.get(this.myFilterKey));
            }
        }

        @Override
        public void setFilter(@Nullable Filter filter) {
            if (ObjectUtils.equals((Object)this.myFilter, filter)) {
                return;
            }
            if (filter != null) {
                SingleFilterModel.triggerFilterSet(this.myFilterKey.getName());
            }
            super.setFilter(filter);
        }

        @Nullable
        protected abstract Filter createFilter(@NotNull List<String> var1);

        @NotNull
        protected abstract List<String> getFilterValues(@NotNull Filter var1);

        @Override
        protected void saveFilterToProperties(@Nullable Filter filter) {
            this.myUiProperties.saveFilterValues(this.myFilterKey.getName(), filter == null ? null : this.getFilterValues(filter));
        }

        @Override
        @Nullable
        protected Filter getFilterFromProperties() {
            List<String> values = this.myUiProperties.getFilterValues(this.myFilterKey.getName());
            if (values != null) {
                return this.createFilter(values);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filterKey";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "uiProperties";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/ui/filter/FilterModel$SingleFilterModel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

