/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@NonNls
public class StopWatch {
    private static final Logger LOG = Logger.getInstance(StopWatch.class);
    private static final String[] UNIT_NAMES = new String[]{"s", "m", "h"};
    private static final long[] UNITS = new long[]{1L, 60L, 3600L};
    private static final String M_SEC_FORMAT = "%03d";
    private final long myStartTime;
    @NotNull
    private final String myOperation;
    @NotNull
    private final Map<VirtualFile, Long> myDurationPerRoot;

    private StopWatch(@NotNull String operation) {
        if (operation == null) {
            StopWatch.$$$reportNull$$$0(0);
        }
        this.myOperation = operation;
        this.myStartTime = System.currentTimeMillis();
        this.myDurationPerRoot = new HashMap<VirtualFile, Long>();
    }

    @NotNull
    public static StopWatch start(@NonNls @NotNull String operation) {
        if (operation == null) {
            StopWatch.$$$reportNull$$$0(1);
        }
        return new StopWatch(operation);
    }

    public void rootCompleted(@NotNull VirtualFile root) {
        if (root == null) {
            StopWatch.$$$reportNull$$$0(2);
        }
        long totalDuration = System.currentTimeMillis() - this.myStartTime;
        long duration = totalDuration - StopWatch.sum(this.myDurationPerRoot.values());
        this.myDurationPerRoot.put(root, duration);
    }

    private static long sum(@NotNull Collection<Long> durations) {
        if (durations == null) {
            StopWatch.$$$reportNull$$$0(3);
        }
        long sum = 0L;
        for (Long duration : durations) {
            sum += duration.longValue();
        }
        return sum;
    }

    public void report() {
        this.report(LOG);
    }

    public void report(@NotNull Logger logger) {
        if (logger == null) {
            StopWatch.$$$reportNull$$$0(4);
        }
        String message = this.myOperation + " took " + StopWatch.formatTime(System.currentTimeMillis() - this.myStartTime);
        if (this.myDurationPerRoot.size() > 1) {
            message = message + "\n" + StringUtil.join(this.myDurationPerRoot.entrySet(), entry -> "    " + ((VirtualFile)entry.getKey()).getName() + ": " + StopWatch.formatTime((Long)entry.getValue()), (String)"\n");
        }
        logger.debug(message);
    }

    @NotNull
    public static String formatTime(long time) {
        if (time < 1000L * UNITS[0]) {
            String string = time + "ms";
            if (string == null) {
                StopWatch.$$$reportNull$$$0(5);
            }
            return string;
        }
        String result2 = "";
        long remainder = time / 1000L;
        long msec = time % 1000L;
        for (int i = UNITS.length - 1; i >= 0; --i) {
            if (remainder < UNITS[i]) continue;
            long quotient = remainder / UNITS[i];
            remainder %= UNITS[i];
            if (i == 0) {
                result2 = result2 + quotient + (msec == 0L ? "" : "." + String.format(M_SEC_FORMAT, msec)) + UNIT_NAMES[i];
                continue;
            }
            result2 = result2 + quotient + UNIT_NAMES[i];
            if (remainder == 0L && msec == 0L) continue;
            result2 = result2 + " ";
            if (remainder != 0L) continue;
            result2 = result2 + "0." + String.format(M_SEC_FORMAT, msec) + UNIT_NAMES[0];
        }
        String string = result2;
        if (string == null) {
            StopWatch.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "durations";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/util/StopWatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/util/StopWatch";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "rootCompleted";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sum";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

