/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.filter;

import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.filter.ClassFilter;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.filter.TextOnlyFilter;

public final class Filters {
    private static final Filter<Content> fcontent = new ClassFilter<Content>(Content.class);
    private static final Filter<Comment> fcomment = new ClassFilter<Comment>(Comment.class);
    private static final Filter<CDATA> fcdata = new ClassFilter<CDATA>(CDATA.class);
    private static final Filter<DocType> fdoctype = new ClassFilter<DocType>(DocType.class);
    private static final Filter<EntityRef> fentityref = new ClassFilter<EntityRef>(EntityRef.class);
    private static final Filter<ProcessingInstruction> fpi = new ClassFilter<ProcessingInstruction>(ProcessingInstruction.class);
    private static final Filter<Text> ftext = new ClassFilter<Text>(Text.class);
    private static final Filter<Text> ftextonly = new TextOnlyFilter();
    private static final Filter<Element> felement = new ClassFilter<Element>(Element.class);

    private Filters() {
    }

    public static final Filter<Content> content() {
        return fcontent;
    }

    public static final Filter<Comment> comment() {
        return fcomment;
    }

    public static final Filter<CDATA> cdata() {
        return fcdata;
    }

    public static final Filter<DocType> doctype() {
        return fdoctype;
    }

    public static final Filter<EntityRef> entityref() {
        return fentityref;
    }

    public static final Filter<Element> element() {
        return felement;
    }

    public static final Filter<Element> element(String name) {
        return new ElementFilter(name, Namespace.NO_NAMESPACE);
    }

    public static final Filter<Element> element(String name, Namespace ns) {
        return new ElementFilter(name, ns);
    }

    public static final Filter<Element> element(Namespace ns) {
        return new ElementFilter(null, ns);
    }

    public static final Filter<ProcessingInstruction> processinginstruction() {
        return fpi;
    }

    public static final Filter<Text> text() {
        return ftext;
    }

    public static final Filter<Text> textOnly() {
        return ftextonly;
    }
}

