/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider;

import java.io.Closeable;
import java.io.IOException;
import java.security.KeyPair;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.userauth.keyprovider.BaseFileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;
import net.schmizz.sshj.userauth.password.PasswordUtils;
import org.bouncycastle.openssl.EncryptionException;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS8KeyFile
extends BaseFileKeyProvider {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected char[] passphrase;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected KeyPair readKeyPair() throws IOException {
        KeyPair kp = null;
        PEMParser r = null;
        while (true) {
            try {
                r = new PEMParser(this.resource.getReader());
                Object o = r.readObject();
                JcaPEMKeyConverter pemConverter = new JcaPEMKeyConverter();
                pemConverter.setProvider(SecurityUtils.getSecurityProvider());
                if (o instanceof PEMEncryptedKeyPair) {
                    PEMEncryptedKeyPair encryptedKeyPair = (PEMEncryptedKeyPair)o;
                    JcePEMDecryptorProviderBuilder decryptorBuilder = new JcePEMDecryptorProviderBuilder();
                    decryptorBuilder.setProvider(SecurityUtils.getSecurityProvider());
                    try {
                        this.passphrase = this.pwdf == null ? null : this.pwdf.reqPassword(this.resource);
                        kp = pemConverter.getKeyPair(encryptedKeyPair.decryptKeyPair(decryptorBuilder.build(this.passphrase)));
                        break;
                    }
                    finally {
                        PasswordUtils.blankOut(this.passphrase);
                    }
                }
                if (o instanceof PEMKeyPair) {
                    kp = pemConverter.getKeyPair((PEMKeyPair)o);
                    break;
                }
                this.log.debug("Expected PEMEncryptedKeyPair or PEMKeyPair, got: {}", o);
            }
            catch (EncryptionException e) {
                block12: {
                    try {
                        if (this.pwdf == null || !this.pwdf.shouldRetry(this.resource)) break block12;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(new Closeable[]{r});
                        throw throwable;
                    }
                    IOUtils.closeQuietly(new Closeable[]{r});
                    continue;
                }
                throw e;
            }
            break;
        }
        IOUtils.closeQuietly(new Closeable[]{r});
        if (kp == null) {
            throw new IOException("Could not read key pair from: " + this.resource);
        }
        return kp;
    }

    public String toString() {
        return "PKCS8KeyFile{resource=" + this.resource + "}";
    }

    public static class Factory
    implements Factory.Named<FileKeyProvider> {
        @Override
        public FileKeyProvider create() {
            return new PKCS8KeyFile();
        }

        @Override
        public String getName() {
            return "PKCS8";
        }
    }
}

