/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.libraries;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PuppetLibraryNamingUtil {
    @NonNls
    private static final String OLD_PUPPET_LIB_NAME = "Puppet modules";
    @NonNls
    private static final String PUPPET_LIB_TAIL = "[puppet module]";

    @NotNull
    public static String getLibraryNameByNameAndVersion(@NotNull String name, @NotNull String version) {
        if (name == null) {
            PuppetLibraryNamingUtil.$$$reportNull$$$0(0);
        }
        if (version == null) {
            PuppetLibraryNamingUtil.$$$reportNull$$$0(1);
        }
        String string = name + "_" + version + " " + PUPPET_LIB_TAIL;
        if (string == null) {
            PuppetLibraryNamingUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static boolean isPuppetLibraryName(@Nullable String libraryName) {
        if (libraryName == null) {
            return false;
        }
        return libraryName.equals(OLD_PUPPET_LIB_NAME) || libraryName.equals(PuppetLibraryNamingUtil.getLibraryNameForStubLib()) || libraryName.matches("^\\S*_\\S* " + Pattern.quote(PUPPET_LIB_TAIL) + "$");
    }

    @NotNull
    public static String getLibraryNameForStubLib() {
        return "stub [puppet module]";
    }

    @NotNull
    static String getModuleFallbackLibraryName(@NotNull String url) {
        if (url == null) {
            PuppetLibraryNamingUtil.$$$reportNull$$$0(3);
        }
        List list = StringUtil.split((String)url, (String)"/");
        String dirName = StringUtil.notNullize((String)((String)ContainerUtil.getLastItem((List)list)), (String)url);
        return PuppetLibraryNamingUtil.getLibraryNameByNameAndVersion(dirName, "nover");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ide/libraries/PuppetLibraryNamingUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ide/libraries/PuppetLibraryNamingUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryNameByNameAndVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryNameByNameAndVersion";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getModuleFallbackLibraryName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

