/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.navigation;

import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.lang.puppet.PuppetTokenTypes;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class PuppetGotoDeclarationHandler
implements GotoDeclarationHandler,
PuppetTokenTypes {
    private static final TokenSet ACCEPTABLE_ELEMENTS = TokenSet.create((IElementType[])new IElementType[]{VARIABLE_NAME, NAME, CAPITALIZED_NAME, SINGLE_QUOTED_STRING});

    public PsiElement @Nullable [] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, Editor editor) {
        if (!ACCEPTABLE_ELEMENTS.contains(PsiUtilCore.getElementType((PsiElement)sourceElement))) {
            return null;
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        assert (sourceElement != null);
        int offsetInElement = offset - sourceElement.getNode().getStartOffset();
        PsiElement referencesProvider = sourceElement.getParent();
        for (PsiReference reference : referencesProvider.getReferences()) {
            if (!reference.getRangeInElement().contains(offsetInElement)) continue;
            if (reference instanceof PsiPolyVariantReference) {
                for (ResolveResult resolveResult : ((PsiPolyVariantReference)reference).multiResolve(false)) {
                    PsiElement targetElement = resolveResult.getElement();
                    if (targetElement == null) continue;
                    result.add(targetElement);
                }
                continue;
            }
            PsiElement targetElement = reference.resolve();
            if (targetElement == null) continue;
            result.add(targetElement);
        }
        return result.toArray(PsiElement.EMPTY_ARRAY);
    }
}

