/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.psi.mixins;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.lang.puppet.PuppetTokenTypes;
import com.intellij.lang.puppet.psi.PsiPuppetExpression;
import com.intellij.lang.puppet.psi.PsiPuppetExpressionAssignment;
import com.intellij.lang.puppet.psi.PuppetCapitalizedNameWrapper;
import com.intellij.lang.puppet.psi.PuppetDataType;
import com.intellij.lang.puppet.psi.PuppetNamedScopeHolder;
import com.intellij.lang.puppet.psi.PuppetPsiFileImpl;
import com.intellij.lang.puppet.psi.PuppetScopeHolder;
import com.intellij.lang.puppet.psi.PuppetTypeDefinition;
import com.intellij.lang.puppet.psi.PuppetVariable;
import com.intellij.lang.puppet.psi.stubs.PuppetStubBasedNamedPsiElementBase;
import com.intellij.lang.puppet.psi.stubs.PuppetVariableStub;
import com.intellij.lang.puppet.util.PuppetQualifiedNamesUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PuppetVariableMixin
extends PuppetStubBasedNamedPsiElementBase<PuppetVariableStub>
implements PuppetVariable {
    private static final TokenSet DECLARATION_CONTAINERS = TokenSet.create((IElementType[])new IElementType[]{EXPRESSION_ASSIGNMENT});

    public PuppetVariableMixin(@NotNull ASTNode node) {
        if (node == null) {
            PuppetVariableMixin.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public PuppetVariableMixin(@NotNull PuppetVariableStub stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            PuppetVariableMixin.$$$reportNull$$$0(1);
        }
        if (nodeType == null) {
            PuppetVariableMixin.$$$reportNull$$$0(2);
        }
        super(stub, nodeType);
    }

    @Override
    @Nullable
    protected String computeName() {
        return this.getNameRange().substring(this.getText());
    }

    @Override
    @Nullable
    public String getFullQualifiedName() {
        return super.getFullQualifiedName();
    }

    @Override
    @Nullable
    protected String computeNamespaceName() {
        String identifierText = this.getNameIdentifierText();
        if (StringUtil.isEmpty((String)identifierText)) {
            return null;
        }
        int lastSeparatorIndex = (identifierText = PuppetQualifiedNamesUtil.getCanonicalVariableFullQualifiedName(identifierText)).lastIndexOf("::");
        if (lastSeparatorIndex != -1) {
            return StringUtil.toLowerCase((String)identifierText.substring(0, lastSeparatorIndex));
        }
        if (!this.isDeclaration()) {
            return null;
        }
        PuppetScopeHolder closestScopeHolder = this.getScopeHolder();
        return closestScopeHolder instanceof PuppetNamedScopeHolder ? ((PuppetNamedScopeHolder)closestScopeHolder).getScopeFullQualifiedName() : null;
    }

    @Override
    @NotNull
    public TextRange getNameRange() {
        PsiElement identifier = this.getNameIdentifier();
        if (identifier == null) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                PuppetVariableMixin.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        String identifierText = identifier.getText();
        int separatorOffset = identifierText.lastIndexOf("::");
        TextRange nameRange = separatorOffset == -1 ? TextRange.allOf((String)identifierText) : TextRange.create((int)(separatorOffset + "::".length()), (int)identifierText.length());
        TextRange textRange = nameRange.shiftRight(identifier.getStartOffsetInParent());
        if (textRange == null) {
            PuppetVariableMixin.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            PuppetVariableMixin.$$$reportNull$$$0(5);
        }
        return ElementManipulators.handleContentChange((PsiElement)this, (String)name);
    }

    @Override
    public boolean isFullQualified() {
        String identifierText = this.getNameIdentifierText();
        return StringUtil.isNotEmpty((String)identifierText) && identifierText.lastIndexOf("::") != -1;
    }

    @Override
    public int getTextOffset() {
        return this.getNameRange().getStartOffset() + this.getTextRange().getStartOffset();
    }

    @Override
    @Nullable
    public PsiElement getNameIdentifier() {
        return this.findChildByType(PuppetTokenTypes.VARIABLE_NAME);
    }

    @Override
    public boolean isDeclaration() {
        PuppetVariableStub stub = (PuppetVariableStub)this.getGreenStub();
        if (stub != null) {
            return stub.isDeclaration();
        }
        if (this.isFullQualified()) {
            return false;
        }
        return DECLARATION_CONTAINERS.contains(PsiUtilCore.getElementType((PsiElement)this.getParent())) && this.getPrevSibling() == null || this.isParameter() || this.isAssignmentExpressionLvalue();
    }

    private boolean isAssignmentExpressionLvalue() {
        PsiPuppetExpressionAssignment assignment = (PsiPuppetExpressionAssignment)PsiTreeUtil.getParentOfType((PsiElement)this, PsiPuppetExpressionAssignment.class);
        if (assignment == null) {
            return false;
        }
        PsiElement rightSide = assignment.getLastChild();
        return rightSide != null && !PsiTreeUtil.isAncestor((PsiElement)rightSide, (PsiElement)this, (boolean)false);
    }

    @Override
    public boolean isParameter() {
        PuppetVariableStub stub = (PuppetVariableStub)this.getGreenStub();
        if (stub != null) {
            return stub.isParameter();
        }
        PsiElement parent = this.getParent();
        IElementType parentType = PsiUtilCore.getElementType((PsiElement)parent);
        if (!PARAMETER.equals(parentType)) {
            return false;
        }
        PsiElement[] children = parent.getChildren();
        return children[0] == this || (children[0] instanceof PuppetDataType || children[0] instanceof PuppetCapitalizedNameWrapper) && children.length > 1 && children[1] == this;
    }

    @Override
    public boolean isMetaparameter() {
        PuppetTypeDefinition resourceDefinition = (PuppetTypeDefinition)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)this, PuppetTypeDefinition.class);
        return resourceDefinition != null && resourceDefinition.isMetaparameterContainingType();
    }

    @Override
    public boolean isCoreFact() {
        return this.isDeclaration() && !this.isParameter() && PuppetPsiFileImpl.isInBuiltInStubsFile(this);
    }

    @Override
    public boolean isBuiltIn() {
        return PuppetPsiFileImpl.isInBuiltinVariablesStubsFile(this);
    }

    @Nullable
    public Icon getIcon(int flags) {
        if (this.isParameter()) {
            return AllIcons.Nodes.Parameter;
        }
        return AllIcons.Nodes.Variable;
    }

    @Override
    public boolean hasReferences() {
        return true;
    }

    @Nullable
    public PsiPuppetExpression getExpression() {
        return null;
    }

    @Override
    public boolean isLexicalDeclaration() {
        PuppetScopeHolder scopeHolder = this.getScopeHolder();
        return !(scopeHolder instanceof PuppetNamedScopeHolder) || ((PuppetNamedScopeHolder)scopeHolder).isLocalScope();
    }

    @Override
    @Nullable
    public PuppetScopeHolder getScopeHolder() {
        return (PuppetScopeHolder)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)this, PuppetScopeHolder.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/psi/mixins/PuppetVariableMixin";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/psi/mixins/PuppetVariableMixin";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

