/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.diff;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.diff.DiffUmlProvider;
import com.intellij.uml.diff.ShowDiffOnUmlAction;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowChangesAction
extends ShowDiffOnUmlAction {
    private String selectedListID;

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowChangesAction.$$$reportNull$$$0(0);
        }
        this.selectedListID = null;
        Project project = e.getProject();
        RelativePoint point = JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext());
        ChangeList[] contextChangeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        List allChangeLists = ChangeListManager.getInstance((Project)project).getChangeLists();
        FeatureUsageTracker.getInstance().triggerFeatureUsed("diagram.show.diff");
        if (contextChangeLists != null && contextChangeLists.length == 1 && contextChangeLists[0] instanceof LocalChangeList) {
            this.run(project, (LocalChangeList)contextChangeLists[0], point);
        } else if (allChangeLists.size() == 1) {
            this.run(project, (LocalChangeList)allChangeLists.get(0), point);
        } else {
            JBList jbList = new JBList((Collection)allChangeLists);
            JBPopupFactory.getInstance().createListPopupBuilder((JList)jbList).setItemChoosenCallback(() -> this.run(project, (LocalChangeList)jbList.getSelectedValue(), point)).setTitle(DiagramBundle.message((String)"popup.title.select.change.list", (Object[])new Object[0])).createPopup().showInBestPositionFor(e.getDataContext());
        }
    }

    private void run(Project project, LocalChangeList changeList, RelativePoint point) {
        this.selectedListID = changeList.getId();
        if (changeList.getChanges().size() <= 50) {
            this.showUnderProgress(DiffUmlProvider.INSTANCE, project, null, Collections.emptyList(), point);
        } else {
            String message = DiagramBundle.message((String)"change.list.contains.too.many.files", (Object[])new Object[]{this.selectedListID, 50});
            DiagramAction.showNotification((String)message, (RelativePoint)point);
        }
    }

    @Override
    protected String getTitle(Project project, Object element, DiagramProvider provider, DiagramState presentation, Collection additionalElements) {
        LocalChangeList list = this.getChangeList(project);
        return list == null ? "Changes" : "Changes for '" + list.getName() + "'";
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        boolean isFileContextMenu;
        Project project;
        boolean enabled;
        if (e == null) {
            ShowChangesAction.$$$reportNull$$$0(1);
        }
        boolean visible = enabled = (project = e.getProject()) != null && ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss();
        boolean bl = isFileContextMenu = ActionPlaces.isPopupPlace((String)e.getPlace()) && !"ChangesViewPopup".equals(e.getPlace());
        if (visible && isFileContextMenu) {
            Object[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
            visible = files != null && ContainerUtil.exists((Object[])files, file -> {
                FileStatus status = ChangeListManager.getInstance((Project)project).getStatus(file);
                return status == FileStatus.ADDED || status == FileStatus.MODIFIED;
            });
        }
        e.getPresentation().setEnabled(enabled && !DumbService.isDumb((Project)project));
        e.getPresentation().setVisible(visible);
    }

    @Nullable
    protected LocalChangeList getChangeList(Project project) {
        if (ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss().length > 0 && this.selectedListID != null) {
            return ChangeListManager.getInstance((Project)project).getChangeList(this.selectedListID);
        }
        return null;
    }

    @Override
    protected VirtualFile getVirtualFile(Project project, DiagramProvider provider) {
        String url = "uml://" + provider.getID() + "/" + "$SHOW_CHANGES$";
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(url);
        LocalChangeList list = this.getChangeList(project);
        if (list != null && virtualFile instanceof UmlVirtualFileSystem.UmlVirtualFile) {
            UmlVirtualFileSystem.UmlVirtualFile file = (UmlVirtualFileSystem.UmlVirtualFile)virtualFile;
            String text = "Changes for '" + list.getName() + "'";
            file.setPresentableName(text);
            file.putUserData(DiffUmlProvider.CHANGE_LIST, list);
            UmlVirtualFileSystem.setInitialized(file);
            return file;
        }
        return super.getVirtualFile(project, provider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/uml/diff/ShowChangesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

