/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.profilers.YourKitProfilerHandler;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class CaptureCPUUsageDataAction
extends ToggleAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(CaptureCPUUsageDataAction.class);

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            CaptureCPUUsageDataAction.$$$reportNull$$$0(0);
        }
        return YourKitProfilerHandler.isCPUProfiling();
    }

    public void setSelected(@NotNull AnActionEvent event, boolean state) {
        if (event == null) {
            CaptureCPUUsageDataAction.$$$reportNull$$$0(1);
        }
        if (!YourKitProfilerHandler.isCPUProfiling()) {
            boolean success;
            boolean tracing;
            boolean bl = tracing = event != null && (event.getModifiers() & 1) != 0;
            if (!(YourKitProfilerHandler.hasValidController() && YourKitProfilerHandler.isProfilerInVMFileEnabled() || (success = CaptureCPUUsageDataAction.enableProfiler(tracing)))) {
                return;
            }
            YourKitProfilerHandler.startCPUProfiling(tracing);
        } else {
            new Task.Backgroundable(CaptureCPUUsageDataAction.getEventProject((AnActionEvent)event), PerformanceTestingBundle.message("profiling.compress.snapshot.progress", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        String dumpPath = YourKitProfilerHandler.captureCPUSnapshot();
                        YourKitProfilerHandler.copySnapshotAndNotify(dumpPath, this.getProject(), false);
                    }
                    catch (ProcessCanceledException dumpPath) {
                    }
                    catch (Exception ex) {
                        YourKitProfilerHandler.notifyCapturingError(ex, this.getProject());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/performancePlugin/actions/CaptureCPUUsageDataAction$1", "run"));
                }
            }.queue();
        }
    }

    private static boolean enableProfiler(boolean tracing) {
        int enableViaVMOptions;
        String message = "";
        if (YourKitProfilerHandler.canProfilerBeAttached() && !tracing) {
            try {
                YourKitProfilerHandler.attachProfilerAgent();
                return true;
            }
            catch (Exception dynamicAttachmentException) {
                message = dynamicAttachmentException.getMessage() + "\n";
            }
        }
        if (tracing) {
            message = "Tracing can only be done with persistent profiler\n";
        }
        if ((enableViaVMOptions = Messages.showOkCancelDialog((String)PerformanceTestingBundle.message("dialog.message.0.profiler.will.be.enabled.after.restart", message), (String)PerformanceTestingBundle.message("change.vm.options.to.enable.profiler", new Object[0]), (String)PerformanceTestingBundle.message("button.text.change.and.restart", new Object[0]), (String)PerformanceTestingBundle.message("button.text.cancel", new Object[0]), (Icon)Messages.getWarningIcon())) == 0) {
            try {
                YourKitProfilerHandler.enablePersistentProfiler();
                ApplicationManager.getApplication().restart();
            }
            catch (IOException vmOptionsException) {
                Messages.showErrorDialog((String)vmOptionsException.getMessage(), (String)PerformanceTestingBundle.message("dialog.title.profiler.can.t.be.enabled", new Object[0]));
                LOG.error((Throwable)vmOptionsException);
            }
        }
        return false;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CaptureCPUUsageDataAction.$$$reportNull$$$0(2);
        }
        Presentation presentation = e.getPresentation();
        boolean profiling = YourKitProfilerHandler.isCPUProfiling();
        presentation.setText(PerformanceTestingBundle.messagePointer(profiling ? "stop.capture.cpu.usage.data.action.name" : "action.CaptureCPUUsageData.text", new Object[0]));
        if (!profiling) {
            presentation.setDescription(PerformanceTestingBundle.messagePointer("action.CaptureCPUUsageData.description.ext", new Object[0]));
        }
        super.update(e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/performancePlugin/actions/CaptureCPUUsageDataAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelected";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

