/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.profilers;

import com.intellij.diagnostic.VMOptions;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.MemoryDumpHelper;
import com.intellij.util.SystemProperties;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.Timer;
import com.jetbrains.performancePlugin.commands.Waiter;
import com.jetbrains.performancePlugin.profilers.Profiler;
import com.jetbrains.performancePlugin.profilers.ProfilersController;
import com.sun.jna.Platform;
import com.sun.tools.attach.VirtualMachine;
import com.yourkit.api.Controller;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YourKitProfilerHandler
implements Profiler {
    private static final String STARTUP_PROFILING_OPTIONS = "sampling";
    public static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.performancePlugin.profilers.YourKitProfilerHandler");
    private static final NotificationGroup GROUP = new NotificationGroup("Profiling", NotificationDisplayType.BALLOON, false);
    private static YourKitProfilerHandler instance;
    private static Controller ourController;
    private static boolean ourCPUProfiling;
    private final ProfilersController myProfilersController = ProfilersController.getInstance();

    private YourKitProfilerHandler() {
    }

    public static synchronized YourKitProfilerHandler getInstance() {
        if (instance == null) {
            instance = new YourKitProfilerHandler();
        }
        return instance;
    }

    @Override
    public void startProfiling(@NotNull String activityName, @NotNull List<String> options) {
        if (activityName == null) {
            YourKitProfilerHandler.$$$reportNull$$$0(0);
        }
        if (options == null) {
            YourKitProfilerHandler.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            try {
                if (!YourKitProfilerHandler.hasValidController()) {
                    YourKitProfilerHandler.attachProfilerAgent();
                    Waiter.checkCondition(() -> YourKitProfilerHandler.hasValidController()).await();
                }
                YourKitProfilerHandler.startCPUProfiling();
                Timer.instance.start(activityName);
                this.myProfilersController.setCurrentProfiler(this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    @NotNull
    public String stopProfiling(@NotNull List<String> options) {
        if (options == null) {
            YourKitProfilerHandler.$$$reportNull$$$0(2);
        }
        this.myProfilersController.setCurrentProfiler(this);
        Timer timer = Timer.instance;
        if (timer.isStarted()) {
            timer.stop();
            timer.reportToTeamCity();
        }
        this.myProfilersController.setReportsPath(YourKitProfilerHandler.captureCPUSnapshot());
        return this.myProfilersController.getReportsPath() != null ? this.myProfilersController.getReportsPath() : "";
    }

    @Override
    public File compressResults(@NotNull String pathToResult, @NotNull String archiveName) throws IOException {
        if (pathToResult == null) {
            YourKitProfilerHandler.$$$reportNull$$$0(3);
        }
        if (archiveName == null) {
            YourKitProfilerHandler.$$$reportNull$$$0(4);
        }
        return YourKitProfilerHandler.compressSnapshot(pathToResult, archiveName);
    }

    private static String getAgentFullLibraryName() {
        if (!Platform.isIntel()) {
            throw new RuntimeException("YK profiling can't be enabled. Architecture is not supported.");
        }
        String agent = "yjpagent";
        if (SystemInfo.isMac) {
            agent = "lib" + agent + ".dylib";
        } else if (SystemInfo.isLinux) {
            agent = "lib" + agent;
            if (SystemInfo.is64Bit) {
                agent = agent + "64";
            }
            agent = agent + ".so";
        } else if (SystemInfo.isWindows) {
            if (SystemInfo.is64Bit) {
                agent = agent + "64";
            }
            agent = agent + ".dll";
        } else {
            throw new RuntimeException("YK profiling can't be enabled. OS is not supported.");
        }
        return agent;
    }

    private static String getAgentOptions() {
        String agentOptions = "disable_async_sampling,disablealloc,onlylocal,probe_disable=*";
        String snapshotPath = System.getProperty("snapshots.path");
        if (snapshotPath != null) {
            agentOptions = agentOptions + ",dir=" + snapshotPath;
        }
        return agentOptions;
    }

    public static void attachProfilerAgent() throws Exception {
        ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<Void, Exception>(null, PerformanceTestingBundle.message("loading.yourkit.library", new Object[0]), false){

            public Void compute(@NotNull ProgressIndicator indicator) throws Exception {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!YourKitProfilerHandler.canProfilerBeAttached()) {
                    throw new Exception("Profiling agent can't be attached dynamically on JRE (only JDK is supported).");
                }
                String agentOptions = YourKitProfilerHandler.getAgentOptions();
                VirtualMachine virtualMachine = VirtualMachine.attach(OSProcessUtil.getApplicationPid());
                virtualMachine.loadAgentPath(YourKitProfilerHandler.getFullLibraryPath(), agentOptions);
                YourKitProfilerHandler.reinitialize();
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/performancePlugin/profilers/YourKitProfilerHandler$1", "compute"));
            }
        });
    }

    public static boolean canProfilerBeAttached() {
        try {
            Class.forName("com.sun.tools.attach.VirtualMachine");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static String moveBinariesFromPluginToConfig() throws IOException {
        Path dirInConfig = Paths.get(PathManager.getConfigPath(), "yk-binaries");
        Files.createDirectories(dirInConfig, new FileAttribute[0]);
        Path pathToBinInConfig = dirInConfig.resolve(YourKitProfilerHandler.getAgentFullLibraryName());
        Files.copy(Paths.get(YourKitProfilerHandler.getFullLibraryPath(), new String[0]), pathToBinInConfig, StandardCopyOption.REPLACE_EXISTING);
        return pathToBinInConfig.toAbsolutePath().toString();
    }

    public static void enableStartupProfiling() throws IOException {
        YourKitProfilerHandler.disableProfiler();
        YourKitProfilerHandler.enablePersistentProfiler("sampling," + YourKitProfilerHandler.getAgentOptions());
    }

    public static void enablePersistentProfiler() throws IOException {
        YourKitProfilerHandler.enablePersistentProfiler("delay=10000," + YourKitProfilerHandler.getAgentOptions());
    }

    private static void enablePersistentProfiler(String options) throws IOException {
        String content;
        File file = VMOptions.getWriteFile();
        String lineSeparator = SystemProperties.getLineSeparator();
        if (file == null) {
            throw new IOException("VM options file is not configured");
        }
        String string = content = file.exists() ? FileUtil.loadFile((File)file) : VMOptions.read();
        if (file.exists()) {
            FileUtil.setReadOnlyAttribute((String)file.getPath(), (boolean)false);
        } else {
            FileUtil.ensureExists((File)file.getParentFile());
        }
        String pathToBinInConfig = YourKitProfilerHandler.moveBinariesFromPluginToConfig();
        String YKAgent = "-agentpath:" + pathToBinInConfig + "=" + options;
        FileUtil.writeToFile((File)file, (String)(content + lineSeparator + YKAgent));
    }

    private static String getFullLibraryPath() throws IOException {
        String folderPath;
        File bundledPlugin = Paths.get(PathManager.getPreInstalledPluginsPath(), "performanceTesting", "bin").toFile();
        File installedPlugin = Paths.get(PathManager.getPluginsPath(), "performanceTesting", "bin").toFile();
        if (installedPlugin.exists()) {
            folderPath = installedPlugin.getAbsolutePath();
        } else if (bundledPlugin.exists()) {
            folderPath = bundledPlugin.getAbsolutePath();
        } else {
            throw new IOException("No binaries in performance plugin");
        }
        return Paths.get(folderPath, YourKitProfilerHandler.getAgentFullLibraryName()).toString();
    }

    public static boolean isStartupProfilingInVMEnabled() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments().stream().anyMatch(argument -> argument.contains("yjpagent") && argument.contains("=sampling"));
    }

    public static void disableProfiler() {
        String content = VMOptions.read();
        if (content != null) {
            content = Arrays.stream(StringUtil.splitByLinesKeepSeparators((String)content)).filter(line -> !line.contains("yjpagent")).collect(Collectors.joining());
            try {
                File file = VMOptions.getWriteFile();
                if (file != null) {
                    FileUtil.writeToFile((File)file, (String)content);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void reinitialize() {
        try {
            ourController = new Controller();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasValidController() {
        return ourController != null;
    }

    public static boolean isCPUProfiling() {
        return ourCPUProfiling;
    }

    public static void startCPUProfiling() {
        YourKitProfilerHandler.startCPUProfiling(false);
    }

    public static void startCPUProfiling(boolean withCounts) {
        if (YourKitProfilerHandler.hasValidController()) {
            try {
                if (withCounts) {
                    ourController.startCPUTracing(null);
                } else {
                    ourController.startCPUSampling(null);
                }
                ourCPUProfiling = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            LOG.warn("ProfilingUtil is disabled");
        }
    }

    public static String captureCPUSnapshot() {
        if (YourKitProfilerHandler.hasValidController()) {
            try {
                String dumpPath = ourController.captureSnapshot(0L);
                ourController.stopCPUProfiling();
                LOG.info("CPU snapshot is generated at " + dumpPath);
                ourCPUProfiling = false;
                return dumpPath;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static boolean canCaptureMemorySnapshot() {
        boolean forceYourKit = Boolean.getBoolean("profile.yourkit");
        return YourKitProfilerHandler.hasValidController() || !forceYourKit && MemoryDumpHelper.memoryDumpAvailable();
    }

    public static String captureMemorySnapshot() {
        boolean forceYourKit = Boolean.getBoolean("profile.yourkit");
        if (!forceYourKit && MemoryDumpHelper.memoryDumpAvailable()) {
            try {
                File tempFile = FileUtil.createTempFile((String)"heapDump.", (String)".hprof");
                FileUtil.delete((File)tempFile);
                String dumpPath = tempFile.getPath();
                MemoryDumpHelper.captureMemoryDump((String)dumpPath);
                return dumpPath;
            }
            catch (Exception e) {
                if (!YourKitProfilerHandler.hasValidController()) {
                    throw new RuntimeException(e);
                }
                LOG.debug((Throwable)e);
            }
        }
        if (YourKitProfilerHandler.hasValidController()) {
            try {
                return ourController.captureMemorySnapshot();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        LOG.warn("ProfilingUtil is disabled");
        return null;
    }

    @NotNull
    public static String formatSnapshotName(boolean isMemorySnapshot) {
        String buildNumber = ApplicationInfo.getInstance().getBuild().asString();
        String userName = SystemProperties.getUserName();
        String snapshotDate = new SimpleDateFormat("dd.MM.yyyy_HH.mm.ss").format(new Date());
        String string = buildNumber + '_' + (isMemorySnapshot ? "memory_" : "") + userName + '_' + snapshotDate;
        if (string == null) {
            YourKitProfilerHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private static File compressSnapshot(@NotNull String dumpFilePath, @NotNull String snapshotName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void copySnapshotAndNotify(@Nullable String dumpPath, @Nullable Project project, boolean isMemorySnapshot) throws IOException {
        if (dumpPath == null) {
            return;
        }
        File snapshot = YourKitProfilerHandler.compressSnapshot(dumpPath, YourKitProfilerHandler.formatSnapshotName(isMemorySnapshot));
        if (snapshot == null) {
            return;
        }
        LOG.info(isMemorySnapshot ? "Memory" : "CPU snapshot is moved to " + snapshot.getAbsolutePath());
        String url = FileUtil.getUrl((File)snapshot);
        String text = PerformanceTestingBundle.message("profiling.capture.snapshot.success", snapshot.getName(), url, RevealFileAction.getFileManagerName());
        GROUP.createNotification("", text, NotificationType.INFORMATION, RevealFileAction.FILE_SELECTING_LISTENER).notify(project);
    }

    public static void notifyCapturingError(@NotNull Throwable t, @Nullable Project project) {
        if (t == null) {
            YourKitProfilerHandler.$$$reportNull$$$0(8);
        }
        LOG.warn(t);
        String text = PerformanceTestingBundle.message("profiling.capture.snapshot.error", t.getMessage());
        GROUP.createNotification(text, NotificationType.ERROR).notify(project);
    }

    public static boolean isProfilerInVMFileEnabled() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments().stream().anyMatch(argument -> argument.contains("yjpagent"));
    }

    static {
        ourCPUProfiling = YourKitProfilerHandler.isStartupProfilingInVMEnabled();
        Controller controller = null;
        try {
            if (YourKitProfilerHandler.isProfilerInVMFileEnabled()) {
                controller = new Controller();
            }
        }
        catch (Throwable t) {
            LOG.warn("YourKit controller initialization failed : " + t.getMessage(), t.getCause());
        }
        ourController = controller;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToResult";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/profilers/YourKitProfilerHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumpFilePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshotName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/profilers/YourKitProfilerHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "formatSnapshotName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startProfiling";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "stopProfiling";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "compressResults";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "compressSnapshot";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "notifyCapturingError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

