/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.branch;

import com.intellij.dvcs.ui.BranchActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.branch.HgBranchAbstractAction;
import org.zmlx.hg4idea.branch.HgBranchManager;
import org.zmlx.hg4idea.branch.HgBranchType;
import org.zmlx.hg4idea.branch.HgBrancher;
import org.zmlx.hg4idea.command.HgMergeCommand;
import org.zmlx.hg4idea.command.HgUpdateCommand;
import org.zmlx.hg4idea.repo.HgRepository;

public class HgCommonBranchActions
extends BranchActionGroup {
    @NotNull
    protected final Project myProject;
    @NotNull
    private final HgBranchManager myBranchManager;
    @NotNull
    protected final String myBranchName;
    @NotNull
    protected final List<HgRepository> myRepositories;
    @Nullable
    private final HgBranchType myBranchType;

    HgCommonBranchActions(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
        if (project == null) {
            HgCommonBranchActions.$$$reportNull$$$0(0);
        }
        if (repositories == null) {
            HgCommonBranchActions.$$$reportNull$$$0(1);
        }
        if (branchName == null) {
            HgCommonBranchActions.$$$reportNull$$$0(2);
        }
        this(project, repositories, branchName, null);
    }

    HgCommonBranchActions(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName, @Nullable HgBranchType branchType) {
        if (project == null) {
            HgCommonBranchActions.$$$reportNull$$$0(3);
        }
        if (repositories == null) {
            HgCommonBranchActions.$$$reportNull$$$0(4);
        }
        if (branchName == null) {
            HgCommonBranchActions.$$$reportNull$$$0(5);
        }
        this.myProject = project;
        this.myBranchName = branchName;
        this.myRepositories = repositories;
        this.myBranchManager = (HgBranchManager)((Object)ServiceManager.getService((Project)project, HgBranchManager.class));
        this.getTemplatePresentation().setText(this.myBranchName, false);
        this.myBranchType = branchType;
        this.setFavorite(this.myBranchManager.isFavorite(this.myBranchType, HgCommonBranchActions.chooseRepository(this.myRepositories), this.myBranchName));
        this.hideIconForUnnamedHeads();
    }

    private void hideIconForUnnamedHeads() {
        if (this.myBranchType == null) {
            this.getTemplatePresentation().setIcon(null);
            this.getTemplatePresentation().setHoveredIcon(null);
        }
    }

    @Nullable
    private static HgRepository chooseRepository(@NotNull List<? extends HgRepository> repositories) {
        if (repositories == null) {
            HgCommonBranchActions.$$$reportNull$$$0(6);
        }
        assert (!repositories.isEmpty());
        return repositories.size() > 1 ? null : repositories.get(0);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray = new AnAction[]{new UpdateAction(this.myProject, this.myRepositories, this.myBranchName), new CompareAction(this.myProject, this.myRepositories, this.myBranchName), new MergeAction(this.myProject, this.myRepositories, this.myBranchName)};
        if (anActionArray == null) {
            HgCommonBranchActions.$$$reportNull$$$0(7);
        }
        return anActionArray;
    }

    public void toggle() {
        super.toggle();
        this.myBranchManager.setFavorite(this.myBranchType, HgCommonBranchActions.chooseRepository(this.myRepositories), this.myBranchName, this.isFavorite());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/branch/HgCommonBranchActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/branch/HgCommonBranchActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "chooseRepository";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CompareAction
    extends HgBranchAbstractAction {
        CompareAction(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                CompareAction.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                CompareAction.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                CompareAction.$$$reportNull$$$0(2);
            }
            super(project, "Compare", repositories, branchName);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CompareAction.$$$reportNull$$$0(3);
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            HgRepository repository = (HgRepository)this.myRepositories.get(0);
            new HgBrancher(this.myProject).compare(this.myBranchName, this.myRepositories, repository);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "org/zmlx/hg4idea/branch/HgCommonBranchActions$CompareAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class UpdateAction
    extends HgBranchAbstractAction {
        UpdateAction(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                UpdateAction.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                UpdateAction.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                UpdateAction.$$$reportNull$$$0(2);
            }
            super(project, "Update", repositories, branchName);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                UpdateAction.$$$reportNull$$$0(3);
            }
            HgUpdateCommand.updateTo(this.myBranchName, this.myRepositories, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "org/zmlx/hg4idea/branch/HgCommonBranchActions$UpdateAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MergeAction
    extends HgBranchAbstractAction {
        MergeAction(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                MergeAction.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                MergeAction.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                MergeAction.$$$reportNull$$$0(2);
            }
            super(project, "Merge", repositories, branchName);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MergeAction.$$$reportNull$$$0(3);
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            UpdatedFiles updatedFiles = UpdatedFiles.create();
            for (HgRepository repository : this.myRepositories) {
                HgMergeCommand.mergeWith(repository, this.myBranchName, updatedFiles);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "org/zmlx/hg4idea/branch/HgCommonBranchActions$MergeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

