/*
 * Decompiled with CFR 0.152.
 */
package ini4idea.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import ini4idea.IniBundle;
import ini4idea.lang.psi.IniFile;
import ini4idea.lang.psi.IniSection;
import ini4idea.lang.psi.IniSectionName;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class DuplicateSectionInspection
extends LocalInspectionTool {
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiElement[] children;
        if (file == null) {
            DuplicateSectionInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            DuplicateSectionInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof IniFile)) {
            return null;
        }
        SmartList descriptors = new SmartList();
        HashSet<String> sectionSet = new HashSet<String>();
        for (PsiElement elem : children = file.getChildren()) {
            IniSectionName namePsi;
            if (!(elem instanceof IniSection) || (namePsi = ((IniSection)elem).getIniSectionName()) == null) continue;
            String sectionName = namePsi.getText();
            if (sectionSet.contains(sectionName)) {
                descriptors.add(manager.createProblemDescriptor((PsiElement)namePsi, (TextRange)null, IniBundle.message("ini.duplicate.section.short.problem.description", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, new LocalQuickFix[]{RemoveDuplicateSectionFix.INSTANCE}));
                continue;
            }
            sectionSet.add(sectionName);
        }
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @NotNull
    public String getShortName() {
        return "DuplicateSectionInFile";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "ini4idea/inspections/DuplicateSectionInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RemoveDuplicateSectionFix
    implements LocalQuickFix {
        private static final RemoveDuplicateSectionFix INSTANCE = new RemoveDuplicateSectionFix();

        private RemoveDuplicateSectionFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = IniBundle.message("ini.duplicate.section.fix.name", new Object[0]);
            if (string == null) {
                RemoveDuplicateSectionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Document document;
            PsiElement element;
            TextRange textRange;
            if (project == null) {
                RemoveDuplicateSectionFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemoveDuplicateSectionFix.$$$reportNull$$$0(2);
            }
            if ((textRange = (element = descriptor.getPsiElement()).getTextRange()) != null && (document = PsiDocumentManager.getInstance((Project)project).getDocument(element.getContainingFile())) != null) {
                document.deleteString(textRange.getStartOffset(), textRange.getEndOffset());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ini4idea/inspections/DuplicateSectionInspection$RemoveDuplicateSectionFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ini4idea/inspections/DuplicateSectionInspection$RemoveDuplicateSectionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

