/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.jobs;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJob;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJobFieldValue;
import org.jetbrains.idea.perforce.perforce.jobs.SelfLoadingJobDetailsPanel;
import org.jetbrains.idea.perforce.perforce.jobs.StandardJobFields;

public class JobsMasterDetails
extends MasterDetailsComponent {
    private final Project myProject;
    private ListSelectionListener myListSelectionListener;

    public JobsMasterDetails(Project project) {
        this.myProject = project;
        this.initTree();
        this.init();
        this.getSplitter().setProportion(0.3f);
    }

    public void onlyMain() {
        this.getSplitter().setProportion(0.0f);
        this.getSplitter().setSecondComponent(null);
    }

    public JComponent getPreferredFocusTarget() {
        return this.myTree;
    }

    public void setSelectionListener(ListSelectionListener selectionListener) {
        this.myListSelectionListener = selectionListener;
    }

    @Nls
    public String getDisplayName() {
        return PerforceBundle.message((String)"configurable.JobsMasterDetails.display.name", (Object[])new Object[0]);
    }

    @NotNull
    public List<PerforceJob> getSelectedJobs() {
        MasterDetailsComponent.MyNode[] nodes = (MasterDetailsComponent.MyNode[])this.myTree.getSelectedNodes(MasterDetailsComponent.MyNode.class, null);
        ArrayList<PerforceJob> result = new ArrayList<PerforceJob>();
        for (MasterDetailsComponent.MyNode node : nodes) {
            result.add((PerforceJob)node.getConfigurable().getEditableObject());
        }
        ArrayList<PerforceJob> arrayList = result;
        if (arrayList == null) {
            JobsMasterDetails.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    public void removeSelectedJobs() {
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths != null) {
            this.removePaths(paths);
        }
        if (this.myTree.getRowCount() > 0) {
            this.myTree.setSelectionRow(0);
        }
    }

    public void addJob(PerforceJob job) {
        MyConfigurable configurable = new MyConfigurable(this.myProject, job);
        this.myRoot.add((MutableTreeNode)new MasterDetailsComponent.MyNode((NamedConfigurable)configurable));
        ((DefaultTreeModel)this.myTree.getModel()).reload((TreeNode)this.myRoot);
        this.myTree.setSelectionRow(this.myTree.getRowCount() - 1);
    }

    public List<PerforceJob> getJobs() {
        ArrayList<PerforceJob> result = new ArrayList<PerforceJob>();
        int childCount = this.myRoot.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
            result.add((PerforceJob)node.getConfigurable().getEditableObject());
        }
        return result;
    }

    protected Dimension getPanelPreferredSize() {
        return JBUI.size((int)400, (int)200);
    }

    private void init() {
        this.myTree.setCellRenderer((TreeCellRenderer)new PerforceJobCellRenderer());
        this.myTree.setShowsRootHandles(false);
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (JobsMasterDetails.this.myListSelectionListener != null) {
                    JobsMasterDetails.this.myListSelectionListener.valueChanged(null);
                }
            }
        });
    }

    public void fillTree(List<PerforceJob> jobs, @Nullable PerforceJob selectJob) {
        this.myRoot.removeAllChildren();
        int idx = -1;
        for (int i = 0; i < jobs.size(); ++i) {
            PerforceJob job = jobs.get(i);
            MyConfigurable configurable = new MyConfigurable(this.myProject, job);
            this.myRoot.add((MutableTreeNode)new MasterDetailsComponent.MyNode((NamedConfigurable)configurable));
            if (selectJob == null || !job.getName().equals(selectJob.getName())) continue;
            idx = i;
        }
        ((DefaultTreeModel)this.myTree.getModel()).reload((TreeNode)this.myRoot);
        if (idx >= 0) {
            this.myTree.setSelectionRow(idx);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/perforce/jobs/JobsMasterDetails", "getSelectedJobs"));
    }

    private static class MyConfigurable
    extends NamedConfigurable<PerforceJob> {
        private final SelfLoadingJobDetailsPanel mySelfLoadingJobDetailsPanel;
        private final PerforceJob myJob;

        private MyConfigurable(Project project, @NotNull PerforceJob job) {
            if (job == null) {
                MyConfigurable.$$$reportNull$$$0(0);
            }
            this.mySelfLoadingJobDetailsPanel = new SelfLoadingJobDetailsPanel(project, job);
            this.myJob = job;
        }

        public void setDisplayName(String name) {
        }

        public PerforceJob getEditableObject() {
            return this.myJob;
        }

        public String getBannerSlogan() {
            return this.myJob.getName();
        }

        public JComponent createOptionsPanel() {
            return this.mySelfLoadingJobDetailsPanel.getPanel();
        }

        @Nls
        public String getDisplayName() {
            return this.myJob.getName();
        }

        public String getHelpTopic() {
            return null;
        }

        public boolean isModified() {
            return false;
        }

        public void apply() throws ConfigurationException {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "job", "org/jetbrains/idea/perforce/perforce/jobs/JobsMasterDetails$MyConfigurable", "<init>"));
        }
    }

    private static class PerforceJobCellRenderer
    implements TreeCellRenderer {
        private final ColoredTreeCellRenderer myTop;
        private final JPanel myPanel = new JPanel(new GridBagLayout());

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (!(value instanceof MasterDetailsComponent.MyNode)) {
                return this.myPanel;
            }
            return this.myTop.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }

        private PerforceJobCellRenderer() {
            this.myPanel.setBackground(Color.white);
            this.myTop = new ColoredTreeCellRenderer(){

                public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    if (!(value instanceof MasterDetailsComponent.MyRootNode)) {
                        MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)value;
                        MyConfigurable configurable = (MyConfigurable)node.getConfigurable();
                        PerforceJob job = configurable.getEditableObject();
                        this.append(job.getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                        PerforceJobFieldValue status = job.getValueForStandardField(StandardJobFields.status);
                        this.append(" <" + (status == null ? "unknown status" : status.getValue()) + ">", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
                        PerforceJobFieldValue desc = job.getValueForStandardField(StandardJobFields.description);
                        if (desc != null) {
                            String text = desc.getValue();
                            text = text.length() > 30 ? text.substring(0, 30) + "..." : text;
                            this.append(" " + text, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
                        }
                    }
                }
            };
        }
    }
}

