/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecStartCmd;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentLogManager;
import com.intellij.docker.agent.tty.ResizeContainerCmd;
import com.intellij.docker.agent.tty.ResizeExecCmd;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public interface DockerAgentContext {
    public DockerAgent getAgent();

    public DockerClient getClient();

    public DockerClientExt getClientExt();

    public CloudAgentErrorHandler getErrorHandler();

    public DockerAgentLogManager getLogManager();

    public CloudAgentLogger getLogger();

    default public boolean isConnected() {
        return this.getAgent().isConnected();
    }

    default public ObjectMapper getObjectMapper() {
        return this.getClientExt().getObjectMapper();
    }

    public static interface DockerClientExt
    extends Closeable {
        @NotNull
        public ResizeExecCmd resizeExecCmd();

        @NotNull
        public ResizeContainerCmd resizeContainerCmd();

        public ExecStartCmd jerseyExecStartCmd(String var1);

        public ExecCreateCmd jerseyExecCreateCmd(String var1);

        @NotNull
        public DockerClient getDockerClient();

        @NotNull
        public ObjectMapper getObjectMapper();
    }
}

