/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.console.ConsoleHtmlPanel;
import com.intellij.javascript.debugger.console.javafx.JavaFXConsoleHtmlPanel;
import com.intellij.javascript.debugger.console.jcef.JCEFConsoleHtmlPanel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.jcef.JBCefApp;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lcom/intellij/javascript/debugger/console/ConsoleHtmlPanelProvider;", "", "()V", "createHtmlPanel", "Lcom/intellij/javascript/debugger/console/ConsoleHtmlPanel;", "Companion", "intellij.javascript.debugger"})
public final class ConsoleHtmlPanelProvider {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ConsoleHtmlPanel createHtmlPanel() {
        if (Companion.isJcefAvailable() && JBCefApp.isEnabled()) {
            return new JCEFConsoleHtmlPanel();
        }
        return new JavaFXConsoleHtmlPanel();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\u0004H\u0002J\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/debugger/console/ConsoleHtmlPanelProvider$Companion;", "", "()V", "hasAvailableProviders", "", "project", "Lcom/intellij/openapi/project/Project;", "isJavaFxAvailable", "isJcefAvailable", "intellij.javascript.debugger"})
    public static final class Companion {
        public final boolean hasAvailableProviders(@NotNull Project project) {
            boolean anyProviderAvailable;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            boolean useWebConsoleSetting = Registry.is((String)"js.debugger.webconsole");
            boolean bl = anyProviderAvailable = this.isJavaFxAvailable() || this.isJcefAvailable();
            if (useWebConsoleSetting && !anyProviderAvailable) {
                NotificationGroup notificationGroup = NotificationGroup.Companion.logOnlyGroup("JavaScript Debugger Console");
                String string = JSDebuggerBundle.message("js.console.javafx.check.notification", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JSDebuggerBundle.message\u2026vafx.check.notification\")");
                Notification notification = notificationGroup.createNotification(string, NotificationType.WARNING);
                notification.notify(project);
            }
            return useWebConsoleSetting && anyProviderAvailable;
        }

        public final boolean isJcefAvailable() {
            try {
                if (Class.forName("org.cef.browser.CefBrowser", false, this.getClass().getClassLoader()) != null) {
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return false;
        }

        private final boolean isJavaFxAvailable() {
            try {
                if (Class.forName("javafx.scene.web.WebView", false, ConsoleHtmlPanelProvider.class.getClassLoader()) != null) {
                    boolean hasInitializationFreezes = PropertiesComponent.getInstance().getBoolean("js.debugger.javafx.inititalization", false);
                    if (hasInitializationFreezes) {
                        boolean $i$f$logger = false;
                        Logger logger = Logger.getInstance(ConsoleHtmlPanelProvider.class);
                        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
                        logger.warn("JavaFX wasn't initialized");
                        Registry.get((String)"js.debugger.webconsole").setValue(false);
                        PropertiesComponent.getInstance().setValue("js.debugger.javafx.inititalization", false);
                    }
                    return !hasInitializationFreezes;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

