/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console.javafx;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.javascript.debugger.console.ConsoleHtmlPanel;
import com.intellij.javascript.debugger.console.JSBridge;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.javafx.JavaFxHtmlPanel;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import netscape.javascript.JSObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 22\u00020\u00012\u00020\u0002:\u00012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\bH\u0016J7\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00060\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ)\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018\"\u00020\u0019H\u0016\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u0006H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00192\u0006\u0010 \u001a\u00020\u0016H\u0016J\u0010\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0016H\u0016J\u0016\u0010#\u001a\u00020\u00062\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\b\u0010%\u001a\u00020\u0006H\u0002J\u0010\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(H\u0014J*\u0010)\u001a\u00020\u00062 \u0010*\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00180,0+H\u0016J\u0016\u0010-\u001a\u00020\u00062\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0010\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u000201H\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/javascript/debugger/console/javafx/JavaFXConsoleHtmlPanel;", "Lcom/intellij/ui/javafx/JavaFxHtmlPanel;", "Lcom/intellij/javascript/debugger/console/ConsoleHtmlPanel;", "()V", "initHandler", "Lkotlin/Function0;", "", "listener", "Ljava/awt/event/KeyListener;", "pageLoaded", "", "getPageLoaded", "()Z", "setPageLoaded", "(Z)V", "platformRequests", "", "Ljava/lang/Runnable;", "addKeyListener", "keyListener", "callJS", "method", "", "args", "", "", "callback", "Lkotlin/Function1;", "(Ljava/lang/String;[Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "(Ljava/lang/String;[Ljava/lang/Object;)V", "dispose", "executeScript", "s", "load", "mainUrl", "onInit", "function", "pageInit", "registerListeners", "engine", "Ljavafx/scene/web/WebEngine;", "runRequestsBatch", "batch", "", "Lkotlin/Pair;", "runWhenPageReady", "runnable", "setBridge", "jsBridge", "Lcom/intellij/javascript/debugger/console/JSBridge;", "Companion", "intellij.javascript.debugger"})
public final class JavaFXConsoleHtmlPanel
extends JavaFxHtmlPanel
implements ConsoleHtmlPanel {
    private volatile boolean pageLoaded;
    private final List<Runnable> platformRequests;
    private Function0<Unit> initHandler;
    private KeyListener listener;
    private static final Logger LOG;
    @NotNull
    private static final Gson gson;
    public static final Companion Companion;

    public final boolean getPageLoaded() {
        return this.pageLoaded;
    }

    public final void setPageLoaded(boolean bl) {
        this.pageLoaded = bl;
    }

    @Override
    public void load(@NotNull String mainUrl) {
        Intrinsics.checkParameterIsNotNull((Object)mainUrl, (String)"mainUrl");
        this.runInPlatformWhenAvailable(new Runnable(this, mainUrl){
            final /* synthetic */ JavaFXConsoleHtmlPanel this$0;
            final /* synthetic */ String $mainUrl;

            public final void run() {
                String url = this.$mainUrl + (StringsKt.contains$default((CharSequence)this.$mainUrl, (CharSequence)"?", (boolean)false, (int)2, null) ? "&" : "?") + "renderer=javafx";
                WebView webView = JavaFXConsoleHtmlPanel.access$getWebViewGuaranteed(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)webView, (String)"webViewGuaranteed");
                webView.getEngine().load(url);
            }
            {
                this.this$0 = javaFXConsoleHtmlPanel;
                this.$mainUrl = string;
            }
        });
    }

    @Override
    @Nullable
    public Object executeScript(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        try {
            WebView webView = this.getWebViewGuaranteed();
            Intrinsics.checkExpressionValueIsNotNull((Object)webView, (String)"webViewGuaranteed");
            return webView.getEngine().executeScript(s);
        }
        catch (Exception e) {
            LOG.error("Error on script execution '" + s + "'\n" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected void registerListeners(@NotNull WebEngine engine) {
        Intrinsics.checkParameterIsNotNull((Object)engine, (String)"engine");
        engine.setOnAlert((EventHandler)new EventHandler<WebEvent<String>>(this){
            final /* synthetic */ JavaFXConsoleHtmlPanel this$0;

            public final void handle(WebEvent<String> event) {
                WebEvent<String> webEvent = event;
                Intrinsics.checkExpressionValueIsNotNull(webEvent, (String)"event");
                if (Intrinsics.areEqual((Object)"command:ready", (Object)((String)webEvent.getData()))) {
                    JavaFXConsoleHtmlPanel.access$pageInit(this.this$0);
                }
            }
            {
                this.this$0 = javaFXConsoleHtmlPanel;
            }
        });
    }

    @Override
    public void onInit(@NotNull Function0<Unit> function) {
        Intrinsics.checkParameterIsNotNull(function, (String)"function");
        this.initHandler = function;
    }

    private final void pageInit() {
        this.pageLoaded = true;
        LOG.info("WebConsole page loaded");
        Function0<Unit> function0 = this.initHandler;
        if (function0 != null) {
            Unit cfr_ignored_0 = (Unit)function0.invoke();
        }
        for (Runnable request : this.platformRequests) {
            Platform.runLater((Runnable)request);
        }
        this.platformRequests.clear();
        LOG.info("initialization complete");
    }

    @Override
    public void runWhenPageReady(@NotNull Function0<Unit> runnable) {
        Intrinsics.checkParameterIsNotNull(runnable, (String)"runnable");
        if (!this.pageLoaded) {
            this.platformRequests.add(new Runnable(runnable){
                final /* synthetic */ Function0 $runnable;

                public final void run() {
                    this.$runnable.invoke();
                }
                {
                    this.$runnable = function0;
                }
            });
            return;
        }
        if (!Platform.isFxApplicationThread()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            Platform.runLater((Runnable)new Runnable(runnable){
                final /* synthetic */ Function0 $runnable;

                public final void run() {
                    this.$runnable.invoke();
                }
                {
                    this.$runnable = function0;
                }
            });
        } else {
            runnable.invoke();
        }
    }

    @Override
    public void addKeyListener(@NotNull KeyListener keyListener) {
        Intrinsics.checkParameterIsNotNull((Object)keyListener, (String)"keyListener");
        this.runInPlatformWhenAvailable(new Runnable(this, keyListener){
            final /* synthetic */ JavaFXConsoleHtmlPanel this$0;
            final /* synthetic */ KeyListener $keyListener;

            public final void run() {
                block0: {
                    JavaFXConsoleHtmlPanel.access$setListener$p(this.this$0, this.$keyListener);
                    JFXPanel jFXPanel = JavaFXConsoleHtmlPanel.access$getMyPanel$p(this.this$0);
                    if (jFXPanel == null) break block0;
                    jFXPanel.addKeyListener(this.$keyListener);
                }
            }
            {
                this.this$0 = javaFXConsoleHtmlPanel;
                this.$keyListener = keyListener;
            }
        });
    }

    @Override
    public void runRequestsBatch(@NotNull List<? extends Pair<String, ? extends Object[]>> batch) {
        Intrinsics.checkParameterIsNotNull(batch, (String)"batch");
        this.executeScript("window.processRequests(" + gson.toJson(batch) + ')');
    }

    @Override
    public void callJS(@NotNull String method, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Object[] objectArray = args;
        boolean bl = false;
        Object[] objectArray2 = objectArray;
        boolean bl2 = false;
        String jsArgs = !(objectArray2.length == 0) ? "..." + gson.toJson((Object)args) : "";
        this.executeScript("WebConsole.instance()." + method + '(' + jsArgs + ");");
    }

    @Override
    public void callJS(@NotNull String method, @NotNull Object[] args, @NotNull Function1<? super String, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        Object[] objectArray = args;
        boolean bl = false;
        Object[] objectArray2 = objectArray;
        boolean bl2 = false;
        String jsArgs = !(objectArray2.length == 0) ? "..." + gson.toJson((Object)args) : "";
        String res = String.valueOf(this.executeScript("WebConsole.instance()." + method + '(' + jsArgs + ");"));
        AppUIUtil.invokeOnEdt((Runnable)new Runnable(callback, res){
            final /* synthetic */ Function1 $callback;
            final /* synthetic */ String $res;

            public final void run() {
                this.$callback.invoke((Object)this.$res);
            }
            {
                this.$callback = function1;
                this.$res = string;
            }
        });
    }

    @Override
    public void setBridge(@NotNull JSBridge jsBridge) {
        Intrinsics.checkParameterIsNotNull((Object)jsBridge, (String)"jsBridge");
        Object object = this.executeScript("window");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type netscape.javascript.JSObject");
        }
        JSObject win = (JSObject)object;
        win.setMember("JSBridge", jsBridge);
    }

    public void dispose() {
        super.dispose();
        this.runInPlatformWhenAvailable(new Runnable(this){
            final /* synthetic */ JavaFXConsoleHtmlPanel this$0;

            public final void run() {
                JFXPanel jFXPanel = JavaFXConsoleHtmlPanel.access$getMyPanel$p(this.this$0);
                if (jFXPanel != null && (jFXPanel = jFXPanel.getScene()) != null && (jFXPanel = jFXPanel.getWindow()) != null) {
                    jFXPanel.hide();
                }
                JFXPanel jFXPanel2 = JavaFXConsoleHtmlPanel.access$getMyPanel$p(this.this$0);
                if (jFXPanel2 != null) {
                    jFXPanel2.removeKeyListener(JavaFXConsoleHtmlPanel.access$getListener$p(this.this$0));
                }
                JavaFXConsoleHtmlPanel.access$setListener$p(this.this$0, null);
            }
            {
                this.this$0 = javaFXConsoleHtmlPanel;
            }
        });
        this.initHandler = null;
        this.platformRequests.clear();
    }

    public JavaFXConsoleHtmlPanel() {
        List list;
        JavaFXConsoleHtmlPanel javaFXConsoleHtmlPanel = this;
        boolean bl = false;
        javaFXConsoleHtmlPanel.platformRequests = list = (List)new ArrayList();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(JavaFXConsoleHtmlPanel.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(JavaF\u2026oleHtmlPanel::class.java)");
        LOG = logger;
        Gson gson = new GsonBuilder().create();
        Intrinsics.checkExpressionValueIsNotNull((Object)gson, (String)"GsonBuilder().create()");
        JavaFXConsoleHtmlPanel.gson = gson;
    }

    public static final /* synthetic */ WebView access$getWebViewGuaranteed(JavaFXConsoleHtmlPanel $this) {
        return $this.getWebViewGuaranteed();
    }

    public static final /* synthetic */ void access$pageInit(JavaFXConsoleHtmlPanel $this) {
        $this.pageInit();
    }

    public static final /* synthetic */ KeyListener access$getListener$p(JavaFXConsoleHtmlPanel $this) {
        return $this.listener;
    }

    public static final /* synthetic */ void access$setListener$p(JavaFXConsoleHtmlPanel $this, KeyListener keyListener) {
        $this.listener = keyListener;
    }

    public static final /* synthetic */ JFXPanel access$getMyPanel$p(JavaFXConsoleHtmlPanel $this) {
        return $this.myPanel;
    }

    public static final /* synthetic */ void access$setMyPanel$p(JavaFXConsoleHtmlPanel $this, JFXPanel jFXPanel) {
        $this.myPanel = jFXPanel;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/javascript/debugger/console/javafx/JavaFXConsoleHtmlPanel$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "intellij.javascript.debugger"})
    public static final class Companion {
        @NotNull
        public final Gson getGson() {
            return gson;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

