/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.browsers.actions.OpenFileInDefaultBrowserActionKt;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.DebuggableFileFinderImpl;
import com.intellij.javascript.debugger.JavaScriptDebugEngine;
import com.intellij.javascript.debugger.JavaScriptDebugEngineKt;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinder;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinderKt;
import com.intellij.javascript.debugger.execution.ILiveEditOptions;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.JavaScriptDebugSettingsEditor;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J&\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u0005H\u0004J\b\u0010\u0017\u001a\u00020\u0007H\u0016J,\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0002J\b\u0010\u001c\u001a\u00020\u0005H\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/javascript/debugger/execution/JavaScriptDebugRunner;", "Lcom/intellij/execution/runners/AsyncProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "execute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "findEngineAndBrowser", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/javascript/debugger/JavaScriptDebugEngine;", "Lcom/intellij/ide/browsers/WebBrowser;", "browserIdOrNameOrEngineId", "isRun", "getRunnerId", "startSession", "project", "Lcom/intellij/openapi/project/Project;", "engineAndBrowser", "useExtension", "intellij.javascript.debugger"})
public class JavaScriptDebugRunner
extends AsyncProgramRunner<RunnerSettings> {
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)executorId, (String)"executorId");
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        return profile instanceof JavaScriptDebugConfiguration && (Intrinsics.areEqual((Object)executorId, (Object)"Debug") || Intrinsics.areEqual((Object)executorId, (Object)"Run"));
    }

    @NotNull
    public String getRunnerId() {
        return "JavascriptDebugRunner";
    }

    @NotNull
    protected final Pair<JavaScriptDebugEngine, WebBrowser> findEngineAndBrowser(@Nullable String browserIdOrNameOrEngineId, boolean isRun) {
        WebBrowser webBrowser;
        JavaScriptDebugEngine debugEngine;
        JavaScriptDebugEngine javaScriptDebugEngine;
        Pair<JavaScriptDebugEngine, WebBrowser> info;
        Pair<JavaScriptDebugEngine, WebBrowser> pair;
        boolean bl;
        boolean useExtension = this.useExtension();
        String string = browserIdOrNameOrEngineId;
        if (string != null) {
            String string2 = string;
            boolean bl2 = false;
            bl = false;
            String it = string2;
            boolean bl3 = false;
            pair = JavaScriptDebugEngine.Companion.findByBrowserIdOrName(it, useExtension);
        } else {
            pair = info = null;
        }
        if (info != null) {
            return info;
        }
        String string3 = browserIdOrNameOrEngineId;
        if (string3 != null) {
            String string4 = string3;
            bl = false;
            boolean bl4 = false;
            String it = string4;
            boolean bl5 = false;
            javaScriptDebugEngine = JavaScriptDebugEngineKt.findByBrowserIdOrNameOrEngineId(it, useExtension);
        } else {
            javaScriptDebugEngine = debugEngine = null;
        }
        if (debugEngine == null) {
            if (isRun) {
                Pair pair2 = Pair.create(null, (Object)OpenFileInDefaultBrowserActionKt.findUsingBrowser());
                Intrinsics.checkExpressionValueIsNotNull((Object)pair2, (String)"Pair.create(null, findUsingBrowser())");
                return pair2;
            }
            List list = WebBrowserManager.getInstance().getBrowsers(JavaScriptDebugSettingsEditor.BROWSER_CONDITION);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"WebBrowserManager.getIns\u2026Editor.BROWSER_CONDITION)");
            WebBrowser defaultBrowser = (WebBrowser)CollectionsKt.firstOrNull((List)list);
            if (defaultBrowser == null) {
                JavaScriptDebugEngine javaScriptDebugEngine2;
                block12: {
                    JavaScriptDebugEngine[] javaScriptDebugEngineArray = JavaScriptDebugEngineKt.getEngines();
                    boolean bl6 = false;
                    JavaScriptDebugEngine[] javaScriptDebugEngineArray2 = javaScriptDebugEngineArray;
                    boolean bl7 = false;
                    JavaScriptDebugEngine[] javaScriptDebugEngineArray3 = javaScriptDebugEngineArray2;
                    int n = javaScriptDebugEngineArray3.length;
                    for (int i = 0; i < n; ++i) {
                        JavaScriptDebugEngine javaScriptDebugEngine3;
                        JavaScriptDebugEngine it = javaScriptDebugEngine3 = javaScriptDebugEngineArray3[i];
                        boolean bl8 = false;
                        if (!(it.getRequiresExtension() == useExtension)) continue;
                        javaScriptDebugEngine2 = javaScriptDebugEngine3;
                        break block12;
                    }
                    javaScriptDebugEngine2 = null;
                }
                if (javaScriptDebugEngine2 == null) {
                    Intrinsics.throwNpe();
                }
                debugEngine = javaScriptDebugEngine2;
            } else {
                debugEngine = JavaScriptDebugEngine.Companion.findByBrowser(defaultBrowser, useExtension);
                Pair pair3 = Pair.create((Object)debugEngine, (Object)defaultBrowser);
                Intrinsics.checkExpressionValueIsNotNull((Object)pair3, (String)"Pair.create(debugEngine, defaultBrowser)");
                return pair3;
            }
        }
        if ((webBrowser = debugEngine.getBrowser()) == null) {
            WebBrowser webBrowser2 = WebBrowserManager.getInstance().getFirstBrowser(debugEngine.getBrowserFamily());
            webBrowser = webBrowser2;
            Intrinsics.checkExpressionValueIsNotNull((Object)webBrowser2, (String)"WebBrowserManager.getIns\u2026ebugEngine.browserFamily)");
        }
        WebBrowser notNullBrowser = webBrowser;
        Pair pair4 = Pair.create((Object)debugEngine, (Object)notNullBrowser);
        Intrinsics.checkExpressionValueIsNotNull((Object)pair4, (String)"Pair.create(debugEngine, notNullBrowser)");
        return pair4;
    }

    @NotNull
    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        RunProfile runProfile = environment.getRunProfile();
        if (runProfile == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration");
        }
        JavaScriptDebugConfiguration configuration = (JavaScriptDebugConfiguration)runProfile;
        Executor executor = environment.getExecutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)executor, (String)"environment.executor");
        boolean isRun = Intrinsics.areEqual((Object)executor.getId(), (Object)"Run");
        Pair<JavaScriptDebugEngine, WebBrowser> engineAndBrowser = this.findEngineAndBrowser(configuration.getEngineId(), isRun);
        if (isRun) {
            BrowserLauncher browserLauncher = BrowserLauncher.Companion.getInstance();
            String string = configuration.getUri();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"configuration.uri!!");
            browserLauncher.browse(string, (WebBrowser)engineAndBrowser.second, environment.getProject());
            return Promises.resolvedPromise();
        }
        JavaScriptDebugEngine javaScriptDebugEngine = (JavaScriptDebugEngine)engineAndBrowser.first;
        Project project = environment.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"environment.project");
        Object object = engineAndBrowser.second;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"engineAndBrowser.second");
        Promise promise2 = javaScriptDebugEngine.prepareDebugger(project, (WebBrowser)object).then(new Function<T, SUB_RESULT>(this, environment, engineAndBrowser){
            final /* synthetic */ JavaScriptDebugRunner this$0;
            final /* synthetic */ ExecutionEnvironment $environment;
            final /* synthetic */ Pair $engineAndBrowser;

            @NotNull
            public final RunContentDescriptor fun(Unit it) {
                FileDocumentManager.getInstance().saveAllDocuments();
                Project project = this.$environment.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"environment.project");
                return JavaScriptDebugRunner.access$startSession(this.this$0, project, this.$environment, this.$engineAndBrowser);
            }
            {
                this.this$0 = javaScriptDebugRunner;
                this.$environment = executionEnvironment;
                this.$engineAndBrowser = pair;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"engineAndBrowser.first.p\u2026gineAndBrowser)\n        }");
        return promise2;
    }

    private final boolean useExtension() {
        ILiveEditOptions liveEditOptions = (ILiveEditOptions)ServiceManager.getService(ILiveEditOptions.class);
        return liveEditOptions != null && liveEditOptions.isUseJBChromeExtension();
    }

    private final RunContentDescriptor startSession(Project project, ExecutionEnvironment environment, Pair<JavaScriptDebugEngine, WebBrowser> engineAndBrowser) {
        RunProfile runProfile = environment.getRunProfile();
        if (runProfile == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration");
        }
        JavaScriptDebugConfiguration configuration = (JavaScriptDebugConfiguration)runProfile;
        String string = configuration.getUri();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"configuration.uri!!");
        Url url = Urls.newFromIdea((CharSequence)string);
        DebuggableFileFinderImpl defaultFileFinder = new DebuggableFileFinderImpl(project, url);
        DebuggableFileFinder fileFinder = null;
        if (url.isInLocalFileSystem()) {
            fileFinder = defaultFileFinder;
        } else {
            List<RemoteUrlMappingBean> list = configuration.getMappings();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"configuration.mappings");
            fileFinder = new RemoteDebuggingFileFinder(RemoteDebuggingFileFinderKt.createUrlToLocalMap(list), defaultFileFinder);
        }
        boolean $i$f$startSession = false;
        ExecutionEnvironment executionEnvironment = environment;
        XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)environment.getProject());
        boolean $i$f$xDebugProcessStarter = false;
        XDebugProcessStarter xDebugProcessStarter = new XDebugProcessStarter(engineAndBrowser, fileFinder, url){
            final /* synthetic */ Pair $engineAndBrowser$inlined;
            final /* synthetic */ DebuggableFileFinder $fileFinder$inlined;
            final /* synthetic */ Url $url$inlined;
            {
                this.$engineAndBrowser$inlined = pair;
                this.$fileFinder$inlined = debuggableFileFinder;
                this.$url$inlined = url;
            }

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
                XDebugSession it = session;
                boolean bl = false;
                JavaScriptDebugEngine javaScriptDebugEngine = (JavaScriptDebugEngine)this.$engineAndBrowser$inlined.first;
                Object object = this.$engineAndBrowser$inlined.second;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"engineAndBrowser.second");
                return (XDebugProcess)javaScriptDebugEngine.createDebugProcess(it, (WebBrowser)object, this.$fileFinder$inlined, this.$url$inlined, null, true);
            }
        };
        XDebugSession xDebugSession = xDebuggerManager.startSession(executionEnvironment, xDebugProcessStarter);
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"XDebuggerManager.getInst\u2026gProcessStarter(starter))");
        RunContentDescriptor runContentDescriptor = xDebugSession.getRunContentDescriptor();
        Intrinsics.checkExpressionValueIsNotNull((Object)runContentDescriptor, (String)"startSession(environment\u2026) }).runContentDescriptor");
        return runContentDescriptor;
    }

    public static final /* synthetic */ RunContentDescriptor access$startSession(JavaScriptDebugRunner $this, Project project, ExecutionEnvironment environment, Pair engineAndBrowser) {
        return $this.startSession(project, environment, (Pair<JavaScriptDebugEngine, WebBrowser>)engineAndBrowser);
    }
}

