/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.scripts.FileNode;
import com.intellij.javascript.debugger.scripts.OpenActualScriptSourceAction;
import com.intellij.javascript.debugger.scripts.OpenScriptSourceAction;
import com.intellij.javascript.debugger.scripts.SetLocalPathForScriptAction;
import com.intellij.javascript.debugger.scripts.SourceTabManager;
import com.intellij.javascript.debugger.scripts.SourcesTreeStructure;
import com.intellij.javascript.debugger.scripts.VisualizeScriptSourcemap;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.WeightBasedComparator;
import com.intellij.xdebugger.XDebugSession;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u001bR\u0015\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001c"}, d2={"Lcom/intellij/javascript/debugger/scripts/SourcesTreeComponent;", "", "sourceTabManager", "Lcom/intellij/javascript/debugger/scripts/SourceTabManager;", "(Lcom/intellij/javascript/debugger/scripts/SourceTabManager;)V", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "getDebugProcess", "()Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "mainComponent", "Ljavax/swing/JScrollPane;", "Lorg/jetbrains/annotations/NotNull;", "getMainComponent", "()Ljavax/swing/JScrollPane;", "selectedNode", "Lcom/intellij/javascript/debugger/scripts/FileNode;", "getSelectedNode", "()Lcom/intellij/javascript/debugger/scripts/FileNode;", "tree", "Lcom/intellij/ui/treeStructure/SimpleTree;", "treeBuilder", "Lcom/intellij/ui/treeStructure/SimpleTreeBuilder;", "getTreeBuilder$intellij_javascript_debugger", "()Lcom/intellij/ui/treeStructure/SimpleTreeBuilder;", "createPopupGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "getDefaultFocusedComponent", "Ljavax/swing/JComponent;", "intellij.javascript.debugger"})
public final class SourcesTreeComponent {
    private final SimpleTree tree;
    @NotNull
    private final SimpleTreeBuilder treeBuilder;
    @NotNull
    private final JScrollPane mainComponent;
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;

    @NotNull
    public final SimpleTreeBuilder getTreeBuilder$intellij_javascript_debugger() {
        return this.treeBuilder;
    }

    @NotNull
    public final JScrollPane getMainComponent() {
        return this.mainComponent;
    }

    @NotNull
    public final JavaScriptDebugProcess<?> getDebugProcess() {
        return this.debugProcess;
    }

    @Nullable
    public final FileNode getSelectedNode() {
        SimpleNode simpleNode = this.tree.getSelectedNode();
        if (!(simpleNode instanceof FileNode)) {
            simpleNode = null;
        }
        return (FileNode)simpleNode;
    }

    @NotNull
    public final JComponent getDefaultFocusedComponent() {
        return (JComponent)this.tree;
    }

    private final DefaultActionGroup createPopupGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new OpenScriptSourceAction(this));
        WebBrowser browser = this.debugProcess.getConnection().getBrowser();
        if (browser == null || browser.getFamily() == BrowserFamily.CHROME) {
            group.add((AnAction)new OpenActualScriptSourceAction(this));
            group.add((AnAction)new VisualizeScriptSourcemap(this));
        }
        return group;
    }

    public SourcesTreeComponent(@NotNull SourceTabManager sourceTabManager) {
        Intrinsics.checkParameterIsNotNull((Object)sourceTabManager, (String)"sourceTabManager");
        this.tree = new SimpleTree();
        this.treeBuilder = new SimpleTreeBuilder((JTree)this.tree, this.tree.getBuilderModel(), (AbstractTreeStructure)new SourcesTreeStructure(sourceTabManager), (Comparator)new WeightBasedComparator(true));
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)this.tree));
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane, (String)"ScrollPaneFactory.createScrollPane(tree)");
        this.mainComponent = jScrollPane;
        this.debugProcess = sourceTabManager.getDebugProcess();
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.treeBuilder.initRootNode();
        sourceTabManager.setTreeBuilder(this.treeBuilder);
        XDebugSession xDebugSession = this.debugProcess.getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
        SetLocalPathForScriptAction setLocalPathForScriptAction = xDebugSession.getRunProfile() instanceof JavaScriptDebugConfiguration ? new SetLocalPathForScriptAction(this) : null;
        final DefaultActionGroup fileGroup = this.createPopupGroup();
        final DefaultActionGroup dirGroup = null;
        if (setLocalPathForScriptAction != null) {
            dirGroup = new DefaultActionGroup();
            dirGroup.add((AnAction)setLocalPathForScriptAction);
            fileGroup.add((AnAction)setLocalPathForScriptAction);
        } else {
            dirGroup = null;
        }
        this.tree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(@NotNull Component comp, int x, int y) {
                block1: {
                    DefaultActionGroup group;
                    Intrinsics.checkParameterIsNotNull((Object)comp, (String)"comp");
                    FileNode fileNode = this.getSelectedNode();
                    if (fileNode == null) break block1;
                    FileNode fileNode2 = fileNode;
                    boolean bl = false;
                    boolean bl2 = false;
                    FileNode it = fileNode2;
                    boolean bl3 = false;
                    DefaultActionGroup defaultActionGroup = group = it.getFileInfo().isFile() ? fileGroup : dirGroup;
                    if (group != null) {
                        ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group);
                        Intrinsics.checkExpressionValueIsNotNull((Object)actionPopupMenu, (String)"ActionManager.getInstanc\u2026ionPlaces.UNKNOWN, group)");
                        actionPopupMenu.getComponent().show(comp, x, y);
                    }
                }
            }
        });
    }
}

