/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.sourcemap.PreloadedSourceMapList;
import com.intellij.javascript.debugger.sourcemap.SourceMapLoaderKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.NettyKt;
import com.intellij.util.io.PathKt;
import com.intellij.xdebugger.XDebuggerManager;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.WebServerFileHandlerKt;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.io.FileResponses;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/SourceMapDetectorFileHandler;", "Lorg/jetbrains/builtInWebServer/WebServerFileHandler;", "()V", "process", "", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "canonicalPath", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "channel", "Lio/netty/channel/Channel;", "projectNameIfNotCustomHost", "", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "intellij.javascript.debugger"})
final class SourceMapDetectorFileHandler
extends WebServerFileHandler {
    public boolean process(@NotNull PathInfo pathInfo, @NotNull CharSequence canonicalPath, @NotNull Project project, @NotNull FullHttpRequest request, @NotNull Channel channel, @Nullable String projectNameIfNotCustomHost, @NotNull HttpHeaders extraHeaders) {
        Object object;
        boolean bl;
        int n;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)pathInfo, (String)"pathInfo");
        Intrinsics.checkParameterIsNotNull((Object)canonicalPath, (String)"canonicalPath");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull((Object)extraHeaders, (String)"extraHeaders");
        Path file2 = pathInfo.getIoFile();
        if (file2 == null || !StringsKt.endsWith((String)((Object)file2.getFileName()).toString(), (String)".js", (boolean)true)) {
            return false;
        }
        List list = XDebuggerManager.getInstance((Project)project).getDebugProcesses(JavaScriptDebugProcess.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"XDebuggerManager.getInst\u2026DebugProcess::class.java)");
        List debugProcesses = list;
        if (debugProcesses.isEmpty()) {
            return false;
        }
        String string2 = SourceMapLoaderKt.getSourceMapUrl(file2);
        if (string2 == null) {
            return false;
        }
        String sourceMapUrl = string2;
        String string3 = NettyKt.getHost((HttpRequest)((HttpRequest)request));
        if (string3 == null) {
            return false;
        }
        String host = string3;
        Url scriptUrl = Urls.newUrl((String)NettyKt.getUriScheme((Channel)channel), (String)host, (String)WebServerFileHandlerKt.getRequestPath((CharSequence)canonicalPath, (String)projectNameIfNotCustomHost));
        Url parsedUrl = SourceMapLoaderKt.canonicalizeUrl(sourceMapUrl, scriptUrl);
        if (!JsFileUtil.isOnBuiltInWebServer(parsedUrl)) {
            return false;
        }
        String string4 = parsedUrl.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"parsedUrl.path");
        String path = string4;
        if (projectNameIfNotCustomHost == null) {
            string = path;
            n = 1;
            bl = false;
            String string5 = string;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            path = string6;
        } else if (path.length() > projectNameIfNotCustomHost.length() + 1 && StringsKt.startsWith$default((String)path, (String)projectNameIfNotCustomHost, (int)1, (boolean)false, (int)4, null) && path.charAt(projectNameIfNotCustomHost.length() + 1) == '/') {
            string = path;
            n = projectNameIfNotCustomHost.length() + 1;
            bl = false;
            String string7 = string;
            if (string7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
            path = string8;
        } else {
            Logger $this$debug$iv = JavaScriptDebugProcessKt.getLOG();
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv;
                boolean bl2 = false;
                String string9 = "SourceMap " + parsedUrl + " doesn't belong to current project " + projectNameIfNotCustomHost;
                logger.debug(string9, (Throwable)e$iv);
            }
            return false;
        }
        if ((object = WebServerPathToFileManager.getPathInfo$default((WebServerPathToFileManager)WebServerPathToFileManager.Companion.getInstance(project), (String)path, (boolean)false, null, (int)6, null)) == null || (object = object.getIoFile()) == null) {
            return false;
        }
        Object sourceMapFile = object;
        CharSequence sourceMapData = PathKt.readChars((Path)sourceMapFile);
        SmartList promises = new SmartList();
        for (JavaScriptDebugProcess debugProcess : debugProcesses) {
            SourceMap sourceMap;
            if (debugProcess.isFilesOnlyInLocalFileSystem() || debugProcess.getPreloadedSourceMaps().containsScript(scriptUrl)) continue;
            if (debugProcess.decodeSourceMap(sourceMapData, scriptUrl, true) == null) {
                continue;
            }
            PreloadedSourceMapList.add$default(debugProcess.getPreloadedSourceMaps(), parsedUrl, sourceMap, scriptUrl, null, null, 24, null);
            Vm vm = debugProcess.getMainVm();
            if (vm == null) {
                Intrinsics.throwNpe();
            }
            debugProcess.sourceMapFound(vm, sourceMap, null, scriptUrl, (List)promises);
        }
        Promise $this$processedRun$iv = Promises.all((Collection)((Collection)promises));
        boolean $i$f$processedRun = false;
        Intrinsics.checkExpressionValueIsNotNull((Object)$this$processedRun$iv.onProcessed((Consumer)new Consumer<Object>(request, channel, file2, extraHeaders){
            final /* synthetic */ FullHttpRequest $request$inlined;
            final /* synthetic */ Channel $channel$inlined;
            final /* synthetic */ Path $file$inlined;
            final /* synthetic */ HttpHeaders $extraHeaders$inlined;
            {
                this.$request$inlined = fullHttpRequest;
                this.$channel$inlined = channel;
                this.$file$inlined = path;
                this.$extraHeaders$inlined = httpHeaders;
            }

            public final void accept(@Nullable Object it) {
                boolean bl = false;
                FileResponses.INSTANCE.sendFile((HttpRequest)this.$request$inlined, this.$channel$inlined, this.$file$inlined, this.$extraHeaders$inlined);
            }
        }), (String)"(this as Promise<Any?>).onProcessed { handler() }");
        return true;
    }
}

