/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap.visualizer.actions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.sourcemap.visualizer.SourceMapInspectorKt;
import com.intellij.javascript.debugger.sourcemap.visualizer.actions.AddSourceContentsActionKt;
import com.intellij.javascript.debugger.sourcemap.visualizer.actions.BaseSourceMapAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/visualizer/actions/AddSourceContentsAction;", "Lcom/intellij/javascript/debugger/sourcemap/visualizer/actions/BaseSourceMapAction;", "()V", "perform", "", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.debugger"})
public final class AddSourceContentsAction
extends BaseSourceMapAction {
    @Override
    protected void perform(@NotNull SourceMap sourceMap, @NotNull VirtualFile file2, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)sourceMap, (String)"sourceMap");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(file2, project, sourceMap, project, JSDebuggerBundle.message("js.scripts.visualize.action.add.content", SourceMapInspectorKt.getFileTitle(file2)), true){
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Project $project;
            final /* synthetic */ SourceMap $sourceMap;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                String string;
                boolean bl;
                CharSequence charSequence;
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
                InputStreamReader reader = new InputStreamReader(this.$file.getInputStream(), Charsets.UTF_8);
                Map map = (Map)gson.fromJson((Reader)reader, (Type)((Object)Map.class));
                reader.close();
                if (map.containsKey("sourcesContent")) {
                    NotificationGroup notificationGroup = AddSourceContentsActionKt.access$getNOTIFICATION_GROUP$p();
                    String string2 = JSDebuggerBundle.message("js.scripts.visualize.action.add.content.notification", new Object[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"JSDebuggerBundle.message\u2026dd.content.notification\")");
                    MessageType messageType = MessageType.INFO;
                    Intrinsics.checkExpressionValueIsNotNull((Object)messageType, (String)"MessageType.INFO");
                    notificationGroup.createNotification(string2, messageType).notify(this.$project);
                    return;
                }
                V v = map.get("sources");
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                List sources = (List)v;
                int n = sources.size();
                Object[] objectArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    void it;
                    int n2 = i;
                    int n3 = i;
                    Object[] objectArray2 = objectArray;
                    boolean bl2 = false;
                    VirtualFile virtualFile = SourceMapInspectorKt.getSourceFile(this.$sourceMap.getSources()[it]);
                    if (virtualFile == null) {
                        Intrinsics.throwNpe();
                    }
                    charSequence = VfsUtilCore.loadText((VirtualFile)virtualFile);
                    objectArray2[n3] = charSequence;
                }
                Object[] sourcesContent = objectArray;
                map.put("sourcesContent", ArraysKt.toList((Object[])sourcesContent));
                String string3 = this.$file.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"file.path");
                String path = string3;
                int index = StringsKt.lastIndexOf$default((CharSequence)path, (String)".map", (int)0, (boolean)false, (int)6, null);
                String ext = ".source.map";
                CharSequence charSequence2 = new StringBuilder();
                if (index > -1) {
                    String bl2 = path;
                    int n4 = 0;
                    charSequence = charSequence2;
                    bl = false;
                    String string4 = bl2;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n4, index);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string6 = string5;
                    charSequence2 = charSequence;
                    string = string6;
                } else {
                    string = path;
                }
                String string7 = charSequence2.append(string).append(ext).toString();
                File outFile = new File(string7);
                OutputStreamWriter stream = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), Charsets.UTF_8);
                Closeable closeable = stream;
                bl = false;
                Throwable throwable = null;
                try {
                    OutputStreamWriter it = (OutputStreamWriter)closeable;
                    boolean bl3 = false;
                    gson.toJson((Object)map, (Appendable)it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                LocalFileSystem.getInstance().refreshAndFindFileByIoFile(outFile);
                NotificationGroup notificationGroup = AddSourceContentsActionKt.access$getNOTIFICATION_GROUP$p();
                String string8 = JSDebuggerBundle.message("js.scripts.visualize.action.add.content.notification.created", outFile.getName());
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"JSDebuggerBundle.message\u2026n.created\", outFile.name)");
                MessageType messageType = MessageType.INFO;
                Intrinsics.checkExpressionValueIsNotNull((Object)messageType, (String)"MessageType.INFO");
                notificationGroup.createNotification(string8, messageType).notify(this.$project);
            }
            {
                this.$file = $captured_local_variable$0;
                this.$project = $captured_local_variable$1;
                this.$sourceMap = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        });
    }
}

