/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptorImpl;
import com.intellij.util.xml.highlighting.DomElementResolveProblemDescriptor;
import com.intellij.xml.util.XmlStringUtil;
import org.jetbrains.annotations.Nullable;

public class DomElementsHighlightingUtil {
    private DomElementsHighlightingUtil() {
    }

    @Nullable
    public static ProblemDescriptor createProblemDescriptors(InspectionManager manager, DomElementProblemDescriptor problemDescriptor) {
        ProblemHighlightType problemHighlightType = DomElementsHighlightingUtil.a(problemDescriptor);
        return (ProblemDescriptor)DomElementsHighlightingUtil.a(problemDescriptor, pair -> manager.createProblemDescriptor((PsiElement)pair.second, (TextRange)pair.first, problemDescriptor.getDescriptionTemplate(), problemHighlightType, true, problemDescriptor.getFixes()));
    }

    private static ProblemHighlightType a(DomElementProblemDescriptor domElementProblemDescriptor) {
        TextRange textRange;
        if (domElementProblemDescriptor.getHighlightType() != null) {
            return domElementProblemDescriptor.getHighlightType();
        }
        if (domElementProblemDescriptor instanceof DomElementResolveProblemDescriptor && (textRange = ((DomElementResolveProblemDescriptor)domElementProblemDescriptor).getPsiReference().getRangeInElement()).getStartOffset() != textRange.getEndOffset()) {
            return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
        }
        return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }

    @Nullable
    public static Annotation createAnnotation(DomElementProblemDescriptor problemDescriptor) {
        return (Annotation)DomElementsHighlightingUtil.a(problemDescriptor, pair -> {
            String string = problemDescriptor.getDescriptionTemplate();
            if (StringUtil.isEmpty((String)string)) {
                string = null;
            }
            HighlightSeverity highlightSeverity = problemDescriptor.getHighlightSeverity();
            TextRange textRange = (TextRange)pair.first;
            if (string == null) {
                textRange = TextRange.from((int)textRange.getStartOffset(), (int)0);
            }
            textRange = textRange.shiftRight(((PsiElement)pair.second).getTextRange().getStartOffset());
            String string2 = string == null ? null : XmlStringUtil.wrapInHtml((CharSequence)XmlStringUtil.escapeString((String)string));
            Annotation annotation = new Annotation(textRange.getStartOffset(), textRange.getEndOffset(), highlightSeverity, string, string2);
            if (problemDescriptor instanceof DomElementResolveProblemDescriptor) {
                annotation.setTextAttributes(CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES);
            }
            for (LocalQuickFix localQuickFix : problemDescriptor.getFixes()) {
                if (!(localQuickFix instanceof IntentionAction)) continue;
                annotation.registerFix((IntentionAction)localQuickFix);
            }
            return annotation;
        });
    }

    @Nullable
    private static <T> T a(DomElementProblemDescriptor domElementProblemDescriptor, Function<? super Pair<TextRange, PsiElement>, ? extends T> function) {
        Pair<TextRange, PsiElement> pair = ((DomElementProblemDescriptorImpl)domElementProblemDescriptor).getProblemRange();
        return (T)(pair == DomElementProblemDescriptorImpl.NO_PROBLEM || !((PsiElement)pair.second).isPhysical() ? null : function.fun(pair));
    }
}

