/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import a.d.la;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xmlb.annotations.Attribute;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class DomFileMetaData
extends AbstractExtensionPointBean {
    static final ExtensionPointName<DomFileMetaData> EP_NAME;
    @Attribute(value="implementation")
    public String implementation;
    @Attribute(value="rootTagName")
    @Nullable
    public String rootTagName;
    @Attribute(value="domVersion")
    public int domVersion;
    @Attribute(value="stubVersion")
    @Nullable
    public Integer stubVersion;
    volatile DomFileDescription<?> lazyInstance;
    private static final long a;

    public DomFileMetaData() {
    }

    public DomFileMetaData(DomFileDescription<?> description) {
        this.lazyInstance = description;
        this.implementation = description.getClass().getName();
        this.rootTagName = description.acceptsOtherRootTagNames() ? null : description.getRootTagName();
        this.domVersion = description.getVersion();
        this.stubVersion = description.hasStubs() ? Integer.valueOf(description.getStubVersion()) : null;
    }

    DomFileDescription<?> getDescription() {
        long l2 = a ^ 0x4386A09927A1L;
        DomFileDescription domFileDescription = this.lazyInstance;
        if (domFileDescription == null) {
            try {
                domFileDescription = (DomFileDescription)DomFileMetaData.instantiate((Class)this.findExtensionClass(this.implementation), (PicoContainer)ApplicationManager.getApplication().getPicoContainer());
                if (StringUtil.isEmpty((String)this.rootTagName)) {
                    if (!domFileDescription.acceptsOtherRootTagNames()) {
                        throw new PluginException(this.implementation + " should either specify a root tag name in XML, or return true from 'acceptsOtherRootTagNames'", this.getPluginId());
                    }
                } else if (!this.rootTagName.equals(domFileDescription.getRootTagName())) {
                    throw new PluginException(this.implementation + " XML declaration should have " + domFileDescription.getRootTagName() + " root tag name", this.getPluginId());
                }
                DomApplicationComponent.getInstance().initDescription(domFileDescription);
                this.lazyInstance = domFileDescription;
            }
            catch (PluginException | ProcessCanceledException throwable) {
                throw throwable;
            }
            catch (Exception exception) {
                throw new PluginException((Throwable)exception, this.getPluginId());
            }
        }
        return domFileDescription;
    }

    public boolean hasStubs() {
        return this.stubVersion != null;
    }

    static {
        a = la.a(8951267044871382034L, -4106685917931065667L, MethodHandles.lookup().lookupClass()).a(99186009242525L);
        long l2 = a ^ 0x58AC7087677BL;
        EP_NAME = ExtensionPointName.create((String)"com.intellij.dom.fileMetaData");
    }
}

