/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.tabs.JBTabPainter;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBEditorTabPainter;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabPainterAdapter;
import com.intellij.ui.tabs.impl.themes.TabTheme;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ui/tabs/impl/EditorTabPainterAdapter;", "Lcom/intellij/ui/tabs/impl/TabPainterAdapter;", "()V", "magicOffset", "", "painter", "Lcom/intellij/ui/tabs/impl/JBEditorTabPainter;", "tabPainter", "Lcom/intellij/ui/tabs/JBTabPainter;", "getTabPainter", "()Lcom/intellij/ui/tabs/JBTabPainter;", "paintBackground", "", "label", "Lcom/intellij/ui/tabs/impl/TabLabel;", "g", "Ljava/awt/Graphics;", "tabs", "Lcom/intellij/ui/tabs/impl/JBTabsImpl;", "paintBorders", "Ljava/awt/Graphics2D;", "intellij.platform.ide"})
public final class EditorTabPainterAdapter
implements TabPainterAdapter {
    private final int magicOffset = 1;
    private final JBEditorTabPainter painter = new JBEditorTabPainter();

    @Override
    @NotNull
    public JBTabPainter getTabPainter() {
        return this.painter;
    }

    @Override
    public void paintBackground(@NotNull TabLabel label, @NotNull Graphics g, @NotNull JBTabsImpl tabs) {
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)tabs, (String)"tabs");
        TabInfo info = label.getInfo();
        boolean isSelected = Intrinsics.areEqual((Object)info, (Object)tabs.getSelectedInfo());
        Rectangle rect = new Rectangle(0, 0, label.getWidth(), label.getHeight());
        Graphics2D g2d = (Graphics2D)g;
        if (isSelected) {
            JBTabsPosition jBTabsPosition = tabs.getPosition();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)jBTabsPosition), (String)"tabs.position");
            int n = tabs.getBorderThickness();
            TabInfo tabInfo = info;
            Intrinsics.checkExpressionValueIsNotNull((Object)tabInfo, (String)"info");
            this.painter.paintSelectedTab(jBTabsPosition, g2d, rect, n, tabInfo.getTabColor(), tabs.isActiveTabs(info), tabs.isHoveredTab(label));
            this.paintBorders(g2d, label, tabs);
        } else {
            JBTabsPosition jBTabsPosition = tabs.getPosition();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)jBTabsPosition), (String)"tabs.position");
            int n = tabs.getBorderThickness();
            TabInfo tabInfo = info;
            Intrinsics.checkExpressionValueIsNotNull((Object)tabInfo, (String)"info");
            this.painter.paintTab(jBTabsPosition, g2d, rect, n, tabInfo.getTabColor(), tabs.isActiveTabs(info), tabs.isHoveredTab(label));
            this.paintBorders(g2d, label, tabs);
        }
    }

    private final void paintBorders(Graphics2D g, TabLabel label, JBTabsImpl tabs) {
        if (tabs.getPosition() == JBTabsPosition.top && (Registry.is((String)"ide.new.editor.tabs.vertical.borders") || !tabs.isSingleRow()) || tabs.getPosition() == JBTabsPosition.bottom && Registry.is((String)"ide.new.editor.tabs.vertical.borders")) {
            Rectangle rect = new Rectangle(0, 0, label.getWidth(), label.getHeight());
            Rectangle bounds = label.getBounds();
            if (bounds.x > this.magicOffset) {
                JBTabsPosition jBTabsPosition = tabs.getPosition();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)jBTabsPosition), (String)"tabs.position");
                this.painter.paintLeftGap(jBTabsPosition, g, rect, tabs.getBorderThickness());
            }
            if (bounds.x + bounds.width < tabs.getWidth() - this.magicOffset) {
                JBTabsPosition jBTabsPosition = tabs.getPosition();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)jBTabsPosition), (String)"tabs.position");
                this.painter.paintRightGap(jBTabsPosition, g, rect, tabs.getBorderThickness());
            }
        }
    }

    @Override
    @NotNull
    public TabTheme getTabTheme() {
        return TabPainterAdapter.DefaultImpls.getTabTheme(this);
    }
}

