/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DarculaColors;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.usageView.UsageTreeColors;
import com.intellij.usageView.UsageTreeColorsScheme;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.FontUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

class UsageViewTreeCellRenderer
extends ColoredTreeCellRenderer {
    private static final Logger LOG = Logger.getInstance(UsageViewTreeCellRenderer.class);
    private static final EditorColorsScheme ourColorsScheme = UsageTreeColorsScheme.getInstance().getScheme();
    private static final SimpleTextAttributes ourInvalidAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)ourColorsScheme.getAttributes(UsageTreeColors.INVALID_PREFIX));
    private static final SimpleTextAttributes ourReadOnlyAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)ourColorsScheme.getAttributes(UsageTreeColors.READONLY_PREFIX));
    private static final SimpleTextAttributes ourNumberOfUsagesAttribute = SimpleTextAttributes.fromTextAttributes((TextAttributes)ourColorsScheme.getAttributes(UsageTreeColors.NUMBER_OF_USAGES));
    private static final SimpleTextAttributes ourInvalidAttributesDarcula = new SimpleTextAttributes(null, DarculaColors.RED, null, ourInvalidAttributes.getStyle());
    private static final Insets STANDARD_IPAD_NOWIFI = JBUI.insets((int)1, (int)2);
    private static final TextChunk[] ourLoadingText = new TextChunk[]{new TextChunk(SimpleTextAttributes.GRAY_ATTRIBUTES.toTextAttributes(), "loading...")};
    private boolean myRowBoundsCalled;
    private final UsageViewPresentation myPresentation;
    private final UsageViewImpl myView;
    private boolean myCalculated;
    private int myRowHeight;
    private Dimension cachedPreferredSize;

    UsageViewTreeCellRenderer(@NotNull UsageViewImpl view) {
        if (view == null) {
            UsageViewTreeCellRenderer.$$$reportNull$$$0(0);
        }
        this.myRowHeight = AllIcons.Nodes.AbstractClass.getIconHeight() + 2;
        this.myView = view;
        this.myPresentation = view.getPresentation();
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return this.myCalculated ? super.getPreferredSize() : new Dimension(10, this.myRowHeight);
    }

    @Override
    @DirtyUI
    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            UsageViewTreeCellRenderer.$$$reportNull$$$0(1);
        }
        boolean showAsReadOnly = false;
        if (value instanceof Node && value != tree.getModel().getRoot()) {
            Node node = (Node)value;
            if (!node.isValid()) {
                this.append(UsageViewBundle.message("node.invalid", new Object[0]) + " ", StartupUiUtil.isUnderDarcula() ? ourInvalidAttributesDarcula : ourInvalidAttributes);
            }
            if (this.myPresentation.isShowReadOnlyStatusAsRed() && node.isReadOnly()) {
                showAsReadOnly = true;
            }
        }
        this.myCalculated = false;
        if (value instanceof DefaultMutableTreeNode) {
            Node node;
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
            Object userObject = treeNode.getUserObject();
            Rectangle visibleRect = ((JViewport)tree.getParent()).getViewRect();
            if (!visibleRect.isEmpty()) {
                RowLocation visible = this.myRowBoundsCalled ? RowLocation.INSIDE_VISIBLE_RECT : this.isRowVisible(row, visibleRect);
                this.myRowBoundsCalled = false;
                if (visible != RowLocation.INSIDE_VISIBLE_RECT) {
                    return;
                }
                if (!this.getIpad().equals(STANDARD_IPAD_NOWIFI)) {
                    this.setIpad(STANDARD_IPAD_NOWIFI);
                }
            }
            if (this.myCalculated) {
                return;
            }
            this.myCalculated = true;
            if (userObject instanceof UsageTarget) {
                String text;
                LOG.assertTrue(treeNode instanceof Node);
                if (!((Node)treeNode).isValid()) {
                    if (!this.getCharSequence(false).toString().contains(UsageViewBundle.message("node.invalid", new Object[0]))) {
                        this.append(UsageViewBundle.message("node.invalid", new Object[0]), ourInvalidAttributes);
                    }
                    return;
                }
                UsageTarget usageTarget = (UsageTarget)userObject;
                ItemPresentation presentation = usageTarget.getPresentation();
                LOG.assertTrue(presentation != null);
                if (showAsReadOnly) {
                    this.append(UsageViewBundle.message("node.readonly", new Object[0]) + " ", ourReadOnlyAttributes);
                }
                this.append((text = presentation.getPresentableText()) == null ? "" : text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.setIcon(presentation.getIcon(expanded));
            } else if (treeNode instanceof GroupNode) {
                node = (GroupNode)treeNode;
                if (node.isRoot()) {
                    this.append(StringUtil.capitalize((String)this.myPresentation.getUsagesWord()), UsageViewTreeCellRenderer.patchAttrs(node, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES));
                } else {
                    this.append(((GroupNode)node).getGroup().getText(this.myView), UsageViewTreeCellRenderer.patchAttrs(node, showAsReadOnly ? ourReadOnlyAttributes : SimpleTextAttributes.REGULAR_ATTRIBUTES));
                    this.setIcon(((GroupNode)node).getGroup().getIcon(expanded));
                }
                int count = ((GroupNode)node).getRecursiveUsageCount();
                SimpleTextAttributes attributes = UsageViewTreeCellRenderer.patchAttrs(node, ourNumberOfUsagesAttribute);
                this.append(FontUtil.spaceAndThinSpace() + StringUtil.pluralize((String)(count + " " + this.myPresentation.getUsagesWord()), (int)count), SimpleTextAttributes.GRAYED_ATTRIBUTES.derive(attributes.getStyle(), null, null, null));
            } else if (treeNode instanceof UsageNode) {
                node = (UsageNode)treeNode;
                this.setIcon(((UsageNode)node).getUsage().getPresentation().getIcon());
                if (showAsReadOnly) {
                    this.append(UsageViewBundle.message("node.readonly", new Object[0]) + " ", UsageViewTreeCellRenderer.patchAttrs(node, ourReadOnlyAttributes));
                }
                if (node.isValid()) {
                    TextChunk[] text = ((UsageNode)node).getUsage().getPresentation().getCachedText();
                    if (text == null) {
                        text = ourLoadingText;
                        node.forceUpdate();
                        this.myView.updateLater();
                    }
                    for (int i = 0; i < text.length; ++i) {
                        TextChunk textChunk = text[i];
                        SimpleTextAttributes simples = textChunk.getSimpleAttributesIgnoreBackground();
                        this.append(textChunk.getText() + (i == 0 ? " " : ""), UsageViewTreeCellRenderer.patchAttrs(node, simples), true);
                    }
                }
            } else if (userObject instanceof String) {
                this.append((String)userObject, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            } else {
                this.append(userObject == null ? "" : userObject.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        } else {
            this.append(value.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        SpeedSearchUtil.applySpeedSearchHighlighting(tree, this, true, this.mySelected);
    }

    @NotNull
    String getPlainTextForNode(Object value) {
        boolean showAsReadOnly = false;
        StringBuilder result = new StringBuilder();
        if (value instanceof Node) {
            Node node = (Node)value;
            if (!node.isValid()) {
                result.append(UsageViewBundle.message("node.invalid", new Object[0])).append(" ");
            }
            if (this.myPresentation.isShowReadOnlyStatusAsRed() && node.isReadOnly()) {
                showAsReadOnly = true;
            }
        }
        if (value instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
            Object userObject = treeNode.getUserObject();
            if (userObject instanceof UsageTarget) {
                UsageTarget usageTarget = (UsageTarget)userObject;
                if (usageTarget.isValid()) {
                    String text;
                    ItemPresentation presentation = usageTarget.getPresentation();
                    LOG.assertTrue(presentation != null);
                    if (showAsReadOnly) {
                        result.append(UsageViewBundle.message("node.readonly", new Object[0])).append(" ");
                    }
                    result.append((text = presentation.getPresentableText()) == null ? "" : text);
                } else {
                    result.append(UsageViewBundle.message("node.invalid", new Object[0]));
                }
            } else if (treeNode instanceof GroupNode) {
                GroupNode node = (GroupNode)treeNode;
                if (node.isRoot()) {
                    result.append(StringUtil.capitalize((String)this.myPresentation.getUsagesWord()));
                } else {
                    result.append(node.getGroup().getText(this.myView));
                }
                int count = node.getRecursiveUsageCount();
                result.append(" (").append(StringUtil.pluralize((String)(count + " " + this.myPresentation.getUsagesWord()), (int)count)).append(")");
            } else if (treeNode instanceof UsageNode) {
                UsageNode node = (UsageNode)treeNode;
                if (showAsReadOnly) {
                    result.append(UsageViewBundle.message("node.readonly", new Object[0])).append(" ");
                }
                if (node.isValid()) {
                    TextChunk[] text;
                    for (TextChunk textChunk : text = node.getUsage().getPresentation().getText()) {
                        result.append(textChunk.getText());
                    }
                }
            } else if (userObject instanceof String) {
                result.append((String)userObject);
            } else {
                result.append(userObject == null ? "" : userObject.toString());
            }
        } else {
            result.append(value);
        }
        String string = result.toString();
        if (string == null) {
            UsageViewTreeCellRenderer.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    RowLocation isRowVisible(int row, @NotNull Rectangle visibleRect) {
        Dimension pref;
        if (visibleRect == null) {
            UsageViewTreeCellRenderer.$$$reportNull$$$0(3);
        }
        if (this.cachedPreferredSize == null) {
            this.cachedPreferredSize = pref = this.getPreferredSize();
        } else {
            pref = this.cachedPreferredSize;
        }
        pref.width = Math.max(visibleRect.width, pref.width);
        this.myRowBoundsCalled = true;
        JTree tree = this.getTree();
        Rectangle bounds = tree == null ? null : tree.getRowBounds(row);
        this.myRowBoundsCalled = false;
        if (bounds != null) {
            this.myRowHeight = bounds.height;
        }
        int y = bounds == null ? 0 : bounds.y;
        TextRange vis = TextRange.from((int)Math.max(0, visibleRect.y - pref.height), (int)(visibleRect.height + pref.height * 2));
        boolean inside = vis.contains(y);
        if (inside) {
            RowLocation rowLocation = RowLocation.INSIDE_VISIBLE_RECT;
            if (rowLocation == null) {
                UsageViewTreeCellRenderer.$$$reportNull$$$0(4);
            }
            return rowLocation;
        }
        RowLocation rowLocation = y < vis.getStartOffset() ? RowLocation.BEFORE_VISIBLE_RECT : RowLocation.AFTER_VISIBLE_RECT;
        if (rowLocation == null) {
            UsageViewTreeCellRenderer.$$$reportNull$$$0(5);
        }
        return rowLocation;
    }

    private static SimpleTextAttributes patchAttrs(@NotNull Node node, @NotNull SimpleTextAttributes original) {
        if (node == null) {
            UsageViewTreeCellRenderer.$$$reportNull$$$0(6);
        }
        if (original == null) {
            UsageViewTreeCellRenderer.$$$reportNull$$$0(7);
        }
        if (node.isExcluded()) {
            original = new SimpleTextAttributes(original.getStyle() | 4, original.getFgColor(), original.getWaveColor());
        }
        if (node instanceof GroupNode) {
            DefaultMutableTreeNode parent;
            FileStatus fileStatus;
            UsageGroup group = ((GroupNode)node).getGroup();
            FileStatus fileStatus2 = fileStatus = group != null ? group.getFileStatus() : null;
            if (fileStatus != null && fileStatus != FileStatus.NOT_CHANGED) {
                original = new SimpleTextAttributes(original.getStyle(), fileStatus.getColor(), original.getWaveColor());
            }
            if ((parent = (DefaultMutableTreeNode)node.getParent()) != null && parent.isRoot()) {
                original = new SimpleTextAttributes(original.getStyle() | 1, original.getFgColor(), original.getWaveColor());
            }
        }
        return original;
    }

    static String getTooltipFromPresentation(Object value) {
        DefaultMutableTreeNode treeNode;
        if (value instanceof DefaultMutableTreeNode && (treeNode = (DefaultMutableTreeNode)value) instanceof UsageNode) {
            UsageNode node = (UsageNode)treeNode;
            return node.getUsage().getPresentation().getTooltipText();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/impl/UsageViewTreeCellRenderer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRect";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/impl/UsageViewTreeCellRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlainTextForNode";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "isRowVisible";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "customizeCellRenderer";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isRowVisible";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "patchAttrs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum RowLocation {
        BEFORE_VISIBLE_RECT,
        INSIDE_VISIBLE_RECT,
        AFTER_VISIBLE_RECT;

    }
}

