/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.documentation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.intellij.javascript.nodejs.packageJson.documentation.PackageJsonEntry;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PackageJsonEntries {
    private static final Logger LOG = Logger.getInstance(PackageJsonEntries.class);
    private final ImmutableList<PackageJsonEntry> myEntries;
    private final ImmutableMap<String, PackageJsonEntry> myEntryByNameMap;

    private PackageJsonEntries(@NotNull List<PackageJsonEntry> entries) {
        if (entries == null) {
            PackageJsonEntries.$$$reportNull$$$0(0);
        }
        this.myEntries = ImmutableList.copyOf(entries);
        HashMap entryByNameMap = Maps.newHashMapWithExpectedSize((int)entries.size());
        for (PackageJsonEntry entry : entries) {
            PackageJsonEntry oldEntry = entryByNameMap.put(entry.getName(), entry);
            if (oldEntry == null) continue;
            throw new RuntimeException("Duplicated package.json entry: " + entry.getName());
        }
        this.myEntryByNameMap = ImmutableMap.copyOf((Map)entryByNameMap);
    }

    @Nullable
    public static PackageJsonEntry findEntryByName(@NotNull String name) {
        if (name == null) {
            PackageJsonEntries.$$$reportNull$$$0(1);
        }
        return (PackageJsonEntry)Holder.INSTANCE.myEntryByNameMap.get((Object)name);
    }

    @NotNull
    private static PackageJsonEntries parseFromXml() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            String content = PackageJsonEntries.loadText();
            InputSource source = new InputSource(new StringReader(content));
            Document document2 = db.parse(source);
            return PackageJsonEntries.fromDocument(document2);
        }
        catch (Exception e) {
            LOG.error("Can't parse package.json documentation :(", (Throwable)e);
            return new PackageJsonEntries(Collections.emptyList());
        }
    }

    @NotNull
    private static String loadText() throws IOException {
        InputStream in = PackageJsonEntries.class.getResourceAsStream("package-json-documentation.xml");
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        String string = FileUtil.loadTextAndClose((Reader)reader);
        if (string == null) {
            PackageJsonEntries.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static PackageJsonEntries fromDocument(@NotNull Document document2) {
        if (document2 == null) {
            PackageJsonEntries.$$$reportNull$$$0(3);
        }
        ArrayList<PackageJsonEntry> entries = new ArrayList<PackageJsonEntry>();
        Element entriesElement = PackageJsonEntries.getTheOnlyChildElementWithTagName(document2, "entries");
        List<Element> entryChildren = PackageJsonEntries.getChildElementsByTagName(entriesElement, "entry");
        for (Element entryElement : entryChildren) {
            PackageJsonEntry entry = PackageJsonEntries.createEntry(entryElement);
            List<String> aliases = PackageJsonEntries.createAliases(entryElement);
            entries.add(entry);
            for (String alias : aliases) {
                entries.add(new PackageJsonEntry(alias, entry.getShortDescription(), entry.getHtmlFullDescription()));
            }
        }
        return new PackageJsonEntries(entries);
    }

    @NotNull
    private static Element getTheOnlyChildElementWithTagName(@NotNull Node parentNode, @NotNull String childTagName) {
        List<Element> children;
        if (parentNode == null) {
            PackageJsonEntries.$$$reportNull$$$0(4);
        }
        if (childTagName == null) {
            PackageJsonEntries.$$$reportNull$$$0(5);
        }
        if ((children = PackageJsonEntries.getChildElementsByTagName(parentNode, childTagName)).size() != 1) {
            throw new RuntimeException("The only child is expected, but found: " + children.size());
        }
        Element element = children.get(0);
        if (element == null) {
            PackageJsonEntries.$$$reportNull$$$0(6);
        }
        return element;
    }

    @NotNull
    private static List<Element> getChildElementsByTagName(@NotNull Node parentNode, @NotNull String childTagName) {
        if (parentNode == null) {
            PackageJsonEntries.$$$reportNull$$$0(7);
        }
        if (childTagName == null) {
            PackageJsonEntries.$$$reportNull$$$0(8);
        }
        ArrayList<Element> children = new ArrayList<Element>();
        NodeList nodeList = parentNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element childElement = (Element)ObjectUtils.tryCast((Object)nodeList.item(i), Element.class);
            if (childElement == null || !childTagName.equals(childElement.getTagName())) continue;
            children.add(childElement);
        }
        ArrayList<Element> arrayList = children;
        if (arrayList == null) {
            PackageJsonEntries.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    private static PackageJsonEntry createEntry(@NotNull Element entryElement) {
        if (entryElement == null) {
            PackageJsonEntries.$$$reportNull$$$0(10);
        }
        String name = PackageJsonEntries.getMandatoryAttribute(entryElement, "name");
        Element shortDescriptionElement = PackageJsonEntries.getTheOnlyChildElementWithTagName(entryElement, "short-description");
        String shortDescription = shortDescriptionElement.getTextContent();
        Element fullDescriptionElement = PackageJsonEntries.getTheOnlyChildElementWithTagName(entryElement, "full-description");
        String fullHtmlDescription = fullDescriptionElement.getTextContent();
        if (!fullHtmlDescription.startsWith("<html>")) {
            fullHtmlDescription = "<html><body>" + fullHtmlDescription + "</body></html>";
        }
        return new PackageJsonEntry(name, shortDescription, fullHtmlDescription);
    }

    @NotNull
    private static List<String> createAliases(@NotNull Element entryElement) {
        List<Element> aliasesElementList;
        if (entryElement == null) {
            PackageJsonEntries.$$$reportNull$$$0(11);
        }
        if ((aliasesElementList = PackageJsonEntries.getChildElementsByTagName(entryElement, "aliases")).isEmpty()) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                PackageJsonEntries.$$$reportNull$$$0(12);
            }
            return list2;
        }
        ArrayList<String> aliases = new ArrayList<String>();
        for (Element aliasesElement : aliasesElementList) {
            List<Element> aliasElementList = PackageJsonEntries.getChildElementsByTagName(aliasesElement, "alias");
            for (Element aliasElement : aliasElementList) {
                aliases.add(aliasElement.getTextContent());
            }
        }
        ArrayList<String> arrayList = aliases;
        if (arrayList == null) {
            PackageJsonEntries.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    private static String getMandatoryAttribute(@NotNull Element element, @NotNull String attrName) {
        String value;
        if (element == null) {
            PackageJsonEntries.$$$reportNull$$$0(14);
        }
        if (attrName == null) {
            PackageJsonEntries.$$$reportNull$$$0(15);
        }
        if (StringUtil.isEmpty((String)(value = element.getAttribute(attrName)))) {
            throw new RuntimeException("No '" + attrName + "' attribute!");
        }
        String string = value;
        if (string == null) {
            PackageJsonEntries.$$$reportNull$$$0(16);
        }
        return string;
    }

    static /* synthetic */ PackageJsonEntries access$100() {
        return PackageJsonEntries.parseFromXml();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/documentation/PackageJsonEntries";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTagName";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/documentation/PackageJsonEntries";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTheOnlyChildElementWithTagName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildElementsByTagName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createAliases";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getMandatoryAttribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findEntryByName";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromDocument";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTheOnlyChildElementWithTagName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getChildElementsByTagName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createEntry";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createAliases";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMandatoryAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Holder {
        private static final PackageJsonEntries INSTANCE = PackageJsonEntries.access$100();

        private Holder() {
        }
    }
}

