/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.settings;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryConfigurator;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.javascript.nodejs.settings.NodeVersionListener;
import com.intellij.javascript.nodejs.settings.nodeCoreLibrary.MultiModuleNodeCoreLibraryMappingsView;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.NullableConsumer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ui.ModuleScopeSelectionView;
import com.intellij.webcore.libraries.ui.ScriptingContextsConfigurable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeCoreSourcesView
implements NodeVersionListener {
    private final Project myProject;
    private final VirtualFile myRequestor;
    private final ThreeStateCheckBox myCheckBox;
    private final JPanel myPanel;
    private final LinkLabel<Void> myLinkLabel;
    private NodeJsInterpreter myLastInterpreter;
    private SemVer myLastVersion;

    public NodeCoreSourcesView(@NotNull Project project, @Nullable VirtualFile requestor) {
        if (project == null) {
            NodeCoreSourcesView.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myRequestor = requestor;
        this.myCheckBox = new ThreeStateCheckBox(JavaScriptBundle.message((String)"settings.nodejs.coding.assistance.label", (Object[])new Object[0]));
        this.myCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeCoreSourcesView.this.selectionChanged(!ThreeStateCheckBox.State.NOT_SELECTED.equals((Object)NodeCoreSourcesView.this.myCheckBox.getState()));
            }
        });
        this.myLinkLabel = new LinkLabel(JavaScriptBundle.message((String)"settings.nodejs.coding.assistance.manage.scopes.label", (Object[])new Object[0]), null, (LinkListener)new LinkListener<Void>(){

            public void linkSelected(LinkLabel aSource, Void aLinkData) {
                NodeCoreSourcesView.this.showUsageScopeDialog();
            }
        });
        this.myPanel = SwingHelper.newHorizontalPanel((float)0.5f, (Component[])new Component[]{this.myCheckBox, Box.createHorizontalStrut(JBUIScale.scale((int)10)), this.myLinkLabel});
        this.myCheckBox.setEnabled(false);
        this.myLinkLabel.setEnabled(false);
    }

    private void selectionChanged(boolean selected) {
        this.myCheckBox.setSelected(selected);
        if (selected) {
            ModalityState modalityState = ModalityState.current();
            NodeJsInterpreter interpreter = Objects.requireNonNull(this.myLastInterpreter);
            interpreter.provideCachedVersionOrFetch((NullableConsumer<SemVer>)((NullableConsumer)version -> ApplicationManager.getApplication().invokeLater(() -> {
                if (version != null) {
                    NodeCoreSourcesView.enableCodeAssistance(this.myProject, interpreter, version, this.myRequestor, () -> this.handleVersionUpdated(this.myLastInterpreter, this.myLastVersion));
                } else {
                    this.handleVersionUpdated(this.myLastInterpreter, this.myLastVersion);
                }
            }, modalityState, this.myProject.getDisposed())));
        } else {
            NodeCoreLibraryConfigurator.getInstance(this.myProject).disable();
            this.handleVersionUpdated(this.myLastInterpreter, this.myLastVersion);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            NodeCoreSourcesView.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @Override
    public void versionUpdateStarted() {
    }

    @Override
    public void versionUpdated(@Nullable NodeJsInterpreter interpreter, @Nullable SemVer version) {
        this.handleVersionUpdated(interpreter, version);
    }

    private void handleVersionUpdated(@Nullable NodeJsInterpreter interpreter, @Nullable SemVer version) {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.myLastInterpreter = interpreter;
        this.myLastVersion = version;
        if (interpreter == null || version == null) {
            this.myCheckBox.setEnabled(false);
            this.myLinkLabel.setEnabled(false);
            return;
        }
        this.myCheckBox.setEnabled(true);
        ThreeStateCheckBox.State state = this.getState();
        this.myCheckBox.setState(state);
        this.myLinkLabel.setEnabled(state != ThreeStateCheckBox.State.NOT_SELECTED);
    }

    @NotNull
    private ThreeStateCheckBox.State getState() {
        ThreeStateCheckBox.State state = (ThreeStateCheckBox.State)ReadAction.compute(() -> {
            JSLibraryManager libraryManager = JSLibraryManager.getInstance(this.myProject);
            ScriptingLibraryModel coreLibrary = libraryManager.getLibraryByName("Node.js Core");
            if (coreLibrary == null) {
                return ThreeStateCheckBox.State.NOT_SELECTED;
            }
            List<VirtualFile> roots2 = NodeCoreLibraryManager.getInstance(this.myProject).getAssociatedRoots();
            if (roots2.contains(null)) {
                return ThreeStateCheckBox.State.SELECTED;
            }
            if (roots2.isEmpty()) {
                return ThreeStateCheckBox.State.NOT_SELECTED;
            }
            return ThreeStateCheckBox.State.DONT_CARE;
        });
        if (state == null) {
            NodeCoreSourcesView.$$$reportNull$$$0(2);
        }
        return state;
    }

    public static void enableCodeAssistance(@NotNull Project project, @NotNull NodeJsInterpreter interpreter, @NotNull SemVer version, @Nullable VirtualFile requestor, @Nullable Runnable onDone) {
        if (project == null) {
            NodeCoreSourcesView.$$$reportNull$$$0(3);
        }
        if (interpreter == null) {
            NodeCoreSourcesView.$$$reportNull$$$0(4);
        }
        if (version == null) {
            NodeCoreSourcesView.$$$reportNull$$$0(5);
        }
        NodeCoreLibraryConfigurator configurator = NodeCoreLibraryConfigurator.getInstance(project);
        if (PlatformUtils.isIntelliJ()) {
            List<VirtualFile> roots2 = new MultiModuleNodeCoreLibraryMappingsView(project, new ModuleScopeSelectionView(project, requestor, true, false)).getRoots();
            if (roots2 != null) {
                configurator.configureAndAssociateWith(interpreter, version, roots2, onDone);
            }
        } else {
            configurator.configureAndAssociateWithProject(interpreter, version, onDone);
        }
    }

    private void showUsageScopeDialog() {
        JSLibraryMappings mappings = JSLibraryMappings.getInstance(this.myProject);
        boolean ok = ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)new ScriptingContextsConfigurable(this.myProject, (ScriptingLibraryMappings)mappings));
        if (ok) {
            ApplicationManager.getApplication().runWriteAction(() -> JSLibraryManager.getInstance(this.myProject).commitChanges());
            this.handleVersionUpdated(this.myLastInterpreter, this.myLastVersion);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/settings/NodeCoreSourcesView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/settings/NodeCoreSourcesView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "enableCodeAssistance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

