/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.application.Topics;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.ide.FrameStateListener;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.download.DownloadableNodePackage;
import com.intellij.javascript.nodejs.interpreter.download.NodeJsDownloadableInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodePackage;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.javascript.nodejs.util.NodePackageRefResolver;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultNodePackageRefResolver
implements NodePackageRefResolver {
    private final Project myProject;
    private final NodePackageDescriptor myDescriptor;
    private final Supplier<? extends NodeJsInterpreter> myInterpreterSupplier;
    private final Map<String, NodePackage> myCache;
    private NodeJsLocalInterpreter myCacheInterpreter;

    public DefaultNodePackageRefResolver(@Nullable Project project, @NotNull NodePackageDescriptor descriptor2, @Nullable Supplier<? extends NodeJsInterpreter> interpreterSupplier) {
        if (descriptor2 == null) {
            DefaultNodePackageRefResolver.$$$reportNull$$$0(0);
        }
        this.myCache = new HashMap<String, NodePackage>();
        this.myProject = project;
        this.myDescriptor = descriptor2;
        this.myInterpreterSupplier = interpreterSupplier;
        Topics.subscribe((Topic)FrameStateListener.TOPIC, (Disposable)((Disposable)ObjectUtils.chooseNotNull((Object)project, (Object)ApplicationManager.getApplication())), (Object)new FrameStateListener(){

            public void onFrameDeactivated() {
                DefaultNodePackageRefResolver.this.myCache.clear();
            }
        });
    }

    @Override
    @Nullable
    public NodePackage resolve(@NotNull NodePackageRef ref) {
        NodePackage pkg;
        if (ref == null) {
            DefaultNodePackageRefResolver.$$$reportNull$$$0(1);
        }
        if ((pkg = ref.getConstantPackage()) != null) {
            return pkg;
        }
        return this.resolve(ref, this.myInterpreterSupplier != null ? this.myInterpreterSupplier.get() : null);
    }

    @Override
    @Nullable
    public NodePackage resolve(@NotNull NodePackageRef ref, @Nullable NodeJsInterpreter interpreter) {
        NodePackage pkg;
        if (ref == null) {
            DefaultNodePackageRefResolver.$$$reportNull$$$0(2);
        }
        if (this.myProject != null) {
            ref = this.myDescriptor.dereferenceIfProjectRef(this.myProject, ref);
        }
        if ((pkg = ref.getConstantPackage()) != null) {
            return pkg;
        }
        if (interpreter instanceof WslNodeInterpreter) {
            return WslNodePackage.resolvePackageRefAsWsl((WslNodeInterpreter)interpreter, ref);
        }
        if (interpreter instanceof NodeJsDownloadableInterpreter) {
            return DownloadableNodePackage.resolvePackage((NodeJsDownloadableInterpreter)interpreter, ref);
        }
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter);
        if (localInterpreter == null) {
            return null;
        }
        if (!localInterpreter.equals(this.myCacheInterpreter)) {
            this.myCache.clear();
        }
        this.myCacheInterpreter = localInterpreter;
        String name = ref.getReferenceName();
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return null;
        }
        pkg = this.myCache.get(name);
        if (pkg == null) {
            pkg = DefaultNodePackageRefResolver.findGlobalPackage(localInterpreter, name);
            if (pkg == null && "yarn".equals(name)) {
                pkg = DefaultNodePackageRefResolver.findYarnInPath(name);
            }
            this.myCache.put(name, pkg);
        }
        return pkg;
    }

    @Override
    public boolean isValidPackage(NodePackageRef ref, @Nullable NodePackage pkg) {
        return pkg != null && (this.myProject != null ? pkg.isValid(this.myProject) : pkg.isValid());
    }

    @Nullable
    private static NodePackage findGlobalPackage(@NotNull NodeJsLocalInterpreter interpreter, @NotNull String pkgName) {
        File pkg;
        String dir;
        if (interpreter == null) {
            DefaultNodePackageRefResolver.$$$reportNull$$$0(3);
        }
        if (pkgName == null) {
            DefaultNodePackageRefResolver.$$$reportNull$$$0(4);
        }
        if ("npm".equals(pkgName) && !(dir = interpreter.getNpmPackageDir()).isEmpty() && DefaultNodePackageRefResolver.isPackageDir(pkg = new File(dir))) {
            return new NodePackage(pkg.getAbsolutePath());
        }
        VirtualFile globalNodeModulesDir = interpreter.getGlobalNodeModulesVirtualDir();
        if (globalNodeModulesDir != null && DefaultNodePackageRefResolver.isPackageDir(pkg = new File(globalNodeModulesDir.getPath(), pkgName))) {
            return new NodePackage(pkg.getAbsolutePath());
        }
        return null;
    }

    @Nullable
    private static NodePackage findYarnInPath(@NotNull String pkgName) {
        File file2;
        if (pkgName == null) {
            DefaultNodePackageRefResolver.$$$reportNull$$$0(5);
        }
        if ((file2 = PathEnvironmentVariableUtil.findInPath((String)(SystemInfo.isWindows ? pkgName + ".cmd" : pkgName))) != null) {
            File dir = DefaultNodePackageRefResolver.findPackageDir(file2);
            if (dir != null) {
                return new NodePackage(dir.getAbsolutePath());
            }
            if ("/snap/bin/yarn".equals(file2.getAbsolutePath())) {
                return NpmUtil.YarnSnapPackage.createIfInstalled();
            }
        }
        return null;
    }

    @Nullable
    public static File findPackageDir(@NotNull File exeFile) {
        File root;
        if (exeFile == null) {
            DefaultNodePackageRefResolver.$$$reportNull$$$0(6);
        }
        if (SystemInfo.isWindows) {
            File dir = exeFile.getParentFile();
            if (dir != null && "bin".equalsIgnoreCase(dir.getName())) {
                dir = dir.getParentFile();
            }
            return DefaultNodePackageRefResolver.isPackageDir(dir) ? dir : null;
        }
        File binDir = exeFile.getParentFile();
        File file2 = root = binDir != null ? binDir.getParentFile() : null;
        if (DefaultNodePackageRefResolver.isPackageDir(root)) {
            return root;
        }
        Path path = Paths.get(exeFile.toURI());
        try {
            Path realPath = path.toRealPath(new LinkOption[0]);
            if (!path.toString().equals(realPath.toString())) {
                File libexecDir;
                binDir = new File(realPath.toString()).getParentFile();
                File file3 = root = binDir != null ? binDir.getParentFile() : null;
                if (DefaultNodePackageRefResolver.isPackageDir(root)) {
                    return root;
                }
                if (root != null && DefaultNodePackageRefResolver.isPackageDir(libexecDir = new File(root, "libexec"))) {
                    return libexecDir;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Contract(value="null -> false")
    private static boolean isPackageDir(@Nullable File dir) {
        return dir != null && new File(dir, "package.json").isFile();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkgName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exeFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/util/DefaultNodePackageRefResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resolve";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findGlobalPackage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findYarnInPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findPackageDir";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

