/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSLookupElementRenderer;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.ecmascript6.TypeScriptMemberInfo;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.generation.OverrideMethodsFix;
import com.intellij.lang.javascript.highlighting.JSMethodToImplement;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.lang.javascript.validation.fixes.ImplementJSDocMethodsFix;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMembersFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ClassMemberCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final String GET_PREFIX = "$get$_";
    private static final String SET_PREFIX = "$set$_";
    public static final AtomicNotNullLazyValue<Icon> IMPLEMENTATION = AtomicNotNullLazyValue.createValue(() -> ES6ClassMemberCompletionProvider.getImplCompletionIcon(true));
    public static final AtomicNotNullLazyValue<Icon> OVERRIDE = AtomicNotNullLazyValue.createValue(() -> ES6ClassMemberCompletionProvider.getImplCompletionIcon(false));

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        HashSet<String> existingMembers;
        PsiElement parent;
        PsiElement typeMember;
        if (parameters == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((typeMember = ES6ClassMemberCompletionProvider.findTypeMember(parent = parameters.getPosition().getParent())) == null) {
            return;
        }
        JSClass containingClass = JSUtils.getMemberContainingClass(typeMember);
        if (containingClass == null || containingClass instanceof TypeScriptEnum) {
            return;
        }
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)containingClass);
        HashSet<String> hashSet = existingMembers = typeMember instanceof JSFunction ? null : new HashSet<String>();
        if (!(typeMember instanceof JSFunction)) {
            PsiElement originalField = CompletionUtil.getOriginalOrSelf((PsiElement)typeMember);
            for (JSElement o : containingClass.getMembers()) {
                String name = o.getName();
                if (name == null || o == originalField) continue;
                existingMembers.add(ES6ClassMemberCompletionProvider.prefixName(o, name));
            }
        }
        String nameToCheck = typeMember instanceof JSFunction ? ((JSFunction)typeMember).getName() : null;
        HashSet<JSElement> forCompletion = new HashSet<JSElement>();
        HashMap typeSubstitutors = new HashMap();
        TypeScriptUtil.JSClassHierarchyProcessor processor = (aClass, typeSubstitutor, fromImplements) -> {
            if (aClass.isEquivalentTo((PsiElement)containingClass)) {
                return true;
            }
            for (JSFunction jSFunction : aClass.getFunctions()) {
                if (jSFunction.isConstructor() || ES6ClassMemberCompletionProvider.isPrivate((JSAttributeListOwner)jSFunction) || nameToCheck != null && !nameToCheck.equals(jSFunction.getName())) continue;
                ES6ClassMemberCompletionProvider.addIfValid(existingMembers, forCompletion, (JSQualifiedNamedElement)jSFunction);
            }
            typeSubstitutors.put(aClass, typeSubstitutor);
            if (!isTypeScript || nameToCheck != null) {
                return true;
            }
            for (JSFunction jSFunction : aClass.getFields()) {
                if (ES6ClassMemberCompletionProvider.isPrivate((JSAttributeListOwner)jSFunction)) continue;
                ES6ClassMemberCompletionProvider.addIfValid(existingMembers, forCompletion, (JSQualifiedNamedElement)jSFunction);
            }
            return true;
        };
        JSClassUtils.processClassesInHierarchy(containingClass, true, processor);
        Map<TypeScriptMemberInfo, JSClass> infos = TypeScriptUtil.getMemberInfos(containingClass, true);
        for (TypeScriptMemberInfo info : infos.keySet()) {
            JSElement element;
            if (info.getKind() != TypeScriptMemberInfo.Kind.UNIMPLEMENTED || (element = info.getElement()).getName() == null) continue;
            forCompletion.add(element);
        }
        boolean useOverridesCompletion = JSApplicationSettings.getInstance().isUseOverridesCompletion();
        JSTypeSubstitutor substitutor = null;
        for (JSTypeSubstitutor value : typeSubstitutors.values()) {
            if (substitutor == null) {
                substitutor = value;
                continue;
            }
            substitutor = substitutor.combine(value);
        }
        JSTypeSubstitutor finalSubstitutor = substitutor;
        forCompletion.forEach(el -> result2.consume(ES6ClassMemberCompletionProvider.createLookupElement(el, containingClass, useOverridesCompletion, finalSubstitutor, typeMember instanceof JSFunction)));
    }

    @Nullable
    private static PsiElement findTypeMember(@Nullable PsiElement parent) {
        PsiElement grand;
        if (parent instanceof JSField) {
            return parent;
        }
        if (parent instanceof JSParameter && (grand = parent.getParent()) instanceof JSParameterList) {
            JSParameterListElement[] allParams = ((JSParameterList)grand).getParameters();
            if (allParams.length != 1 || allParams[0] != parent) {
                return null;
            }
            return (PsiElement)ObjectUtils.tryCast((Object)grand.getParent(), JSFunction.class);
        }
        return null;
    }

    private static String prefixName(JSElement o, String name) {
        if (o instanceof JSFunction) {
            if (((JSFunction)o).isGetProperty()) {
                name = GET_PREFIX + name;
            }
            if (((JSFunction)o).isSetProperty()) {
                name = SET_PREFIX + name;
            }
        }
        return name;
    }

    private static void addIfValid(@Nullable HashSet<String> existingMembers, HashSet<JSElement> forCompletion, JSQualifiedNamedElement function2) {
        JSContext jsContext;
        String name = function2.getName();
        if (name != null && (existingMembers == null || existingMembers.add(ES6ClassMemberCompletionProvider.prefixName((JSElement)function2, name))) && (jsContext = function2.getJSContext()) != JSContext.STATIC) {
            forCompletion.add((JSElement)function2);
        }
    }

    private static boolean isPrivate(JSAttributeListOwner function2) {
        JSAttributeList attributeList = function2.getAttributeList();
        return attributeList != null && attributeList.getAccessType() == JSAttributeList.AccessType.PRIVATE;
    }

    private static LookupElement createLookupElement(@NotNull JSElement function2, @NotNull JSClass containingClass, boolean useOverridesCompletion, @Nullable JSTypeSubstitutor substitutor, boolean paramsOnly) {
        if (function2 == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(3);
        }
        if (containingClass == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(4);
        }
        String name = function2.getName();
        assert (name != null);
        LookupElementBuilder element = LookupElementBuilder.create((Object)function2, (String)name).withLookupString(function2.getName());
        if (!useOverridesCompletion) {
            return element;
        }
        JSLookupElementRenderer renderer = ES6ClassMemberCompletionProvider.getRenderer((PsiElement)function2, containingClass, substitutor, name, false, paramsOnly);
        return element.withRenderer((LookupElementRenderer)renderer).withInsertHandler(ES6ClassMemberCompletionProvider.createInsertHandler((PsiElement)function2, (PsiElement)containingClass, name, paramsOnly));
    }

    @NotNull
    static JSLookupElementRenderer getRenderer(@NotNull PsiElement function2, @Nullable JSClass containingClass, @Nullable JSTypeSubstitutor substitutor, @NotNull String name, boolean partial, boolean paramsOnly) {
        if (function2 == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(5);
        }
        if (name == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(6);
        }
        String nameTail = null;
        String nameHead = "";
        if (function2 instanceof JSFunction && !paramsOnly) {
            nameTail = "{...}";
            if (((JSFunction)function2).isGetProperty()) {
                nameHead = nameHead + "get ";
            }
            if (((JSFunction)function2).isSetProperty()) {
                nameHead = nameHead + "set ";
            }
        }
        Icon icon = paramsOnly ? JSLookupUtilImpl.IconHolder.ourParamParamIcon : ES6ClassMemberCompletionProvider.getIcon(function2, (PsiElement)containingClass);
        return new JSLookupElementRenderer(nameHead + name, function2, JSLookupPriority.SMART_PRIORITY, partial, icon, nameTail, substitutor, paramsOnly);
    }

    @Nullable
    private static Icon getIcon(@NotNull PsiElement psiElement, @Nullable PsiElement classOfInsertionContext) {
        JSClass sourceClass;
        if (psiElement == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(7);
        }
        boolean implemented = false;
        if (classOfInsertionContext instanceof JSClass && (sourceClass = JSResolveUtil.getClassOfContext(psiElement)) != null && sourceClass.isInterface()) {
            implemented = true;
        }
        return implemented ? (Icon)IMPLEMENTATION.getValue() : (Icon)OVERRIDE.getValue();
    }

    @NotNull
    private static Icon getImplCompletionIcon(boolean implemented) {
        Icon icon = implemented ? AllIcons.Gutter.ImplementingMethod : AllIcons.Gutter.OverridingMethod;
        Icon empty = JSLookupUtilImpl.getEmptyIcon();
        Icon icon2 = IconUtil.toSize((Icon)icon, (int)empty.getIconWidth(), (int)empty.getIconHeight());
        if (icon2 == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(8);
        }
        return icon2;
    }

    static InsertHandler<LookupElement> createInsertHandler(final @NotNull PsiElement psiElement, @NotNull PsiElement classOfInsertionContext, @NotNull String name, boolean paramsOnly) {
        JSClass sourceClass;
        if (psiElement == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(9);
        }
        if (classOfInsertionContext == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(10);
        }
        if (name == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(11);
        }
        if (!(psiElement instanceof JSFunction)) {
            return (context, item) -> {};
        }
        if (classOfInsertionContext instanceof JSClass && (sourceClass = JSResolveUtil.getClassOfContext(psiElement)) != null && !sourceClass.isInterface()) {
            return (context, item) -> {
                OverrideMethodsFix fix = new OverrideMethodsFix((JSClass)classOfInsertionContext){

                    @Override
                    public Set<JSQualifiedNamedElement> getElementsToProcess() {
                        return ContainerUtil.set((Object[])new JSQualifiedNamedElement[]{(JSFunction)psiElement});
                    }
                };
                ES6ClassMemberCompletionProvider.insertFunctionText((JSFunction)psiElement, name, context, fix, classOfInsertionContext, paramsOnly);
            };
        }
        if (psiElement instanceof TypeScriptFunction) {
            return (ctx, item) -> {
                TypeScriptImplementMembersFix fix = new TypeScriptImplementMembersFix(classOfInsertionContext, false){

                    @Override
                    public Set<TypeScriptFunction> getElementsToProcess() {
                        return ContainerUtil.set((Object[])new TypeScriptFunction[]{(TypeScriptFunction)psiElement});
                    }
                };
                ES6ClassMemberCompletionProvider.insertFunctionText((TypeScriptFunction)psiElement, name, ctx, fix, classOfInsertionContext, paramsOnly);
            };
        }
        return (ctx, item) -> {
            String bodyText = ImplementJSDocMethodsFix.formatFunction(classOfInsertionContext, psiElement.getProject(), new JSMethodToImplement((JSPsiElementBase)((JSFunction)psiElement), false, ""));
            ES6ClassMemberCompletionProvider.insertFunctionText(name, ctx, bodyText, classOfInsertionContext);
        };
    }

    private static <T extends JSElement> void insertFunctionText(@NotNull T function2, @NotNull String name, @NotNull InsertionContext context, @NotNull BaseCreateMembersFix<T> fix, @NotNull PsiElement classOfInsertionContext, boolean paramsOnly) {
        String functionText;
        if (function2 == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(12);
        }
        if (name == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(13);
        }
        if (context == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(14);
        }
        if (fix == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(15);
        }
        if (classOfInsertionContext == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(16);
        }
        if ((functionText = fix.buildFunctionText(function2, null)) != null) {
            if (paramsOnly) {
                ES6ClassMemberCompletionProvider.insertParametersText(function2, name, context, functionText);
            } else {
                ES6ClassMemberCompletionProvider.insertFunctionText(name, context, functionText, classOfInsertionContext);
            }
        }
    }

    private static <T extends JSElement> void insertParametersText(@NotNull T function2, @NotNull String name, @NotNull InsertionContext context, String functionText) {
        int lBrace;
        if (function2 == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(17);
        }
        if (name == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(18);
        }
        if (context == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(19);
        }
        if ((lBrace = functionText.indexOf(123)) == -1) {
            return;
        }
        String signature = functionText.substring(0, lBrace);
        int lPar = signature.indexOf(40);
        int rPar = signature.lastIndexOf(41);
        if (lPar == -1 || rPar == -1) {
            return;
        }
        Document document2 = context.getDocument();
        int offset = context.getStartOffset();
        document2.replaceString(offset, offset + name.length(), (CharSequence)"");
        String listText = signature.substring(lPar + 1, rPar);
        document2.insertString(offset, (CharSequence)listText);
        FormatFixer.create(function2.getContainingFile(), new TextRange(offset, offset + listText.length()), context.getDocument(), FormatFixer.Mode.Reformat).fixFormat();
    }

    private static void insertFunctionText(@NotNull String name, @NotNull InsertionContext context, @NotNull String functionText, @NotNull PsiElement classOfInsertionContext) {
        int indexOfName;
        if (name == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(20);
        }
        if (context == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(21);
        }
        if (functionText == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(22);
        }
        if (classOfInsertionContext == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(23);
        }
        String prefix = (indexOfName = functionText.indexOf(name + "(")) > 0 ? functionText.substring(0, indexOfName) : "";
        String restText = functionText.substring(prefix.length() + name.length());
        int startOffset = context.getEditor().getCaretModel().getOffset();
        Document document2 = context.getDocument();
        document2.insertString(startOffset, (CharSequence)restText);
        if (!prefix.isEmpty()) {
            String toInsert = classOfInsertionContext instanceof JSObjectLiteralExpression ? StringUtil.trimStart((String)prefix, (String)"public ") : prefix;
            document2.insertString(context.getStartOffset(), (CharSequence)toInsert);
            startOffset = context.getStartOffset();
        }
        context.commitDocument();
        FormatFixer.create(context.getFile(), new TextRange(startOffset, startOffset + restText.length() + prefix.length() + (prefix.isEmpty() ? 0 : name.length())), document2, FormatFixer.Mode.Reformat).fixFormat();
        JSFunction func = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)context.getFile().findElementAt(startOffset), JSFunction.class);
        JSBlockStatement block = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)func, JSBlockStatement.class);
        if (block != null) {
            JSSourceElement[] statements = block.getStatementListItems();
            if (statements.length == 1) {
                JSSourceElement statement = statements[0];
                TextRange range = statement.getTextRange();
                context.getEditor().getCaretModel().moveToOffset(range.getStartOffset());
                context.getEditor().getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
            } else {
                context.getEditor().getCaretModel().moveToOffset(block.getFirstChild().getTextOffset() + 1);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 14: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 6: 
            case 11: 
            case 13: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/completion/ES6ClassMemberCompletionProvider";
                break;
            }
            case 10: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classOfInsertionContext";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/completion/ES6ClassMemberCompletionProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplCompletionIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRenderer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createInsertHandler";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "insertFunctionText";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "insertParametersText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

