/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.lang.ecmascript6.psi.ES6DoExpression;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6NamespaceExport;
import com.intellij.lang.ecmascript6.psi.Es6MetaProperty;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.FlowJSDeclareExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluationHelper;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyCallElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyInstanceContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSWrapInPromiseTypeElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUniqueSymbolTypeImpl;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.intellij.lang.regexp.RegExpFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6TypeEvaluator
extends JSTypeEvaluator {
    private static final Predicate<JSType> IS_REG_EXP_EXEC_ARRAY = type -> type instanceof JSNamedType && "RegExpExecArray".equals(JSTypeUtils.getQualifiedNameMatchingType(type, false));

    @Deprecated
    public ES6TypeEvaluator(@NotNull JSEvaluateContext context, @NotNull JSTypeProcessor processor) {
        if (context == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(1);
        }
        super(context, processor);
    }

    public ES6TypeEvaluator(@NotNull JSEvaluateContext context, @NotNull JSTypeProcessor processor, @NotNull JSTypeEvaluationHelper helper) {
        if (context == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(3);
        }
        if (helper == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(4);
        }
        super(context, processor, helper);
    }

    @Override
    protected boolean addTypeFromDialectSpecificElements(PsiElement resolveResult) {
        if (resolveResult instanceof ES6NamespaceExport) {
            Collection elements = ((ES6NamespaceExport)resolveResult).findReferencedElements();
            for (PsiElement element : elements) {
                this.addTypeFromResolvedImport(element);
            }
        }
        if (resolveResult instanceof ES6ExportSpecifierAlias) {
            if ((resolveResult = resolveResult.getParent()) instanceof ES6ExportSpecifier) {
                ES6ExportSpecifier specifier = (ES6ExportSpecifier)resolveResult;
                this.processItem((PsiElement)specifier, () -> {
                    ResolveResult[] exportSpecifierResults;
                    for (ResolveResult result2 : exportSpecifierResults = specifier.multiResolve(false)) {
                        PsiElement element;
                        if (!result2.isValidResult() || (element = result2.getElement()) == null) continue;
                        this.addTypeFromResolvedImport(element);
                    }
                });
            }
            return true;
        }
        if (resolveResult instanceof ES6ImportedExportedDefaultBinding) {
            String type;
            JSDocComment docComment;
            Collection referencedElements = ((ES6ImportedExportedDefaultBinding)resolveResult).findReferencedElements();
            for (PsiElement referencedElement : referencedElements) {
                this.addTypeFromResolvedImport(referencedElement);
            }
            PsiElement parent = resolveResult.getParent();
            if (parent instanceof ES6ImportDeclaration && ((ES6ImportDeclaration)parent).getImportSpecifiers().length == 0 && (!DialectDetector.isTypeScript(parent) || referencedElements.size() == 0) && (docComment = JSStubBasedPsiTreeUtil.findDocComment(parent)) != null && (type = docComment.getType()) != null) {
                this.addType(JSTypeUtils.createType(type, JSTypeSourceFactory.createTypeSource((PsiElement)docComment, true)), resolveResult);
            }
            if (referencedElements.isEmpty()) {
                this.myTypeProcessor.processResolvedElement(resolveResult, this.myContext);
            }
            this.addTypeFromLocalName((PsiNamedElement)resolveResult);
            return true;
        }
        if (resolveResult instanceof ES6ImportSpecifierAlias) {
            this.addTypeFromES6ImportSpecifier((ES6ImportSpecifierAlias)resolveResult);
            return true;
        }
        if (resolveResult instanceof JSExportAssignment) {
            this.evaluateExportAssignment((JSExportAssignment)resolveResult);
        }
        return super.addTypeFromDialectSpecificElements(resolveResult);
    }

    private void addTypeFromES6ImportSpecifier(ES6ImportSpecifierAlias resolveResult) {
        PsiElement aliasedElement = resolveResult.findAliasedElement();
        if (aliasedElement != null) {
            this.processItem(aliasedElement, () -> this.addTypeFromResolveResult(aliasedElement));
        }
        this.addTypeFromLocalName((PsiNamedElement)resolveResult);
    }

    protected void addTypeFromResolvedImport(PsiElement referencedElement) {
        if (referencedElement instanceof JSExportAssignment) {
            this.evaluateExportAssignment((JSExportAssignment)referencedElement);
        } else if (referencedElement instanceof JSFile) {
            this.addTypeFromExternalModuleReferenceResolveResult(referencedElement);
        } else if (referencedElement instanceof StylesheetFile) {
            this.myTypeProcessor.processResolvedElement(referencedElement, this.myContext);
        } else if (referencedElement != null) {
            this.addTypeFromResolveResult(referencedElement);
        }
    }

    protected void evaluateExportAssignment(@NotNull JSExportAssignment assignment) {
        JSType type;
        if (assignment == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(5);
        }
        JSElement element = assignment.getStubSafeElement();
        if (assignment instanceof FlowJSDeclareExportDeclaration) {
            if (element != null) {
                this.addType(((JSTypeDeclaration)element).getJSType(), EXPLICIT_TYPE_MARKER_ELEMENT);
            }
            return;
        }
        if (element instanceof JSClass || element != null && !(element instanceof JSExpression)) {
            this.addTypeFromResolveResult((PsiElement)element);
            return;
        }
        if (element instanceof JSFunction) {
            this.processFunction((JSFunction)element);
            return;
        }
        if (element instanceof JSObjectLiteralExpression) {
            this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)element, false);
            return;
        }
        if (DialectDetector.isTypeScript((PsiElement)assignment)) {
            JSExpression exportDefaultAssignmentExpression;
            String reference = assignment.getInitializerReference();
            if (reference != null) {
                JSTypeResolveResult result2 = TypeScriptImportHandler.getInstance().resolveName(reference, (PsiElement)assignment);
                Collection<? extends PsiElement> elements = result2.getElements();
                for (PsiElement psiElement : elements) {
                    this.processItem(psiElement, () -> this.addTypeFromResolvedImport(psiElement));
                }
                return;
            }
            JSExpression jSExpression = element == null ? (JSExpression)AstLoadingFilter.forceAllowTreeLoading((PsiFile)assignment.getContainingFile(), () -> ((JSExportAssignment)assignment).getExpression()) : (exportDefaultAssignmentExpression = (JSExpression)element);
            if (exportDefaultAssignmentExpression != null) {
                this.evaluateTypes(exportDefaultAssignmentExpression);
            }
        } else if (element instanceof JSAssignmentExpression) {
            JSDefinitionExpression definitionExpression = ((JSAssignmentExpression)element).getDefinitionExpression();
            if (definitionExpression != null) {
                this.addTypeFromDefExpr(definitionExpression);
                return;
            }
        } else if (element != null) {
            this.evaluateTypes((JSExpression)element);
            return;
        }
        if (assignment instanceof ES6ExportDefaultAssignment && (type = ((ES6ExportDefaultAssignment)assignment).getJSType()) != null) {
            this.addType(type, (PsiElement)assignment);
        }
    }

    @Override
    protected boolean evaluateDialectSpecificTypes(JSExpression rawqualifier) {
        JSType expressionType;
        if (rawqualifier instanceof JSSpreadExpression && (expressionType = this.getExpressionTypeInContext(((JSSpreadExpression)rawqualifier).getExpression())) != null) {
            this.addType(new JSSpreadTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true), expressionType), (PsiElement)rawqualifier);
            return true;
        }
        if (rawqualifier instanceof Es6MetaProperty && ((Es6MetaProperty)rawqualifier).getKind() == Es6MetaProperty.Kind.ImportMeta) {
            this.addType(JSNamedTypeFactory.createType("ImportMeta", JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, DialectDetector.isTypeScript((PsiElement)rawqualifier)), JSTypeContext.INSTANCE), (PsiElement)rawqualifier);
        } else {
            if (rawqualifier instanceof JSClassExpression) {
                this.addTypeFromClassExpression((JSClassExpression)rawqualifier);
                return true;
            }
            if (rawqualifier instanceof ES6DoExpression) {
                JSExpression expression;
                JSExpressionStatement expressionStatement;
                ES6DoExpression doExpression = (ES6DoExpression)rawqualifier;
                JSSourceElement lastStatement = (JSSourceElement)ArrayUtil.getLastElement((Object[])doExpression.getStatementListItems());
                JSExpressionStatement jSExpressionStatement = expressionStatement = lastStatement instanceof JSExpressionStatement ? (JSExpressionStatement)lastStatement : null;
                if (expressionStatement != null && (expression = expressionStatement.getExpression()) != null) {
                    this.evaluateTypes(expression);
                }
            } else {
                if (rawqualifier instanceof ES6ImportCall) {
                    boolean isImportType;
                    ES6ImportCall importCall = (ES6ImportCall)rawqualifier;
                    boolean bl = isImportType = importCall.getContext() != null && importCall.getContext().getContext() instanceof TypeScriptSingleType;
                    if (!isImportType) {
                        this.myContext.pushJSElementToApply(new JSWrapInPromiseTypeElement((PsiElement)importCall));
                    }
                    this.addTypeFromImportCall(importCall);
                    return true;
                }
                if (rawqualifier instanceof ES6TaggedTemplateExpression) {
                    ES6TaggedTemplateExpression taggedTemplate = (ES6TaggedTemplateExpression)rawqualifier;
                    JSApplyCallElement elementToApply = JSApplyCallElement.fromTaggedTemplateExpression(taggedTemplate);
                    this.myContext.processWithJSElementToApply(elementToApply, () -> this.evaluateTypes(elementToApply.getMethodExpression()));
                    return true;
                }
            }
        }
        return super.evaluateDialectSpecificTypes(rawqualifier);
    }

    @Override
    protected void evaluateCallExpressionTypes(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(6);
        }
        if (DialectDetector.isTypeScript((PsiElement)callExpression) && this.addUniqueSymbolForConst(callExpression)) {
            return;
        }
        super.evaluateCallExpressionTypes(callExpression);
    }

    private boolean addUniqueSymbolForConst(@NotNull JSCallExpression callExpression) {
        JSFieldVariable variable;
        if (callExpression == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(7);
        }
        if ((variable = (JSFieldVariable)PsiTreeUtil.getContextOfType((PsiElement)callExpression, (Class[])new Class[]{JSFieldVariable.class})) == null || !variable.isConst() || variable.getInitializerOrStub() != callExpression) {
            return false;
        }
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression)) {
            return false;
        }
        JSReferenceExpression invoked = (JSReferenceExpression)methodExpression;
        String referencedName = invoked.getReferenceName();
        if (!"Symbol".equals(referencedName)) {
            return false;
        }
        this.addType(new JSUniqueSymbolTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)variable, true), JSTypeContext.INSTANCE, true), (PsiElement)variable);
        return true;
    }

    @Override
    protected void doAddType(@NotNull JSType type, @Nullable PsiElement source) {
        if (type == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(8);
        }
        type = this.addTypeFromRegexpExecCall(type);
        super.doAddType(type, source);
    }

    @NotNull
    private static NotNullFunction<JSType, JSType> createRegExpGroupsAdder(@NotNull JSLiteralExpression regexp) {
        if (regexp == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(9);
        }
        NotNullFunction notNullFunction = type -> {
            RegExpFile injectedRegexpFile;
            if (IS_REG_EXP_EXEC_ARRAY.test((JSType)type) && (injectedRegexpFile = ES6TypeEvaluator.findInjectedRegexpFile((PsiElement)regexp)) != null) {
                JSType typeForRegexpGroups = ES6TypeEvaluator.getTypeForRegexpGroups((PsiElement)regexp, injectedRegexpFile);
                return JSCompositeTypeFactory.createIntersectionType(Arrays.asList(type, typeForRegexpGroups), type.getSource());
            }
            return type;
        };
        if (notNullFunction == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(10);
        }
        return notNullFunction;
    }

    @NotNull
    private JSType addTypeFromRegexpExecCall(@NotNull JSType targetJSType) {
        JSReferenceExpression processedExpression;
        if (targetJSType == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(11);
        }
        if ((processedExpression = this.myContext.getProcessedExpression()) == null || !DialectDetector.isES6((PsiElement)processedExpression) || !this.isAstAccessAllowed((PsiElement)processedExpression)) {
            JSType jSType = targetJSType;
            if (jSType == null) {
                ES6TypeEvaluator.$$$reportNull$$$0(12);
            }
            return jSType;
        }
        if (!(targetJSType instanceof JSNamedType && IS_REG_EXP_EXEC_ARRAY.test(targetJSType) || targetJSType instanceof JSUnionOrIntersectionType && ((JSUnionOrIntersectionType)targetJSType).getTypes().stream().anyMatch(IS_REG_EXP_EXEC_ARRAY))) {
            JSType jSType = targetJSType;
            if (jSType == null) {
                ES6TypeEvaluator.$$$reportNull$$$0(13);
            }
            return jSType;
        }
        JSExpression qualifier = processedExpression.getQualifier();
        if (qualifier == null) {
            JSType jSType = targetJSType;
            if (jSType == null) {
                ES6TypeEvaluator.$$$reportNull$$$0(14);
            }
            return jSType;
        }
        JSType qualifierType = JSResolveUtil.getExpressionJSType(qualifier);
        if (qualifierType == null) {
            JSType jSType = targetJSType;
            if (jSType == null) {
                ES6TypeEvaluator.$$$reportNull$$$0(15);
            }
            return jSType;
        }
        PsiElement sourceElement = qualifierType.getSourceElement();
        if (!(sourceElement instanceof JSLiteralExpression) || !((JSLiteralExpression)sourceElement).isRegExpLiteral()) {
            JSType jSType = targetJSType;
            if (jSType == null) {
                ES6TypeEvaluator.$$$reportNull$$$0(16);
            }
            return jSType;
        }
        NotNullFunction<JSType, JSType> transformer = ES6TypeEvaluator.createRegExpGroupsAdder((JSLiteralExpression)sourceElement);
        JSType jSType = targetJSType instanceof JSNamedType ? (JSType)transformer.fun((Object)targetJSType) : ((JSUnionOrIntersectionType)targetJSType).transformTypes((NullableFunction<? super JSType, JSType>)transformer);
        if (jSType == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(17);
        }
        return jSType;
    }

    @NotNull
    private static JSType getTypeForRegexpGroups(@NotNull PsiElement context, @NotNull RegExpFile injectedFile) {
        if (context == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(18);
        }
        if (injectedFile == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(19);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(context, true);
        List properties = ContainerUtil.mapNotNull((Collection)injectedFile.getGroups(), group -> {
            String name = group.isAnyNamedGroup() ? group.getGroupName() : null;
            JSType jsStringType = JSNamedTypeFactory.createType("string", typeSource, JSTypeContext.INSTANCE);
            if (name == null) {
                return null;
            }
            JSLocalImplicitElementImpl groupElement = new JSLocalImplicitElementImpl(name, jsStringType, context, JSImplicitElement.Type.Property);
            return new JSRecordTypeImpl.PropertySignatureImpl(name, jsStringType, true, false, (PsiElement)groupElement);
        });
        JSSimpleRecordTypeImpl groupsType = new JSSimpleRecordTypeImpl(typeSource, properties);
        JSLocalImplicitElementImpl groupsElement = new JSLocalImplicitElementImpl("groups", groupsType, context, JSImplicitElement.Type.Property);
        return new JSSimpleRecordTypeImpl(typeSource, Collections.singletonList(new JSRecordTypeImpl.PropertySignatureImpl("groups", (JSType)groupsType, false, false, (PsiElement)groupsElement)));
    }

    @Nullable
    private static RegExpFile findInjectedRegexpFile(@NotNull PsiElement expression) {
        List files;
        if (expression == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(20);
        }
        return (files = InjectedLanguageManager.getInstance((Project)expression.getProject()).getInjectedPsiFiles(expression)) == null || files.isEmpty() ? null : (RegExpFile)ObjectUtils.tryCast((Object)((Pair)files.get((int)0)).first, RegExpFile.class);
    }

    @Override
    public void addTypeFromClassExpression(@NotNull JSClassExpression classExpression) {
        String qualifiedName;
        if (classExpression == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(21);
        }
        if ((qualifiedName = classExpression.getQualifiedName()) == null || ES6PsiUtil.isLocalClass((JSClass)classExpression)) {
            this.myTypeProcessor.processResolvedElement((PsiElement)classExpression, this.myContext);
            return;
        }
        this.addTypeFromClassWithQName((JSClass)classExpression);
    }

    protected boolean isPrototypeOrNewExpression() {
        return this.myContext.peekJSElementToApply() instanceof JSApplyInstanceContextElement;
    }

    @Override
    protected void addTypeFromClassCandidate(@NotNull JSClass resolveResult) {
        if (resolveResult == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(22);
        }
        if (resolveResult instanceof JSClassExpression) {
            this.addTypeFromClassExpression((JSClassExpression)resolveResult);
        } else {
            this.addTypeFromClassWithQName(resolveResult);
        }
    }

    protected void addTypeFromClassWithQName(@NotNull JSClass resolveResult) {
        JSNamespace namespace;
        if (resolveResult == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(23);
        }
        if ((namespace = this.getNamespaceFromQualifiedNamedElement((JSQualifiedNamedElement)resolveResult, true)).getQualifiedName() == null) {
            return;
        }
        this.addType((JSType)namespace, (PsiElement)resolveResult);
    }

    @Override
    protected void processSuperQualifierExpression(JSSuperExpression rawqualifier, @Nullable JSClass jsClass) {
        if (jsClass != null) {
            for (JSClass aClass : jsClass.getSuperClasses()) {
                this.addTypeFromClassCandidate(aClass);
            }
        }
    }

    protected void addTypeFromImportCall(@NotNull ES6ImportCall importCall) {
        if (importCall == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(24);
        }
        for (PsiElement module : importCall.resolveReferencedElements()) {
            if (module instanceof JSFile) {
                this.addTypeFromModuleFile((JSFile)module, false);
                continue;
            }
            this.addTypeFromExternalModuleReferenceResolveResult(module);
        }
    }

    @Override
    public void addTypeFromExternalModuleReferenceResolveResult(@NotNull PsiElement resolve, boolean fromRequire) {
        if (resolve == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(25);
        }
        if (resolve instanceof JSExportAssignment) {
            this.evaluateExportAssignment((JSExportAssignment)resolve);
            return;
        }
        super.addTypeFromExternalModuleReferenceResolveResult(resolve, fromRequire);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regexp";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/resolve/ES6TypeEvaluator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetJSType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedFile";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classExpression";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importCall";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/ES6TypeEvaluator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createRegExpGroupsAdder";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "addTypeFromRegexpExecCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "evaluateExportAssignment";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "evaluateCallExpressionTypes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addUniqueSymbolForConst";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doAddType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createRegExpGroupsAdder";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromRegexpExecCall";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForRegexpGroups";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findInjectedRegexpFile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromClassExpression";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromClassCandidate";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromClassWithQName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromImportCall";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromExternalModuleReferenceResolveResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

