/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.documentation.JSDocBuilderParameterInfo;
import com.intellij.lang.javascript.documentation.JSDocBuilderSimpleInfo;
import com.intellij.lang.javascript.documentation.JSDocumentationBuilder;
import com.intellij.lang.javascript.documentation.JSDocumentationProvider;
import com.intellij.lang.javascript.documentation.JSHtmlHighlightingUtil;
import com.intellij.lang.javascript.documentation.JSQuickNavigateBuilder;
import com.intellij.lang.javascript.documentation.JSSeeAlsoDocBuilderInfo;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.psi.JSConstantValueOwner;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSDocBuilderSymbolInfo
extends JSDocBuilderSimpleInfo {
    public static final String EVENTS = "Events:";
    public static final int PATH_LENGTH = 40;
    @Nullable
    protected final JSPsiNamedElementBase namedItem;
    @Nullable
    protected final PsiElement contextElement;
    @NotNull
    protected final PsiElement myElement;
    @NotNull
    protected final JSSeeAlsoDocBuilderInfo mySeeAlsoDocBuilderInfo;
    @NotNull
    protected final Map<String, String> mySimpleTags;
    @Nullable
    Map<JSQualifiedName, JSDocBuilderParameterInfo> myProperties;
    @Nullable
    private String defaultValue;

    void addSimpleTag(@NotNull String key, @Nullable String text) {
        if (key == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(0);
        }
        this.mySimpleTags.put(key, StringUtil.notNullize((String)text));
    }

    void addEventTag(@Nullable String name, @Nullable String text) {
        String oldValue = this.mySimpleTags.get(EVENTS);
        String value = StringUtil.notNullize((String)oldValue) + "<p>" + StringUtil.notNullize((String)name) + " &ndash; " + StringUtil.notNullize((String)text);
        this.mySimpleTags.put(EVENTS, value);
    }

    void addSeeAlsoText(@Nullable String text) {
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        this.mySeeAlsoDocBuilderInfo.addText(text);
    }

    JSDocBuilderSymbolInfo(@NotNull PsiElement element, @Nullable PsiElement _contextElement, boolean canBeNamed) {
        if (element == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(1);
        }
        this.mySimpleTags = new HashMap<String, String>();
        this.namedItem = element instanceof JSPsiNamedElementBase && canBeNamed ? (JSPsiNamedElementBase)element : null;
        this.contextElement = _contextElement;
        this.myElement = element;
        this.mySeeAlsoDocBuilderInfo = new JSSeeAlsoDocBuilderInfo(this.myElement);
        if (this.namedItem != null) {
            PsiElement parent = element.getParent();
            this.namespace = element instanceof JSClass && parent instanceof JSPackageStatement ? ((JSPackageStatement)parent).getQualifiedName() : null;
        }
    }

    public void appendDoc(@NotNull StringBuilder result2, @NotNull JSDocumentationProvider provider) {
        if (result2 == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(2);
        }
        if (provider == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(3);
        }
        this.appendDefinitionDoc(result2, provider);
        boolean hasDefinition = result2.length() > 0;
        JSDocBuilderSymbolInfo.appendDescriptionContent(this, result2);
        result2.append("<table class='sections'>");
        this.appendInnerSections(result2, provider, hasDefinition);
        result2.append("</table>");
    }

    protected void appendInnerSections(@NotNull StringBuilder result2, @NotNull JSDocumentationProvider provider, boolean hasDefinition) {
        if (result2 == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(4);
        }
        if (provider == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(5);
        }
        this.appendBodyDoc(result2);
        JSDocBuilderSymbolInfo.addSections(this.mySimpleTags, result2);
        JSDocBuilderSymbolInfo.addSections(this.myUnknownTags, result2);
        this.mySeeAlsoDocBuilderInfo.appendDoc(result2, provider);
        if (hasDefinition) {
            this.appendLocation(result2);
        }
    }

    private void appendLocation(@NotNull StringBuilder result2) {
        if (result2 == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(6);
        }
        if (DialectDetector.isActionScript(this.myElement) || !(this.myElement instanceof JSElement)) {
            return;
        }
        PsiFile file2 = this.myElement.getContainingFile();
        String rawLocation = StringUtil.notNullize((String)JSItemPresentation.getFileName(file2, true, true, false));
        String location = JSDocBuilderSymbolInfo.getLocationWithEllipsis(rawLocation = StringUtil.trimEnd((String)StringUtil.trimStart((String)rawLocation, (String)"("), (String)")"), 40);
        if (location.isEmpty()) {
            return;
        }
        int sections = result2.indexOf("<tr><td valign='top' class='section'><p>");
        result2.append("<tr><td valign='top'");
        if (sections > 0) {
            result2.append(" colspan='2'");
        }
        result2.append(">");
        String icon = JSDocBuilderSymbolInfo.getFileIconPath(file2);
        result2.append("<icon src='").append(icon).append("'/>&nbsp;").append(StringUtil.escapeXmlEntities((String)location));
        result2.append("</td>");
    }

    @NotNull
    public static String getLocationWithEllipsis(@NotNull String filePath, int maxLength) {
        int startPartSymbolCount;
        String fileName;
        if (filePath == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(7);
        }
        if ((fileName = VfsUtil.extractFileName((String)filePath)) == null) {
            String string = filePath;
            if (string == null) {
                JSDocBuilderSymbolInfo.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (fileName.length() + 4 >= maxLength) {
            String string = fileName;
            if (string == null) {
                JSDocBuilderSymbolInfo.$$$reportNull$$$0(9);
            }
            return string;
        }
        if (maxLength >= filePath.length()) {
            String string = filePath;
            if (string == null) {
                JSDocBuilderSymbolInfo.$$$reportNull$$$0(10);
            }
            return string;
        }
        int acceptableSymbolCount = maxLength - fileName.length() - 4;
        int leftPartEnd = filePath.indexOf("/");
        if (leftPartEnd == 0) {
            leftPartEnd = filePath.indexOf("/", 1);
        }
        if ((startPartSymbolCount = leftPartEnd + 1) > acceptableSymbolCount) {
            String string = fileName;
            if (string == null) {
                JSDocBuilderSymbolInfo.$$$reportNull$$$0(11);
            }
            return string;
        }
        int lastIndex = filePath.lastIndexOf("/");
        if (leftPartEnd >= lastIndex) {
            String string = fileName;
            if (string == null) {
                JSDocBuilderSymbolInfo.$$$reportNull$$$0(12);
            }
            return string;
        }
        StringBuilder result2 = new StringBuilder();
        result2.append(filePath, 0, leftPartEnd + 1).append(".../");
        JSDocBuilderSymbolInfo.appendMaxRightPath(filePath.substring(leftPartEnd + 1, lastIndex + 1), result2, acceptableSymbolCount - startPartSymbolCount);
        result2.append(fileName);
        String string = result2.toString();
        if (string == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static void appendMaxRightPath(@NotNull String subPathWithoutFilename, @NotNull StringBuilder result2, int maxLength) {
        if (subPathWithoutFilename == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(14);
        }
        if (result2 == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(15);
        }
        if (maxLength > 0 && subPathWithoutFilename.length() > 0) {
            String partOfPathToTrim;
            int toCropIndex;
            int startOffset = subPathWithoutFilename.length() - maxLength;
            if (startOffset > 0 && subPathWithoutFilename.charAt(startOffset - 1) == '/') {
                result2.append(subPathWithoutFilename.substring(startOffset));
            } else if (startOffset > 0 && (toCropIndex = (partOfPathToTrim = subPathWithoutFilename.substring(startOffset)).indexOf("/")) >= 0 && partOfPathToTrim.length() > toCropIndex + 1) {
                result2.append(partOfPathToTrim.substring(toCropIndex + 1));
            }
        }
    }

    @NotNull
    private static String getFileIconPath(@NotNull PsiFile file2) {
        if (file2 == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(16);
        }
        if (DialectDetector.isTypeScript((PsiElement)file2)) {
            return "JavaScriptPsiIcons.FileTypes.TypeScriptFile";
        }
        if (DialectDetector.isJavaScript((PsiElement)file2)) {
            return "AllIcons.FileTypes.JavaScript";
        }
        return "AllIcons.Nodes.Folder";
    }

    protected void appendBodyDoc(@NotNull StringBuilder result2) {
        String text;
        JSType declaration;
        String value;
        if (result2 == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(17);
        }
        if (this.defaultValue != null) {
            result2.append(this.defaultValue);
        }
        if (this.myProperties != null) {
            JSDocBuilderSymbolInfo.startNamedSection("Properties:", result2);
            result2.append("<td valign='top'>");
            for (Map.Entry<JSQualifiedName, JSDocBuilderParameterInfo> field : this.myProperties.entrySet()) {
                result2.append("<p>");
                field.getValue().appendOptionDescription(field.getKey().getName(), result2);
            }
            result2.append("</td>");
        }
        if (this.myElement instanceof JSConstantValueOwner && (value = ((JSConstantValueOwner)this.myElement).getConstantValueDescription()) != null) {
            JSDocBuilderSymbolInfo.startNamedSection("Constant value:", result2);
            result2.append("<td valign='top'>");
            JSDocBuilderSymbolInfo.appendSingleNamedDescriptionSection(value, "", result2);
            result2.append("</td>");
        }
        if (this.myElement instanceof TypeScriptTypeAlias && (declaration = ((TypeScriptTypeAlias)this.myElement).getParsedTypeDeclaration()) != null) {
            JSDocBuilderSymbolInfo.startNamedSection("Alias for:", result2);
            result2.append("<td valign='top'>");
            CharSequence text2 = JSHtmlHighlightingUtil.getTypeWithLinksHtmlHighlighting(declaration, this.myElement, false);
            JSDocBuilderSymbolInfo.appendSingleNamedDescriptionSection(text2, "", result2);
            result2.append("</td>");
            JSType expanded = declaration.substitute();
            if (!expanded.isEquivalentTo(this.type, null)) {
                JSType completelyExpanded;
                String expandedCodeText = expanded.getTypeText(JSType.TypeTextFormat.CODE);
                if (!expandedCodeText.equals(declaration.getTypeText(JSType.TypeTextFormat.CODE))) {
                    JSDocBuilderSymbolInfo.startNamedSection("Initial type:", result2);
                    result2.append("<td valign='top'>");
                    CharSequence initialType = JSHtmlHighlightingUtil.getTypeWithLinksHtmlHighlighting(expanded, this.myElement, false);
                    JSDocBuilderSymbolInfo.appendSingleNamedDescriptionSection(initialType, "", result2);
                    result2.append("</td>");
                }
                if (!(completelyExpanded = JSTypeWithIncompleteSubstitution.substituteCompletely((JSType)expanded)).isEquivalentTo(expanded, null)) {
                    JSDocBuilderSymbolInfo.startNamedSection("Expanded:", result2);
                    result2.append("<td valign='top'>");
                    CharSequence recordText = JSHtmlHighlightingUtil.getTypeWithLinksHtmlHighlighting(completelyExpanded, this.myElement, false);
                    JSDocBuilderSymbolInfo.appendSingleNamedDescriptionSection(recordText, "", result2);
                    result2.append("</td>");
                }
            }
        }
        if (this.contextElement != null && !(this.contextElement instanceof JSImplicitElement) && (text = this.contextElement.getText()).startsWith("#") && text.length() == 7) {
            result2.append(JSDocBuilderSymbolInfo.buildCurrentOrDefaultValue(text.substring(1), true, false, text, true));
        }
    }

    protected void appendDefinitionDoc(@NotNull StringBuilder result2, @NotNull JSDocumentationProvider provider) {
        if (result2 == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(18);
        }
        if (provider == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(19);
        }
        if (this.namedItem != null) {
            String name;
            result2.append("<div class='definition'><pre>");
            String string = name = this.myElement instanceof JSAttributeNameValuePair ? ((JSAttributeNameValuePair)this.myElement).getSimpleValue() : JSDocumentationBuilder.getNameForDocumentation(this.namedItem);
            if (!(this.namedItem instanceof JSAttributeNameValuePair || this.namedItem instanceof JSImplicitElement || this.namedItem instanceof JSDefinitionExpression || DialectDetector.isActionScript((PsiElement)this.namedItem))) {
                JSPsiNamedElementBase element;
                JSQuickNavigateBuilder builder = provider.getQuickNavigateBuilder();
                String navInfoResult = builder.getQuickNavigateInfoForNavigationElement((PsiElement)this.namedItem, (PsiElement)(element = this.contextElement == null ? this.namedItem : this.contextElement), true);
                if (navInfoResult == null) {
                    navInfoResult = StringUtil.notNullize((String)name);
                }
                result2.append(navInfoResult);
            } else {
                JSType jsType = this.type != null ? this.type.substitute() : null;
                result2.append(JSHtmlHighlightingUtil.getElementHtmlHighlighting(this.myElement, StringUtil.notNullize((String)name), jsType));
            }
            result2.append("</pre></div>");
        }
    }

    protected static void addJSDocVisibilityAndAccess(JSDocBuilderSimpleInfo generationInfo, StringBuilder options) {
        if (generationInfo.modifiers != null) {
            if (options.length() > 0) {
                options.append(", ");
            }
            options.append(generationInfo.modifiers);
        }
        if (generationInfo.finalAccess != null) {
            if (options.length() > 0) {
                options.append(", ");
            }
            options.append(generationInfo.finalAccess);
        }
        if (generationInfo.deprecated) {
            if (options.length() > 0) {
                options.append(", ");
            }
            options.append("deprecated");
        }
    }

    public static void appendDescriptionContent(@NotNull JSDocBuilderSymbolInfo info, @NotNull StringBuilder result2) {
        if (info == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(20);
        }
        if (result2 == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(21);
        }
        if (info.hasDescription()) {
            result2.append("<div class='content'>");
            JSDocBuilderSymbolInfo.addDescription(info.getFinalDescription(), result2);
            result2.append("</div>");
        }
    }

    public static void addSections(@NotNull Map<String, String> sections, @NotNull StringBuilder result2) {
        if (sections == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(22);
        }
        if (result2 == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(23);
        }
        if (sections.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : sections.entrySet()) {
            JSDocBuilderSymbolInfo.startNamedSection(entry.getKey(), result2);
            result2.append("<td valign='top'>");
            String value = entry.getValue();
            if (!value.startsWith("<p>")) {
                result2.append("<p>");
            }
            result2.append(value);
            result2.append("</td>");
        }
    }

    void setDefaultValue(String content, boolean color, String originalText) {
        this.defaultValue = JSDocBuilderSymbolInfo.buildCurrentOrDefaultValue(content, color, true, originalText, true);
    }

    public static void startNamedSection(String sectionName, StringBuilder result2) {
        result2.append("<tr><td valign='top' class='section'><p>");
        result2.append(sectionName);
        result2.append("</td>");
    }

    public static void appendSingleNamedDescriptionSection(CharSequence name, CharSequence description, @NotNull StringBuilder builder) {
        if (builder == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(24);
        }
        builder.append(name);
        if (description.length() > 0) {
            builder.append(" &ndash; ");
            builder.append(description);
        }
    }

    public static void addDescription(@NotNull String description, @NotNull StringBuilder builder) {
        if (description == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(25);
        }
        if (builder == null) {
            JSDocBuilderSymbolInfo.$$$reportNull$$$0(26);
        }
        builder.append("<p>");
        builder.append(description);
    }

    protected static String buildCurrentOrDefaultValue(String content, boolean color, boolean isDefaultValue, String originalText, boolean needSection) {
        content = color ? "<code style='background-color:#" + content + "; color: #" + JSDocBuilderSymbolInfo.contrastColor(content) + "'>" + originalText + "</code>" : "<code>" + content + "</code>";
        String label = (isDefaultValue ? "Default" : "Value") + ":";
        if (!needSection) {
            return "<p>" + label + content;
        }
        return "<tr><td valign='top' class='section'><p>" + label + "</td><td valign='top'>" + "<p>" + content;
    }

    private static String contrastColor(String remainingLineContent) {
        try {
            Color color = ColorUtil.fromHex((String)remainingLineContent);
            return ColorUtil.toHex((Color)(ColorUtil.isDark((Color)color) ? JBColor.WHITE : JBColor.BLACK));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return remainingLineContent;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JSDocBuilderSymbolInfo";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subPathWithoutFilename";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sections";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocBuilderSymbolInfo";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationWithEllipsis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addSimpleTag";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendDoc";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendInnerSections";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendLocation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLocationWithEllipsis";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "appendMaxRightPath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFileIconPath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "appendBodyDoc";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "appendDefinitionDoc";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "appendDescriptionContent";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addSections";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "appendSingleNamedDescriptionSection";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

